/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Comparator;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.TagNameComparator;
import org.openrewrite.xml.tree.Xml;

final class AddPropertyVisitor
extends MavenIsoVisitor<ExecutionContext> {
    private final String propertyName;
    private final String value;
    @Nullable
    private final Boolean preserveExistingValue;
    @Nullable
    private final Boolean trustParent;

    @Override
    public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
        Xml.Document d = super.visitDocument(document, ctx);
        Xml.Tag root = d.getRoot();
        Optional properties = root.getChild("properties");
        if (!properties.isPresent()) {
            Xml.Tag propertiesTag = Xml.Tag.build((String)("<properties>\n<" + this.propertyName + ">" + this.value + "</" + this.propertyName + ">\n</properties>"));
            d = (Xml.Document)new AddToTagVisitor(root, propertiesTag, (Comparator)new MavenTagInsertionComparator(root.getChildren())).visitNonNull((Tree)d, (Object)ctx);
        } else if (!((Xml.Tag)properties.get()).getChildValue(this.propertyName).isPresent()) {
            Xml.Tag propertyTag = Xml.Tag.build((String)("<" + this.propertyName + ">" + this.value + "</" + this.propertyName + ">"));
            d = (Xml.Document)new AddToTagVisitor((Xml.Tag)properties.get(), propertyTag, (Comparator)new TagNameComparator()).visitNonNull((Tree)d, (Object)ctx);
        }
        if (d != document) {
            this.maybeUpdateModel();
        }
        return d;
    }

    @Override
    public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
        if (!Boolean.TRUE.equals(this.preserveExistingValue) && this.isPropertyTag() && this.propertyName.equals(tag.getName()) && !this.value.equals(tag.getValue().orElse(null))) {
            this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(tag, this.value));
        }
        return super.visitTag(tag, ctx);
    }

    public AddPropertyVisitor(String propertyName, String value, @Nullable Boolean preserveExistingValue, @Nullable Boolean trustParent) {
        this.propertyName = propertyName;
        this.value = value;
        this.preserveExistingValue = preserveExistingValue;
        this.trustParent = trustParent;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public Boolean getPreserveExistingValue() {
        return this.preserveExistingValue;
    }

    @Nullable
    public Boolean getTrustParent() {
        return this.trustParent;
    }

    @NonNull
    public String toString() {
        return "AddPropertyVisitor(propertyName=" + this.getPropertyName() + ", value=" + this.getValue() + ", preserveExistingValue=" + this.getPreserveExistingValue() + ", trustParent=" + this.getTrustParent() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddPropertyVisitor)) {
            return false;
        }
        AddPropertyVisitor other = (AddPropertyVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$preserveExistingValue = this.getPreserveExistingValue();
        Boolean other$preserveExistingValue = other.getPreserveExistingValue();
        if (this$preserveExistingValue == null ? other$preserveExistingValue != null : !((Object)this$preserveExistingValue).equals(other$preserveExistingValue)) {
            return false;
        }
        Boolean this$trustParent = this.getTrustParent();
        Boolean other$trustParent = other.getTrustParent();
        if (this$trustParent == null ? other$trustParent != null : !((Object)this$trustParent).equals(other$trustParent)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddPropertyVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $preserveExistingValue = this.getPreserveExistingValue();
        result = result * 59 + ($preserveExistingValue == null ? 43 : ((Object)$preserveExistingValue).hashCode());
        Boolean $trustParent = this.getTrustParent();
        result = result * 59 + ($trustParent == null ? 43 : ((Object)$trustParent).hashCode());
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

