/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.License;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.Profile;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;

public final class Pom {
    private static final List<String> JAR_PACKAGING_TYPES = Arrays.asList("jar", "bundle");
    @Nullable
    private final Path sourcePath;
    @Nullable
    private final MavenRepository repository;
    @Nullable
    private final Parent parent;
    private final ResolvedGroupArtifactVersion gav;
    @Nullable
    private final String obsoletePomVersion;
    @Nullable
    private final String name;
    @Nullable
    private final String packaging;
    private final Map<String, String> properties;
    private final List<ManagedDependency> dependencyManagement;
    private final List<Dependency> dependencies;
    private final List<MavenRepository> repositories;
    private final List<License> licenses;
    private final List<Profile> profiles;
    private final List<Plugin> plugins;
    private final List<Plugin> pluginManagement;

    public static int getModelVersion() {
        return 2;
    }

    public String getGroupId() {
        return this.gav.getGroupId();
    }

    public String getArtifactId() {
        return this.gav.getArtifactId();
    }

    public String getVersion() {
        return this.gav.getVersion();
    }

    @Nullable
    public String getDatedSnapshotVersion() {
        return this.gav.getDatedSnapshotVersion();
    }

    public List<MavenRepository> getEffectiveRepositories() {
        return Stream.concat(Stream.of(this.getRepository()), this.getRepositories().stream()).filter(Objects::nonNull).map(r -> {
            if (r.getUri().startsWith("~")) {
                r = r.withUri(Paths.get(System.getProperty("user.home") + r.getUri().substring(1), new String[0]).toUri().toString());
            }
            if (r.getId() != null && ResolvedPom.placeholderHelper.hasPlaceholders(r.getUri())) {
                r = r.withId(ResolvedPom.placeholderHelper.replacePlaceholders(r.getId(), this.properties::get));
            }
            if (ResolvedPom.placeholderHelper.hasPlaceholders(r.getUri())) {
                r = r.withUri(ResolvedPom.placeholderHelper.replacePlaceholders(r.getUri(), this.properties::get));
            }
            return r;
        }).distinct().collect(Collectors.toList());
    }

    public ResolvedPom resolve(Iterable<String> activeProfiles, MavenPomDownloader downloader, ExecutionContext ctx) throws MavenDownloadingException {
        return this.resolve(activeProfiles, downloader, Collections.emptyList(), ctx);
    }

    public ResolvedPom resolve(Iterable<String> activeProfiles, MavenPomDownloader downloader, List<MavenRepository> initialRepositories, ExecutionContext ctx) throws MavenDownloadingException {
        return new ResolvedPom(this, activeProfiles, this.properties, Collections.emptyList(), ListUtils.concatAll(initialRepositories, this.getEffectiveRepositories()), this.repositories, this.dependencies, this.plugins, this.pluginManagement).resolve(ctx, downloader);
    }

    @Nullable
    public String getValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return ResolvedPom.placeholderHelper.replacePlaceholders(value, this.properties::get);
    }

    public boolean hasJarPackaging() {
        return JAR_PACKAGING_TYPES.contains(this.packaging);
    }

    private static Map<String, String> $default$properties() {
        return Collections.emptyMap();
    }

    private static List<ManagedDependency> $default$dependencyManagement() {
        return Collections.emptyList();
    }

    private static List<Dependency> $default$dependencies() {
        return Collections.emptyList();
    }

    private static List<MavenRepository> $default$repositories() {
        return Collections.emptyList();
    }

    private static List<License> $default$licenses() {
        return Collections.emptyList();
    }

    private static List<Profile> $default$profiles() {
        return Collections.emptyList();
    }

    private static List<Plugin> $default$plugins() {
        return Collections.emptyList();
    }

    private static List<Plugin> $default$pluginManagement() {
        return Collections.emptyList();
    }

    @NonNull
    public static PomBuilder builder() {
        return new PomBuilder();
    }

    @Nullable
    public Path getSourcePath() {
        return this.sourcePath;
    }

    @Nullable
    public MavenRepository getRepository() {
        return this.repository;
    }

    @Nullable
    public Parent getParent() {
        return this.parent;
    }

    public ResolvedGroupArtifactVersion getGav() {
        return this.gav;
    }

    @Nullable
    public String getObsoletePomVersion() {
        return this.obsoletePomVersion;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getPackaging() {
        return this.packaging;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public List<ManagedDependency> getDependencyManagement() {
        return this.dependencyManagement;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<MavenRepository> getRepositories() {
        return this.repositories;
    }

    public List<License> getLicenses() {
        return this.licenses;
    }

    public List<Profile> getProfiles() {
        return this.profiles;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public List<Plugin> getPluginManagement() {
        return this.pluginManagement;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pom)) {
            return false;
        }
        Pom other = (Pom)o;
        Path this$sourcePath = this.getSourcePath();
        Path other$sourcePath = other.getSourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
            return false;
        }
        MavenRepository this$repository = this.getRepository();
        MavenRepository other$repository = other.getRepository();
        if (this$repository == null ? other$repository != null : !((Object)this$repository).equals(other$repository)) {
            return false;
        }
        Parent this$parent = this.getParent();
        Parent other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        ResolvedGroupArtifactVersion this$gav = this.getGav();
        ResolvedGroupArtifactVersion other$gav = other.getGav();
        if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
            return false;
        }
        String this$obsoletePomVersion = this.getObsoletePomVersion();
        String other$obsoletePomVersion = other.getObsoletePomVersion();
        if (this$obsoletePomVersion == null ? other$obsoletePomVersion != null : !this$obsoletePomVersion.equals(other$obsoletePomVersion)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$packaging = this.getPackaging();
        String other$packaging = other.getPackaging();
        if (this$packaging == null ? other$packaging != null : !this$packaging.equals(other$packaging)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<ManagedDependency> this$dependencyManagement = this.getDependencyManagement();
        List<ManagedDependency> other$dependencyManagement = other.getDependencyManagement();
        if (this$dependencyManagement == null ? other$dependencyManagement != null : !((Object)this$dependencyManagement).equals(other$dependencyManagement)) {
            return false;
        }
        List<Dependency> this$dependencies = this.getDependencies();
        List<Dependency> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        List<MavenRepository> this$repositories = this.getRepositories();
        List<MavenRepository> other$repositories = other.getRepositories();
        if (this$repositories == null ? other$repositories != null : !((Object)this$repositories).equals(other$repositories)) {
            return false;
        }
        List<License> this$licenses = this.getLicenses();
        List<License> other$licenses = other.getLicenses();
        if (this$licenses == null ? other$licenses != null : !((Object)this$licenses).equals(other$licenses)) {
            return false;
        }
        List<Profile> this$profiles = this.getProfiles();
        List<Profile> other$profiles = other.getProfiles();
        if (this$profiles == null ? other$profiles != null : !((Object)this$profiles).equals(other$profiles)) {
            return false;
        }
        List<Plugin> this$plugins = this.getPlugins();
        List<Plugin> other$plugins = other.getPlugins();
        if (this$plugins == null ? other$plugins != null : !((Object)this$plugins).equals(other$plugins)) {
            return false;
        }
        List<Plugin> this$pluginManagement = this.getPluginManagement();
        List<Plugin> other$pluginManagement = other.getPluginManagement();
        return !(this$pluginManagement == null ? other$pluginManagement != null : !((Object)this$pluginManagement).equals(other$pluginManagement));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path $sourcePath = this.getSourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
        MavenRepository $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : ((Object)$repository).hashCode());
        Parent $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        ResolvedGroupArtifactVersion $gav = this.getGav();
        result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
        String $obsoletePomVersion = this.getObsoletePomVersion();
        result = result * 59 + ($obsoletePomVersion == null ? 43 : $obsoletePomVersion.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $packaging = this.getPackaging();
        result = result * 59 + ($packaging == null ? 43 : $packaging.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<ManagedDependency> $dependencyManagement = this.getDependencyManagement();
        result = result * 59 + ($dependencyManagement == null ? 43 : ((Object)$dependencyManagement).hashCode());
        List<Dependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        List<MavenRepository> $repositories = this.getRepositories();
        result = result * 59 + ($repositories == null ? 43 : ((Object)$repositories).hashCode());
        List<License> $licenses = this.getLicenses();
        result = result * 59 + ($licenses == null ? 43 : ((Object)$licenses).hashCode());
        List<Profile> $profiles = this.getProfiles();
        result = result * 59 + ($profiles == null ? 43 : ((Object)$profiles).hashCode());
        List<Plugin> $plugins = this.getPlugins();
        result = result * 59 + ($plugins == null ? 43 : ((Object)$plugins).hashCode());
        List<Plugin> $pluginManagement = this.getPluginManagement();
        result = result * 59 + ($pluginManagement == null ? 43 : ((Object)$pluginManagement).hashCode());
        return result;
    }

    @NonNull
    public String toString() {
        return "Pom(sourcePath=" + this.getSourcePath() + ", repository=" + this.getRepository() + ", parent=" + this.getParent() + ", gav=" + this.getGav() + ", obsoletePomVersion=" + this.getObsoletePomVersion() + ", name=" + this.getName() + ", packaging=" + this.getPackaging() + ", properties=" + this.getProperties() + ", dependencyManagement=" + this.getDependencyManagement() + ", dependencies=" + this.getDependencies() + ", repositories=" + this.getRepositories() + ", licenses=" + this.getLicenses() + ", profiles=" + this.getProfiles() + ", plugins=" + this.getPlugins() + ", pluginManagement=" + this.getPluginManagement() + ")";
    }

    @NonNull
    public Pom withSourcePath(@Nullable Path sourcePath) {
        return this.sourcePath == sourcePath ? this : new Pom(sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withRepository(@Nullable MavenRepository repository) {
        return this.repository == repository ? this : new Pom(this.sourcePath, repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withParent(@Nullable Parent parent) {
        return this.parent == parent ? this : new Pom(this.sourcePath, this.repository, parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withGav(ResolvedGroupArtifactVersion gav) {
        return this.gav == gav ? this : new Pom(this.sourcePath, this.repository, this.parent, gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withObsoletePomVersion(@Nullable String obsoletePomVersion) {
        return this.obsoletePomVersion == obsoletePomVersion ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withName(@Nullable String name) {
        return this.name == name ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withPackaging(@Nullable String packaging) {
        return this.packaging == packaging ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withProperties(Map<String, String> properties) {
        return this.properties == properties ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withDependencyManagement(List<ManagedDependency> dependencyManagement) {
        return this.dependencyManagement == dependencyManagement ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withDependencies(List<Dependency> dependencies) {
        return this.dependencies == dependencies ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, dependencies, this.repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withRepositories(List<MavenRepository> repositories) {
        return this.repositories == repositories ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, repositories, this.licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withLicenses(List<License> licenses) {
        return this.licenses == licenses ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, licenses, this.profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withProfiles(List<Profile> profiles) {
        return this.profiles == profiles ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, profiles, this.plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withPlugins(List<Plugin> plugins) {
        return this.plugins == plugins ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, plugins, this.pluginManagement);
    }

    @NonNull
    public Pom withPluginManagement(List<Plugin> pluginManagement) {
        return this.pluginManagement == pluginManagement ? this : new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, this.properties, this.dependencyManagement, this.dependencies, this.repositories, this.licenses, this.profiles, this.plugins, pluginManagement);
    }

    public Pom(@Nullable Path sourcePath, @Nullable MavenRepository repository, @Nullable Parent parent, ResolvedGroupArtifactVersion gav, @Nullable String obsoletePomVersion, @Nullable String name, @Nullable String packaging, Map<String, String> properties, List<ManagedDependency> dependencyManagement, List<Dependency> dependencies, List<MavenRepository> repositories, List<License> licenses, List<Profile> profiles, List<Plugin> plugins, List<Plugin> pluginManagement) {
        this.sourcePath = sourcePath;
        this.repository = repository;
        this.parent = parent;
        this.gav = gav;
        this.obsoletePomVersion = obsoletePomVersion;
        this.name = name;
        this.packaging = packaging;
        this.properties = properties;
        this.dependencyManagement = dependencyManagement;
        this.dependencies = dependencies;
        this.repositories = repositories;
        this.licenses = licenses;
        this.profiles = profiles;
        this.plugins = plugins;
        this.pluginManagement = pluginManagement;
    }

    public static class PomBuilder {
        private Path sourcePath;
        private MavenRepository repository;
        private Parent parent;
        private ResolvedGroupArtifactVersion gav;
        private String obsoletePomVersion;
        private String name;
        private String packaging;
        private boolean properties$set;
        private Map<String, String> properties$value;
        private boolean dependencyManagement$set;
        private List<ManagedDependency> dependencyManagement$value;
        private boolean dependencies$set;
        private List<Dependency> dependencies$value;
        private boolean repositories$set;
        private List<MavenRepository> repositories$value;
        private boolean licenses$set;
        private List<License> licenses$value;
        private boolean profiles$set;
        private List<Profile> profiles$value;
        private boolean plugins$set;
        private List<Plugin> plugins$value;
        private boolean pluginManagement$set;
        private List<Plugin> pluginManagement$value;

        PomBuilder() {
        }

        @NonNull
        public PomBuilder sourcePath(@Nullable Path sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        @NonNull
        public PomBuilder repository(@Nullable MavenRepository repository) {
            this.repository = repository;
            return this;
        }

        @NonNull
        public PomBuilder parent(@Nullable Parent parent) {
            this.parent = parent;
            return this;
        }

        @NonNull
        public PomBuilder gav(ResolvedGroupArtifactVersion gav) {
            this.gav = gav;
            return this;
        }

        @NonNull
        public PomBuilder obsoletePomVersion(@Nullable String obsoletePomVersion) {
            this.obsoletePomVersion = obsoletePomVersion;
            return this;
        }

        @NonNull
        public PomBuilder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public PomBuilder packaging(@Nullable String packaging) {
            this.packaging = packaging;
            return this;
        }

        @NonNull
        public PomBuilder properties(Map<String, String> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        @NonNull
        public PomBuilder dependencyManagement(List<ManagedDependency> dependencyManagement) {
            this.dependencyManagement$value = dependencyManagement;
            this.dependencyManagement$set = true;
            return this;
        }

        @NonNull
        public PomBuilder dependencies(List<Dependency> dependencies) {
            this.dependencies$value = dependencies;
            this.dependencies$set = true;
            return this;
        }

        @NonNull
        public PomBuilder repositories(List<MavenRepository> repositories) {
            this.repositories$value = repositories;
            this.repositories$set = true;
            return this;
        }

        @NonNull
        public PomBuilder licenses(List<License> licenses) {
            this.licenses$value = licenses;
            this.licenses$set = true;
            return this;
        }

        @NonNull
        public PomBuilder profiles(List<Profile> profiles) {
            this.profiles$value = profiles;
            this.profiles$set = true;
            return this;
        }

        @NonNull
        public PomBuilder plugins(List<Plugin> plugins) {
            this.plugins$value = plugins;
            this.plugins$set = true;
            return this;
        }

        @NonNull
        public PomBuilder pluginManagement(List<Plugin> pluginManagement) {
            this.pluginManagement$value = pluginManagement;
            this.pluginManagement$set = true;
            return this;
        }

        @NonNull
        public Pom build() {
            Map properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = Pom.$default$properties();
            }
            List dependencyManagement$value = this.dependencyManagement$value;
            if (!this.dependencyManagement$set) {
                dependencyManagement$value = Pom.$default$dependencyManagement();
            }
            List dependencies$value = this.dependencies$value;
            if (!this.dependencies$set) {
                dependencies$value = Pom.$default$dependencies();
            }
            List repositories$value = this.repositories$value;
            if (!this.repositories$set) {
                repositories$value = Pom.$default$repositories();
            }
            List licenses$value = this.licenses$value;
            if (!this.licenses$set) {
                licenses$value = Pom.$default$licenses();
            }
            List profiles$value = this.profiles$value;
            if (!this.profiles$set) {
                profiles$value = Pom.$default$profiles();
            }
            List plugins$value = this.plugins$value;
            if (!this.plugins$set) {
                plugins$value = Pom.$default$plugins();
            }
            List pluginManagement$value = this.pluginManagement$value;
            if (!this.pluginManagement$set) {
                pluginManagement$value = Pom.$default$pluginManagement();
            }
            return new Pom(this.sourcePath, this.repository, this.parent, this.gav, this.obsoletePomVersion, this.name, this.packaging, properties$value, dependencyManagement$value, dependencies$value, repositories$value, licenses$value, profiles$value, plugins$value, pluginManagement$value);
        }

        @NonNull
        public String toString() {
            return "Pom.PomBuilder(sourcePath=" + this.sourcePath + ", repository=" + this.repository + ", parent=" + this.parent + ", gav=" + this.gav + ", obsoletePomVersion=" + this.obsoletePomVersion + ", name=" + this.name + ", packaging=" + this.packaging + ", properties$value=" + this.properties$value + ", dependencyManagement$value=" + this.dependencyManagement$value + ", dependencies$value=" + this.dependencies$value + ", repositories$value=" + this.repositories$value + ", licenses$value=" + this.licenses$value + ", profiles$value=" + this.profiles$value + ", plugins$value=" + this.plugins$value + ", pluginManagement$value=" + this.pluginManagement$value + ")";
        }
    }
}

