/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.tree.MavenRepository;

public class MavenRepositoryMirror {
    @Nullable
    private final String id;
    @Nullable
    private final String url;
    @Nullable
    private final String mirrorOf;
    @Nullable
    private final Boolean releases;
    @Nullable
    private final Boolean snapshots;
    @Nullable
    private final Long timeout;
    private final boolean externalOnly;
    private final List<String> mirrorsOf;
    private final Set<String> excludedRepos;
    private final Set<String> includedRepos;

    public MavenRepositoryMirror(@Nullable String id, @Nullable String url, @Nullable String mirrorOf, @Nullable Boolean releases, @Nullable Boolean snapshots, @Nullable MavenSettings.Servers servers) {
        this.id = id;
        this.url = url;
        this.mirrorOf = mirrorOf;
        this.releases = releases;
        this.snapshots = snapshots;
        if (mirrorOf != null) {
            Optional<MavenSettings.Server> maybeServer;
            String mirrorOfWithoutExternal;
            int colonIndex = mirrorOf.indexOf(58);
            if (colonIndex == -1) {
                mirrorOfWithoutExternal = mirrorOf;
                this.externalOnly = false;
            } else {
                this.externalOnly = true;
                mirrorOfWithoutExternal = mirrorOf.substring(colonIndex + 1);
            }
            this.mirrorsOf = Arrays.stream(mirrorOfWithoutExternal.split(",")).collect(Collectors.toList());
            this.excludedRepos = new HashSet<String>();
            this.includedRepos = new HashSet<String>();
            for (String mirror : this.mirrorsOf) {
                if (mirror.startsWith("!")) {
                    this.excludedRepos.add(mirror.substring(1));
                    continue;
                }
                this.includedRepos.add(mirror);
            }
            this.timeout = id != null && servers != null && servers.getServers() != null ? ((maybeServer = servers.getServers().stream().filter(s -> id.equals(s.getId()) && s.getConfiguration() != null).findFirst()).isPresent() && maybeServer.get().getConfiguration() != null ? maybeServer.get().getConfiguration().getTimeout() : null) : null;
        } else {
            this.externalOnly = false;
            this.mirrorsOf = null;
            this.includedRepos = null;
            this.excludedRepos = null;
            this.timeout = null;
        }
    }

    public static MavenRepository apply(Collection<MavenRepositoryMirror> mirrors, MavenRepository repo) {
        for (MavenRepositoryMirror mirror : mirrors) {
            MavenRepository mapped = mirror.apply(repo);
            if (mapped == repo) continue;
            return mapped;
        }
        return repo;
    }

    public MavenRepository apply(MavenRepository repo) {
        if (this.matches(repo)) {
            return repo.withUri(this.url).withId(this.id).withReleases(!Boolean.FALSE.equals(this.releases) ? "true" : "false").withSnapshots(!Boolean.FALSE.equals(this.snapshots) ? "true" : "false").withKnownToExist(false).withTimeout(repo.getTimeout());
        }
        return repo;
    }

    public boolean matches(MavenRepository repository) {
        if (this.mirrorOf == null) {
            return false;
        }
        if ("*".equals(this.mirrorOf)) {
            return true;
        }
        if (this.externalOnly && this.isInternal(repository)) {
            return false;
        }
        if (this.excludedRepos.contains("*")) {
            return this.includedRepos.contains(repository.getId());
        }
        if (this.includedRepos.contains("*")) {
            return !this.excludedRepos.contains(repository.getId());
        }
        return !this.excludedRepos.contains(repository.getId()) && this.includedRepos.contains(repository.getId());
    }

    private boolean isInternal(MavenRepository repo) {
        if (repo.getUri().regionMatches(true, 0, "file:", 0, 5)) {
            return true;
        }
        try {
            URI uri = new URI(repo.getUri());
            return "localhost".equals(uri.getHost()) || "127.0.0.1".equals(uri.getHost());
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Nullable
    @Generated
    public String getId() {
        return this.id;
    }

    @Nullable
    @Generated
    public String getUrl() {
        return this.url;
    }

    @Nullable
    @Generated
    public String getMirrorOf() {
        return this.mirrorOf;
    }

    @Nullable
    @Generated
    public Boolean getReleases() {
        return this.releases;
    }

    @Nullable
    @Generated
    public Boolean getSnapshots() {
        return this.snapshots;
    }

    @Nullable
    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isExternalOnly() {
        return this.externalOnly;
    }

    @Generated
    public List<String> getMirrorsOf() {
        return this.mirrorsOf;
    }

    @Generated
    public Set<String> getExcludedRepos() {
        return this.excludedRepos;
    }

    @Generated
    public Set<String> getIncludedRepos() {
        return this.includedRepos;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenRepositoryMirror)) {
            return false;
        }
        MavenRepositoryMirror other = (MavenRepositoryMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isExternalOnly() != other.isExternalOnly()) {
            return false;
        }
        Boolean this$releases = this.getReleases();
        Boolean other$releases = other.getReleases();
        if (this$releases == null ? other$releases != null : !((Object)this$releases).equals(other$releases)) {
            return false;
        }
        Boolean this$snapshots = this.getSnapshots();
        Boolean other$snapshots = other.getSnapshots();
        if (this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$mirrorOf = this.getMirrorOf();
        String other$mirrorOf = other.getMirrorOf();
        if (this$mirrorOf == null ? other$mirrorOf != null : !this$mirrorOf.equals(other$mirrorOf)) {
            return false;
        }
        List<String> this$mirrorsOf = this.getMirrorsOf();
        List<String> other$mirrorsOf = other.getMirrorsOf();
        if (this$mirrorsOf == null ? other$mirrorsOf != null : !((Object)this$mirrorsOf).equals(other$mirrorsOf)) {
            return false;
        }
        Set<String> this$excludedRepos = this.getExcludedRepos();
        Set<String> other$excludedRepos = other.getExcludedRepos();
        if (this$excludedRepos == null ? other$excludedRepos != null : !((Object)this$excludedRepos).equals(other$excludedRepos)) {
            return false;
        }
        Set<String> this$includedRepos = this.getIncludedRepos();
        Set<String> other$includedRepos = other.getIncludedRepos();
        return !(this$includedRepos == null ? other$includedRepos != null : !((Object)this$includedRepos).equals(other$includedRepos));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MavenRepositoryMirror;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isExternalOnly() ? 79 : 97);
        Boolean $releases = this.getReleases();
        result = result * 59 + ($releases == null ? 43 : ((Object)$releases).hashCode());
        Boolean $snapshots = this.getSnapshots();
        result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $mirrorOf = this.getMirrorOf();
        result = result * 59 + ($mirrorOf == null ? 43 : $mirrorOf.hashCode());
        List<String> $mirrorsOf = this.getMirrorsOf();
        result = result * 59 + ($mirrorsOf == null ? 43 : ((Object)$mirrorsOf).hashCode());
        Set<String> $excludedRepos = this.getExcludedRepos();
        result = result * 59 + ($excludedRepos == null ? 43 : ((Object)$excludedRepos).hashCode());
        Set<String> $includedRepos = this.getIncludedRepos();
        result = result * 59 + ($includedRepos == null ? 43 : ((Object)$includedRepos).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenRepositoryMirror(id=" + this.getId() + ", url=" + this.getUrl() + ", mirrorOf=" + this.getMirrorOf() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ", timeout=" + this.getTimeout() + ", externalOnly=" + this.isExternalOnly() + ", mirrorsOf=" + this.getMirrorsOf() + ", excludedRepos=" + this.getExcludedRepos() + ", includedRepos=" + this.getIncludedRepos() + ")";
    }
}

