/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.AddManagedDependencyVisitor;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class ManageDependencies
extends ScanningRecipe<Map<GroupArtifactVersion, Collection<ResolvedDependency>>> {
    private static final XPathMatcher MANAGED_DEPENDENCIES_MATCHER = new XPathMatcher("/project/dependencyManagement/dependencies");
    @Option(displayName="Group", description="Group glob expression pattern used to match dependencies that should be managed.Group is the first part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="com.google.*")
    private final String groupPattern;
    @Option(displayName="Artifact", description="Artifact glob expression pattern used to match dependencies that should be managed.Artifact is the second part of a dependency coordinate `com.google.guava:guava:VERSION`.", example="guava*", required=false)
    @Nullable
    private final String artifactPattern;
    @Option(displayName="Add to the root POM", description="Add to the root POM where root is the eldest parent of the pom within the source set.", required=false)
    @Nullable
    private final Boolean addToRootPom;
    @Option(displayName="Skip model updates", description="Optionally skip updating the dependency model after managing dependencies. Updating the model does not affect the source code of the POM,but will cause the resolved dependency model to reflect the changes made to the POM. If this recipe is ran standalone, it is not necessary to update the model.", required=false)
    @Nullable
    private final Boolean skipModelUpdate;

    public String getDisplayName() {
        return "Manage dependencies";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s`", this.groupPattern, this.artifactPattern);
    }

    public String getDescription() {
        return "Make existing dependencies managed by moving their version to be specified in the dependencyManagement section of the POM.";
    }

    public Map<GroupArtifactVersion, Collection<ResolvedDependency>> getInitialValue(ExecutionContext ctx) {
        return new HashMap<GroupArtifactVersion, Collection<ResolvedDependency>>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Map<GroupArtifactVersion, Collection<ResolvedDependency>> rootGavToDependencies) {
        return Preconditions.check((boolean)Boolean.TRUE.equals(this.addToRootPom), (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Document visitDocument(Xml.Document document, ExecutionContext ctx) {
                Xml.Document doc = super.visitDocument(document, ctx);
                List<ResolvedDependency> manageableDependencies = this.findDependencies(ManageDependencies.this.groupPattern, ManageDependencies.this.artifactPattern != null ? ManageDependencies.this.artifactPattern : "*");
                ResolvedGroupArtifactVersion root = ManageDependencies.this.findRootPom(this.getResolutionResult()).getPom().getGav();
                rootGavToDependencies.computeIfAbsent(new GroupArtifactVersion(root.getGroupId(), root.getArtifactId(), root.getVersion()), v -> new ArrayList()).addAll(manageableDependencies);
                return doc;
            }
        });
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Map<GroupArtifactVersion, Collection<ResolvedDependency>> rootGavToDependencies) {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Collection<ResolvedDependency> manageableDependencies;
                Xml maven = super.visitDocument(document, (Object)ctx);
                if (Boolean.TRUE.equals(ManageDependencies.this.addToRootPom)) {
                    ResolvedPom pom = this.getResolutionResult().getPom();
                    GroupArtifactVersion gav = new GroupArtifactVersion(pom.getGav().getGroupId(), pom.getGav().getArtifactId(), pom.getGav().getVersion());
                    manageableDependencies = (Collection)rootGavToDependencies.get(gav);
                } else {
                    manageableDependencies = this.findDependencies(ManageDependencies.this.groupPattern, ManageDependencies.this.artifactPattern != null ? ManageDependencies.this.artifactPattern : "*");
                }
                if (manageableDependencies != null) {
                    HashMap<GroupArtifact, ResolvedDependency> maxVersionByGroupArtifact = new HashMap<GroupArtifact, ResolvedDependency>(manageableDependencies.size());
                    for (ResolvedDependency rmd : manageableDependencies) {
                        String alreadyManagedVersion = this.getResolutionResult().getPom().getManagedVersion(rmd.getGroupId(), rmd.getArtifactId(), rmd.getType(), rmd.getClassifier());
                        if (rmd.getDepth() > 1 || alreadyManagedVersion != null) continue;
                        maxVersionByGroupArtifact.compute(new GroupArtifact(rmd.getGroupId(), rmd.getArtifactId()), (ga, existing) -> existing == null || existing.getVersion().compareTo(rmd.getVersion()) < 0 ? rmd : existing);
                    }
                    for (ResolvedDependency rmd : maxVersionByGroupArtifact.values()) {
                        this.doAfterVisit((TreeVisitor)new AddManagedDependencyVisitor(rmd.getGroupId(), rmd.getArtifactId(), rmd.getVersion(), null, null, rmd.getRequested().getClassifier()));
                        if (Boolean.TRUE.equals(ManageDependencies.this.skipModelUpdate)) continue;
                        this.maybeUpdateModel();
                    }
                }
                this.doAfterVisit((TreeVisitor)new RemoveVersionTagVisitor(ManageDependencies.this.groupPattern, ManageDependencies.this.artifactPattern != null ? ManageDependencies.this.artifactPattern : "*"));
                return maven;
            }
        };
    }

    private MavenResolutionResult findRootPom(MavenResolutionResult pom) {
        if (pom.getParent() == null) {
            return pom;
        }
        return this.findRootPom(pom.getParent());
    }

    @Generated
    public ManageDependencies(String groupPattern, @Nullable String artifactPattern, @Nullable Boolean addToRootPom, @Nullable Boolean skipModelUpdate) {
        this.groupPattern = groupPattern;
        this.artifactPattern = artifactPattern;
        this.addToRootPom = addToRootPom;
        this.skipModelUpdate = skipModelUpdate;
    }

    @Generated
    public String getGroupPattern() {
        return this.groupPattern;
    }

    @Nullable
    @Generated
    public String getArtifactPattern() {
        return this.artifactPattern;
    }

    @Nullable
    @Generated
    public Boolean getAddToRootPom() {
        return this.addToRootPom;
    }

    @Nullable
    @Generated
    public Boolean getSkipModelUpdate() {
        return this.skipModelUpdate;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ManageDependencies(groupPattern=" + this.getGroupPattern() + ", artifactPattern=" + this.getArtifactPattern() + ", addToRootPom=" + this.getAddToRootPom() + ", skipModelUpdate=" + this.getSkipModelUpdate() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ManageDependencies)) {
            return false;
        }
        ManageDependencies other = (ManageDependencies)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$addToRootPom = this.getAddToRootPom();
        Boolean other$addToRootPom = other.getAddToRootPom();
        if (this$addToRootPom == null ? other$addToRootPom != null : !((Object)this$addToRootPom).equals(other$addToRootPom)) {
            return false;
        }
        Boolean this$skipModelUpdate = this.getSkipModelUpdate();
        Boolean other$skipModelUpdate = other.getSkipModelUpdate();
        if (this$skipModelUpdate == null ? other$skipModelUpdate != null : !((Object)this$skipModelUpdate).equals(other$skipModelUpdate)) {
            return false;
        }
        String this$groupPattern = this.getGroupPattern();
        String other$groupPattern = other.getGroupPattern();
        if (this$groupPattern == null ? other$groupPattern != null : !this$groupPattern.equals(other$groupPattern)) {
            return false;
        }
        String this$artifactPattern = this.getArtifactPattern();
        String other$artifactPattern = other.getArtifactPattern();
        return !(this$artifactPattern == null ? other$artifactPattern != null : !this$artifactPattern.equals(other$artifactPattern));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ManageDependencies;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $addToRootPom = this.getAddToRootPom();
        result = result * 59 + ($addToRootPom == null ? 43 : ((Object)$addToRootPom).hashCode());
        Boolean $skipModelUpdate = this.getSkipModelUpdate();
        result = result * 59 + ($skipModelUpdate == null ? 43 : ((Object)$skipModelUpdate).hashCode());
        String $groupPattern = this.getGroupPattern();
        result = result * 59 + ($groupPattern == null ? 43 : $groupPattern.hashCode());
        String $artifactPattern = this.getArtifactPattern();
        result = result * 59 + ($artifactPattern == null ? 43 : $artifactPattern.hashCode());
        return result;
    }

    private static class RemoveVersionTagVisitor
    extends MavenIsoVisitor<ExecutionContext> {
        private final String groupPattern;
        private final String artifactPattern;

        public RemoveVersionTagVisitor(String groupPattern, String artifactPattern) {
            this.groupPattern = groupPattern;
            this.artifactPattern = artifactPattern;
        }

        @Override
        public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
            if (this.isDependencyTag() && this.isDependencyTag(this.groupPattern, this.artifactPattern)) {
                tag.getChild("version").ifPresent(versionTag -> this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)versionTag, false)));
                return tag;
            }
            return super.visitTag(tag, ctx);
        }
    }
}

