/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.internal;

import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.HttpSenderExecutionContextView;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.ipc.http.HttpSender;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenRepositoryCredentials;
import org.openrewrite.maven.tree.MavenRepositoryMirror;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.Semver;

public class MavenPomDownloader {
    private static final RetryPolicy<Object> retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().handle(new Class[]{SocketTimeoutException.class, TimeoutException.class})).handleIf(throwable -> throwable instanceof UncheckedIOException && throwable.getCause() instanceof SocketTimeoutException)).withDelay(Duration.ofMillis(500L)).withJitter(0.1).withMaxRetries(5).build();
    private static final Pattern SNAPSHOT_TIMESTAMP = Pattern.compile("^(.*-)?([0-9]{8}\\.[0-9]{6}-[0-9]+)$");
    private static final String SNAPSHOT = "SNAPSHOT";
    private final MavenPomCache mavenCache;
    private final Map<Path, Pom> projectPoms;
    private final Map<GroupArtifactVersion, Pom> projectPomsByGav;
    private final MavenExecutionContextView ctx;
    private final HttpSender httpSender;
    private @Nullable MavenSettings mavenSettings;
    private Collection<MavenRepositoryMirror> mirrors;
    private @Nullable List<String> activeProfiles;
    private boolean addCentralRepository;
    private boolean addLocalRepository;

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx, @Nullable MavenSettings mavenSettings, @Nullable List<String> activeProfiles) {
        this(projectPoms, HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
        this.mavenSettings = mavenSettings != null ? mavenSettings : MavenExecutionContextView.view(ctx).getSettings();
        this.mirrors = this.ctx.getMirrors(mavenSettings);
        this.activeProfiles = activeProfiles;
    }

    public MavenPomDownloader(ExecutionContext ctx) {
        this(Collections.emptyMap(), HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
        this.addCentralRepository = Boolean.TRUE.equals(MavenExecutionContextView.view(ctx).getAddCentralRepository());
        this.addLocalRepository = Boolean.TRUE.equals(MavenExecutionContextView.view(ctx).getAddLocalRepository());
    }

    public MavenPomDownloader(Map<Path, Pom> projectPoms, ExecutionContext ctx) {
        this(projectPoms, HttpSenderExecutionContextView.view((ExecutionContext)ctx).getHttpSender(), ctx);
    }

    @Deprecated
    public MavenPomDownloader(Map<Path, Pom> projectPoms, HttpSender httpSender, ExecutionContext ctx) {
        this.projectPoms = projectPoms;
        this.projectPomsByGav = this.projectPomsByGav(projectPoms);
        this.httpSender = httpSender;
        this.ctx = MavenExecutionContextView.view(ctx);
        this.mavenSettings = this.ctx.getSettings();
        this.mavenCache = this.ctx.getPomCache();
        this.addCentralRepository = !Boolean.FALSE.equals(MavenExecutionContextView.view(ctx).getAddCentralRepository());
        this.addLocalRepository = !Boolean.FALSE.equals(MavenExecutionContextView.view(ctx).getAddLocalRepository());
        this.mirrors = this.ctx.getMirrors(this.ctx.getSettings());
    }

    byte[] sendRequest(HttpSender.Request request) throws IOException, HttpSenderResponseException {
        long start = System.nanoTime();
        try {
            byte[] byArray = (byte[])Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
                try (HttpSender.Response response = this.httpSender.send(request);){
                    if (!response.isSuccessful()) {
                        throw new HttpSenderResponseException(null, response.getCode(), new String(response.getBodyAsBytes()));
                    }
                    byte[] byArray = response.getBodyAsBytes();
                    return byArray;
                }
            });
            return byArray;
        }
        catch (FailsafeException failsafeException) {
            if (failsafeException.getCause() instanceof HttpSenderResponseException) {
                throw (HttpSenderResponseException)failsafeException.getCause();
            }
            throw failsafeException;
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        finally {
            this.ctx.recordResolutionTime(Duration.ofNanos(System.nanoTime() - start));
        }
    }

    private Map<GroupArtifactVersion, Pom> projectPomsByGav(Map<Path, Pom> projectPoms) {
        HashMap<GroupArtifactVersion, Pom> result = new HashMap<GroupArtifactVersion, Pom>();
        for (Pom projectPom : projectPoms.values()) {
            List<Pom> ancestryWithinProject = this.getAncestryWithinProject(projectPom, projectPoms);
            Map<String, String> mergedProperties = this.mergeProperties(ancestryWithinProject);
            GroupArtifactVersion gav = new GroupArtifactVersion(projectPom.getGroupId(), projectPom.getArtifactId(), ResolvedPom.placeholderHelper.replacePlaceholders(projectPom.getVersion(), mergedProperties::get));
            result.put(gav, projectPom);
        }
        return result;
    }

    private Map<String, String> mergeProperties(List<Pom> pomAncestry) {
        HashMap<String, String> mergedProperties = new HashMap<String, String>();
        for (Pom pom : pomAncestry) {
            for (Map.Entry<String, String> property : pom.getProperties().entrySet()) {
                mergedProperties.putIfAbsent(property.getKey(), property.getValue());
            }
        }
        return mergedProperties;
    }

    private List<Pom> getAncestryWithinProject(Pom projectPom, Map<Path, Pom> projectPoms) {
        Pom parentPom = this.getParentWithinProject(projectPom, projectPoms);
        if (parentPom == null) {
            return Collections.singletonList(projectPom);
        }
        return ListUtils.concat((Object)projectPom, this.getAncestryWithinProject(parentPom, projectPoms));
    }

    private @Nullable Pom getParentWithinProject(Pom projectPom, Map<Path, Pom> projectPoms) {
        Path parentPath;
        Pom parentPom;
        Parent parent = projectPom.getParent();
        if (parent == null || projectPom.getSourcePath() == null) {
            return null;
        }
        String relativePath = parent.getRelativePath();
        if (StringUtils.isBlank((String)relativePath)) {
            relativePath = "../pom.xml";
        }
        return (parentPom = projectPoms.get(parentPath = projectPom.getSourcePath().resolve("..").resolve(Paths.get(relativePath, new String[0])).normalize())) != null && parentPom.getGav().getGroupId().equals(parent.getGav().getGroupId()) && parentPom.getGav().getArtifactId().equals(parent.getGav().getArtifactId()) ? parentPom : null;
    }

    public MavenMetadata downloadMetadata(GroupArtifact groupArtifact, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        return this.downloadMetadata(new GroupArtifactVersion(groupArtifact.getGroupId(), groupArtifact.getArtifactId(), null), containingPom, repositories);
    }

    public MavenMetadata downloadMetadata(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        if (gav.getGroupId() == null) {
            throw new MavenDownloadingException("Missing group id.", null, gav);
        }
        if (containingPom != null) {
            gav = containingPom.getValues(gav);
        }
        this.ctx.getResolutionListener().downloadMetadata(gav);
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("type", "metadata");
        MavenMetadata mavenMetadata = null;
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, null);
        LinkedHashMap<MavenRepository, String> repositoryResponses = new LinkedHashMap<MavenRepository, String>();
        ArrayList<String> attemptedUris = new ArrayList<String>(normalizedRepos.size());
        for (MavenRepository repo : normalizedRepos) {
            this.ctx.getResolutionListener().repository(repo, containingPom);
            if (gav.getVersion() != null && !this.repositoryAcceptsVersion(repo, gav.getVersion(), containingPom)) continue;
            attemptedUris.add(repo.getUri());
            Optional<MavenMetadata> result = this.mavenCache.getMavenMetadata(URI.create(repo.getUri()), gav);
            if (result == null) {
                boolean cacheEmptyResult = false;
                try {
                    MavenMetadata parsed;
                    String scheme = URI.create(repo.getUri()).getScheme();
                    String baseUri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + Objects.requireNonNull(gav.getGroupId()).replace('.', '/') + '/' + gav.getArtifactId() + '/' + (gav.getVersion() == null ? "" : gav.getVersion() + '/');
                    if ("file".equals(scheme)) {
                        Path path = Paths.get(URI.create(baseUri + "maven-metadata-local.xml"));
                        if (Files.exists(path, new LinkOption[0]) && (parsed = MavenMetadata.parse(Files.readAllBytes(path))) != null) {
                            result = Optional.of(parsed);
                        }
                    } else {
                        byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, baseUri + "maven-metadata.xml");
                        parsed = MavenMetadata.parse(responseBody);
                        if (parsed != null) {
                            result = Optional.of(parsed);
                        }
                    }
                }
                catch (HttpSenderResponseException e) {
                    repositoryResponses.put(repo, e.getMessage());
                    if (e.isClientSideException()) {
                        cacheEmptyResult = true;
                    }
                }
                catch (IOException e) {
                    repositoryResponses.put(repo, e.getMessage());
                }
                if (result == null) {
                    try {
                        MavenMetadata derivedMeta = this.deriveMetadata(gav, repo);
                        if (derivedMeta != null) {
                            Counter.builder((String)"rewrite.maven.derived.metadata").tag("repositoryUri", repo.getUri()).tag("group", gav.getGroupId()).tag("artifact", gav.getArtifactId()).register((MeterRegistry)Metrics.globalRegistry).increment();
                            result = Optional.of(derivedMeta);
                        }
                    }
                    catch (IOException | MavenDownloadingException | HttpSenderResponseException e) {
                        repositoryResponses.put(repo, e.getMessage());
                    }
                }
                if (result == null && cacheEmptyResult) {
                    this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, null);
                }
            } else if (!result.isPresent()) {
                repositoryResponses.put(repo, "Did not attempt to download because of a previous failure to retrieve from this repository.");
            }
            if (result == null || !result.isPresent()) continue;
            mavenMetadata = mavenMetadata == null ? result.get() : this.mergeMetadata(mavenMetadata, result.get());
            this.mavenCache.putMavenMetadata(URI.create(repo.getUri()), gav, result.get());
        }
        if (mavenMetadata == null) {
            sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
            this.ctx.getResolutionListener().downloadError(gav, attemptedUris, null);
            throw new MavenDownloadingException("Unable to download metadata.", null, gav).setRepositoryResponses(repositoryResponses);
        }
        sample.stop(timer.tags(new String[]{"outcome", "success"}).register((MeterRegistry)Metrics.globalRegistry));
        return mavenMetadata;
    }

    private @Nullable MavenMetadata deriveMetadata(GroupArtifactVersion gav, MavenRepository repo) throws HttpSenderResponseException, IOException, MavenDownloadingException {
        if (repo.getDeriveMetadataIfMissing() != null && !repo.getDeriveMetadataIfMissing().booleanValue() || gav.getVersion() != null) {
            return null;
        }
        String scheme = URI.create(repo.getUri()).getScheme();
        String uri = repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + Objects.requireNonNull(gav.getGroupId()).replace('.', '/') + '/' + gav.getArtifactId() + '/';
        try {
            MavenMetadata.Versioning versioning;
            if ("file".equals(scheme)) {
                versioning = this.directoryToVersioning(uri, gav);
            } else {
                String responseBody = new String(this.requestAsAuthenticatedOrAnonymous(repo, uri));
                versioning = this.htmlIndexToVersioning(responseBody, uri);
            }
            if (versioning == null) {
                return null;
            }
            return new MavenMetadata(versioning);
        }
        catch (HttpSenderResponseException e) {
            if (e.isClientSideException() && e.getResponseCode() != null && e.getResponseCode() != 404) {
                repo.setDeriveMetadataIfMissing(false);
            }
            throw e;
        }
    }

    private @Nullable MavenMetadata.Versioning directoryToVersioning(String uri, GroupArtifactVersion gav) throws MavenDownloadingException {
        Path dir = Paths.get(URI.create(uri));
        if (Files.exists(dir, new LinkOption[0])) {
            MavenMetadata.Versioning versioning;
            block10: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(dir);
                try {
                    ArrayList<String> versions = new ArrayList<String>();
                    for (Path path : stream) {
                        if (!Files.isDirectory(path, new LinkOption[0]) || !MavenPomDownloader.hasPomFile(dir, path, gav)) continue;
                        versions.add(path.getFileName().toString());
                    }
                    versioning = new MavenMetadata.Versioning(versions, null, null, null, null, null);
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new MavenDownloadingException("Unable to derive metadata from file repository. " + e.getMessage(), null, gav);
                    }
                }
                stream.close();
            }
            return versioning;
        }
        return null;
    }

    private @Nullable MavenMetadata.Versioning htmlIndexToVersioning(String responseBody, String uri) {
        int end;
        ArrayList<String> versions = new ArrayList<String>();
        int start = responseBody.indexOf("<a href=\"");
        while (start > 0 && (end = responseBody.indexOf("\">", start += 9)) >= 0) {
            String href = responseBody.substring(start, end).trim();
            if (href.endsWith("/")) {
                versions.add(this.hrefToVersion(href, uri));
            }
            start = responseBody.indexOf("<a href=\"", end);
        }
        if (versions.isEmpty()) {
            return null;
        }
        return new MavenMetadata.Versioning(versions, null, null, null, null, null);
    }

    String hrefToVersion(String href, String rootUri) {
        String version = href.startsWith(rootUri) ? href.substring(rootUri.length()) : href;
        if (version.endsWith("/")) {
            return version.substring(0, version.length() - 1);
        }
        return version;
    }

    protected MavenMetadata mergeMetadata(MavenMetadata m1, MavenMetadata m2) {
        return new MavenMetadata(new MavenMetadata.Versioning(this.mergeVersions(m1.getVersioning().getVersions(), m2.getVersioning().getVersions()), ListUtils.concatAll(m1.getVersioning().getSnapshotVersions(), m2.getVersioning().getSnapshotVersions()), this.maxSnapshot(m1.getVersioning().getSnapshot(), m2.getVersioning().getSnapshot()), this.maxLastUpdated(m1.getVersioning().getLastUpdated(), m2.getVersioning().getLastUpdated()), Semver.max((String)m1.getVersioning().getLatest(), (String)m2.getVersioning().getLatest()), Semver.max((String)m1.getVersioning().getRelease(), (String)m2.getVersioning().getRelease())));
    }

    private @Nullable ZonedDateTime maxLastUpdated(@Nullable ZonedDateTime left, @Nullable ZonedDateTime right) {
        return left == null ? right : (right == null ? left : (left.compareTo(right) >= 0 ? left : right));
    }

    private List<String> mergeVersions(List<String> versions1, List<String> versions2) {
        HashSet<String> merged = new HashSet<String>(versions1);
        merged.addAll(versions2);
        return new ArrayList<String>(merged);
    }

    private @Nullable MavenMetadata.Snapshot maxSnapshot(@Nullable MavenMetadata.Snapshot s1, @Nullable MavenMetadata.Snapshot s2) {
        if (s1 == null || s1.getTimestamp() == null) {
            return s2;
        }
        if (s2 == null || s2.getTimestamp() == null) {
            return s1;
        }
        return s1.getTimestamp().compareTo(s2.getTimestamp()) >= 0 ? s1 : s2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Pom download(GroupArtifactVersion gav, @Nullable String relativePath, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories) throws MavenDownloadingException {
        Pom maybeLocalPom;
        Path folderContainingPom;
        if (gav.getGroupId() == null || gav.getArtifactId() == null || gav.getVersion() == null) {
            if (containingPom == null) throw new MavenDownloadingException("Group id, artifact id, or version are missing.", null, gav);
            this.ctx.getResolutionListener().downloadError(gav, Collections.emptyList(), containingPom.getRequested());
            throw new MavenDownloadingException("Group id, artifact id, or version are missing.", null, gav);
        }
        this.ctx.getResolutionListener().download(gav);
        Pom projectPomWithResolvedVersion = this.projectPomsByGav.get(gav);
        if (projectPomWithResolvedVersion != null) {
            return projectPomWithResolvedVersion;
        }
        for (Pom projectPom : this.projectPoms.values()) {
            if (!projectPom.getGroupId().equals(gav.getGroupId()) || !projectPom.getArtifactId().equals(gav.getArtifactId())) continue;
            if (projectPom.getVersion().equals(gav.getVersion())) {
                return projectPom;
            }
            Map<String, String> mergedProperties = this.mergeProperties(this.getAncestryWithinProject(projectPom, this.projectPoms));
            String versionWithReplacements = ResolvedPom.placeholderHelper.replacePlaceholders(gav.getVersion(), mergedProperties::get);
            if (!projectPom.getVersion().equals(versionWithReplacements)) continue;
            return projectPom;
        }
        if (containingPom != null && containingPom.getRequested().getSourcePath() != null && !StringUtils.isBlank((String)relativePath) && !relativePath.contains(":") && (folderContainingPom = containingPom.getRequested().getSourcePath().getParent()) != null && (maybeLocalPom = this.projectPoms.get(folderContainingPom.resolve(Paths.get(relativePath, "pom.xml")).normalize())) != null && gav.getGroupId().equals(maybeLocalPom.getGroupId()) && gav.getArtifactId().equals(maybeLocalPom.getArtifactId()) && gav.getVersion().equals(maybeLocalPom.getVersion())) {
            return maybeLocalPom;
        }
        Collection<MavenRepository> normalizedRepos = this.distinctNormalizedRepositories(repositories, containingPom, gav.getVersion());
        Timer.Sample sample = Timer.start();
        Timer.Builder timer = Timer.builder((String)"rewrite.maven.download").tag("type", "pom");
        LinkedHashMap<MavenRepository, String> repositoryResponses = new LinkedHashMap<MavenRepository, String>();
        String versionMaybeDatedSnapshot = this.datedSnapshotVersion(gav, containingPom, repositories, (ExecutionContext)this.ctx);
        GroupArtifactVersion originalGav = gav;
        gav = this.handleSnapshotTimestampVersion(gav);
        ArrayList<String> uris = new ArrayList<String>();
        MavenRepository foundJarInRepo = null;
        ResolvedGroupArtifactVersion foundResolvedGav = null;
        for (MavenRepository repo : normalizedRepos) {
            this.ctx.getResolutionListener().repository(repo, containingPom);
            if (!this.repositoryAcceptsVersion(repo, gav.getVersion(), containingPom)) continue;
            ResolvedGroupArtifactVersion resolvedGav = new ResolvedGroupArtifactVersion(repo.getUri(), gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), versionMaybeDatedSnapshot);
            Optional<Pom> result = this.mavenCache.getPom(resolvedGav);
            if (result == null) {
                URI uri = URI.create(repo.getUri() + (repo.getUri().endsWith("/") ? "" : "/") + Objects.requireNonNull(gav.getGroupId()).replace('.', '/') + '/' + gav.getArtifactId() + '/' + gav.getVersion() + '/' + gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".pom");
                uris.add(uri.toString());
                if ("file".equals(uri.getScheme())) {
                    Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                    try {
                        File pomFile = new File(uri);
                        File jarFile = pomFile.toPath().resolveSibling(gav.getArtifactId() + '-' + versionMaybeDatedSnapshot + ".jar").toFile();
                        boolean jarFileExists = jarFile.exists();
                        boolean pomFileExists = pomFile.exists();
                        if (!pomFileExists && !jarFileExists) continue;
                        if (foundJarInRepo == null && jarFile.length() > 0L) {
                            foundJarInRepo = repo;
                            foundResolvedGav = resolvedGav;
                        }
                        if (pomFileExists) {
                            FileInputStream fis = new FileInputStream(pomFile);
                            try {
                                RawPom rawPom = RawPom.parse(fis, Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                                Pom pom = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                                if ((pom.getPackaging() == null || pom.hasJarPackaging()) && (!jarFileExists || jarFile.length() == 0L)) continue;
                                if (repo.getUri().equals(MavenRepository.MAVEN_LOCAL_DEFAULT.getUri())) {
                                    pom = pom.withRepository(MavenRepository.MAVEN_LOCAL_USER_NEUTRAL);
                                }
                                if (!Objects.equals(versionMaybeDatedSnapshot, pom.getVersion())) {
                                    pom = pom.withGav(pom.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                                }
                                this.mavenCache.putPom(resolvedGav, pom);
                                this.ctx.getResolutionListener().downloadSuccess(resolvedGav, containingPom);
                                sample.stop(timer.tags(new String[]{"outcome", "from maven local"}).register((MeterRegistry)Metrics.globalRegistry));
                                Pom pom2 = pom;
                                return pom2;
                            }
                            finally {
                                fis.close();
                                continue;
                            }
                        }
                        this.ctx.getResolutionListener().downloadError(gav, uris, containingPom == null ? null : containingPom.getRequested());
                    }
                    catch (IOException e) {
                        repositoryResponses.put(repo, e.getMessage());
                    }
                    continue;
                }
                try {
                    try {
                        byte[] responseBody = this.requestAsAuthenticatedOrAnonymous(repo, uri.toString());
                        Path inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                        RawPom rawPom = RawPom.parse(new ByteArrayInputStream(responseBody), Objects.equals(versionMaybeDatedSnapshot, gav.getVersion()) ? null : versionMaybeDatedSnapshot);
                        Pom pom = rawPom.toPom(inputPath, repo).withGav(resolvedGav);
                        if (!Objects.equals(versionMaybeDatedSnapshot, pom.getVersion())) {
                            pom = pom.withGav(pom.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
                        }
                        this.mavenCache.putPom(resolvedGav, pom);
                        this.ctx.getResolutionListener().downloadSuccess(resolvedGav, containingPom);
                        sample.stop(timer.tags(new String[]{"outcome", "downloaded"}).register((MeterRegistry)Metrics.globalRegistry));
                        return pom;
                    }
                    catch (HttpSenderResponseException e) {
                        try {
                            repositoryResponses.put(repo, e.getMessage());
                            if (!e.isClientSideException()) throw e;
                            if (!this.jarExistsForPomUri(repo, uri.toString())) {
                                throw e;
                            }
                            if (foundJarInRepo == null) {
                                foundJarInRepo = repo;
                                foundResolvedGav = resolvedGav;
                            }
                            this.ctx.getResolutionListener().downloadError(gav, uris, containingPom == null ? null : containingPom.getRequested());
                        }
                        catch (HttpSenderResponseException e2) {
                            repositoryResponses.put(repo, e2.getMessage());
                            if (!e2.isClientSideException()) continue;
                            this.mavenCache.putPom(resolvedGav, null);
                        }
                    }
                }
                catch (IOException e) {
                    repositoryResponses.put(repo, e.getMessage());
                }
                continue;
            }
            if (result.isPresent()) {
                sample.stop(timer.tags(new String[]{"outcome", "cached"}).register((MeterRegistry)Metrics.globalRegistry));
                return result.get();
            }
            repositoryResponses.put(repo, "Did not attempt to download because of a previous failure to retrieve from this repository.");
        }
        if (foundJarInRepo != null && foundResolvedGav != null) {
            Path inputPath;
            RawPom rawPom = this.rawPomFromGav(gav);
            Pom pom = rawPom.toPom(inputPath = Paths.get(gav.getGroupId(), gav.getArtifactId(), gav.getVersion()), foundJarInRepo).withGav(foundResolvedGav);
            if (!Objects.equals(versionMaybeDatedSnapshot, pom.getVersion())) {
                pom = pom.withGav(pom.getGav().withDatedSnapshotVersion(versionMaybeDatedSnapshot));
            }
            this.mavenCache.putPom(foundResolvedGav, pom);
            this.ctx.getResolutionListener().downloadSuccess(foundResolvedGav, containingPom);
            sample.stop(timer.tags(new String[]{"outcome", "downloaded"}).register((MeterRegistry)Metrics.globalRegistry));
            return pom;
        }
        this.ctx.getResolutionListener().downloadError(gav, uris, containingPom == null ? null : containingPom.getRequested());
        sample.stop(timer.tags(new String[]{"outcome", "unavailable"}).register((MeterRegistry)Metrics.globalRegistry));
        throw new MavenDownloadingException("Unable to download POM: " + gav + '.', null, originalGav).setRepositoryResponses(repositoryResponses);
    }

    private RawPom rawPomFromGav(GroupArtifactVersion gav) {
        return new RawPom(null, null, gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), null, null, null, null, "jar", null, null, null, null, null, null, null, null, null, null);
    }

    private GroupArtifactVersion handleSnapshotTimestampVersion(GroupArtifactVersion gav) {
        Matcher m = SNAPSHOT_TIMESTAMP.matcher(Objects.requireNonNull(gav.getVersion()));
        if (m.matches()) {
            String baseVersion = m.group(1) != null ? m.group(1) + SNAPSHOT : SNAPSHOT;
            return gav.withVersion(baseVersion);
        }
        return gav;
    }

    private @Nullable String datedSnapshotVersion(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom, List<MavenRepository> repositories, ExecutionContext ctx) {
        if (gav.getVersion() != null && gav.getVersion().endsWith("-SNAPSHOT")) {
            MavenMetadata.Snapshot snapshot;
            MavenMetadata mavenMetadata;
            for (ResolvedGroupArtifactVersion pinnedSnapshotVersion : new MavenExecutionContextView(ctx).getPinnedSnapshotVersions()) {
                if (pinnedSnapshotVersion.getDatedSnapshotVersion() == null || !pinnedSnapshotVersion.getGroupId().equals(gav.getGroupId()) || !pinnedSnapshotVersion.getArtifactId().equals(gav.getArtifactId()) || !pinnedSnapshotVersion.getVersion().equals(gav.getVersion())) continue;
                return pinnedSnapshotVersion.getDatedSnapshotVersion();
            }
            try {
                mavenMetadata = this.downloadMetadata(gav, containingPom, repositories);
            }
            catch (MavenDownloadingException e) {
                return gav.getVersion();
            }
            List<MavenMetadata.SnapshotVersion> snapshotVersions = mavenMetadata.getVersioning().getSnapshotVersions();
            if (snapshotVersions != null) {
                String classifier = MavenPomDownloader.getClassifierFromContainingPom(gav, containingPom);
                MavenMetadata.SnapshotVersion snapshotVersion = snapshotVersions.stream().sorted(Comparator.comparing(MavenMetadata.SnapshotVersion::getUpdated).reversed()).filter(s -> Objects.equals(s.getClassifier(), classifier)).findFirst().orElse(null);
                if (snapshotVersion != null) {
                    return snapshotVersion.getValue();
                }
            }
            if ((snapshot = mavenMetadata.getVersioning().getSnapshot()) != null && snapshot.getTimestamp() != null) {
                return gav.getVersion().replaceFirst("SNAPSHOT$", snapshot.getTimestamp() + "-" + snapshot.getBuildNumber());
            }
        }
        return gav.getVersion();
    }

    Collection<MavenRepository> distinctNormalizedRepositories(List<MavenRepository> repositories, @Nullable ResolvedPom containingPom, @Nullable String acceptsVersion) {
        MavenRepository normalizedRepo;
        MavenRepository normalizedRepo2;
        if (repositories == null) {
            repositories = Collections.emptyList();
        }
        LinkedHashMap<String, MavenRepository> normalizedRepositories = new LinkedHashMap<String, MavenRepository>();
        if (this.addLocalRepository) {
            normalizedRepositories.put(this.ctx.getLocalRepository().getId(), this.ctx.getLocalRepository());
        }
        for (MavenRepository repo : this.ctx.getRepositories(this.mavenSettings, this.activeProfiles)) {
            normalizedRepo2 = this.normalizeRepository(repo, this.ctx, containingPom);
            if (normalizedRepo2 == null || acceptsVersion != null && !this.repositoryAcceptsVersion(normalizedRepo2, acceptsVersion, containingPom)) continue;
            normalizedRepositories.put(normalizedRepo2.getId(), normalizedRepo2);
        }
        for (MavenRepository repo : repositories) {
            normalizedRepo2 = this.normalizeRepository(repo, this.ctx, containingPom);
            if (normalizedRepo2 == null || acceptsVersion != null && !this.repositoryAcceptsVersion(normalizedRepo2, acceptsVersion, containingPom)) continue;
            normalizedRepositories.put(normalizedRepo2.getId(), normalizedRepo2);
        }
        if (!normalizedRepositories.containsKey(MavenRepository.MAVEN_CENTRAL.getId()) && this.addCentralRepository && (normalizedRepo = this.normalizeRepository(MavenRepository.MAVEN_CENTRAL, this.ctx, containingPom)) != null) {
            normalizedRepositories.put(normalizedRepo.getId(), normalizedRepo);
        }
        return normalizedRepositories.values();
    }

    public @Nullable MavenRepository normalizeRepository(MavenRepository originalRepository, MavenExecutionContextView ctx, @Nullable ResolvedPom containingPom) {
        Optional<MavenRepository> result;
        block12: {
            result = null;
            MavenRepository repository = originalRepository;
            if (containingPom != null) {
                repository = repository.withUri(containingPom.getValue(repository.getUri()));
            }
            repository = this.applyAuthenticationToRepository(this.applyMirrors(repository));
            try {
                if (repository.isKnownToExist()) {
                    return repository;
                }
                if (repository.getUri().contains("${")) {
                    ctx.getResolutionListener().repositoryAccessFailed(repository.getUri(), new IllegalArgumentException("Repository " + repository.getUri() + " contains an unresolved property placeholder."));
                    return null;
                }
                if (repository.getUri().contains("0.0.0.0")) {
                    ctx.getResolutionListener().repositoryAccessFailed(repository.getUri(), new IllegalArgumentException("Repository " + repository.getUri() + " has invalid IP address."));
                    return null;
                }
                if ("file".equals(URI.create(repository.getUri()).getScheme())) {
                    return repository;
                }
                result = this.mavenCache.getNormalizedRepository(repository);
                if (result == null) {
                    if (!repository.getUri().toLowerCase().startsWith("http")) {
                        ctx.getResolutionListener().repositoryAccessFailed(repository.getUri(), new IllegalArgumentException("Repository " + repository.getUri() + " is not HTTP(S)."));
                        return null;
                    }
                    MavenRepository normalized = null;
                    try {
                        normalized = this.normalizeRepository(repository);
                    }
                    catch (Throwable e) {
                        ctx.getResolutionListener().repositoryAccessFailed(repository.getUri(), e);
                    }
                    this.mavenCache.putNormalizedRepository(repository, normalized);
                    result = Optional.ofNullable(normalized);
                    break block12;
                }
                if (!result.isPresent()) {
                    ctx.getResolutionListener().repositoryAccessFailedPreviously(repository.getUri());
                }
            }
            catch (Exception e) {
                ctx.getResolutionListener().repositoryAccessFailed(repository.getUri(), e);
                ctx.getOnError().accept(e);
                this.mavenCache.putNormalizedRepository(repository, null);
            }
        }
        return result == null || !result.isPresent() ? null : this.applyAuthenticationToRepository(result.get());
    }

    @Nullable MavenRepository normalizeRepository(MavenRepository repository) throws Throwable {
        HttpSender.Request.Builder request;
        ReachabilityResult reachability;
        String httpsUri;
        String originalUrl = repository.getUri();
        String string = httpsUri = originalUrl.toLowerCase().startsWith("http:") ? repository.getUri().replaceFirst("[hH][tT][tT][pP]://", "https://") : repository.getUri();
        if (!httpsUri.endsWith("/")) {
            httpsUri = httpsUri + "/";
        }
        if ((reachability = this.reachable(this.applyAuthenticationAndTimeoutToRequest(repository, request = this.httpSender.options(httpsUri)))).isSuccess()) {
            return repository.withUri(httpsUri);
        }
        reachability = this.reachable(this.applyAuthenticationAndTimeoutToRequest(repository, request.withMethod(HttpSender.Method.HEAD).url(httpsUri)));
        if (reachability.isReachable()) {
            return repository.withUri(httpsUri);
        }
        if (!originalUrl.equals(httpsUri)) {
            reachability = this.reachable(this.applyAuthenticationAndTimeoutToRequest(repository, request.withMethod(HttpSender.Method.OPTIONS).url(originalUrl)));
            if (reachability.isSuccess()) {
                return repository.withUri(originalUrl);
            }
            reachability = this.reachable(this.applyAuthenticationAndTimeoutToRequest(repository, request.withMethod(HttpSender.Method.HEAD).url(originalUrl)));
            if (reachability.isReachable()) {
                return repository.withUri(originalUrl);
            }
        }
        throw Objects.requireNonNull(reachability.throwable);
    }

    private ReachabilityResult reachable(HttpSender.Request.Builder request) {
        try {
            this.sendRequest(request.build());
            return ReachabilityResult.success();
        }
        catch (Throwable t) {
            HttpSenderResponseException e;
            if (t instanceof HttpSenderResponseException && (e = (HttpSenderResponseException)t).isServerReached()) {
                return new ReachabilityResult(Reachability.ERROR, t);
            }
            return new ReachabilityResult(Reachability.UNREACHABLE, t);
        }
    }

    private boolean jarExistsForPomUri(MavenRepository repo, String pomUrl) {
        String jarUrl = pomUrl.replaceAll("\\.pom$", ".jar");
        try {
            try {
                return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
                    HttpSender.Request authenticated = this.applyAuthenticationAndTimeoutToRequest(repo, this.httpSender.get(jarUrl)).build();
                    try (HttpSender.Response response = this.httpSender.send(authenticated);){
                        Boolean bl = response.isSuccessful();
                        return bl;
                    }
                });
            }
            catch (FailsafeException failsafeException) {
                Throwable cause = failsafeException.getCause();
                if (cause instanceof HttpSenderResponseException && MavenPomDownloader.hasCredentials(repo) && ((HttpSenderResponseException)cause).isClientSideException()) {
                    return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
                        HttpSender.Request unauthenticated = this.httpSender.get(jarUrl).build();
                        try (HttpSender.Response response = this.httpSender.send(unauthenticated);){
                            Boolean bl = response.isSuccessful();
                            return bl;
                        }
                    });
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private byte[] requestAsAuthenticatedOrAnonymous(MavenRepository repo, String uriString) throws HttpSenderResponseException, IOException {
        try {
            HttpSender.Request.Builder request = this.httpSender.get(uriString);
            return this.sendRequest(this.applyAuthenticationAndTimeoutToRequest(repo, request).build());
        }
        catch (HttpSenderResponseException e) {
            if (MavenPomDownloader.hasCredentials(repo) && e.isClientSideException()) {
                return this.retryRequestAnonymously(uriString, e);
            }
            throw e;
        }
    }

    private byte[] retryRequestAnonymously(String uriString, HttpSenderResponseException originalException) throws HttpSenderResponseException, IOException {
        try {
            return this.sendRequest(this.httpSender.get(uriString).build());
        }
        catch (HttpSenderResponseException retryException) {
            if (retryException.isAccessDenied()) {
                throw originalException;
            }
            throw retryException;
        }
    }

    private MavenRepository applyAuthenticationToRepository(MavenRepository repository) {
        return MavenRepositoryCredentials.apply(this.ctx.getCredentials(this.mavenSettings), repository);
    }

    private HttpSender.Request.Builder applyAuthenticationAndTimeoutToRequest(MavenRepository repository, HttpSender.Request.Builder request) {
        if (this.mavenSettings != null && this.mavenSettings.getServers() != null) {
            request.withConnectTimeout(repository.getTimeout() == null ? Duration.ofSeconds(10L) : repository.getTimeout());
            request.withReadTimeout(repository.getTimeout() == null ? Duration.ofSeconds(30L) : repository.getTimeout());
            for (MavenSettings.Server server : this.mavenSettings.getServers().getServers()) {
                if (!server.getId().equals(repository.getId()) || server.getConfiguration() == null) continue;
                MavenSettings.ServerConfiguration configuration = server.getConfiguration();
                if (server.getConfiguration().getHttpHeaders() != null) {
                    for (MavenSettings.HttpHeader header : configuration.getHttpHeaders()) {
                        request.withHeader(header.getName(), header.getValue());
                    }
                }
                if (configuration.getTimeout() != null) {
                    request.withConnectTimeout(Duration.ofMillis(configuration.getTimeout()));
                }
                if (configuration.getTimeout() == null) continue;
                request.withReadTimeout(Duration.ofMillis(configuration.getTimeout()));
            }
        }
        if (MavenPomDownloader.hasCredentials(repository)) {
            return request.withBasicAuthentication(repository.getUsername(), repository.getPassword());
        }
        return request;
    }

    private static boolean hasCredentials(MavenRepository repository) {
        return repository.getUsername() != null && repository.getPassword() != null;
    }

    private MavenRepository applyMirrors(MavenRepository repository) {
        return MavenRepositoryMirror.apply(this.mirrors, repository);
    }

    public boolean repositoryAcceptsVersion(MavenRepository repo, String version, @Nullable ResolvedPom containingPom) {
        if (version.endsWith("-SNAPSHOT")) {
            String snapshotsRaw = containingPom == null ? repo.getSnapshots() : containingPom.getValue(repo.getSnapshots());
            return snapshotsRaw == null || Boolean.parseBoolean(snapshotsRaw.trim());
        }
        if ("https://repo.spring.io/milestone".equalsIgnoreCase(repo.getUri())) {
            return version.matches(".*(M|RC)\\d+$");
        }
        String releasesRaw = containingPom == null ? repo.getReleases() : containingPom.getValue(repo.getReleases());
        return releasesRaw == null || Boolean.parseBoolean(releasesRaw.trim());
    }

    private static boolean hasPomFile(Path dir, Path versionPath, GroupArtifactVersion gav) {
        String artifactPomFile = gav.getArtifactId() + "-" + versionPath.getFileName() + ".pom";
        return Files.exists(dir.resolve(versionPath.resolve(artifactPomFile)), new LinkOption[0]);
    }

    private static @Nullable String getClassifierFromContainingPom(GroupArtifactVersion gav, @Nullable ResolvedPom containingPom) {
        if (containingPom != null) {
            for (Dependency dep : containingPom.getRequestedDependencies()) {
                if (!Objects.equals(dep.getGroupId(), gav.getGroupId()) || !Objects.equals(dep.getArtifactId(), gav.getArtifactId())) continue;
                return dep.getClassifier();
            }
        }
        return null;
    }

    public static class HttpSenderResponseException
    extends Exception {
        private final @Nullable Integer responseCode;
        private final String body;

        public HttpSenderResponseException(@Nullable Throwable cause, @Nullable Integer responseCode, String body) {
            super(cause);
            this.responseCode = responseCode;
            this.body = body;
        }

        public boolean isClientSideException() {
            if (this.responseCode == null || this.responseCode < 400 || this.responseCode > 499) {
                return false;
            }
            return this.responseCode != 408 && this.responseCode != 425 && this.responseCode != 429;
        }

        @Override
        public String getMessage() {
            return this.responseCode == null ? Objects.requireNonNull(this.getCause()).getMessage() : "HTTP " + this.responseCode;
        }

        public boolean isAccessDenied() {
            return this.responseCode != null && 400 < this.responseCode && this.responseCode <= 403;
        }

        public boolean isServerReached() {
            return this.responseCode != null && this.responseCode >= 100 && this.responseCode != 408;
        }

        @Generated
        public @Nullable Integer getResponseCode() {
            return this.responseCode;
        }

        @Generated
        public String getBody() {
            return this.body;
        }
    }

    private static final class ReachabilityResult {
        private final Reachability reachability;
        private final @Nullable Throwable throwable;

        private static ReachabilityResult success() {
            return new ReachabilityResult(Reachability.SUCCESS, null);
        }

        public boolean isReachable() {
            return this.reachability == Reachability.SUCCESS || this.reachability == Reachability.ERROR;
        }

        public boolean isSuccess() {
            return this.reachability == Reachability.SUCCESS;
        }

        @Generated
        public ReachabilityResult(Reachability reachability, @Nullable Throwable throwable) {
            this.reachability = reachability;
            this.throwable = throwable;
        }

        @Generated
        public Reachability getReachability() {
            return this.reachability;
        }

        @Generated
        public @Nullable Throwable getThrowable() {
            return this.throwable;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReachabilityResult)) {
                return false;
            }
            ReachabilityResult other = (ReachabilityResult)o;
            Reachability this$reachability = this.getReachability();
            Reachability other$reachability = other.getReachability();
            if (this$reachability == null ? other$reachability != null : !((Object)((Object)this$reachability)).equals((Object)other$reachability)) {
                return false;
            }
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Reachability $reachability = this.getReachability();
            result = result * 59 + ($reachability == null ? 43 : ((Object)((Object)$reachability)).hashCode());
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenPomDownloader.ReachabilityResult(reachability=" + (Object)((Object)this.getReachability()) + ", throwable=" + this.getThrowable() + ")";
        }
    }

    static enum Reachability {
        SUCCESS,
        ERROR,
        UNREACHABLE;

    }
}

