/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.plugin;

import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class DependencyPluginGoalResolveSources
extends Recipe {
    private static final XPathMatcher xPathMatcher = new XPathMatcher("//plugin[artifactId='maven-dependency-plugin']/executions/execution/goals[goal='sources']/goal");
    private static final String minimumVersion = "3.7.0";

    public String getDisplayName() {
        return "Migrate to `maven-dependency-plugin` goal `resolve-sources`";
    }

    public String getDescription() {
        return "Migrate from `sources` to `resolve-sources` for the `maven-dependency-plugin`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator comparator = Objects.requireNonNull((VersionComparator)Semver.validate((String)minimumVersion, null).getValue());
        return new MavenVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (xPathMatcher.matches(this.getCursor()) && this.isPlugInVersionInRange()) {
                    return tag.withValue("resolve-sources");
                }
                return t;
            }

            private boolean isPlugInVersionInRange() {
                Cursor pluginCursor = this.getCursor().dropParentUntil(i -> i instanceof Xml.Tag && ((Xml.Tag)i).getName().equals("plugin"));
                Xml.Tag pluginTag = (Xml.Tag)pluginCursor.getValue();
                Plugin plugin = this.findPlugin(pluginTag);
                if (!(plugin != null && plugin.getVersion() != null || (plugin = this.findManagedPlugin(pluginTag)) != null && plugin.getVersion() != null)) {
                    return false;
                }
                return comparator.compare(null, plugin.getVersion(), DependencyPluginGoalResolveSources.minimumVersion) >= 0;
            }
        };
    }
}

