/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.AddManagedDependencyVisitor;
import org.openrewrite.maven.AddPropertyVisitor;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.MavenTagInsertionComparator;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.RemoveRedundantDependencyVersions;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public final class ChangeParentPom
extends Recipe {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures(this);
    @Option(displayName="Old group ID", description="The group ID of the Maven parent pom to be changed away from.", example="org.springframework.boot")
    private final String oldGroupId;
    @Option(displayName="New group ID", description="The group ID of the new maven parent pom to be adopted. If this argument is omitted it defaults to the value of `oldGroupId`.", example="org.springframework.boot", required=false)
    private final @Nullable String newGroupId;
    @Option(displayName="Old artifact ID", description="The artifact ID of the maven parent pom to be changed away from.", example="spring-boot-starter-parent")
    private final String oldArtifactId;
    @Option(displayName="New artifact ID", description="The artifact ID of the new maven parent pom to be adopted. If this argument is omitted it defaults to the value of `oldArtifactId`.", example="spring-boot-starter-parent", required=false)
    private final @Nullable String newArtifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Old relative path", description="The relativePath of the maven parent pom to be changed away from. Use an empty String to match `<relativePath />`, use `../pom.xml` to match the default value.", example="../../pom.xml", required=false)
    private final @Nullable String oldRelativePath;
    @Option(displayName="New relative path", description="New relative path attribute for parent lookup.", example="../pom.xml", required=false)
    private final @Nullable String newRelativePath;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Allow version downgrades", description="If the new parent has the same group/artifact, this flag can be used to only upgrade the version if the target version is newer than the current.", required=false)
    private final @Nullable Boolean allowVersionDowngrades;
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{([^}]+)}");

    public String getDisplayName() {
        return "Change Maven parent";
    }

    public String getInstanceNameSuffix() {
        return String.format("`%s:%s:%s`", this.newGroupId, this.newArtifactId, this.newVersion);
    }

    public String getDescription() {
        return "Change the parent pom of a Maven pom.xml by matching the existing parent via groupId and artifactId, and updating it to a new groupId, artifactId, version, and optional relativePath. Also updates the project to retain dependency management and properties previously inherited from the old parent that are no longer provided by the new parent. Removes redundant dependency versions already managed by the new parent.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        return Preconditions.check((TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitDocument(Xml.Document document, ExecutionContext ctx) {
                Parent parent = this.getResolutionResult().getPom().getRequested().getParent();
                if (parent != null && StringUtils.matchesGlob((String)parent.getArtifactId(), (String)ChangeParentPom.this.oldArtifactId) && StringUtils.matchesGlob((String)parent.getGroupId(), (String)ChangeParentPom.this.oldGroupId)) {
                    return (Xml)SearchResult.found((Tree)document);
                }
                return document;
            }
        }, (TreeVisitor)new MavenIsoVisitor<ExecutionContext>(){
            private @Nullable Collection<String> availableVersions;

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                MavenResolutionResult mrr;
                ResolvedPom resolvedPom;
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isParentTag() && StringUtils.matchesGlob((String)(resolvedPom = (mrr = this.getResolutionResult()).getPom()).getValue(tag.getChildValue("groupId").orElse(null)), (String)ChangeParentPom.this.oldGroupId) && StringUtils.matchesGlob((String)resolvedPom.getValue(tag.getChildValue("artifactId").orElse(null)), (String)ChangeParentPom.this.oldArtifactId) && (ChangeParentPom.this.oldRelativePath == null || StringUtils.matchesGlob((String)ChangeParentPom.determineRelativePath(tag, resolvedPom), (String)ChangeParentPom.this.oldRelativePath))) {
                    String oldVersion = resolvedPom.getValue(tag.getChildValue("version").orElse(null));
                    assert (oldVersion != null);
                    String currentGroupId = tag.getChildValue("groupId").orElse(ChangeParentPom.this.oldGroupId);
                    String targetGroupId = ChangeParentPom.this.newGroupId == null ? currentGroupId : ChangeParentPom.this.newGroupId;
                    String currentArtifactId = tag.getChildValue("artifactId").orElse(ChangeParentPom.this.oldArtifactId);
                    String targetArtifactId = ChangeParentPom.this.newArtifactId == null ? currentArtifactId : ChangeParentPom.this.newArtifactId;
                    String targetRelativePath = ChangeParentPom.this.newRelativePath == null ? tag.getChildValue("relativePath").orElse(ChangeParentPom.this.oldRelativePath) : ChangeParentPom.this.newRelativePath;
                    try {
                        Optional<String> targetVersion = this.findAcceptableVersion(targetGroupId, targetArtifactId, oldVersion, ctx);
                        if (!targetVersion.isPresent() || Objects.equals(targetGroupId, currentGroupId) && Objects.equals(targetArtifactId, currentArtifactId) && Objects.equals(targetVersion.get(), oldVersion) && Objects.equals(targetRelativePath, ChangeParentPom.this.oldRelativePath)) {
                            return t;
                        }
                        ArrayList<Object> changeParentTagVisitors = new ArrayList<Object>();
                        if (!currentGroupId.equals(targetGroupId)) {
                            changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)t.getChild("groupId").get(), targetGroupId));
                        }
                        if (!currentArtifactId.equals(targetArtifactId)) {
                            changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)t.getChild("artifactId").get(), targetArtifactId));
                        }
                        if (!oldVersion.equals(targetVersion.get())) {
                            changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)t.getChild("version").get(), targetVersion.get()));
                        }
                        MavenPomDownloader mpd = new MavenPomDownloader(mrr.getProjectPoms(), ctx, mrr.getMavenSettings(), mrr.getActiveProfiles());
                        ResolvedPom newParent = mpd.download(new GroupArtifactVersion(targetGroupId, targetArtifactId, targetVersion.get()), null, resolvedPom, resolvedPom.getRepositories()).resolve(Collections.emptyList(), mpd, ctx);
                        List dependenciesWithoutExplicitVersions = ChangeParentPom.this.getDependenciesUnmanagedByNewParent(mrr, newParent);
                        for (ResolvedManagedDependency dep : dependenciesWithoutExplicitVersions) {
                            changeParentTagVisitors.add((Object)new AddManagedDependencyVisitor(dep.getGav().getGroupId(), dep.getGav().getArtifactId(), dep.getGav().getVersion(), dep.getScope() == null ? null : dep.getScope().toString().toLowerCase(), dep.getType(), dep.getClassifier()));
                        }
                        Map propertiesInUse = ChangeParentPom.getPropertiesInUse((Xml.Document)this.getCursor().firstEnclosingOrThrow(Xml.Document.class), ctx);
                        Map<String, String> newParentProps = newParent.getProperties();
                        for (Map.Entry propInUse : propertiesInUse.entrySet()) {
                            if (newParentProps.containsKey(propInUse.getKey())) continue;
                            changeParentTagVisitors.add((Object)new AddPropertyVisitor((String)propInUse.getKey(), (String)propInUse.getValue(), false));
                        }
                        Optional existingRelativePath = t.getChild("relativePath");
                        if (ChangeParentPom.this.oldRelativePath != null && !ChangeParentPom.this.oldRelativePath.equals(targetRelativePath) && existingRelativePath.isPresent()) {
                            if (StringUtils.isBlank((String)targetRelativePath)) {
                                changeParentTagVisitors.add(new AddOrUpdateChild(t, Xml.Tag.build((String)"<relativePath />")));
                            } else {
                                changeParentTagVisitors.add(new ChangeTagValueVisitor((Xml.Tag)existingRelativePath.get(), targetRelativePath));
                            }
                        } else if (this.mismatches(existingRelativePath.orElse(null), targetRelativePath)) {
                            Xml.Tag relativePathTag = StringUtils.isBlank((String)targetRelativePath) ? Xml.Tag.build((String)"<relativePath />") : Xml.Tag.build((String)("<relativePath>" + targetRelativePath + "</relativePath>"));
                            this.doAfterVisit((TreeVisitor)new AddToTagVisitor(t, relativePathTag, (Comparator)new MavenTagInsertionComparator(t.getChildren())));
                            this.maybeUpdateModel();
                        }
                        if (!changeParentTagVisitors.isEmpty()) {
                            for (TreeVisitor treeVisitor : changeParentTagVisitors) {
                                this.doAfterVisit(treeVisitor);
                            }
                            this.maybeUpdateModel();
                            this.doAfterVisit(new RemoveRedundantDependencyVersions(null, null, RemoveRedundantDependencyVersions.Comparator.GTE, null).getVisitor());
                        }
                    }
                    catch (MavenDownloadingException e) {
                        for (Map.Entry<MavenRepository, String> repositoryResponse : e.getRepositoryResponses().entrySet()) {
                            MavenRepository repository = repositoryResponse.getKey();
                            ChangeParentPom.this.metadataFailures.insertRow(ctx, new MavenMetadataFailures.Row(targetGroupId, targetArtifactId, ChangeParentPom.this.newVersion, repository.getUri(), repository.getSnapshots(), repository.getReleases(), repositoryResponse.getValue()));
                        }
                        return e.warn(tag);
                    }
                }
                return t;
            }

            private boolean mismatches(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable Xml.Tag relativePath, @Nullable String targetRelativePath) {
                if (relativePath == null) {
                    return targetRelativePath != null;
                }
                String relativePathValue = relativePath.getValue().orElse(null);
                if (relativePathValue == null) {
                    return !StringUtils.isBlank((String)targetRelativePath);
                }
                return !relativePathValue.equals(targetRelativePath);
            }

            private Optional<String> findAcceptableVersion(String groupId, String artifactId, String currentVersion, ExecutionContext ctx) throws MavenDownloadingException {
                String finalCurrentVersion;
                String string = finalCurrentVersion = !Semver.isVersion((String)currentVersion) ? "0.0.0" : currentVersion;
                if (this.availableVersions == null) {
                    MavenMetadata mavenMetadata = ChangeParentPom.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    this.availableVersions = mavenMetadata.getVersioning().getVersions().stream().filter(v -> versionComparator.isValid(finalCurrentVersion, v)).filter(v -> Boolean.TRUE.equals(ChangeParentPom.this.allowVersionDowngrades) || versionComparator.compare(finalCurrentVersion, finalCurrentVersion, v) <= 0).collect(Collectors.toList());
                }
                if (Boolean.TRUE.equals(ChangeParentPom.this.allowVersionDowngrades)) {
                    return this.availableVersions.stream().max((v1, v2) -> versionComparator.compare(finalCurrentVersion, v1, v2));
                }
                Optional upgradedVersion = versionComparator.upgrade(finalCurrentVersion, this.availableVersions);
                if (upgradedVersion.isPresent()) {
                    return upgradedVersion;
                }
                return this.availableVersions.stream().filter(finalCurrentVersion::equals).findFirst();
            }
        });
    }

    private static @Nullable String determineRelativePath(Xml.Tag tag, ResolvedPom resolvedPom) {
        Optional relativePath = tag.getChild("relativePath");
        if (relativePath.isPresent()) {
            return resolvedPom.getValue(((Xml.Tag)relativePath.get()).getValue().orElse(""));
        }
        return "../pom.xml";
    }

    private static Map<String, String> getPropertiesInUse(Xml.Document pomXml, ExecutionContext ctx) {
        return (Map)new MavenIsoVisitor<Map<String, String>>(){
            @Nullable ResolvedPom resolvedPom = null;

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, Map<String, String> properties) {
                Xml.Tag t = super.visitTag(tag, properties);
                if (t.getContent() != null && t.getContent().size() == 1 && t.getContent().get(0) instanceof Xml.CharData) {
                    String text = ((Xml.CharData)t.getContent().get(0)).getText().trim();
                    Matcher m = PROPERTY_PATTERN.matcher(text);
                    while (m.find()) {
                        if (this.resolvedPom == null) {
                            this.resolvedPom = this.getResolutionResult().getPom();
                        }
                        String propertyName = m.group(1).trim();
                        if (!this.resolvedPom.getProperties().containsKey(propertyName) || this.isGlobalProperty(propertyName)) continue;
                        properties.put(m.group(1).trim(), this.resolvedPom.getProperties().get(propertyName));
                    }
                }
                return t;
            }

            private boolean isGlobalProperty(String propertyName) {
                return propertyName.startsWith("project.") || propertyName.startsWith("env.") || propertyName.startsWith("settings.") || propertyName.equals("basedir");
            }
        }.reduce((Tree)pomXml, new HashMap());
    }

    private List<ResolvedManagedDependency> getDependenciesUnmanagedByNewParent(MavenResolutionResult mrr, ResolvedPom newParent) {
        ResolvedPom resolvedPom = mrr.getPom();
        List<ManagedDependency> locallyManaged = resolvedPom.getRequested().getDependencyManagement();
        Set requestedWithoutExplicitVersion = resolvedPom.getRequested().getDependencies().stream().filter(dep -> dep.getVersion() == null).filter(dep -> locallyManaged.stream().noneMatch(it -> {
            String groupId = resolvedPom.getValue(it.getGroupId());
            String artifactId = resolvedPom.getValue(it.getArtifactId());
            return dep.getGroupId().equals(groupId) && dep.getArtifactId().equals(artifactId);
        })).map(dep -> new GroupArtifactVersion(dep.getGroupId(), dep.getArtifactId(), null)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (requestedWithoutExplicitVersion.isEmpty()) {
            return Collections.emptyList();
        }
        List depsWithoutExplicitVersion = resolvedPom.getDependencyManagement().stream().filter(dep -> requestedWithoutExplicitVersion.contains(dep.getGav().withVersion(null))).filter(dep -> dep.getBomGav() == null || locallyManaged.stream().noneMatch(it -> {
            String groupId = resolvedPom.getValue(it.getGroupId());
            String artifactId = resolvedPom.getValue(it.getArtifactId());
            return dep.getBomGav().getGroupId().equals(groupId) && dep.getBomGav().getArtifactId().equals(artifactId);
        })).collect(Collectors.toList());
        if (depsWithoutExplicitVersion.isEmpty()) {
            return Collections.emptyList();
        }
        Set newParentManagedGa = newParent.getDependencyManagement().stream().map(dep -> new GroupArtifact(dep.getGav().getGroupId(), dep.getGav().getArtifactId())).collect(Collectors.toSet());
        return depsWithoutExplicitVersion.stream().filter(it -> !newParentManagedGa.contains(new GroupArtifact(it.getGav().getGroupId(), it.getGav().getArtifactId()))).collect(Collectors.toList());
    }

    @Generated
    public ChangeParentPom(String oldGroupId, @Nullable String newGroupId, String oldArtifactId, @Nullable String newArtifactId, String newVersion, @Nullable String oldRelativePath, @Nullable String newRelativePath, @Nullable String versionPattern, @Nullable Boolean allowVersionDowngrades) {
        this.oldGroupId = oldGroupId;
        this.newGroupId = newGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
        this.oldRelativePath = oldRelativePath;
        this.newRelativePath = newRelativePath;
        this.versionPattern = versionPattern;
        this.allowVersionDowngrades = allowVersionDowngrades;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public @Nullable String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public @Nullable String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getOldRelativePath() {
        return this.oldRelativePath;
    }

    @Generated
    public @Nullable String getNewRelativePath() {
        return this.newRelativePath;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getAllowVersionDowngrades() {
        return this.allowVersionDowngrades;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ChangeParentPom(metadataFailures=" + (Object)((Object)this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", newGroupId=" + this.getNewGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ", oldRelativePath=" + this.getOldRelativePath() + ", newRelativePath=" + this.getNewRelativePath() + ", versionPattern=" + this.getVersionPattern() + ", allowVersionDowngrades=" + this.getAllowVersionDowngrades() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeParentPom)) {
            return false;
        }
        ChangeParentPom other = (ChangeParentPom)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$allowVersionDowngrades = this.getAllowVersionDowngrades();
        Boolean other$allowVersionDowngrades = other.getAllowVersionDowngrades();
        if (this$allowVersionDowngrades == null ? other$allowVersionDowngrades != null : !((Object)this$allowVersionDowngrades).equals(other$allowVersionDowngrades)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$oldRelativePath = this.getOldRelativePath();
        String other$oldRelativePath = other.getOldRelativePath();
        if (this$oldRelativePath == null ? other$oldRelativePath != null : !this$oldRelativePath.equals(other$oldRelativePath)) {
            return false;
        }
        String this$newRelativePath = this.getNewRelativePath();
        String other$newRelativePath = other.getNewRelativePath();
        if (this$newRelativePath == null ? other$newRelativePath != null : !this$newRelativePath.equals(other$newRelativePath)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ChangeParentPom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $allowVersionDowngrades = this.getAllowVersionDowngrades();
        result = result * 59 + ($allowVersionDowngrades == null ? 43 : ((Object)$allowVersionDowngrades).hashCode());
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $oldRelativePath = this.getOldRelativePath();
        result = result * 59 + ($oldRelativePath == null ? 43 : $oldRelativePath.hashCode());
        String $newRelativePath = this.getNewRelativePath();
        result = result * 59 + ($newRelativePath == null ? 43 : $newRelativePath.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

