/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenSecuritySettings;
import org.openrewrite.maven.internal.MavenXmlMapper;
import org.openrewrite.maven.internal.RawRepositories;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.ProfileActivation;

@JacksonXmlRootElement(localName="settings")
public class MavenSettings {
    private final @Nullable String localRepository;
    @JsonIgnore
    private @Nullable MavenRepository mavenLocal;
    private final @Nullable Profiles profiles;
    private final @Nullable ActiveProfiles activeProfiles;
    private final @Nullable Mirrors mirrors;
    private final @Nullable Servers servers;

    @JsonCreator
    public MavenSettings(@Nullable String localRepository, @Nullable Profiles profiles, @Nullable ActiveProfiles activeProfiles, @Nullable Mirrors mirrors, @Nullable Servers servers) {
        this.localRepository = localRepository;
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
        this.mirrors = mirrors;
        this.servers = servers;
    }

    public static @Nullable MavenSettings parse(Parser.Input source, ExecutionContext ctx) {
        try {
            MavenSettings settings = new Interpolator().interpolate((MavenSettings)MavenXmlMapper.readMapper().readValue((InputStream)source.getSource(ctx), MavenSettings.class));
            settings.maybeDecryptPasswords(ctx);
            return settings;
        }
        catch (IOException e) {
            ctx.getOnError().accept(new IOException("Failed to parse " + source.getPath(), e));
            return null;
        }
    }

    public static @Nullable MavenSettings parse(Path settingsPath, ExecutionContext ctx) {
        MavenSettings settings = MavenSettings.parse(new Parser.Input(settingsPath, () -> {
            try {
                return Files.newInputStream(settingsPath, new OpenOption[0]);
            }
            catch (IOException e) {
                ctx.getOnError().accept(new IOException("Failed to read settings.xml at " + settingsPath, e));
                return null;
            }
        }), ctx);
        if (settings != null) {
            settings.maybeDecryptPasswords(ctx);
        }
        return settings;
    }

    public static @Nullable MavenSettings readMavenSettingsFromDisk(ExecutionContext ctx) {
        MavenSettings installSettings;
        Optional<MavenSettings> userSettings = Optional.of(MavenSettings.userSettingsPath()).filter(MavenSettings::exists).map(path -> MavenSettings.parse(path, ctx));
        MavenSettings settings = userSettings.map(arg_0 -> MavenSettings.lambda$readMavenSettingsFromDisk$3(installSettings = (MavenSettings)MavenSettings.findMavenHomeSettings().map(path -> MavenSettings.parse(path, ctx)).orElse(null), arg_0)).orElse(installSettings);
        if (settings != null) {
            settings.maybeDecryptPasswords(ctx);
        }
        return settings;
    }

    void maybeDecryptPasswords(ExecutionContext ctx) {
        MavenSecuritySettings security = MavenSecuritySettings.readMavenSecuritySettingsFromDisk(ctx);
        if (security == null) {
            return;
        }
        String decryptedMasterPassword = security.decrypt(security.getMaster(), "settings.security");
        if (decryptedMasterPassword != null) {
            String password;
            if (this.mavenLocal != null && (password = security.decrypt(this.mavenLocal.getPassword(), decryptedMasterPassword)) != null) {
                this.mavenLocal = this.mavenLocal.withPassword(password);
            }
            if (this.servers != null) {
                this.servers.servers = ListUtils.map((List)this.servers.servers, server -> {
                    String password = security.decrypt(server.getPassword(), decryptedMasterPassword);
                    return password == null ? server : server.withPassword(password);
                });
            }
        }
    }

    public static boolean readFromDiskEnabled() {
        String propertyValue = System.getProperty("org.openrewrite.test.readMavenSettingsFromDisk");
        return propertyValue != null && !propertyValue.equalsIgnoreCase("false");
    }

    private static Path userSettingsPath() {
        return Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/settings.xml");
    }

    private static Optional<Path> findMavenHomeSettings() {
        for (String envVariable : Arrays.asList("MVN_HOME", "M2_HOME", "MAVEN_HOME")) {
            for (String s : Optional.ofNullable(System.getenv(envVariable)).map(xva$0 -> Arrays.asList(xva$0)).orElse(Collections.emptyList())) {
                Path resolve = Paths.get(s, new String[0]).resolve("conf/settings.xml");
                if (!MavenSettings.exists(resolve)) continue;
                return Optional.of(resolve);
            }
        }
        return Optional.empty();
    }

    private static boolean exists(Path path) {
        try {
            return path.toFile().exists();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public MavenSettings merge(@Nullable MavenSettings installSettings) {
        return installSettings == null ? this : new MavenSettings(this.localRepository == null ? installSettings.localRepository : this.localRepository, this.profiles == null ? installSettings.profiles : this.profiles.merge(installSettings.profiles), this.activeProfiles == null ? installSettings.activeProfiles : this.activeProfiles.merge(installSettings.activeProfiles), this.mirrors == null ? installSettings.mirrors : this.mirrors.merge(installSettings.mirrors), this.servers == null ? installSettings.servers : this.servers.merge(installSettings.servers));
    }

    public List<RawRepositories.Repository> getActiveRepositories(Iterable<String> activeProfiles) {
        LinkedHashMap<String, RawRepositories.Repository> activeRepositories = new LinkedHashMap<String, RawRepositories.Repository>();
        if (this.profiles != null) {
            for (Profile profile : this.profiles.getProfiles()) {
                if (!profile.isActive(activeProfiles) && (this.activeProfiles == null || !profile.isActive(this.activeProfiles.getActiveProfiles())) || profile.repositories == null) continue;
                for (RawRepositories.Repository repository : profile.repositories.getRepositories()) {
                    activeRepositories.put(repository.getId(), repository);
                }
            }
        }
        return new ArrayList<RawRepositories.Repository>(activeRepositories.values());
    }

    public MavenRepository getMavenLocal() {
        if (this.localRepository == null) {
            return MavenRepository.MAVEN_LOCAL_DEFAULT;
        }
        if (this.mavenLocal == null) {
            this.mavenLocal = MavenRepository.builder().id("local").uri(MavenSettings.asUriString(this.localRepository)).knownToExist(true).build();
        }
        return this.mavenLocal;
    }

    private static String asUriString(String pathname) {
        return pathname.startsWith("file://") ? pathname : Paths.get(pathname, new String[0]).toUri().toString();
    }

    @NonNull
    @Generated
    public String toString() {
        return "MavenSettings()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSettings)) {
            return false;
        }
        MavenSettings other = (MavenSettings)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof MavenSettings;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public @Nullable String getLocalRepository() {
        return this.localRepository;
    }

    @Generated
    public @Nullable Profiles getProfiles() {
        return this.profiles;
    }

    @Generated
    public @Nullable ActiveProfiles getActiveProfiles() {
        return this.activeProfiles;
    }

    @Generated
    public @Nullable Mirrors getMirrors() {
        return this.mirrors;
    }

    @Generated
    public @Nullable Servers getServers() {
        return this.servers;
    }

    @JsonIgnore
    @Generated
    public void setMavenLocal(@Nullable MavenRepository mavenLocal) {
        this.mavenLocal = mavenLocal;
    }

    @Generated
    public MavenSettings(@Nullable String localRepository, @Nullable MavenRepository mavenLocal, @Nullable Profiles profiles, @Nullable ActiveProfiles activeProfiles, @Nullable Mirrors mirrors, @Nullable Servers servers) {
        this.localRepository = localRepository;
        this.mavenLocal = mavenLocal;
        this.profiles = profiles;
        this.activeProfiles = activeProfiles;
        this.mirrors = mirrors;
        this.servers = servers;
    }

    @NonNull
    @Generated
    public MavenSettings withServers(@Nullable Servers servers) {
        return this.servers == servers ? this : new MavenSettings(this.localRepository, this.mavenLocal, this.profiles, this.activeProfiles, this.mirrors, servers);
    }

    private static /* synthetic */ MavenSettings lambda$readMavenSettingsFromDisk$3(MavenSettings installSettings, MavenSettings mavenSettings) {
        return mavenSettings.merge(installSettings);
    }

    public static class Servers {
        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Server> servers = Collections.emptyList();

        public Servers merge(@Nullable Servers servers) {
            LinkedHashMap<String, Server> merged = new LinkedHashMap<String, Server>();
            for (Server server2 : this.servers) {
                merged.put(server2.id, server2);
            }
            if (servers != null) {
                servers.getServers().forEach(server -> merged.putIfAbsent(server.getId(), (Server)server));
            }
            return new Servers(new ArrayList<Server>(merged.values()));
        }

        @Generated
        public List<Server> getServers() {
            return this.servers;
        }

        @JacksonXmlProperty(localName="server")
        @JacksonXmlElementWrapper(useWrapping=false)
        @Generated
        public void setServers(List<Server> servers) {
            this.servers = servers;
        }

        @Generated
        public Servers(List<Server> servers) {
            this.servers = servers;
        }

        @Generated
        public Servers() {
        }

        @NonNull
        @Generated
        public Servers withServers(List<Server> servers) {
            return this.servers == servers ? this : new Servers(servers);
        }
    }

    public static class Mirrors {
        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Mirror> mirrors = Collections.emptyList();

        public Mirrors merge(@Nullable Mirrors mirrors) {
            LinkedHashMap<String, Mirror> merged = new LinkedHashMap<String, Mirror>();
            for (Mirror mirror2 : this.mirrors) {
                merged.put(mirror2.id, mirror2);
            }
            if (mirrors != null) {
                mirrors.getMirrors().forEach(mirror -> merged.putIfAbsent(mirror.getId(), (Mirror)mirror));
            }
            return new Mirrors(new ArrayList<Mirror>(merged.values()));
        }

        @Generated
        public List<Mirror> getMirrors() {
            return this.mirrors;
        }

        @JacksonXmlProperty(localName="mirror")
        @JacksonXmlElementWrapper(useWrapping=false)
        @Generated
        public void setMirrors(List<Mirror> mirrors) {
            this.mirrors = mirrors;
        }

        @Generated
        public Mirrors(List<Mirror> mirrors) {
            this.mirrors = mirrors;
        }

        @Generated
        public Mirrors() {
        }
    }

    public static class ActiveProfiles {
        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<String> activeProfiles = Collections.emptyList();

        public ActiveProfiles merge(@Nullable ActiveProfiles activeProfiles) {
            if (activeProfiles == null) {
                return new ActiveProfiles(new ArrayList<String>(this.activeProfiles));
            }
            ArrayList<String> result = new ArrayList<String>();
            HashSet<String> uniqueValues = new HashSet<String>();
            for (String s : ListUtils.concatAll(this.activeProfiles, activeProfiles.activeProfiles)) {
                if (!uniqueValues.add(s)) continue;
                result.add(s);
            }
            return new ActiveProfiles(result);
        }

        @Generated
        public List<String> getActiveProfiles() {
            return this.activeProfiles;
        }

        @JacksonXmlProperty(localName="activeProfile")
        @JacksonXmlElementWrapper(useWrapping=false)
        @Generated
        public void setActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }

        @Generated
        public ActiveProfiles(List<String> activeProfiles) {
            this.activeProfiles = activeProfiles;
        }

        @Generated
        public ActiveProfiles() {
        }
    }

    public static class Profiles {
        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<Profile> profiles = Collections.emptyList();

        public Profiles merge(@Nullable Profiles profiles) {
            LinkedHashMap<String, Profile> merged = new LinkedHashMap<String, Profile>();
            for (Profile profile2 : this.profiles) {
                merged.put(profile2.id, profile2);
            }
            if (profiles != null) {
                profiles.getProfiles().forEach(profile -> merged.putIfAbsent(profile.getId(), (Profile)profile));
            }
            return new Profiles(new ArrayList<Profile>(merged.values()));
        }

        @Generated
        public List<Profile> getProfiles() {
            return this.profiles;
        }

        @JacksonXmlProperty(localName="profile")
        @JacksonXmlElementWrapper(useWrapping=false)
        @Generated
        public void setProfiles(List<Profile> profiles) {
            this.profiles = profiles;
        }

        @Generated
        public Profiles(List<Profile> profiles) {
            this.profiles = profiles;
        }

        @Generated
        public Profiles() {
        }
    }

    private static class Interpolator {
        private static final PropertyPlaceholderHelper propertyPlaceholders = new PropertyPlaceholderHelper("${", "}", null);
        private static final UnaryOperator<String> propertyResolver = key -> {
            String property = System.getProperty(key);
            if (property != null) {
                return property;
            }
            if (key.startsWith("env.")) {
                return System.getenv().get(key.substring(4));
            }
            return System.getenv().get(key);
        };

        private Interpolator() {
        }

        public MavenSettings interpolate(MavenSettings mavenSettings) {
            return new MavenSettings(this.interpolate(mavenSettings.localRepository), mavenSettings.profiles, this.interpolate(mavenSettings.activeProfiles), this.interpolate(mavenSettings.mirrors), this.interpolate(mavenSettings.servers));
        }

        private @Nullable ActiveProfiles interpolate(@Nullable ActiveProfiles activeProfiles) {
            if (activeProfiles == null) {
                return null;
            }
            return new ActiveProfiles(ListUtils.map(activeProfiles.getActiveProfiles(), this::interpolate));
        }

        private @Nullable Mirrors interpolate(@Nullable Mirrors mirrors) {
            if (mirrors == null) {
                return null;
            }
            return new Mirrors(ListUtils.map(mirrors.getMirrors(), this::interpolate));
        }

        private Mirror interpolate(Mirror mirror) {
            return new Mirror(this.interpolate(mirror.id), this.interpolate(mirror.url), this.interpolate(mirror.getMirrorOf()), mirror.releases, mirror.snapshots);
        }

        private @Nullable Servers interpolate(@Nullable Servers servers) {
            if (servers == null) {
                return null;
            }
            return new Servers(ListUtils.map(servers.getServers(), this::interpolate));
        }

        private @Nullable ServerConfiguration interpolate(@Nullable ServerConfiguration configuration) {
            if (configuration == null) {
                return null;
            }
            return new ServerConfiguration(ListUtils.map((List)configuration.httpHeaders, this::interpolate), configuration.timeout);
        }

        private HttpHeader interpolate(HttpHeader httpHeader) {
            return new HttpHeader(this.interpolate(httpHeader.getName()), this.interpolate(httpHeader.getValue()));
        }

        private Server interpolate(Server server) {
            return new Server(this.interpolate(server.id), this.interpolate(server.username), this.interpolate(server.password), this.interpolate(server.configuration));
        }

        private @Nullable String interpolate(@Nullable String s) {
            return s == null ? null : propertyPlaceholders.replacePlaceholders(s, propertyResolver);
        }
    }

    public static class Profile {
        private final @Nullable String id;
        private final @Nullable ProfileActivation activation;
        private final @Nullable RawRepositories repositories;

        public boolean isActive(Iterable<String> activeProfiles) {
            return ProfileActivation.isActive(this.id, activeProfiles, this.activation);
        }

        public boolean isActive(String ... activeProfiles) {
            return this.isActive(Arrays.asList(activeProfiles));
        }

        @Generated
        public Profile(@Nullable String id, @Nullable ProfileActivation activation, @Nullable RawRepositories repositories) {
            this.id = id;
            this.activation = activation;
            this.repositories = repositories;
        }

        @Generated
        public @Nullable String getId() {
            return this.id;
        }

        @Generated
        public @Nullable ProfileActivation getActivation() {
            return this.activation;
        }

        @Generated
        public @Nullable RawRepositories getRepositories() {
            return this.repositories;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Profile)) {
                return false;
            }
            Profile other = (Profile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            ProfileActivation this$activation = this.getActivation();
            ProfileActivation other$activation = other.getActivation();
            if (this$activation == null ? other$activation != null : !((Object)this$activation).equals(other$activation)) {
                return false;
            }
            RawRepositories this$repositories = this.getRepositories();
            RawRepositories other$repositories = other.getRepositories();
            return !(this$repositories == null ? other$repositories != null : !this$repositories.equals(other$repositories));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Profile;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            ProfileActivation $activation = this.getActivation();
            result = result * 59 + ($activation == null ? 43 : ((Object)$activation).hashCode());
            RawRepositories $repositories = this.getRepositories();
            result = result * 59 + ($repositories == null ? 43 : $repositories.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenSettings.Profile(id=" + this.getId() + ", activation=" + this.getActivation() + ", repositories=" + this.getRepositories() + ")";
        }
    }

    public static class Server {
        private final String id;
        private final String username;
        private final String password;
        private final @Nullable ServerConfiguration configuration;

        @Generated
        public Server(String id, String username, String password, @Nullable ServerConfiguration configuration) {
            this.id = id;
            this.username = username;
            this.password = password;
            this.configuration = configuration;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public @Nullable ServerConfiguration getConfiguration() {
            return this.configuration;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Server)) {
                return false;
            }
            Server other = (Server)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            ServerConfiguration this$configuration = this.getConfiguration();
            ServerConfiguration other$configuration = other.getConfiguration();
            return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Server;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            ServerConfiguration $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenSettings.Server(id=" + this.getId() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", configuration=" + this.getConfiguration() + ")";
        }

        @NonNull
        @Generated
        public Server withId(String id) {
            return this.id == id ? this : new Server(id, this.username, this.password, this.configuration);
        }

        @NonNull
        @Generated
        public Server withUsername(String username) {
            return this.username == username ? this : new Server(this.id, username, this.password, this.configuration);
        }

        @NonNull
        @Generated
        public Server withPassword(String password) {
            return this.password == password ? this : new Server(this.id, this.username, password, this.configuration);
        }

        @NonNull
        @Generated
        public Server withConfiguration(@Nullable ServerConfiguration configuration) {
            return this.configuration == configuration ? this : new Server(this.id, this.username, this.password, configuration);
        }
    }

    public static class HttpHeader {
        private final String name;
        private final String value;

        @Generated
        public HttpHeader(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpHeader)) {
                return false;
            }
            HttpHeader other = (HttpHeader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof HttpHeader;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenSettings.HttpHeader(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }

        @NonNull
        @Generated
        public HttpHeader withName(String name) {
            return this.name == name ? this : new HttpHeader(name, this.value);
        }

        @NonNull
        @Generated
        public HttpHeader withValue(String value) {
            return this.value == value ? this : new HttpHeader(this.name, value);
        }
    }

    @JsonIgnoreProperties(value={"httpHeaders"})
    public static class ServerConfiguration {
        @JacksonXmlProperty(localName="property")
        @JacksonXmlElementWrapper(localName="httpHeaders", useWrapping=true)
        private final @Nullable List<HttpHeader> httpHeaders;
        private final @Nullable Long timeout;

        @Generated
        public ServerConfiguration(@Nullable List<HttpHeader> httpHeaders, @Nullable Long timeout) {
            this.httpHeaders = httpHeaders;
            this.timeout = timeout;
        }

        @Generated
        public @Nullable List<HttpHeader> getHttpHeaders() {
            return this.httpHeaders;
        }

        @Generated
        public @Nullable Long getTimeout() {
            return this.timeout;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfiguration)) {
                return false;
            }
            ServerConfiguration other = (ServerConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timeout = this.getTimeout();
            Long other$timeout = other.getTimeout();
            if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
                return false;
            }
            List<HttpHeader> this$httpHeaders = this.getHttpHeaders();
            List<HttpHeader> other$httpHeaders = other.getHttpHeaders();
            return !(this$httpHeaders == null ? other$httpHeaders != null : !((Object)this$httpHeaders).equals(other$httpHeaders));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof ServerConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            List<HttpHeader> $httpHeaders = this.getHttpHeaders();
            result = result * 59 + ($httpHeaders == null ? 43 : ((Object)$httpHeaders).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenSettings.ServerConfiguration(httpHeaders=" + this.getHttpHeaders() + ", timeout=" + this.getTimeout() + ")";
        }

        @NonNull
        @Generated
        public ServerConfiguration withHttpHeaders(@Nullable List<HttpHeader> httpHeaders) {
            return this.httpHeaders == httpHeaders ? this : new ServerConfiguration(httpHeaders, this.timeout);
        }

        @NonNull
        @Generated
        public ServerConfiguration withTimeout(@Nullable Long timeout) {
            return this.timeout == timeout ? this : new ServerConfiguration(this.httpHeaders, timeout);
        }
    }

    public static class Mirror {
        private final @Nullable String id;
        private final @Nullable String url;
        private final @Nullable String mirrorOf;
        private final @Nullable Boolean releases;
        private final @Nullable Boolean snapshots;

        @Generated
        public Mirror(@Nullable String id, @Nullable String url, @Nullable String mirrorOf, @Nullable Boolean releases, @Nullable Boolean snapshots) {
            this.id = id;
            this.url = url;
            this.mirrorOf = mirrorOf;
            this.releases = releases;
            this.snapshots = snapshots;
        }

        @Generated
        public @Nullable String getId() {
            return this.id;
        }

        @Generated
        public @Nullable String getUrl() {
            return this.url;
        }

        @Generated
        public @Nullable String getMirrorOf() {
            return this.mirrorOf;
        }

        @Generated
        public @Nullable Boolean getReleases() {
            return this.releases;
        }

        @Generated
        public @Nullable Boolean getSnapshots() {
            return this.snapshots;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mirror)) {
                return false;
            }
            Mirror other = (Mirror)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$releases = this.getReleases();
            Boolean other$releases = other.getReleases();
            if (this$releases == null ? other$releases != null : !((Object)this$releases).equals(other$releases)) {
                return false;
            }
            Boolean this$snapshots = this.getSnapshots();
            Boolean other$snapshots = other.getSnapshots();
            if (this$snapshots == null ? other$snapshots != null : !((Object)this$snapshots).equals(other$snapshots)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$mirrorOf = this.getMirrorOf();
            String other$mirrorOf = other.getMirrorOf();
            return !(this$mirrorOf == null ? other$mirrorOf != null : !this$mirrorOf.equals(other$mirrorOf));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Mirror;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $releases = this.getReleases();
            result = result * 59 + ($releases == null ? 43 : ((Object)$releases).hashCode());
            Boolean $snapshots = this.getSnapshots();
            result = result * 59 + ($snapshots == null ? 43 : ((Object)$snapshots).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $mirrorOf = this.getMirrorOf();
            result = result * 59 + ($mirrorOf == null ? 43 : $mirrorOf.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "MavenSettings.Mirror(id=" + this.getId() + ", url=" + this.getUrl() + ", mirrorOf=" + this.getMirrorOf() + ", releases=" + this.getReleases() + ", snapshots=" + this.getSnapshots() + ")";
        }
    }
}

