/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.GitProvenance;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.maven.search.FindScm;
import org.openrewrite.xml.ChangeTagValueVisitor;
import org.openrewrite.xml.tree.Xml;

public class UpdateScmFromGitOrigin
extends Recipe {
    public String getDisplayName() {
        return "Update SCM section to match Git origin";
    }

    public String getDescription() {
        return "Updates the Maven `<scm>` section based on the Git remote origin.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindScm(), (TreeVisitor)new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if ("project".equals(tag.getName())) {
                    return super.visitTag(tag, (Object)ctx);
                }
                if ("scm".equals(tag.getName())) {
                    Optional.ofNullable((Xml.Document)this.getCursor().firstEnclosing(Xml.Document.class)).map(Xml.Document::getMarkers).flatMap(markers -> markers.findFirst(GitProvenance.class)).map(GitProvenance::getOrigin).map(GitOrigin::parseGitUrl).ifPresent(gitOrigin -> {
                        this.updateTagValue(tag, "url", (GitOrigin)gitOrigin);
                        this.updateTagValue(tag, "connection", (GitOrigin)gitOrigin);
                        this.updateTagValue(tag, "developerConnection", (GitOrigin)gitOrigin);
                    });
                    return tag;
                }
                return tag;
            }

            private void updateTagValue(Xml.Tag tag, String tagName, GitOrigin gitOrigin) {
                tag.getChild(tagName).ifPresent(childTag -> {
                    String originalUrl = childTag.getValue().orElse("");
                    String updatedUrl = gitOrigin.replaceHostAndPath(originalUrl);
                    this.doAfterVisit((TreeVisitor)new ChangeTagValueVisitor(childTag, updatedUrl));
                });
            }
        });
    }

    static final class GitOrigin {
        private static final Pattern[] URL_PATTERNS = new Pattern[]{Pattern.compile("^git@([^:]+):(.+?)(?:\\.git)?$"), Pattern.compile("^https?://(?:[^@]+@)?([^/:]+(?::[0-9]+)?)/(.+?)(?:\\.git)?$"), Pattern.compile("^ssh://git@([^/:]+(?::[0-9]+)?)/(.+?)(?:\\.git)?$"), Pattern.compile("^[a-zA-Z][a-zA-Z0-9+.-]*://(?:[^@]+@)?([^/:]+(?::[0-9]+)?)/(.+?)(?:\\.git)?$")};
        private final String host;
        private final String path;

        static @Nullable GitOrigin parseGitUrl(String gitUrl) {
            if (!StringUtils.isNullOrEmpty((String)gitUrl)) {
                for (Pattern pattern : URL_PATTERNS) {
                    Matcher matcher = pattern.matcher(gitUrl);
                    if (!matcher.matches()) continue;
                    return new GitOrigin(matcher.group(1), matcher.group(2));
                }
            }
            return null;
        }

        String replaceHostAndPath(String originalUrl) {
            String gitSuffix;
            if (StringUtils.isNullOrEmpty((String)originalUrl)) {
                return originalUrl;
            }
            if (originalUrl.startsWith("scm:git:")) {
                String actualUrl = originalUrl.substring("scm:git:".length());
                return "scm:git:" + this.replaceHostAndPath(actualUrl);
            }
            String string = gitSuffix = originalUrl.endsWith(".git") ? ".git" : "";
            if (originalUrl.startsWith("git@")) {
                return "git@" + this.host + ":" + this.path + gitSuffix;
            }
            Matcher protocolMatcher = Pattern.compile("^([a-zA-Z][a-zA-Z0-9+.-]*://)(?:([^@/]+)@)?").matcher(originalUrl);
            if (protocolMatcher.find()) {
                String protocol = protocolMatcher.group(1);
                String user = protocolMatcher.group(2);
                String userPrefix = user != null ? user + "@" : "";
                String newUrl = protocol + userPrefix + this.host + "/" + this.path + gitSuffix;
                if (originalUrl.startsWith(newUrl)) {
                    return originalUrl;
                }
                return newUrl;
            }
            return originalUrl;
        }

        @Generated
        public GitOrigin(String host, String path) {
            this.host = host;
            this.path = path;
        }

        @Generated
        public String getHost() {
            return this.host;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitOrigin)) {
                return false;
            }
            GitOrigin other = (GitOrigin)o;
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            return !(this$path == null ? other$path != null : !this$path.equals(other$path));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "UpdateScmFromGitOrigin.GitOrigin(host=" + this.getHost() + ", path=" + this.getPath() + ")";
        }
    }
}

