/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.MavenSettings;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.RawPom;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.Parent;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.tree.ParseError;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.tree.Xml;

public class MavenParser
implements Parser {
    private final Collection<String> activeProfiles;

    public Stream<SourceFile> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public Stream<SourceFile> parse(ExecutionContext ctx, String ... sources) {
        return super.parse(ctx, sources);
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ArrayList<Object> parsed = new ArrayList<Object>();
        LinkedHashMap<Xml.Document, Pom> projectPoms = new LinkedHashMap<Xml.Document, Pom>();
        HashMap<Path, Pom> projectPomsByPath = new HashMap<Path, Pom>();
        for (Parser.Input source : sources) {
            Path pomPath = source.getRelativePath(relativeTo);
            try {
                Pom pom = RawPom.parse((InputStream)source.getSource(ctx), null).toPom(pomPath, null);
                if (pom.getProperties() == null || pom.getProperties().isEmpty()) {
                    pom = pom.withProperties(new LinkedHashMap<String, String>());
                }
                String baseDir = pomPath.toAbsolutePath().getParent().toString();
                pom.getProperties().put("project.basedir", baseDir);
                pom.getProperties().put("basedir", baseDir);
                Xml.Document xml = (Xml.Document)new MavenXmlParser().parseInputs(Collections.singletonList(source), relativeTo, ctx).iterator().next();
                projectPoms.put(xml, pom);
                projectPomsByPath.put(pomPath, pom);
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                parsed.add(ParseError.build((Parser)this, (Parser.Input)source, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t));
            }
        }
        MavenPomDownloader downloader = new MavenPomDownloader(projectPomsByPath, ctx);
        MavenExecutionContextView mavenCtx = MavenExecutionContextView.view(ctx);
        MavenSettings sanitizedSettings = mavenCtx.getSettings() == null ? null : mavenCtx.getSettings().withServers(null);
        for (Map.Entry docToPom : projectPoms.entrySet()) {
            try {
                ResolvedPom resolvedPom = ((Pom)docToPom.getValue()).resolve(this.activeProfiles, downloader, ctx);
                MavenResolutionResult model = new MavenResolutionResult(Tree.randomId(), null, resolvedPom, Collections.emptyList(), null, Collections.emptyMap(), sanitizedSettings, mavenCtx.getActiveProfiles()).resolveDependencies(downloader, ctx);
                parsed.add(((Xml.Document)docToPom.getKey()).withMarkers(((Xml.Document)docToPom.getKey()).getMarkers().compute((Marker)model, (old, n) -> n)));
            }
            catch (MavenDownloadingExceptions e) {
                ParseExceptionResult parseExceptionResult = new ParseExceptionResult(Tree.randomId(), MavenParser.class.getSimpleName(), e.getClass().getSimpleName(), e.warn((Xml.Document)docToPom.getKey()).printAll(), null);
                parsed.add(((Xml.Document)docToPom.getKey()).withMarkers(((Xml.Document)docToPom.getKey()).getMarkers().add((Marker)parseExceptionResult)));
                ctx.getOnError().accept(e);
            }
            catch (MavenDownloadingException e) {
                parsed.add(((Xml.Document)docToPom.getKey()).withMarkers(((Xml.Document)docToPom.getKey()).getMarkers().add((Marker)ParseExceptionResult.build((Parser)this, (Throwable)e))));
                ctx.getOnError().accept(e);
            }
        }
        for (int i = 0; i < parsed.size(); ++i) {
            SourceFile maven = (SourceFile)parsed.get(i);
            Optional maybeResolutionResult = maven.getMarkers().findFirst(MavenResolutionResult.class);
            if (!maybeResolutionResult.isPresent()) continue;
            MavenResolutionResult resolutionResult = (MavenResolutionResult)maybeResolutionResult.get();
            ArrayList<MavenResolutionResult> modules = new ArrayList<MavenResolutionResult>(0);
            for (SourceFile sourceFile : parsed) {
                MavenResolutionResult moduleResolutionResult;
                Parent parent;
                Optional maybeModuleResolutionResult;
                if (sourceFile == maven || !(maybeModuleResolutionResult = sourceFile.getMarkers().findFirst(MavenResolutionResult.class)).isPresent() || (parent = (moduleResolutionResult = (MavenResolutionResult)maybeModuleResolutionResult.get()).getPom().getRequested().getParent()) == null || !resolutionResult.getPom().getGroupId().equals(resolutionResult.getPom().getValue(parent.getGroupId())) || !resolutionResult.getPom().getArtifactId().equals(resolutionResult.getPom().getValue(parent.getArtifactId())) || !resolutionResult.getPom().getVersion().equals(resolutionResult.getPom().getValue(parent.getVersion()))) continue;
                moduleResolutionResult.unsafeSetParent(resolutionResult);
                modules.add(moduleResolutionResult);
            }
            if (modules.isEmpty()) continue;
            resolutionResult.unsafeSetModules(modules);
        }
        return parsed.stream();
    }

    public boolean accept(Path path) {
        return "pom.xml".equals(path.toString()) || path.toString().endsWith(".pom");
    }

    public static Builder builder() {
        return new Builder();
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("pom.xml");
    }

    public MavenParser(Collection<String> activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    private static class MavenXmlParser
    extends XmlParser {
        private MavenXmlParser() {
        }

        public boolean accept(Path path) {
            return super.accept(path) || path.toString().endsWith(".pom");
        }
    }

    public static class Builder
    extends Parser.Builder {
        private final Collection<String> activeProfiles = new HashSet<String>();

        public Builder() {
            super(Xml.Document.class);
        }

        public Builder activeProfiles(String ... profiles) {
            if (profiles != null) {
                Collections.addAll(this.activeProfiles, profiles);
            }
            return this;
        }

        public Builder mavenConfig(@Nullable Path mavenConfig) {
            if (mavenConfig != null && mavenConfig.toFile().exists()) {
                try {
                    String mavenConfigText = new String(Files.readAllBytes(mavenConfig));
                    Matcher matcher = Pattern.compile("(?:$|\\s)-P\\s+([^\\s]+)").matcher(mavenConfigText);
                    if (matcher.find()) {
                        String[] profiles = matcher.group(1).split(",");
                        return this.activeProfiles(profiles);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            return this;
        }

        public MavenParser build() {
            return new MavenParser(this.activeProfiles);
        }

        public String getDslName() {
            return "maven";
        }
    }
}

