/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.PropertyPlaceholderHelper;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenDownloadingExceptions;
import org.openrewrite.maven.MavenExecutionContextView;
import org.openrewrite.maven.cache.MavenPomCache;
import org.openrewrite.maven.internal.MavenParsingException;
import org.openrewrite.maven.internal.MavenPomDownloader;
import org.openrewrite.maven.internal.VersionRequirement;
import org.openrewrite.maven.tree.Dependency;
import org.openrewrite.maven.tree.GroupArtifact;
import org.openrewrite.maven.tree.GroupArtifactClassifierType;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.ManagedDependency;
import org.openrewrite.maven.tree.MavenRepository;
import org.openrewrite.maven.tree.Plugin;
import org.openrewrite.maven.tree.Pom;
import org.openrewrite.maven.tree.Profile;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.ResolvedManagedDependency;
import org.openrewrite.maven.tree.Scope;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonPropertyOrder(value={"requested", "activeProfiles", "properties", "dependencyManagement", "dependencyManagementSorted", "initialRepositories", "repositories", "pluginRepositories", "requestedDependencies", "plugins", "pluginManagement", "subprojects"})
public class ResolvedPom {
    public static final PropertyPlaceholderHelper placeholderHelper = new PropertyPlaceholderHelper("${", "}", null);
    private static final ResolvedPom SUPER_POM = ResolvedPom.builder().repositories(Collections.singletonList(MavenRepository.MAVEN_CENTRAL)).pluginRepositories(Collections.singletonList(MavenRepository.MAVEN_CENTRAL)).build();
    private static final Comparator<ResolvedManagedDependency> MANAGED_DEPENDENCY_COMPARATOR = Comparator.comparing(ResolvedManagedDependency::getGroupId).thenComparing(ResolvedManagedDependency::getArtifactId).thenComparing(ResolvedManagedDependency::getClassifier, Comparator.nullsFirst(String::compareTo)).thenComparing(ResolvedManagedDependency::getType);
    Pom requested;
    Iterable<String> activeProfiles;
    Map<String, String> properties;
    List<ResolvedManagedDependency> dependencyManagement;
    boolean dependencyManagementSorted;
    List<MavenRepository> initialRepositories;
    List<MavenRepository> repositories;
    List<MavenRepository> pluginRepositories;
    List<Dependency> requestedDependencies;
    List<Plugin> plugins;
    List<Plugin> pluginManagement;
    @Nullable List<String> subprojects;

    public ResolvedPom(Pom requested, Iterable<String> activeProfiles) {
        this(requested, activeProfiles, Collections.emptyMap(), Collections.emptyList(), true, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @JsonCreator
    ResolvedPom(Pom requested, Iterable<String> activeProfiles, Map<String, String> properties, List<ResolvedManagedDependency> dependencyManagement, boolean dependencyManagementSorted, @Nullable List<MavenRepository> initialRepositories, List<MavenRepository> repositories, List<MavenRepository> pluginRepositories, List<Dependency> requestedDependencies, List<Plugin> plugins, List<Plugin> pluginManagement, List<String> subprojects) {
        this.requested = requested;
        this.activeProfiles = activeProfiles;
        this.properties = properties;
        this.dependencyManagement = dependencyManagement;
        this.dependencyManagementSorted = dependencyManagementSorted;
        if (initialRepositories != null) {
            this.initialRepositories = initialRepositories;
        }
        this.repositories = repositories;
        this.pluginRepositories = pluginRepositories;
        this.requestedDependencies = requestedDependencies;
        this.plugins = plugins;
        this.pluginManagement = pluginManagement;
        this.subprojects = subprojects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonGetter
    public List<ResolvedManagedDependency> getDependencyManagement() {
        if (!this.dependencyManagementSorted) {
            ResolvedPom resolvedPom = this;
            synchronized (resolvedPom) {
                this.dependencyManagement.sort(MANAGED_DEPENDENCY_COMPARATOR);
                this.dependencyManagementSorted = true;
            }
        }
        return this.dependencyManagement;
    }

    public ResolvedPom deduplicate() {
        LinkedHashSet uniqueDependencies = new LinkedHashSet(this.dependencyManagement.size());
        this.requestedDependencies = ListUtils.map(this.requestedDependencies, d -> uniqueDependencies.add(new UniqueDependencyKey(d.getGav(), d.getType(), d.getClassifier(), d.getScope())) ? d : null);
        return this;
    }

    public ResolvedPom resolve(ExecutionContext ctx, MavenPomDownloader downloader) throws MavenDownloadingException {
        if (this.requested.getObsoletePomVersion() != null) {
            return this;
        }
        ResolvedPom resolved = new ResolvedPom(this.requested, this.activeProfiles, Collections.emptyMap(), Collections.emptyList(), true, this.initialRepositories, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList()).resolver(ctx, downloader).resolve();
        for (Map.Entry<String, String> property : resolved.getProperties().entrySet()) {
            if (this.properties != null && (property.getValue() == null || property.getValue().equals(this.properties.get(property.getKey())))) continue;
            return resolved;
        }
        List<Dependency> resolvedRequestedDependencies = resolved.getRequestedDependencies();
        if (this.requestedDependencies == null || this.requestedDependencies.size() != resolvedRequestedDependencies.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedRequestedDependencies.size(); ++i) {
            if (this.requestedDependencies.get(i).equals(resolvedRequestedDependencies.get(i))) continue;
            return resolved;
        }
        List<ResolvedManagedDependency> resolvedDependencyManagement = resolved.getDependencyManagement();
        List<ResolvedManagedDependency> currentDependencyManagement = this.getDependencyManagement();
        if (currentDependencyManagement.size() != resolvedDependencyManagement.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedDependencyManagement.size(); ++i) {
            if (currentDependencyManagement.get(i).equals(resolvedDependencyManagement.get(i))) continue;
            return resolved;
        }
        List<MavenRepository> resolvedRepositories = resolved.getRepositories();
        if (this.repositories == null || this.repositories.size() != resolvedRepositories.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedRepositories.size(); ++i) {
            if (this.repositories.get(i).equals(resolvedRepositories.get(i))) continue;
            return resolved;
        }
        List<Plugin> resolvedPlugins = resolved.getPlugins();
        if (this.plugins == null || this.plugins.size() != resolvedPlugins.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedPlugins.size(); ++i) {
            if (this.plugins.get(i).equals(resolvedPlugins.get(i))) continue;
            return resolved;
        }
        List<Plugin> resolvedPluginManagement = resolved.getPluginManagement();
        if (this.pluginManagement == null || this.pluginManagement.size() != resolvedPluginManagement.size()) {
            return resolved;
        }
        for (int i = 0; i < resolvedPluginManagement.size(); ++i) {
            if (this.pluginManagement.get(i).equals(resolvedPluginManagement.get(i))) continue;
            return resolved;
        }
        return this;
    }

    Resolver resolver(ExecutionContext ctx, MavenPomDownloader downloader) {
        return new Resolver(ctx, downloader);
    }

    public ResolvedGroupArtifactVersion getGav() {
        return this.requested.getGav();
    }

    public String getGroupId() {
        return this.requested.getGroupId();
    }

    public String getArtifactId() {
        return this.requested.getArtifactId();
    }

    public String getVersion() {
        return this.requested.getVersion();
    }

    public @Nullable String getDatedSnapshotVersion() {
        return this.requested.getDatedSnapshotVersion();
    }

    public String getPackaging() {
        return this.requested.getPackaging() == null ? "jar" : this.requested.getPackaging();
    }

    public @Nullable String getValue(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return placeholderHelper.replacePlaceholders(value, this::getProperty);
    }

    private @Nullable String getProperty(@Nullable String property) {
        if (property == null) {
            return null;
        }
        String propVal = System.getProperty(property, this.properties.get(property));
        if (propVal != null) {
            if (propVal.equals("${" + property + "}")) {
                propVal = null;
            } else {
                return propVal;
            }
        }
        switch (property) {
            case "groupId": 
            case "project.groupId": 
            case "pom.groupId": {
                return this.requested.getGroupId();
            }
            case "project.parent.groupId": 
            case "parent.groupId": {
                return this.requested.getParent() != null ? this.requested.getParent().getGroupId() : null;
            }
            case "artifactId": 
            case "project.artifactId": 
            case "pom.artifactId": {
                return this.requested.getArtifactId();
            }
            case "project.parent.artifactId": 
            case "parent.artifactId": {
                return this.requested.getParent() == null ? null : this.requested.getParent().getArtifactId();
            }
            case "version": 
            case "project.version": 
            case "pom.version": {
                String version = this.requested.getVersion();
                if (version.contains(property)) {
                    if (this.requested.getParent() != null) {
                        version = this.requested.getParent().getVersion();
                    }
                    if (version.contains(property)) {
                        return "error.circular.project.version";
                    }
                }
                return version;
            }
            case "project.parent.version": 
            case "parent.version": {
                return this.requested.getParent() != null ? this.requested.getParent().getVersion() : null;
            }
            case "prerequisites.maven": 
            case "pom.prerequisites.maven": 
            case "project.prerequisites.maven": {
                return this.requested.getPrerequisites() == null ? null : this.requested.getPrerequisites().getMaven();
            }
        }
        return System.getProperty(property);
    }

    public @Nullable String getManagedVersion(@Nullable String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        ResolvedManagedDependency dependency = this.getManagedDependency(groupId, artifactId, type, classifier);
        return dependency != null ? this.getValue(dependency.getVersion()) : null;
    }

    public List<GroupArtifact> getManagedExclusions(String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        ResolvedManagedDependency dependency = this.getManagedDependency(groupId, artifactId, type, classifier);
        return dependency != null ? (dependency.getExclusions() == null ? Collections.emptyList() : dependency.getExclusions()) : Collections.emptyList();
    }

    public @Nullable Scope getManagedScope(String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        ResolvedManagedDependency dependency = this.getManagedDependency(groupId, artifactId, type, classifier);
        return dependency != null ? dependency.getScope() : null;
    }

    public @Nullable ResolvedManagedDependency getManagedDependency(@Nullable String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        List<ResolvedManagedDependency> deps = this.getDependencyManagement();
        if (deps.isEmpty()) {
            return null;
        }
        ResolvedManagedDependency searchKey = ResolvedPom.createSearchKey(groupId, artifactId, type, classifier);
        int index = Collections.binarySearch(deps, searchKey, MANAGED_DEPENDENCY_COMPARATOR);
        return index >= 0 ? deps.get(index) : null;
    }

    private static ResolvedManagedDependency createSearchKey(@Nullable String groupId, String artifactId, @Nullable String type, @Nullable String classifier) {
        return new ResolvedManagedDependency(new GroupArtifactVersion(groupId, artifactId, null), null, type, classifier, null, null, null, null);
    }

    public GroupArtifactVersion getValues(GroupArtifactVersion gav) {
        return gav.withGroupId(this.getValue(gav.getGroupId())).withArtifactId(this.getValue(gav.getArtifactId())).withVersion(this.getValue(gav.getVersion()));
    }

    public GroupArtifact getValues(GroupArtifact ga) {
        return ga.withGroupId(this.getValue(ga.getGroupId())).withArtifactId(this.getValue(ga.getArtifactId()));
    }

    public List<ResolvedDependency> resolveDependencies(Scope scope, MavenPomDownloader downloader, ExecutionContext ctx) throws MavenDownloadingExceptions {
        return this.resolveDependencies(scope, new HashMap<GroupArtifact, VersionRequirement>(), downloader, ctx);
    }

    public List<ResolvedDependency> resolveDependencies(Scope scope, Map<GroupArtifact, VersionRequirement> requirements, MavenPomDownloader downloader, ExecutionContext ctx) throws MavenDownloadingExceptions {
        ArrayList<ResolvedDependency> dependencies = new ArrayList<ResolvedDependency>();
        LinkedHashMap<GroupArtifact, DependencyAndDependent> rootDependencies = new LinkedHashMap<GroupArtifact, DependencyAndDependent>();
        for (Dependency requestedDependency : this.getRequestedDependencies()) {
            Dependency d = this.getValues(requestedDependency, 0);
            Scope dScope = Scope.fromName(d.getScope());
            if (dScope != scope && dScope.transitiveOf(scope) != scope) continue;
            rootDependencies.put(d.getGav().asGroupArtifact(), new DependencyAndDependent(requestedDependency, Scope.Compile, null, requestedDependency, this));
        }
        MavenDownloadingExceptions exceptions = null;
        int depth = 0;
        Collection dependenciesAtDepth = rootDependencies.values();
        while (!dependenciesAtDepth.isEmpty()) {
            LinkedHashMap<GroupArtifact, DependencyAndDependent> dependenciesAtNextDepthMap = new LinkedHashMap<GroupArtifact, DependencyAndDependent>();
            for (DependencyAndDependent dd : dependenciesAtDepth) {
                Dependency d = dd.getDefinedIn().getValues(dd.getDependency(), 0);
                d = this.getValues(d, depth);
                try {
                    VersionRequirement newRequirement;
                    if (depth == 0 && d.getVersion() == null) {
                        String coordinates = d.getGav() + (d.getClassifier() == null ? "" : ":" + d.getClassifier()) + (d.getType() == null ? "" : ":" + d.getType()) + (d.getScope() == null ? "" : ":" + d.getScope());
                        throw new MavenDownloadingException("No version provided for direct dependency " + coordinates, null, dd.getDependency().getGav());
                    }
                    if (d.getVersion() == null || d.getType() != null && !"jar".equals(d.getType()) && !"pom".equals(d.getType()) && !"zip".equals(d.getType()) && !"bom".equals(d.getType()) && !"tgz".equals(d.getType())) continue;
                    GroupArtifact ga = new GroupArtifact(d.getGroupId() == null ? "" : d.getGroupId(), d.getArtifactId());
                    VersionRequirement existingRequirement = requirements.get(ga);
                    if (existingRequirement == null) {
                        newRequirement = VersionRequirement.fromVersion(d.getVersion(), depth);
                        requirements.put(ga, newRequirement);
                        String newRequiredVersion = newRequirement.resolve(ga, downloader, this.getRepositories());
                        if (newRequiredVersion == null) {
                            throw new MavenParsingException("Could not resolve version for [" + ga + "] matching version requirements " + newRequirement);
                        }
                        d = d.withGav(d.getGav().withVersion(newRequiredVersion));
                    } else {
                        newRequirement = existingRequirement.addRequirement(d.getVersion());
                        requirements.put(ga, newRequirement);
                        String existingRequiredVersion = existingRequirement.resolve(ga, downloader, this.getRepositories());
                        String newRequiredVersion = newRequirement.resolve(ga, downloader, this.getRepositories());
                        if (newRequiredVersion == null) {
                            throw new MavenParsingException("Could not resolve version for [" + ga + "] matching version requirements " + newRequirement);
                        }
                        d = d.withGav(d.getGav().withVersion(newRequiredVersion));
                        if (!Objects.equals(existingRequiredVersion, newRequiredVersion)) {
                            MavenExecutionContextView.view(ctx).getResolutionListener().clear();
                            return this.resolveDependencies(scope, requirements, downloader, ctx);
                        }
                        if (this.contains(dependencies, ga, d.getClassifier())) continue;
                    }
                    if (d.getGav().getGroupId() != null && d.getGav().getGroupId().startsWith("${") && d.getGav().getGroupId().endsWith("}") || d.getGav().getArtifactId().startsWith("${") && d.getGav().getArtifactId().endsWith("}") || d.getGav().getVersion() != null && d.getGav().getVersion().startsWith("${") && d.getGav().getVersion().endsWith("}")) {
                        throw new MavenDownloadingException("Could not resolve property", null, d.getGav());
                    }
                    Pom dPom = downloader.download(d.getGav(), null, dd.definedIn, this.getRepositories());
                    MavenPomCache cache = MavenExecutionContextView.view(ctx).getPomCache();
                    ResolvedPom resolvedPom = cache.getResolvedDependencyPom(dPom.getGav());
                    if (resolvedPom == null) {
                        resolvedPom = new ResolvedPom(dPom, this.getActiveProfiles(), Collections.emptyMap(), Collections.emptyList(), true, this.initialRepositories, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                        resolvedPom.resolver(ctx, downloader).resolveParentsRecursively(dPom);
                        cache.putResolvedDependencyPom(dPom.getGav(), resolvedPom);
                    }
                    ResolvedDependency resolved = new ResolvedDependency(dPom.getRepository(), resolvedPom.getGav(), dd.getDependency(), Collections.emptyList(), resolvedPom.getRequested().getLicenses(), resolvedPom.getValue(dd.getDependency().getType()), resolvedPom.getValue(dd.getDependency().getClassifier()), Boolean.valueOf(resolvedPom.getValue(dd.getDependency().getOptional())), depth, Collections.emptyList());
                    MavenExecutionContextView.view(ctx).getResolutionListener().dependency(scope, resolved, dd.getDefinedIn());
                    ResolvedDependency includedBy = dd.getDependent();
                    if (includedBy != null) {
                        if (includedBy.getDependencies().isEmpty()) {
                            includedBy.unsafeSetDependencies(new ArrayList<ResolvedDependency>());
                        }
                        includedBy.getDependencies().add(resolved);
                    }
                    if (dd.getScope().transitiveOf(scope) != scope) continue;
                    dependencies.add(resolved);
                    block5: for (Dependency d2 : resolvedPom.getRequestedDependencies()) {
                        Scope d2Scope;
                        String optional;
                        if (d2.getGroupId() == null) {
                            d2 = d2.withGav(d2.getGav().withGroupId(resolvedPom.getGroupId()));
                        }
                        if (d.getExclusions() != null) {
                            d2 = d2.withExclusions(ListUtils.concatAll(d2.getExclusions(), d.getExclusions()));
                            for (GroupArtifact exclusion : d.getExclusions()) {
                                if (!StringUtils.matchesGlob((String)this.getValue(d2.getGroupId()), (String)this.getValue(exclusion.getGroupId())) || !StringUtils.matchesGlob((String)this.getValue(d2.getArtifactId()), (String)this.getValue(exclusion.getArtifactId()))) continue;
                                if (resolved.getEffectiveExclusions().isEmpty()) {
                                    resolved.unsafeSetEffectiveExclusions(new ArrayList<GroupArtifact>());
                                }
                                resolved.getEffectiveExclusions().add(d2.getGav().asGroupArtifact());
                                continue block5;
                            }
                        }
                        if ((optional = resolvedPom.getValue(d2.getOptional())) != null && Boolean.parseBoolean(optional.trim()) || !(d2Scope = this.getDependencyScope(d2, resolvedPom)).isInClasspathOf(dd.getScope())) continue;
                        GroupArtifact d2Ga = new GroupArtifact(d2.getGroupId() == null ? "" : d2.getGroupId(), d2.getArtifactId());
                        dependenciesAtNextDepthMap.putIfAbsent(d2Ga, new DependencyAndDependent(d2, d2Scope, resolved, dd.getRootDependent(), resolvedPom));
                    }
                }
                catch (MavenDownloadingException e) {
                    exceptions = MavenDownloadingExceptions.append(exceptions, e.setRoot(dd.getRootDependent().getGav()));
                }
            }
            dependenciesAtDepth = dependenciesAtNextDepthMap.values();
            ++depth;
        }
        if (exceptions != null) {
            throw exceptions;
        }
        return dependencies;
    }

    private boolean contains(List<ResolvedDependency> dependencies, GroupArtifact ga, @Nullable String classifier) {
        for (ResolvedDependency it : dependencies) {
            if (!it.getGroupId().equals(ga.getGroupId()) || !it.getArtifactId().equals(ga.getArtifactId()) || !Objects.equals(classifier, it.getClassifier())) continue;
            return true;
        }
        return false;
    }

    private Scope getDependencyScope(Dependency d2, ResolvedPom containingPom) {
        Scope scopeInContainingPom;
        if (d2.getScope() != null) {
            scopeInContainingPom = Scope.fromName(this.getValue(d2.getScope()));
        } else {
            scopeInContainingPom = containingPom.getManagedScope(this.getValue(d2.getGroupId()), this.getValue(d2.getArtifactId()), this.getValue(d2.getType()), this.getValue(d2.getClassifier()));
            if (scopeInContainingPom == null) {
                scopeInContainingPom = Scope.Compile;
            }
        }
        Scope scopeInThisProject = this.getManagedScope(this.getValue(d2.getGroupId()), this.getValue(d2.getArtifactId()), this.getValue(d2.getType()), this.getValue(d2.getClassifier()));
        return scopeInThisProject == null ? scopeInContainingPom : (scopeInContainingPom.isInClasspathOf(scopeInThisProject) ? scopeInThisProject : scopeInContainingPom);
    }

    private Dependency getValues(Dependency dep, int depth) {
        Dependency d = dep;
        try {
            Scope parsedScope;
            d = dep.withGav(this.getValues(dep.getGav())).withScope(this.getValue(dep.getScope()));
            if (d.getGroupId() == null) {
                return d;
            }
            String scope = d.getScope() == null ? ((parsedScope = this.getManagedScope(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier())) == null ? null : parsedScope.toString().toLowerCase()) : this.getValue(d.getScope());
            List<GroupArtifact> managedExclusions = this.getManagedExclusions(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier());
            if (!managedExclusions.isEmpty()) {
                d = d.withExclusions(ListUtils.concatAll(d.getExclusions(), managedExclusions));
            }
            if (d.getClassifier() != null) {
                d = d.withClassifier(this.getValue(d.getClassifier()));
            }
            if (d.getType() != null) {
                d = d.withType(this.getValue(d.getType()));
            }
            String version = d.getVersion();
            if ((d.getVersion() == null || depth > 0) && (version = this.getManagedVersion(d.getGroupId(), d.getArtifactId(), d.getType(), d.getClassifier())) == null) {
                version = d.getVersion();
            }
            return d.withGav(d.getGav().withVersion(version)).withScope(scope);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to get values of " + d, e);
        }
    }

    @Generated
    private static Iterable<String> $default$activeProfiles() {
        return Collections.emptyList();
    }

    @Generated
    private static Map<String, String> $default$properties() {
        return Collections.emptyMap();
    }

    @Generated
    private static List<ResolvedManagedDependency> $default$dependencyManagement() {
        return Collections.emptyList();
    }

    @Generated
    private static boolean $default$dependencyManagementSorted() {
        return false;
    }

    @Generated
    private static List<MavenRepository> $default$initialRepositories() {
        return Collections.emptyList();
    }

    @Generated
    private static List<MavenRepository> $default$repositories() {
        return Collections.emptyList();
    }

    @Generated
    private static List<MavenRepository> $default$pluginRepositories() {
        return Collections.emptyList();
    }

    @Generated
    private static List<Dependency> $default$requestedDependencies() {
        return Collections.emptyList();
    }

    @Generated
    private static List<Plugin> $default$plugins() {
        return Collections.emptyList();
    }

    @Generated
    private static List<Plugin> $default$pluginManagement() {
        return Collections.emptyList();
    }

    @Generated
    private static List<String> $default$subprojects() {
        return Collections.emptyList();
    }

    @NonNull
    @Generated
    public static ResolvedPomBuilder builder() {
        return new ResolvedPomBuilder();
    }

    @Generated
    public Pom getRequested() {
        return this.requested;
    }

    @Generated
    public Iterable<String> getActiveProfiles() {
        return this.activeProfiles;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public List<MavenRepository> getInitialRepositories() {
        return this.initialRepositories;
    }

    @Generated
    public List<MavenRepository> getRepositories() {
        return this.repositories;
    }

    @Generated
    public List<MavenRepository> getPluginRepositories() {
        return this.pluginRepositories;
    }

    @Generated
    public List<Dependency> getRequestedDependencies() {
        return this.requestedDependencies;
    }

    @Generated
    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    @Generated
    public List<Plugin> getPluginManagement() {
        return this.pluginManagement;
    }

    @Generated
    public @Nullable List<String> getSubprojects() {
        return this.subprojects;
    }

    @NonNull
    @Generated
    public ResolvedPom withRequested(Pom requested) {
        return this.requested == requested ? this : new ResolvedPom(requested, this.activeProfiles, this.properties, this.dependencyManagement, this.dependencyManagementSorted, this.initialRepositories, this.repositories, this.pluginRepositories, this.requestedDependencies, this.plugins, this.pluginManagement, this.subprojects);
    }

    @NonNull
    @Generated
    public ResolvedPom withActiveProfiles(Iterable<String> activeProfiles) {
        return this.activeProfiles == activeProfiles ? this : new ResolvedPom(this.requested, activeProfiles, this.properties, this.dependencyManagement, this.dependencyManagementSorted, this.initialRepositories, this.repositories, this.pluginRepositories, this.requestedDependencies, this.plugins, this.pluginManagement, this.subprojects);
    }

    final class Resolver {
        private final ExecutionContext ctx;
        private final MavenPomDownloader downloader;

        public ResolvedPom resolve() throws MavenDownloadingException {
            this.resolveParentsRecursively(ResolvedPom.this.requested);
            return ResolvedPom.this;
        }

        void resolveParentsRecursively(Pom requested) throws MavenDownloadingException {
            ArrayList<Pom> pomAncestry = new ArrayList<Pom>();
            pomAncestry.add(requested);
            if (ResolvedPom.this.initialRepositories != null) {
                this.mergeRepositories(ResolvedPom.this.initialRepositories);
            }
            this.resolveParentPropertiesAndRepositoriesRecursively(new ArrayList<Pom>(pomAncestry));
            if (ResolvedPom.this.initialRepositories == null) {
                ResolvedPom.this.initialRepositories = ResolvedPom.this.repositories;
            }
            Pom pomReference = ResolvedPom.this.requested;
            pomReference = pomReference.withGav(pomReference.getGav().withRepository(ResolvedPom.this.getValue(pomReference.getGav().getRepository())));
            pomReference = pomReference.withGav(pomReference.getGav().withGroupId(ResolvedPom.this.getValue(pomReference.getGav().getGroupId())));
            pomReference = pomReference.withGav(pomReference.getGav().withArtifactId(ResolvedPom.this.getValue(pomReference.getGav().getArtifactId())));
            pomReference = pomReference.withGav(pomReference.getGav().withVersion(ResolvedPom.this.getValue(pomReference.getGav().getVersion())));
            if (ResolvedPom.this.requested != (pomReference = pomReference.withGav(pomReference.getGav().withDatedSnapshotVersion(ResolvedPom.this.getValue(pomReference.getGav().getDatedSnapshotVersion()))))) {
                ResolvedPom.this.requested = pomReference;
            }
            this.resolveParentDependenciesRecursively(new ArrayList<Pom>(pomAncestry));
            this.resolveParentPluginsRecursively(new ArrayList<Pom>(pomAncestry));
        }

        private void resolveParentPropertiesAndRepositoriesRecursively(List<Pom> pomAncestry) throws MavenDownloadingException {
            Pom pom = pomAncestry.get(0);
            List<Profile> effectiveProfiles = pom.effectiveProfiles(ResolvedPom.this.activeProfiles);
            for (Profile profile : effectiveProfiles) {
                this.mergeProperties(profile.getProperties(), pom);
            }
            this.mergeProperties(pom.getProperties(), pom);
            this.updateRepositories();
            for (Profile profile : effectiveProfiles) {
                this.mergeRepositories(profile.getRepositories());
            }
            this.mergeRepositories(pom.getRepositories());
            if (pom.getParent() != null) {
                Pom parentPom = this.resolveParentPom(pom);
                for (Pom ancestor : pomAncestry) {
                    if (!ancestor.getGav().equals(parentPom.getGav())) continue;
                    return;
                }
                pomAncestry.add(0, parentPom);
                this.resolveParentPropertiesAndRepositoriesRecursively(pomAncestry);
            }
        }

        private void resolveParentDependenciesRecursively(List<Pom> pomAncestry) throws MavenDownloadingException {
            if (pomAncestry.isEmpty()) {
                return;
            }
            Map managedDependencyMap = ResolvedPom.this.dependencyManagement.stream().collect(Collectors.toMap(this::createDependencyManagementKey, d -> d, (x, y) -> y, LinkedHashMap::new));
            this.resolveParentDependenciesRecursively(pomAncestry, managedDependencyMap);
            if (!managedDependencyMap.isEmpty()) {
                ResolvedPom.this.dependencyManagement = new ArrayList(managedDependencyMap.values());
                ResolvedPom.this.dependencyManagementSorted = false;
            }
        }

        private void resolveParentDependenciesRecursively(List<Pom> pomAncestry, Map<GroupArtifactClassifierType, ResolvedManagedDependency> managedDependencyMap) throws MavenDownloadingException {
            Pom pom = pomAncestry.get(0);
            List<Profile> effectiveProfiles = pom.effectiveProfiles(ResolvedPom.this.activeProfiles);
            for (Profile profile : effectiveProfiles) {
                this.mergeDependencyManagement(profile.getDependencyManagement(), managedDependencyMap, pomAncestry);
                this.mergeRequestedDependencies(profile.getDependencies());
            }
            this.mergeDependencyManagement(pom.getDependencyManagement(), managedDependencyMap, pomAncestry);
            this.mergeRequestedDependencies(pom.getDependencies());
            if (pom.getParent() != null) {
                Pom parentPom = this.resolveParentPom(pom);
                MavenExecutionContextView.view(this.ctx).getResolutionListener().parent(parentPom, pom);
                for (Pom ancestor : pomAncestry) {
                    if (!ancestor.getGav().equals(parentPom.getGav())) continue;
                    return;
                }
                pomAncestry.add(0, parentPom);
                this.resolveParentDependenciesRecursively(pomAncestry, managedDependencyMap);
            }
        }

        private void resolveParentPluginsRecursively(List<Pom> pomAncestry) throws MavenDownloadingException {
            Pom pom = pomAncestry.get(0);
            for (Profile profile : pom.getProfiles()) {
                if (!profile.isActive(ResolvedPom.this.activeProfiles)) continue;
                this.mergePluginManagement(profile.getPluginManagement());
                this.mergePlugins(profile.getPlugins());
            }
            this.mergePluginManagement(pom.getPluginManagement());
            this.mergePlugins(pom.getPlugins());
            if (pom.getParent() != null) {
                Pom parentPom = this.resolveParentPom(pom);
                MavenExecutionContextView.view(this.ctx).getResolutionListener().parent(parentPom, pom);
                for (Pom ancestor : pomAncestry) {
                    if (!ancestor.getGav().equals(parentPom.getGav())) continue;
                    return;
                }
                pomAncestry.add(0, parentPom);
                this.resolveParentPluginsRecursively(pomAncestry);
            }
        }

        private Pom resolveParentPom(Pom pom) throws MavenDownloadingException {
            GroupArtifact ga;
            GroupArtifactVersion gav = ResolvedPom.this.getValues(pom.getParent().getGav());
            if (gav.getVersion() == null) {
                throw new MavenParsingException("Parent version must always specify a version " + gav);
            }
            VersionRequirement newRequirement = VersionRequirement.fromVersion(gav.getVersion(), 0);
            String newRequiredVersion = newRequirement.resolve(ga = new GroupArtifact(gav.getGroupId(), gav.getArtifactId()), this.downloader, ResolvedPom.this.getRepositories());
            if (newRequiredVersion == null) {
                throw new MavenParsingException("Could not resolve version for [" + ga + "] matching version requirements " + newRequirement);
            }
            gav = gav.withVersion(newRequiredVersion);
            return this.downloader.download(gav, pom.getParent().getRelativePath(), ResolvedPom.this, ResolvedPom.this.repositories);
        }

        private void mergeRequestedDependencies(List<Dependency> incomingRequestedDependencies) {
            if (!incomingRequestedDependencies.isEmpty()) {
                if (ResolvedPom.this.requestedDependencies == null || ResolvedPom.this.requestedDependencies.isEmpty()) {
                    ResolvedPom.this.requestedDependencies = new ArrayList<Dependency>(incomingRequestedDependencies);
                } else {
                    for (Dependency incReqDep : incomingRequestedDependencies) {
                        boolean found = false;
                        for (Dependency reqDep : ResolvedPom.this.requestedDependencies) {
                            if (!reqDep.getGav().getGroupId().equals(incReqDep.getGav().getGroupId()) || !reqDep.getArtifactId().equals(incReqDep.getArtifactId())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        ResolvedPom.this.requestedDependencies.add(incReqDep);
                    }
                }
            }
        }

        private PluginKey getPluginKey(Plugin plugin) {
            return new PluginKey(plugin.getGroupId(), plugin.getArtifactId());
        }

        private List<Dependency> mergePluginDependencies(List<Dependency> dependencies, List<Dependency> incomingDependencies) {
            if (incomingDependencies.isEmpty()) {
                return dependencies;
            }
            if (dependencies.isEmpty()) {
                return incomingDependencies;
            }
            ArrayList<Dependency> merged = new ArrayList<Dependency>();
            HashSet<GroupArtifact> uniqueDependencies = new HashSet<GroupArtifact>();
            for (Dependency dependency : dependencies) {
                merged.add(dependency);
                uniqueDependencies.add(new GroupArtifact(dependency.getGroupId(), dependency.getArtifactId()));
            }
            for (Dependency dependency : incomingDependencies) {
                if (uniqueDependencies.contains(new GroupArtifact(dependency.getGroupId(), dependency.getArtifactId()))) continue;
                merged.add(dependency);
            }
            return merged;
        }

        private @Nullable JsonNode mergePluginConfigurations(@Nullable JsonNode configuration, @Nullable JsonNode incomingConfiguration) {
            if (!(incomingConfiguration instanceof ObjectNode)) {
                return configuration;
            }
            if (!(configuration instanceof ObjectNode)) {
                return incomingConfiguration;
            }
            ObjectNode ret = (ObjectNode)incomingConfiguration.deepCopy();
            Iterator fields = configuration.fields();
            while (fields.hasNext()) {
                JsonNode parentCombine;
                Map.Entry conf = (Map.Entry)fields.next();
                JsonNode parentConf = ret.get((String)conf.getKey());
                JsonNode jsonNode = parentCombine = parentConf != null ? parentConf.get("combine.children") : null;
                if (parentCombine != null && "append".equals(parentCombine.asText())) {
                    JsonNode selfCombine = ((JsonNode)conf.getValue()).get("combine.self");
                    if (selfCombine != null && "override".equals(selfCombine.asText())) {
                        ret.set((String)conf.getKey(), (JsonNode)conf.getValue());
                        continue;
                    }
                    ret.set((String)conf.getKey(), this.combineLists((JsonNode)conf.getValue(), parentConf));
                    continue;
                }
                ret.set((String)conf.getKey(), (JsonNode)conf.getValue());
            }
            return ret;
        }

        private JsonNode combineLists(JsonNode list, JsonNode incomingList) {
            ObjectNode ret = (ObjectNode)incomingList.deepCopy();
            ArrayList keys = new ArrayList();
            ret.fieldNames().forEachRemaining(keys::add);
            keys.remove("combine.children");
            if (keys.isEmpty()) {
                return list.deepCopy();
            }
            String arrayElemField = (String)keys.get(0);
            JsonNode retNode = ret.get(arrayElemField);
            JsonNode node = list.get(arrayElemField);
            if (!(retNode instanceof ArrayNode)) {
                ArrayNode arrayNode = JsonNodeFactory.instance.arrayNode();
                arrayNode.add(retNode);
                ret.set(arrayElemField, (JsonNode)arrayNode);
                retNode = arrayNode;
            }
            if (node instanceof ArrayNode) {
                ((ArrayNode)retNode).addAll((ArrayNode)node);
            } else if (node != null) {
                ((ArrayNode)retNode).add(node);
            }
            JsonNode listCombine = list.get("combine.children");
            if (listCombine != null) {
                ret.set("combine.children", listCombine);
            }
            return ret;
        }

        private List<Plugin.Execution> mergePluginExecutions(List<Plugin.Execution> currentExecutions, List<Plugin.Execution> incomingExecutions) {
            if (currentExecutions.isEmpty()) {
                return incomingExecutions;
            }
            if (incomingExecutions.isEmpty()) {
                return currentExecutions;
            }
            Map currentExecutionsById = currentExecutions.stream().collect(Collectors.toMap(Plugin.Execution::getId, Function.identity()));
            ArrayList<Plugin.Execution> mergedExecutions = new ArrayList<Plugin.Execution>(currentExecutions);
            for (Plugin.Execution incomingExecution : incomingExecutions) {
                String executionId = incomingExecution.getId();
                if (!currentExecutionsById.containsKey(executionId)) {
                    mergedExecutions.add(incomingExecution);
                    continue;
                }
                Plugin.Execution currentExecution = (Plugin.Execution)currentExecutionsById.get(executionId);
                HashSet<String> mergedGoals = new HashSet<String>();
                if (currentExecution.getGoals() != null) {
                    mergedGoals.addAll(currentExecution.getGoals());
                }
                if (incomingExecution.getGoals() != null) {
                    mergedGoals.addAll(incomingExecution.getGoals());
                }
                String mergedPhase = currentExecution.getPhase();
                if (incomingExecution.getPhase() != null && !Objects.equals(mergedPhase, incomingExecution.getPhase())) {
                    mergedPhase = incomingExecution.getPhase();
                }
                JsonNode mergedConfiguration = this.mergePluginConfigurations(currentExecution.getConfiguration(), incomingExecution.getConfiguration());
                Plugin.Execution mergedExecution = new Plugin.Execution(executionId, new ArrayList<String>(mergedGoals), mergedPhase, incomingExecution.getInherited(), mergedConfiguration);
                mergedExecutions.remove(currentExecution);
                mergedExecutions.add(mergedExecution);
            }
            return mergedExecutions;
        }

        private Plugin mergePlugins(Plugin plugin, Plugin incoming) {
            return new Plugin(plugin.getGroupId(), plugin.getArtifactId(), Optional.ofNullable(plugin.getVersion()).orElse(incoming.getVersion()), Optional.ofNullable(plugin.getExtensions()).orElse(incoming.getExtensions()), Optional.ofNullable(plugin.getInherited()).orElse(incoming.getInherited()), this.mergePluginConfigurations(plugin.getConfiguration(), incoming.getConfiguration()), this.mergePluginDependencies(plugin.getDependencies(), incoming.getDependencies()), this.mergePluginExecutions(plugin.getExecutions(), incoming.getExecutions()));
        }

        private void mergePlugins(List<Plugin> plugins, List<Plugin> incomingPlugins) {
            HashMap pluginMap = new HashMap();
            plugins.forEach(p -> pluginMap.put(this.getPluginKey((Plugin)p), p));
            for (Plugin incomingPlugin : incomingPlugins) {
                if ("false".equals(incomingPlugin.getInherited())) continue;
                Plugin plugin = (Plugin)pluginMap.get(this.getPluginKey(incomingPlugin));
                if (plugin != null) {
                    plugins.remove(plugin);
                    plugins.add(this.mergePlugins(plugin, incomingPlugin));
                    continue;
                }
                plugins.add(incomingPlugin);
            }
        }

        private void mergePlugins(List<Plugin> incomingPlugins) {
            if (!incomingPlugins.isEmpty()) {
                if (ResolvedPom.this.plugins == null || ResolvedPom.this.plugins.isEmpty()) {
                    ResolvedPom.this.plugins = new ArrayList<Plugin>();
                }
                this.mergePlugins(ResolvedPom.this.plugins, incomingPlugins);
            }
        }

        private void mergePluginManagement(List<Plugin> incomingPlugins) {
            if (!incomingPlugins.isEmpty()) {
                if (ResolvedPom.this.pluginManagement == null || ResolvedPom.this.pluginManagement.isEmpty()) {
                    ResolvedPom.this.pluginManagement = new ArrayList<Plugin>();
                }
                this.mergePlugins(ResolvedPom.this.pluginManagement, incomingPlugins);
            }
        }

        private void updateRepositories() {
            ResolvedPom.this.repositories = ListUtils.map(ResolvedPom.this.repositories, repo -> {
                if (placeholderHelper.hasPlaceholders(repo.getId())) {
                    repo = repo.withId(placeholderHelper.replacePlaceholders(repo.getId(), ResolvedPom.this.properties::get));
                }
                if (placeholderHelper.hasPlaceholders(repo.getUri())) {
                    repo = repo.withUri(placeholderHelper.replacePlaceholders(repo.getUri(), ResolvedPom.this.properties::get));
                }
                return repo;
            });
        }

        private void mergeRepositories(List<MavenRepository> incomingRepositories) {
            if (!incomingRepositories.isEmpty()) {
                if (ResolvedPom.this.repositories == null || ResolvedPom.this.repositories.isEmpty()) {
                    ResolvedPom.this.repositories = new ArrayList<MavenRepository>(incomingRepositories.size());
                }
                block0: for (MavenRepository incomingRepository : incomingRepositories) {
                    MavenRepository incoming = new MavenRepository(ResolvedPom.this.getValue(incomingRepository.getId()), ResolvedPom.this.getValue(incomingRepository.getUri()), incomingRepository.getReleases(), incomingRepository.getSnapshots(), incomingRepository.isKnownToExist(), incomingRepository.getUsername(), incomingRepository.getPassword(), incomingRepository.getTimeout(), incomingRepository.getDeriveMetadataIfMissing());
                    if (incoming.getId() != null) {
                        for (MavenRepository repository : ResolvedPom.this.repositories) {
                            if (!incoming.getId().equals(repository.getId())) continue;
                            continue block0;
                        }
                    }
                    ResolvedPom.this.repositories.add(incoming);
                }
            }
        }

        private void mergeProperties(Map<String, String> incomingProperties, Pom pom) {
            if (!incomingProperties.isEmpty()) {
                if (ResolvedPom.this.properties == null || ResolvedPom.this.properties.isEmpty()) {
                    ResolvedPom.this.properties = new HashMap<String, String>(incomingProperties.size());
                }
                for (Map.Entry<String, String> property : incomingProperties.entrySet()) {
                    MavenExecutionContextView.view(this.ctx).getResolutionListener().property(property.getKey(), property.getValue(), pom);
                    if (ResolvedPom.this.properties.containsKey(property.getKey())) continue;
                    ResolvedPom.this.properties.put(property.getKey(), property.getValue());
                }
            }
        }

        private GroupArtifactClassifierType createDependencyManagementKey(ResolvedManagedDependency dependency) {
            return new GroupArtifactClassifierType(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType());
        }

        private GroupArtifactClassifierType createDependencyManagementKey(ManagedDependency.Defined defined) {
            return new GroupArtifactClassifierType(defined.getGroupId(), defined.getArtifactId(), defined.getClassifier(), defined.getType() == null ? "jar" : defined.getType());
        }

        private ResolvedManagedDependency mergeProperties(ResolvedManagedDependency child, ResolvedManagedDependency parent) {
            return new ResolvedManagedDependency(child.getGav().withVersion(child.getVersion() != null ? child.getVersion() : parent.getVersion()), child.getScope() != null ? child.getScope() : parent.getScope(), child.getType() != null ? child.getType() : parent.getType(), child.getClassifier() != null ? child.getClassifier() : parent.getClassifier(), this.mergeExclusions(child.getExclusions(), parent.getExclusions()), child.getRequested(), child.getRequestedBom() != null ? child.getRequestedBom() : parent.getRequestedBom(), child.getBomGav() != null ? child.getBomGav() : parent.getBomGav());
        }

        private List<GroupArtifact> mergeExclusions(@Nullable List<GroupArtifact> childExclusions, @Nullable List<GroupArtifact> parentExclusions) {
            if (childExclusions != null && !childExclusions.isEmpty()) {
                return childExclusions;
            }
            return parentExclusions != null ? parentExclusions : Collections.emptyList();
        }

        private void mergeDependencyManagement(List<ManagedDependency> incomingDependencyManagement, Map<GroupArtifactClassifierType, ResolvedManagedDependency> managedDependencyMap, List<Pom> pomAncestry) throws MavenDownloadingException {
            Pom pom = pomAncestry.get(0);
            for (ManagedDependency d : incomingDependencyManagement) {
                if (d instanceof ManagedDependency.Imported) {
                    GroupArtifactVersion groupArtifactVersion = ResolvedPom.this.getValues(((ManagedDependency.Imported)d).getGav());
                    if (this.isAlreadyResolved(groupArtifactVersion, pomAncestry)) continue;
                    ResolvedPom bom = this.downloader.download(groupArtifactVersion, null, ResolvedPom.this, ResolvedPom.this.repositories).resolve(ResolvedPom.this.activeProfiles, this.downloader, ResolvedPom.this.initialRepositories, this.ctx);
                    MavenExecutionContextView.view(this.ctx).getResolutionListener().bomImport(bom.getGav(), pom);
                    List bomManaged = ListUtils.map(bom.getDependencyManagement(), dm -> dm.withRequestedBom(d).withBomGav(bom.getGav()));
                    for (ResolvedManagedDependency managed : bomManaged) {
                        managedDependencyMap.compute(this.createDependencyManagementKey(managed), (key, existing) -> {
                            if (existing == null) {
                                return managed;
                            }
                            return this.mergeProperties((ResolvedManagedDependency)existing, managed);
                        });
                    }
                    continue;
                }
                if (!(d instanceof ManagedDependency.Defined)) continue;
                ManagedDependency.Defined defined = (ManagedDependency.Defined)d;
                MavenExecutionContextView.view(this.ctx).getResolutionListener().dependencyManagement(defined.withGav(ResolvedPom.this.getValues(defined.getGav())), pom);
                ResolvedManagedDependency resolvedDefined = new ResolvedManagedDependency(ResolvedPom.this.getValues(defined.getGav()), defined.getScope() == null ? null : Scope.fromName(ResolvedPom.this.getValue(defined.getScope())), ResolvedPom.this.getValue(defined.getType()), ResolvedPom.this.getValue(defined.getClassifier()), ListUtils.map(defined.getExclusions(), ResolvedPom.this::getValues), defined, null, null);
                managedDependencyMap.compute(this.createDependencyManagementKey(defined), (key, existing) -> {
                    if (existing == null || existing.getBomGav() != null) {
                        return resolvedDefined;
                    }
                    return this.mergeProperties((ResolvedManagedDependency)existing, resolvedDefined);
                });
            }
        }

        private boolean isAlreadyResolved(GroupArtifactVersion groupArtifactVersion, List<Pom> pomAncestry) {
            for (int i = 1; i < pomAncestry.size(); ++i) {
                Pom pom = pomAncestry.get(i);
                ResolvedGroupArtifactVersion alreadyResolvedGav = pom.getGav();
                if (!alreadyResolvedGav.getGroupId().equals(groupArtifactVersion.getGroupId()) || !alreadyResolvedGav.getArtifactId().equals(groupArtifactVersion.getArtifactId()) || !alreadyResolvedGav.getVersion().equals(groupArtifactVersion.getVersion())) continue;
                return true;
            }
            return false;
        }

        @Generated
        public Resolver(ExecutionContext ctx, MavenPomDownloader downloader) {
            this.ctx = ctx;
            this.downloader = downloader;
        }

        @Generated
        public ExecutionContext getCtx() {
            return this.ctx;
        }

        @Generated
        public MavenPomDownloader getDownloader() {
            return this.downloader;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Resolver)) {
                return false;
            }
            Resolver other = (Resolver)o;
            ExecutionContext this$ctx = this.getCtx();
            ExecutionContext other$ctx = other.getCtx();
            if (this$ctx == null ? other$ctx != null : !this$ctx.equals(other$ctx)) {
                return false;
            }
            MavenPomDownloader this$downloader = this.getDownloader();
            MavenPomDownloader other$downloader = other.getDownloader();
            return !(this$downloader == null ? other$downloader != null : !this$downloader.equals(other$downloader));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutionContext $ctx = this.getCtx();
            result = result * 59 + ($ctx == null ? 43 : $ctx.hashCode());
            MavenPomDownloader $downloader = this.getDownloader();
            result = result * 59 + ($downloader == null ? 43 : $downloader.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ResolvedPom.Resolver(ctx=" + this.getCtx() + ", downloader=" + this.getDownloader() + ")";
        }

        private final class PluginKey {
            private final String groupId;
            private final String artifactId;

            @Generated
            public PluginKey(String groupId, String artifactId) {
                this.groupId = groupId;
                this.artifactId = artifactId;
            }

            @Generated
            public String getGroupId() {
                return this.groupId;
            }

            @Generated
            public String getArtifactId() {
                return this.artifactId;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PluginKey)) {
                    return false;
                }
                PluginKey other = (PluginKey)o;
                String this$groupId = this.getGroupId();
                String other$groupId = other.getGroupId();
                if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                    return false;
                }
                String this$artifactId = this.getArtifactId();
                String other$artifactId = other.getArtifactId();
                return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $groupId = this.getGroupId();
                result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
                String $artifactId = this.getArtifactId();
                result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "ResolvedPom.Resolver.PluginKey(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
            }
        }
    }

    private static final class DependencyAndDependent {
        private final Dependency dependency;
        private final Scope scope;
        private final ResolvedDependency dependent;
        private final Dependency rootDependent;
        private final ResolvedPom definedIn;

        @Generated
        public DependencyAndDependent(Dependency dependency, Scope scope, ResolvedDependency dependent, Dependency rootDependent, ResolvedPom definedIn) {
            this.dependency = dependency;
            this.scope = scope;
            this.dependent = dependent;
            this.rootDependent = rootDependent;
            this.definedIn = definedIn;
        }

        @Generated
        public Dependency getDependency() {
            return this.dependency;
        }

        @Generated
        public Scope getScope() {
            return this.scope;
        }

        @Generated
        public ResolvedDependency getDependent() {
            return this.dependent;
        }

        @Generated
        public Dependency getRootDependent() {
            return this.rootDependent;
        }

        @Generated
        public ResolvedPom getDefinedIn() {
            return this.definedIn;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DependencyAndDependent)) {
                return false;
            }
            DependencyAndDependent other = (DependencyAndDependent)o;
            Dependency this$dependency = this.getDependency();
            Dependency other$dependency = other.getDependency();
            if (this$dependency == null ? other$dependency != null : !((Object)this$dependency).equals(other$dependency)) {
                return false;
            }
            Scope this$scope = this.getScope();
            Scope other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
                return false;
            }
            ResolvedDependency this$dependent = this.getDependent();
            ResolvedDependency other$dependent = other.getDependent();
            if (this$dependent == null ? other$dependent != null : !((Object)this$dependent).equals(other$dependent)) {
                return false;
            }
            Dependency this$rootDependent = this.getRootDependent();
            Dependency other$rootDependent = other.getRootDependent();
            if (this$rootDependent == null ? other$rootDependent != null : !((Object)this$rootDependent).equals(other$rootDependent)) {
                return false;
            }
            ResolvedPom this$definedIn = this.getDefinedIn();
            ResolvedPom other$definedIn = other.getDefinedIn();
            return !(this$definedIn == null ? other$definedIn != null : !this$definedIn.equals(other$definedIn));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Dependency $dependency = this.getDependency();
            result = result * 59 + ($dependency == null ? 43 : ((Object)$dependency).hashCode());
            Scope $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
            ResolvedDependency $dependent = this.getDependent();
            result = result * 59 + ($dependent == null ? 43 : ((Object)$dependent).hashCode());
            Dependency $rootDependent = this.getRootDependent();
            result = result * 59 + ($rootDependent == null ? 43 : ((Object)$rootDependent).hashCode());
            ResolvedPom $definedIn = this.getDefinedIn();
            result = result * 59 + ($definedIn == null ? 43 : $definedIn.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ResolvedPom.DependencyAndDependent(dependency=" + this.getDependency() + ", scope=" + (Object)((Object)this.getScope()) + ", dependent=" + this.getDependent() + ", rootDependent=" + this.getRootDependent() + ", definedIn=" + this.getDefinedIn() + ")";
        }
    }

    @Generated
    public static class ResolvedPomBuilder {
        @Generated
        private Pom requested;
        @Generated
        private boolean activeProfiles$set;
        @Generated
        private Iterable<String> activeProfiles$value;
        @Generated
        private boolean properties$set;
        @Generated
        private Map<String, String> properties$value;
        @Generated
        private boolean dependencyManagement$set;
        @Generated
        private List<ResolvedManagedDependency> dependencyManagement$value;
        @Generated
        private boolean dependencyManagementSorted$set;
        @Generated
        private boolean dependencyManagementSorted$value;
        @Generated
        private boolean initialRepositories$set;
        @Generated
        private List<MavenRepository> initialRepositories$value;
        @Generated
        private boolean repositories$set;
        @Generated
        private List<MavenRepository> repositories$value;
        @Generated
        private boolean pluginRepositories$set;
        @Generated
        private List<MavenRepository> pluginRepositories$value;
        @Generated
        private boolean requestedDependencies$set;
        @Generated
        private List<Dependency> requestedDependencies$value;
        @Generated
        private boolean plugins$set;
        @Generated
        private List<Plugin> plugins$value;
        @Generated
        private boolean pluginManagement$set;
        @Generated
        private List<Plugin> pluginManagement$value;
        @Generated
        private boolean subprojects$set;
        @Generated
        private List<String> subprojects$value;

        @Generated
        ResolvedPomBuilder() {
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder requested(Pom requested) {
            this.requested = requested;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder activeProfiles(Iterable<String> activeProfiles) {
            this.activeProfiles$value = activeProfiles;
            this.activeProfiles$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder properties(Map<String, String> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder dependencyManagement(List<ResolvedManagedDependency> dependencyManagement) {
            this.dependencyManagement$value = dependencyManagement;
            this.dependencyManagement$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder dependencyManagementSorted(boolean dependencyManagementSorted) {
            this.dependencyManagementSorted$value = dependencyManagementSorted;
            this.dependencyManagementSorted$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder initialRepositories(List<MavenRepository> initialRepositories) {
            this.initialRepositories$value = initialRepositories;
            this.initialRepositories$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder repositories(List<MavenRepository> repositories) {
            this.repositories$value = repositories;
            this.repositories$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder pluginRepositories(List<MavenRepository> pluginRepositories) {
            this.pluginRepositories$value = pluginRepositories;
            this.pluginRepositories$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder requestedDependencies(List<Dependency> requestedDependencies) {
            this.requestedDependencies$value = requestedDependencies;
            this.requestedDependencies$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder plugins(List<Plugin> plugins) {
            this.plugins$value = plugins;
            this.plugins$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder pluginManagement(List<Plugin> pluginManagement) {
            this.pluginManagement$value = pluginManagement;
            this.pluginManagement$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPomBuilder subprojects(@Nullable List<String> subprojects) {
            this.subprojects$value = subprojects;
            this.subprojects$set = true;
            return this;
        }

        @NonNull
        @Generated
        public ResolvedPom build() {
            Iterable activeProfiles$value = this.activeProfiles$value;
            if (!this.activeProfiles$set) {
                activeProfiles$value = ResolvedPom.$default$activeProfiles();
            }
            Map properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = ResolvedPom.$default$properties();
            }
            List dependencyManagement$value = this.dependencyManagement$value;
            if (!this.dependencyManagement$set) {
                dependencyManagement$value = ResolvedPom.$default$dependencyManagement();
            }
            boolean dependencyManagementSorted$value = this.dependencyManagementSorted$value;
            if (!this.dependencyManagementSorted$set) {
                dependencyManagementSorted$value = ResolvedPom.$default$dependencyManagementSorted();
            }
            List initialRepositories$value = this.initialRepositories$value;
            if (!this.initialRepositories$set) {
                initialRepositories$value = ResolvedPom.$default$initialRepositories();
            }
            List repositories$value = this.repositories$value;
            if (!this.repositories$set) {
                repositories$value = ResolvedPom.$default$repositories();
            }
            List pluginRepositories$value = this.pluginRepositories$value;
            if (!this.pluginRepositories$set) {
                pluginRepositories$value = ResolvedPom.$default$pluginRepositories();
            }
            List requestedDependencies$value = this.requestedDependencies$value;
            if (!this.requestedDependencies$set) {
                requestedDependencies$value = ResolvedPom.$default$requestedDependencies();
            }
            List plugins$value = this.plugins$value;
            if (!this.plugins$set) {
                plugins$value = ResolvedPom.$default$plugins();
            }
            List pluginManagement$value = this.pluginManagement$value;
            if (!this.pluginManagement$set) {
                pluginManagement$value = ResolvedPom.$default$pluginManagement();
            }
            List subprojects$value = this.subprojects$value;
            if (!this.subprojects$set) {
                subprojects$value = ResolvedPom.$default$subprojects();
            }
            return new ResolvedPom(this.requested, activeProfiles$value, properties$value, dependencyManagement$value, dependencyManagementSorted$value, initialRepositories$value, repositories$value, pluginRepositories$value, requestedDependencies$value, plugins$value, pluginManagement$value, subprojects$value);
        }

        @NonNull
        @Generated
        public String toString() {
            return "ResolvedPom.ResolvedPomBuilder(requested=" + this.requested + ", activeProfiles$value=" + this.activeProfiles$value + ", properties$value=" + this.properties$value + ", dependencyManagement$value=" + this.dependencyManagement$value + ", dependencyManagementSorted$value=" + this.dependencyManagementSorted$value + ", initialRepositories$value=" + this.initialRepositories$value + ", repositories$value=" + this.repositories$value + ", pluginRepositories$value=" + this.pluginRepositories$value + ", requestedDependencies$value=" + this.requestedDependencies$value + ", plugins$value=" + this.plugins$value + ", pluginManagement$value=" + this.pluginManagement$value + ", subprojects$value=" + this.subprojects$value + ")";
        }
    }

    private static final class UniqueDependencyKey {
        private final GroupArtifactVersion gav;
        private final @Nullable String type;
        private final @Nullable String classifier;
        private final Object scope;

        @Generated
        public UniqueDependencyKey(GroupArtifactVersion gav, @Nullable String type, @Nullable String classifier, Object scope) {
            this.gav = gav;
            this.type = type;
            this.classifier = classifier;
            this.scope = scope;
        }

        @Generated
        public GroupArtifactVersion getGav() {
            return this.gav;
        }

        @Generated
        public @Nullable String getType() {
            return this.type;
        }

        @Generated
        public @Nullable String getClassifier() {
            return this.classifier;
        }

        @Generated
        public Object getScope() {
            return this.scope;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UniqueDependencyKey)) {
                return false;
            }
            UniqueDependencyKey other = (UniqueDependencyKey)o;
            GroupArtifactVersion this$gav = this.getGav();
            GroupArtifactVersion other$gav = other.getGav();
            if (this$gav == null ? other$gav != null : !((Object)this$gav).equals(other$gav)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$classifier = this.getClassifier();
            String other$classifier = other.getClassifier();
            if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
                return false;
            }
            Object this$scope = this.getScope();
            Object other$scope = other.getScope();
            return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GroupArtifactVersion $gav = this.getGav();
            result = result * 59 + ($gav == null ? 43 : ((Object)$gav).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $classifier = this.getClassifier();
            result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
            Object $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ResolvedPom.UniqueDependencyKey(gav=" + this.getGav() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", scope=" + this.getScope() + ")";
        }
    }
}

