/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.marker.JavaProject;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.search.FindPlugin;

public final class ModuleHasPlugin
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Group", description="The first part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="org.openrewrite.maven")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate 'org.openrewrite.maven:rewrite-maven-plugin:VERSION'.", example="rewrite-maven-plugin")
    private final String artifactId;

    public String getDisplayName() {
        return "Module has plugin";
    }

    public String getDescription() {
        return "Searches for Maven modules that have a plugin matching the specified groupId and artifactId. Places a `SearchResult` marker on all sources within a module with a matching plugin. This recipe is intended to be used as a precondition for other recipes. For example this could be used to limit the application of a spring boot migration to only projects that apply the spring boot plugin, limiting unnecessary upgrading. If the search result you want is instead just the build.gradle(.kts) file applying the plugin, use the `FindPlugins` recipe instead.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(new HashSet<JavaProject>());
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                tree.getMarkers().findFirst(JavaProject.class).ifPresent(jp -> {
                    Tree t = new FindPlugin(ModuleHasPlugin.this.groupId, ModuleHasPlugin.this.artifactId).getVisitor().visit(tree, (Object)ctx);
                    if (t != tree) {
                        acc.getProjectsWithDependency().add((JavaProject)jp);
                    }
                });
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                assert (tree != null);
                Optional maybeJp = tree.getMarkers().findFirst(JavaProject.class);
                if (!maybeJp.isPresent()) {
                    return tree;
                }
                JavaProject jp = (JavaProject)maybeJp.get();
                if (acc.getProjectsWithDependency().contains(jp)) {
                    return SearchResult.found((Tree)tree, (String)("Module has plugin: " + ModuleHasPlugin.this.groupId + ":" + ModuleHasPlugin.this.artifactId));
                }
                return tree;
            }
        };
    }

    @Generated
    public ModuleHasPlugin(String groupId, String artifactId) {
        this.groupId = groupId;
        this.artifactId = artifactId;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ModuleHasPlugin(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleHasPlugin)) {
            return false;
        }
        ModuleHasPlugin other = (ModuleHasPlugin)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        return !(this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof ModuleHasPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        return result;
    }

    public static final class Accumulator {
        private final Set<JavaProject> projectsWithDependency;

        @Generated
        public Accumulator(Set<JavaProject> projectsWithDependency) {
            this.projectsWithDependency = projectsWithDependency;
        }

        @Generated
        public Set<JavaProject> getProjectsWithDependency() {
            return this.projectsWithDependency;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<JavaProject> this$projectsWithDependency = this.getProjectsWithDependency();
            Set<JavaProject> other$projectsWithDependency = other.getProjectsWithDependency();
            return !(this$projectsWithDependency == null ? other$projectsWithDependency != null : !((Object)this$projectsWithDependency).equals(other$projectsWithDependency));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<JavaProject> $projectsWithDependency = this.getProjectsWithDependency();
            result = result * 59 + ($projectsWithDependency == null ? 43 : ((Object)$projectsWithDependency).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "ModuleHasPlugin.Accumulator(projectsWithDependency=" + this.getProjectsWithDependency() + ")";
        }
    }
}

