/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplaceReader;
import org.openrewrite.maven.marketplace.RecipeClassLoaderFactory;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;

public class MavenRecipeBundleReader
implements RecipeBundleReader {
    private static final Map<ResolvedGroupArtifactVersion, Lock> DEPENDENCY_LOCKS = new ConcurrentHashMap<ResolvedGroupArtifactVersion, Lock>();
    private final RecipeBundle bundle;
    private final MavenResolutionResult mrr;
    private final MavenArtifactDownloader downloader;
    private final RecipeClassLoaderFactory classLoaderFactory;
    private transient @Nullable Environment environment;
    private transient @Nullable Path recipeJar;
    private transient @Nullable List<Path> classpath;
    private transient @Nullable ClassLoader classLoader;

    /*
     * Enabled aggressive exception aggregation
     */
    public RecipeMarketplace read() {
        block16: {
            if (this.recipeJar == null) {
                for (ResolvedDependency resolvedDependency : this.mrr.getDependencies().get((Object)Scope.Runtime)) {
                    if (!resolvedDependency.isDirect() || this.recipeJar == null) continue;
                    this.recipeJar = this.downloader.downloadArtifact(resolvedDependency);
                }
                if (this.recipeJar != null) {
                    try (JarFile jarFile = new JarFile(this.recipeJar.toFile());){
                        RecipeMarketplace recipeMarketplace;
                        block17: {
                            JarEntry entry = jarFile.getJarEntry("META-INF/rewrite/recipes.csv");
                            if (entry == null) break block16;
                            InputStream recipesCsv = jarFile.getInputStream(entry);
                            try {
                                recipeMarketplace = new RecipeMarketplaceReader().fromCsv(recipesCsv);
                                if (recipesCsv == null) break block17;
                            }
                            catch (Throwable throwable) {
                                if (recipesCsv != null) {
                                    try {
                                        recipesCsv.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            recipesCsv.close();
                        }
                        return recipeMarketplace;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.marketplaceFromClasspathScan();
    }

    private RecipeMarketplace marketplaceFromClasspathScan() {
        String[] ga = this.bundle.getPackageName().split(":");
        GroupArtifactVersion gav = new GroupArtifactVersion(ga[0], ga[1], this.bundle.getVersion());
        RecipeMarketplace marketplace = new RecipeMarketplace();
        Environment env = this.environment();
        for (RecipeDescriptor descriptor : env.listRecipeDescriptors()) {
            marketplace.install(RecipeListing.fromDescriptor((RecipeDescriptor)descriptor, (RecipeBundle)new RecipeBundle("maven", gav.getGroupId() + ":" + gav.getArtifactId(), Objects.requireNonNull(gav.getVersion()), null)), descriptor.inferCategoriesFromName(env));
        }
        return marketplace;
    }

    public RecipeDescriptor describe(RecipeListing listing) {
        return this.environment().activateRecipes(new String[]{listing.getName()}).getDescriptor();
    }

    public Recipe prepare(RecipeListing listing, @Nullable Map<String, Object> options) {
        Recipe r = this.environment().activateRecipes(new String[]{listing.getName()});
        return this.applyOptions(r, options);
    }

    private Environment environment() {
        if (this.environment == null) {
            this.environment = Environment.builder().load((ResourceLoader)new ClasspathScanningLoader(new Properties(), this.classLoader())).build();
        }
        return this.environment;
    }

    private ClassLoader classLoader() {
        if (this.classLoader == null) {
            List<Path> classpath = this.classpath();
            this.classLoader = this.classLoaderFactory.create(Objects.requireNonNull(this.recipeJar), classpath);
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> classpath() {
        if (this.classpath == null) {
            this.classpath = new ArrayList<Path>();
            for (ResolvedDependency resolvedDependency : this.mrr.getDependencies().get((Object)Scope.Runtime)) {
                Lock lock = DEPENDENCY_LOCKS.computeIfAbsent(resolvedDependency.getGav(), g -> new ReentrantLock());
                lock.lock();
                try {
                    if (resolvedDependency.isDirect() && this.recipeJar != null) {
                        this.classpath.add(this.recipeJar);
                        continue;
                    }
                    Path path = this.downloader.downloadArtifact(resolvedDependency);
                    if (path == null) {
                        throw new IllegalStateException("Unable to download dependency " + resolvedDependency.getGav());
                    }
                    if (resolvedDependency.isDirect()) {
                        this.recipeJar = path;
                    }
                    this.classpath.add(path);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return this.classpath;
    }

    private <R extends Recipe> R applyOptions(R recipe, @Nullable Map<String, Object> options) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("@c", recipe.getName());
        ObjectMapper objectMapper = ((JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES})).configure(MapperFeature.PROPAGATE_TRANSIENT_MARKER, true)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setVisibility(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        try {
            Recipe clone = recipe.clone();
            if (options != null) {
                m.putAll(options);
                for (OptionDescriptor optionDescriptor : clone.getDescriptor().getOptions()) {
                    Object value = options.get(optionDescriptor.getName());
                    if (!(value instanceof String)) continue;
                    HashMap<String, Object> option = new HashMap<String, Object>();
                    option.put("value", value);
                    objectMapper.updateValue((Object)optionDescriptor, option);
                }
            }
            return (R)((Recipe)objectMapper.updateValue((Object)clone, m));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Generated
    public MavenRecipeBundleReader(RecipeBundle bundle, MavenResolutionResult mrr, MavenArtifactDownloader downloader, RecipeClassLoaderFactory classLoaderFactory) {
        this.bundle = bundle;
        this.mrr = mrr;
        this.downloader = downloader;
        this.classLoaderFactory = classLoaderFactory;
    }

    @Generated
    public RecipeBundle getBundle() {
        return this.bundle;
    }
}

