/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrewrite.maven.graph.DependencyGraph;
import org.openrewrite.maven.graph.DependencyGraphBuilder;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

public abstract class AbstractDependencyGraphBuilder<T extends DependencyGraph.DependencyNode>
implements DependencyGraphBuilder<T> {
    @Override
    public void collectDependencyPaths(List<ResolvedDependency> dependencies, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> paths, String scope) {
        ArrayList<DependencyGraph.DependencyNode> pathBuffer = new ArrayList<DependencyGraph.DependencyNode>();
        for (ResolvedDependency dependency : dependencies) {
            this.collectDependencyPathsRecursive(dependency, pathBuffer, paths, scope);
        }
    }

    private void collectDependencyPathsRecursive(ResolvedDependency dependency, List<DependencyGraph.DependencyNode> pathBuffer, Map<ResolvedGroupArtifactVersion, List<DependencyGraph.DependencyPath>> paths, String scope) {
        ResolvedGroupArtifactVersion gav = dependency.getGav();
        Object node = this.createNode(dependency, scope);
        pathBuffer.add((DependencyGraph.DependencyNode)node);
        ArrayList<DependencyGraph.DependencyNode> pathSnapshot = new ArrayList<DependencyGraph.DependencyNode>(pathBuffer.size());
        for (int i = pathBuffer.size() - 1; i >= 0; --i) {
            pathSnapshot.add(pathBuffer.get(i));
        }
        DependencyGraph.DependencyPath path = new DependencyGraph.DependencyPath(pathSnapshot, scope);
        paths.computeIfAbsent(gav, k -> new ArrayList()).add(path);
        for (ResolvedDependency child : dependency.getDependencies()) {
            boolean hasCycle = false;
            for (int i = 0; i < pathBuffer.size(); ++i) {
                DependencyGraph.DependencyNode n = pathBuffer.get(i);
                if (!n.getGroupId().equals(child.getGroupId()) || !n.getArtifactId().equals(child.getArtifactId())) continue;
                hasCycle = true;
                break;
            }
            if (hasCycle) continue;
            this.collectDependencyPathsRecursive(child, pathBuffer, paths, scope);
        }
        pathBuffer.remove(pathBuffer.size() - 1);
    }
}

