/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.search;

import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.ParentPomsInUse;
import org.openrewrite.maven.tree.ResolvedPom;
import org.openrewrite.xml.tree.Xml;

public final class ParentPomInsight
extends Recipe {
    private final transient ParentPomsInUse inUse = new ParentPomsInUse(this);
    @Option(displayName="Group pattern", description="Group glob pattern used to match dependencies.", example="org.springframework.boot")
    private final String groupIdPattern;
    @Option(displayName="Artifact pattern", description="Artifact glob pattern used to match dependencies.", example="spring-boot-starter-*")
    private final String artifactIdPattern;
    private final UUID searchId = Tree.randomId();

    public String getDisplayName() {
        return "Maven parent insight";
    }

    public String getDescription() {
        return "Find Maven parents matching a `groupId` and `artifactId`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){

            @Override
            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, ctx);
                if (this.isParentTag()) {
                    ResolvedPom resolvedPom = this.getResolutionResult().getPom();
                    String groupId = resolvedPom.getValue(tag.getChildValue("groupId").orElse(null));
                    String artifactId = resolvedPom.getValue(tag.getChildValue("artifactId").orElse(null));
                    if (StringUtils.matchesGlob((String)groupId, (String)ParentPomInsight.this.groupIdPattern) && StringUtils.matchesGlob((String)artifactId, (String)ParentPomInsight.this.artifactIdPattern)) {
                        String version = resolvedPom.getValue(tag.getChildValue("version").orElse(null));
                        String relativePath = tag.getChildValue("relativePath").orElse(null);
                        ParentPomInsight.this.inUse.insertRow(ctx, new ParentPomsInUse.Row(resolvedPom.getArtifactId(), groupId, artifactId, version, relativePath));
                        return (Xml.Tag)SearchResult.found((Tree)t);
                    }
                }
                return t;
            }
        };
    }

    public ParentPomInsight(String groupIdPattern, String artifactIdPattern) {
        this.groupIdPattern = groupIdPattern;
        this.artifactIdPattern = artifactIdPattern;
    }

    public ParentPomsInUse getInUse() {
        return this.inUse;
    }

    public String getGroupIdPattern() {
        return this.groupIdPattern;
    }

    public String getArtifactIdPattern() {
        return this.artifactIdPattern;
    }

    public UUID getSearchId() {
        return this.searchId;
    }

    @NonNull
    public String toString() {
        return "ParentPomInsight(inUse=" + (Object)((Object)this.getInUse()) + ", groupIdPattern=" + this.getGroupIdPattern() + ", artifactIdPattern=" + this.getArtifactIdPattern() + ", searchId=" + this.getSearchId() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParentPomInsight)) {
            return false;
        }
        ParentPomInsight other = (ParentPomInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupIdPattern = this.getGroupIdPattern();
        String other$groupIdPattern = other.getGroupIdPattern();
        if (this$groupIdPattern == null ? other$groupIdPattern != null : !this$groupIdPattern.equals(other$groupIdPattern)) {
            return false;
        }
        String this$artifactIdPattern = this.getArtifactIdPattern();
        String other$artifactIdPattern = other.getArtifactIdPattern();
        if (this$artifactIdPattern == null ? other$artifactIdPattern != null : !this$artifactIdPattern.equals(other$artifactIdPattern)) {
            return false;
        }
        UUID this$searchId = this.getSearchId();
        UUID other$searchId = other.getSearchId();
        return !(this$searchId == null ? other$searchId != null : !((Object)this$searchId).equals(other$searchId));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ParentPomInsight;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupIdPattern = this.getGroupIdPattern();
        result = result * 59 + ($groupIdPattern == null ? 43 : $groupIdPattern.hashCode());
        String $artifactIdPattern = this.getArtifactIdPattern();
        result = result * 59 + ($artifactIdPattern == null ? 43 : $artifactIdPattern.hashCode());
        UUID $searchId = this.getSearchId();
        result = result * 59 + ($searchId == null ? 43 : ((Object)$searchId).hashCode());
        return result;
    }
}

