/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.polyglot.ProgressBar;

public class RemoteProgressBarSender
implements ProgressBar {
    static final int MAX_MESSAGE_SIZE = 256;
    private DatagramSocket socket;
    private InetAddress address;
    private int port;

    public RemoteProgressBarSender(int port) {
        this(null, port);
    }

    public RemoteProgressBarSender(@Nullable InetAddress address, int port) {
        String localhost = Files.exists(Paths.get("/.dockerenv", new String[0]), new LinkOption[0]) ? "host.docker.internal" : "localhost";
        try {
            this.address = address == null ? InetAddress.getByName(localhost) : address;
            this.port = port;
            this.socket = new DatagramSocket();
        }
        catch (SocketException | UnknownHostException e) {
            if (localhost.equals("host.docker.internal")) {
                try {
                    this.address = InetAddress.getByName("localhost");
                }
                catch (UnknownHostException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void intermediateResult(@Nullable String message) {
        this.send(Request.Type.IntermediateResult, message);
    }

    @Override
    public void finish(String message) {
        throw new UnsupportedOperationException("The finish message must be determined by the receiver");
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public void step() {
        this.send(Request.Type.Step, null);
    }

    @Override
    public ProgressBar setExtraMessage(String extraMessage) {
        this.send(Request.Type.SetExtraMessage, extraMessage);
        return this;
    }

    @Override
    public ProgressBar setMax(int max) {
        this.send(Request.Type.SetMax, Integer.toString(max));
        return this;
    }

    private void send(Request.Type type, @Nullable String message) {
        try {
            message = RemoteProgressBarSender.truncateMessage(message, 255);
            byte[] buf = (type.ordinal() + (message == null ? "" : message)).getBytes();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, this.address, this.port);
            this.socket.send(packet);
        }
        catch (SocketException buf) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Nullable
    static String truncateMessage(@Nullable String message, int maxLength) {
        if (message == null || message.length() <= maxLength) {
            return message;
        }
        return "..." + message.substring(Math.max(message.length() - maxLength + 3, 0));
    }

    static final class Request {
        private final Type type;
        @Nullable
        private final String body;

        public Request(Type type, String body) {
            this.type = type;
            this.body = body;
        }

        public Type getType() {
            return this.type;
        }

        public String getBody() {
            return this.body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$body = this.getBody();
            String other$body = other.getBody();
            return !(this$body == null ? other$body != null : !this$body.equals(other$body));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $body = this.getBody();
            result = result * 59 + ($body == null ? 43 : $body.hashCode());
            return result;
        }

        public String toString() {
            return "RemoteProgressBarSender.Request(type=" + (Object)((Object)this.getType()) + ", body=" + this.getBody() + ")";
        }

        static enum Type {
            IntermediateResult,
            Step,
            SetExtraMessage,
            SetMax;

        }
    }
}

