/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.polyglot;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.polyglot.ProgressBar;
import org.openrewrite.polyglot.RemoteException;
import org.openrewrite.polyglot.RemoteProgressMessage;

public class RemoteProgressBarSender
implements ProgressBar {
    private DatagramSocket socket;
    private InetAddress address;
    private int port;

    public RemoteProgressBarSender(int port) {
        this(null, port);
    }

    public RemoteProgressBarSender(@Nullable InetAddress address, int port) {
        String localhost = Files.exists(Paths.get("/.dockerenv", new String[0]), new LinkOption[0]) ? "host.docker.internal" : "localhost";
        try {
            this.socket = new DatagramSocket();
            this.port = port;
            this.address = address == null ? InetAddress.getByName(localhost) : address;
        }
        catch (SocketException | UnknownHostException e) {
            if (localhost.equals("host.docker.internal")) {
                try {
                    this.address = InetAddress.getByName("localhost");
                }
                catch (UnknownHostException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void intermediateResult(@Nullable String message) {
        this.send(RemoteProgressMessage.Type.IntermediateResult, message);
    }

    @Override
    public void finish(String message) {
        throw new UnsupportedOperationException("The finish message must be determined by the receiver");
    }

    @Override
    public void close() {
        this.socket.close();
    }

    @Override
    public void step() {
        this.send(RemoteProgressMessage.Type.Step, null);
    }

    @Override
    public ProgressBar setExtraMessage(String extraMessage) {
        this.send(RemoteProgressMessage.Type.SetExtraMessage, extraMessage);
        return this;
    }

    @Override
    public ProgressBar setMax(int max) {
        this.send(RemoteProgressMessage.Type.SetMax, Integer.toString(max));
        return this;
    }

    public void throwRemote(RemoteException ex) {
        this.send(RemoteProgressMessage.Type.Exception, ex.encode());
    }

    private void send(RemoteProgressMessage.Type type, @Nullable String message) {
        try {
            for (byte[] packet : RemoteProgressMessage.toPackets(type, message)) {
                this.socket.send(new DatagramPacket(packet, packet.length, this.address, this.port));
            }
        }
        catch (SocketException socketException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

