/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.tree;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.internal.PropertiesPrinter;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
public interface Properties
extends Serializable,
Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptProperties((PropertiesVisitor)v, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v instanceof PropertiesVisitor;
    }

    @Nullable
    default public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
        return (Properties)v.defaultValue(this, p);
    }

    public String getPrefix();

    public Properties withPrefix(String var1);

    public <T extends Properties> T withMarkers(Markers var1);

    public Markers getMarkers();

    public static class Comment
    implements Content {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String message;

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitComment(this, p);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Comment;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Comment(UUID id, String prefix, Markers markers, String message) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.message = message;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public String getMessage() {
            return this.message;
        }

        @NonNull
        public String toString() {
            return "Properties.Comment(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", message=" + this.getMessage() + ")";
        }

        @Override
        @NonNull
        public Comment withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Comment(this.id, prefix, this.markers, this.message);
        }

        @NonNull
        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.prefix, markers, this.message);
        }

        @NonNull
        public Comment withMessage(String message) {
            return this.message == message ? this : new Comment(this.id, this.prefix, this.markers, message);
        }
    }

    public static class Value {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String text;

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Value;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Value(UUID id, String prefix, Markers markers, String text) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.text = text;
        }

        public UUID getId() {
            return this.id;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Markers getMarkers() {
            return this.markers;
        }

        public String getText() {
            return this.text;
        }

        @NonNull
        public String toString() {
            return "Properties.Value(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", text=" + this.getText() + ")";
        }

        @NonNull
        public Value withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Value(this.id, prefix, this.markers, this.text);
        }

        @NonNull
        public Value withMarkers(Markers markers) {
            return this.markers == markers ? this : new Value(this.id, this.prefix, markers, this.text);
        }

        @NonNull
        public Value withText(String text) {
            return this.text == text ? this : new Value(this.id, this.prefix, this.markers, text);
        }
    }

    public static class Entry
    implements Content {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final String key;
        private final String beforeEquals;
        private final Value value;

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitEntry(this, p);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public Entry(UUID id, String prefix, Markers markers, String key, String beforeEquals, Value value) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.beforeEquals = beforeEquals;
            this.value = value;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public String getKey() {
            return this.key;
        }

        public String getBeforeEquals() {
            return this.beforeEquals;
        }

        public Value getValue() {
            return this.value;
        }

        @NonNull
        public String toString() {
            return "Properties.Entry(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", key=" + this.getKey() + ", beforeEquals=" + this.getBeforeEquals() + ", value=" + this.getValue() + ")";
        }

        @Override
        @NonNull
        public Entry withPrefix(String prefix) {
            return this.prefix == prefix ? this : new Entry(this.id, prefix, this.markers, this.key, this.beforeEquals, this.value);
        }

        @NonNull
        public Entry withMarkers(Markers markers) {
            return this.markers == markers ? this : new Entry(this.id, this.prefix, markers, this.key, this.beforeEquals, this.value);
        }

        @NonNull
        public Entry withKey(String key) {
            return this.key == key ? this : new Entry(this.id, this.prefix, this.markers, key, this.beforeEquals, this.value);
        }

        @NonNull
        public Entry withBeforeEquals(String beforeEquals) {
            return this.beforeEquals == beforeEquals ? this : new Entry(this.id, this.prefix, this.markers, this.key, beforeEquals, this.value);
        }

        @NonNull
        public Entry withValue(Value value) {
            return this.value == value ? this : new Entry(this.id, this.prefix, this.markers, this.key, this.beforeEquals, value);
        }
    }

    public static interface Content
    extends Properties {
    }

    @JsonIgnoreProperties(value={"styles"})
    public static class File
    implements Properties,
    SourceFile {
        private final UUID id;
        private final String prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final List<Content> content;
        private final String eof;

        @Override
        public <P> Properties acceptProperties(PropertiesVisitor<P> v, P p) {
            return v.visitFile(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new PropertiesPrinter();
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof File)) {
                return false;
            }
            File other = (File)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof File;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        public File(UUID id, String prefix, Markers markers, Path sourcePath, List<Content> content, String eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.content = content;
            this.eof = eof;
        }

        public UUID getId() {
            return this.id;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Markers getMarkers() {
            return this.markers;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public List<Content> getContent() {
            return this.content;
        }

        public String getEof() {
            return this.eof;
        }

        @NonNull
        public String toString() {
            return "Properties.File(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", content=" + this.getContent() + ", eof=" + this.getEof() + ")";
        }

        @Override
        @NonNull
        public File withPrefix(String prefix) {
            return this.prefix == prefix ? this : new File(this.id, prefix, this.markers, this.sourcePath, this.content, this.eof);
        }

        @NonNull
        public File withMarkers(Markers markers) {
            return this.markers == markers ? this : new File(this.id, this.prefix, markers, this.sourcePath, this.content, this.eof);
        }

        @NonNull
        public File withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new File(this.id, this.prefix, this.markers, sourcePath, this.content, this.eof);
        }

        @NonNull
        public File withContent(List<Content> content) {
            return this.content == content ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, content, this.eof);
        }

        @NonNull
        public File withEof(String eof) {
            return this.eof == eof ? this : new File(this.id, this.prefix, this.markers, this.sourcePath, this.content, eof);
        }
    }
}

