/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties.internal;

import org.openrewrite.PrintOutputCapture;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public class PropertiesPrinter<P>
extends PropertiesVisitor<PrintOutputCapture<P>> {
    @Override
    public Properties visitFile(Properties.File file, PrintOutputCapture<P> p) {
        p.out.append(file.getPrefix());
        this.visitMarkers(file.getMarkers(), p);
        this.visit(file.getContent(), p);
        p.out.append(file.getEof());
        return file;
    }

    @Override
    public Properties visitEntry(Properties.Entry entry, PrintOutputCapture<P> p) {
        p.out.append(entry.getPrefix());
        this.visitMarkers(entry.getMarkers(), p);
        p.out.append(entry.getKey()).append(entry.getBeforeEquals()).append('=').append(entry.getValue().getPrefix());
        this.visitMarkers(entry.getValue().getMarkers(), p);
        p.out.append(entry.getValue().getText());
        return entry;
    }

    @Override
    public Properties visitComment(Properties.Comment comment, PrintOutputCapture<P> p) {
        p.out.append(comment.getPrefix());
        this.visitMarkers(comment.getMarkers(), p);
        p.out.append('#').append(comment.getMessage());
        return comment;
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        if (marker instanceof SearchResult) {
            String description = ((SearchResult)marker).getDescription();
            p.out.append("~~").append(description == null ? "" : "(" + description + ")~~").append(">");
        }
        return (M)marker;
    }
}

