/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.MetricsHelper;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.tree.Properties;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PropertiesParser
implements Parser<Properties.File> {
    public List<Properties.File> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public List<Properties.File> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            Properties.File file;
            block8: {
                Path path = sourceFile.getRelativePath(relativeTo);
                Timer.Builder timer = Timer.builder((String)"rewrite.parse").description("The time spent parsing a properties file").tag("file.type", "Properties");
                Timer.Sample sample = Timer.start();
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                try {
                    Properties.File file2 = this.parseFromInput(path, is).withFileAttributes(sourceFile.getFileAttributes());
                    sample.stop(MetricsHelper.successTags((Timer.Builder)timer).register((MeterRegistry)Metrics.globalRegistry));
                    parsingListener.parsed(sourceFile, (SourceFile)file2);
                    file = file2;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        sample.stop(MetricsHelper.errorTags((Timer.Builder)timer, (Throwable)t).register((MeterRegistry)Metrics.globalRegistry));
                        ParsingExecutionContextView.view((ExecutionContext)ctx).parseFailure(sourceFile, relativeTo, (Parser)this, t);
                        ctx.getOnError().accept(new IllegalStateException(sourceFile.getPath() + " " + t.getMessage(), t));
                        return null;
                    }
                }
                is.close();
            }
            return file;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Properties.File parseFromInput(Path sourceFile, EncodingDetectingInputStream source) {
        ArrayList<Properties.Content> contents = new ArrayList<Properties.Content>();
        StringBuilder prefix = new StringBuilder();
        StringBuilder buff = new StringBuilder();
        String s = source.readFully();
        char prev = '$';
        boolean isEscapedNewLine = false;
        for (char c : s.toCharArray()) {
            if (isEscapedNewLine) {
                if (Character.isWhitespace(c)) continue;
                isEscapedNewLine = false;
            }
            if (c == '\n') {
                if (prev == '\\') {
                    isEscapedNewLine = true;
                    buff.deleteCharAt(buff.length() - 1);
                } else {
                    Properties.Content content = this.extractContent(buff.toString(), prefix);
                    if (content != null) {
                        contents.add(content);
                    }
                    buff = new StringBuilder();
                    prefix.append(c);
                }
            } else {
                buff.append(c);
            }
            prev = c;
        }
        Properties.Content content = this.extractContent(buff.toString(), prefix);
        if (content != null) {
            contents.add(content);
        }
        return new Properties.File(Tree.randomId(), "", Markers.EMPTY, sourceFile, contents, prefix.toString(), source.getCharset().name(), source.isCharsetBomMarked(), FileAttributes.fromPath((Path)sourceFile), null);
    }

    @Nullable
    private Properties.Content extractContent(String line, StringBuilder prefix) {
        Properties.Content content = null;
        if (line.trim().startsWith("#") || line.trim().startsWith("!")) {
            content = this.commentFromLine(line, prefix.toString());
            prefix.delete(0, prefix.length());
        } else if (line.contains("=") || line.contains(":") || this.isDelimitedByWhitespace(line)) {
            StringBuilder trailingWhitespaceBuffer = new StringBuilder();
            content = this.entryFromLine(line, prefix.toString(), trailingWhitespaceBuffer);
            prefix.delete(0, prefix.length());
            prefix.append((CharSequence)trailingWhitespaceBuffer);
        } else {
            prefix.append(line);
        }
        return content;
    }

    private boolean isDelimitedByWhitespace(String line) {
        return line.length() >= 3 && !Character.isWhitespace(line.charAt(0)) && !Character.isWhitespace(line.length() - 1) && line.contains(" ");
    }

    private Properties.Comment commentFromLine(String line, String prefix) {
        StringBuilder prefixBuilder = new StringBuilder(prefix);
        StringBuilder message = new StringBuilder();
        boolean inComment = false;
        int state = 0;
        block5: for (char c : line.toCharArray()) {
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        prefixBuilder.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 1: {
                    if (!(c != '#' && c != '!' || inComment)) {
                        inComment = true;
                        continue block5;
                    }
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        continue block5;
                    }
                    ++state;
                }
                case 2: {
                    if (!Character.isWhitespace(c)) {
                        message.append(c);
                        --state;
                        continue block5;
                    }
                    message.append(c);
                }
            }
        }
        return new Properties.Comment(Tree.randomId(), prefixBuilder.toString(), Markers.EMPTY, message.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private Properties.Entry entryFromLine(String line, String prefix, StringBuilder trailingWhitespaceBuffer) {
        StringBuilder prefixBuilder = new StringBuilder(prefix);
        StringBuilder key = new StringBuilder();
        StringBuilder equalsPrefix = new StringBuilder();
        StringBuilder valuePrefix = new StringBuilder();
        StringBuilder value = new StringBuilder();
        char prev = '$';
        int state = 0;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block19: {
                if (n2 >= n) {
                    return new Properties.Entry(Tree.randomId(), prefixBuilder.toString(), Markers.EMPTY, key.toString(), equalsPrefix.toString(), new Properties.Value(Tree.randomId(), valuePrefix.toString(), Markers.EMPTY, value.toString()));
                }
                char c = cArray[n2];
                switch (state) {
                    case 0: {
                        if (Character.isWhitespace(c)) {
                            prefixBuilder.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 1: {
                        if (c == '=' || c == ':') {
                            if (prev == '\\') {
                                key.append(c);
                                break;
                            }
                            state += 2;
                        } else {
                            if (!Character.isWhitespace(c)) {
                                key.append(c);
                                break;
                            }
                            ++state;
                        }
                    }
                    case 2: {
                        if (Character.isWhitespace(c)) {
                            equalsPrefix.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 3: {
                        if (c == 61 || c == ':') break block19;
                        if (Character.isWhitespace(c)) {
                            valuePrefix.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 4: {
                        if (!Character.isWhitespace(c)) {
                            value.append(c);
                            break;
                        }
                        ++state;
                    }
                    case 5: {
                        if (!Character.isWhitespace(c)) {
                            value.append((CharSequence)trailingWhitespaceBuffer);
                            trailingWhitespaceBuffer.delete(0, trailingWhitespaceBuffer.length());
                            value.append(c);
                            --state;
                            break;
                        }
                        trailingWhitespaceBuffer.append(c);
                    }
                }
                prev = c;
            }
            ++n2;
        }
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".properties");
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.properties");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        public Builder() {
            super(Properties.File.class);
        }

        public PropertiesParser build() {
            return new PropertiesParser();
        }

        public String getDslName() {
            return "properties";
        }
    }
}

