/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.properties;

import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.search.FindProperties;
import org.openrewrite.properties.tree.Properties;

public final class AddProperty
extends Recipe {
    @Option(displayName="Property key", description="The property key to add.", example="management.metrics.enable.process.files")
    private final String property;
    @Option(displayName="Property value", description="The value of the new property key.")
    private final String value;
    @Option(displayName="Optional delimiter", description="Property entries support different delimiters (`=`, `:`, or whitespace). The default value is `=` unless provided the delimiter of the new property entry.", required=false, example=":")
    @Nullable
    private final String delimiter;

    public String getDisplayName() {
        return "Add a new property";
    }

    public String getDescription() {
        return "Adds a new property to a property file at the bottom of the file if it's missing. Whitespace before and after the `=` must be included in the property and value.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            @Override
            public Properties visitFile(Properties.File file, ExecutionContext executionContext) {
                Set<Properties.Entry> properties;
                Properties p = super.visitFile(file, executionContext);
                if (!StringUtils.isBlank((String)AddProperty.this.property) && !StringUtils.isBlank((String)AddProperty.this.value) && (properties = FindProperties.find(p, AddProperty.this.property, false)).isEmpty()) {
                    Properties.Value propertyValue = new Properties.Value(Tree.randomId(), "", Markers.EMPTY, AddProperty.this.value);
                    Properties.Entry.Delimiter delimitedBy = AddProperty.this.delimiter != null && !AddProperty.this.delimiter.isEmpty() ? Properties.Entry.Delimiter.getDelimiter(AddProperty.this.delimiter) : Properties.Entry.Delimiter.EQUALS;
                    String beforeEquals = delimitedBy == Properties.Entry.Delimiter.NONE ? AddProperty.this.delimiter : "";
                    Properties.Entry entry = new Properties.Entry(Tree.randomId(), "\n", Markers.EMPTY, AddProperty.this.property, beforeEquals, delimitedBy, propertyValue);
                    List contentList = ListUtils.concat(((Properties.File)p).getContent(), (Object)entry);
                    p = ((Properties.File)p).withContent(contentList);
                }
                return p;
            }
        };
    }

    public AddProperty(String property, String value, @Nullable String delimiter) {
        this.property = property;
        this.value = value;
        this.delimiter = delimiter;
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getDelimiter() {
        return this.delimiter;
    }

    @NonNull
    public String toString() {
        return "AddProperty(property=" + this.getProperty() + ", value=" + this.getValue() + ", delimiter=" + this.getDelimiter() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddProperty)) {
            return false;
        }
        AddProperty other = (AddProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$property = this.getProperty();
        String other$property = other.getProperty();
        if (this$property == null ? other$property != null : !this$property.equals(other$property)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$delimiter = this.getDelimiter();
        String other$delimiter = other.getDelimiter();
        return !(this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $property = this.getProperty();
        result = result * 59 + ($property == null ? 43 : $property.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $delimiter = this.getDelimiter();
        result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
        return result;
    }
}

