/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.remote;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.python.PythonVisitor;
import org.openrewrite.python.remote.Extensions;
import org.openrewrite.python.tree.Py;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;

public final class PythonSender
implements Sender<Py> {
    public void send(Py after, @Nullable Py before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor)visitor, (Tree)before));
        ctx.flush();
    }

    private static <T extends J> void sendContainer(JContainer<T> container, SenderContext ctx) {
        Extensions.sendContainer(container, ctx);
    }

    private static <T> void sendLeftPadded(JLeftPadded<T> leftPadded, SenderContext ctx) {
        Extensions.sendLeftPadded(leftPadded, ctx);
    }

    private static <T> void sendRightPadded(JRightPadded<T> rightPadded, SenderContext ctx) {
        Extensions.sendRightPadded(rightPadded, ctx);
    }

    private static void sendSpace(Space space, SenderContext ctx) {
        Extensions.sendSpace(space, ctx);
    }

    private static void sendComment(Comment comment, SenderContext ctx) {
        Extensions.sendComment(comment, ctx);
    }

    @Generated
    public PythonSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof PythonSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "PythonSender()";
    }

    private static class Visitor
    extends PythonVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable J visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode((Object)tree, Function.identity(), (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            this.setCursor(this.getCursor().getParent());
            return (J)tree;
        }

        public Py.Async visitAsync(Py.Async async, SenderContext ctx) {
            ctx.sendValue((Object)async, Py.Async::getId);
            ctx.sendNode((Object)async, Py.Async::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)async, Py.Async::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)async, Py.Async::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return async;
        }

        public Py.Await visitAwait(Py.Await await, SenderContext ctx) {
            ctx.sendValue((Object)await, Py.Await::getId);
            ctx.sendNode((Object)await, Py.Await::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)await, Py.Await::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)await, Py.Await::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)await, Py.Await::getType);
            return await;
        }

        public Py.Binary visitBinary(Py.Binary binary, SenderContext ctx) {
            ctx.sendValue((Object)binary, Py.Binary::getId);
            ctx.sendNode((Object)binary, Py.Binary::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)binary, Py.Binary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)binary, Py.Binary::getLeft, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)binary, e -> e.getPadding().getOperator(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)binary, Py.Binary::getNegation, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)binary, Py.Binary::getRight, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)binary, Py.Binary::getType);
            return binary;
        }

        public Py.ChainedAssignment visitChainedAssignment(Py.ChainedAssignment chainedAssignment, SenderContext ctx) {
            ctx.sendValue((Object)chainedAssignment, Py.ChainedAssignment::getId);
            ctx.sendNode((Object)chainedAssignment, Py.ChainedAssignment::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)chainedAssignment, Py.ChainedAssignment::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)chainedAssignment, e -> e.getPadding().getVariables(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            ctx.sendNode((Object)chainedAssignment, Py.ChainedAssignment::getAssignment, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)chainedAssignment, Py.ChainedAssignment::getType);
            return chainedAssignment;
        }

        public Py.ExceptionType visitExceptionType(Py.ExceptionType exceptionType, SenderContext ctx) {
            ctx.sendValue((Object)exceptionType, Py.ExceptionType::getId);
            ctx.sendNode((Object)exceptionType, Py.ExceptionType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)exceptionType, Py.ExceptionType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendTypedValue((Object)exceptionType, Py.ExceptionType::getType);
            ctx.sendValue((Object)exceptionType, Py.ExceptionType::isExceptionGroup);
            ctx.sendNode((Object)exceptionType, Py.ExceptionType::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return exceptionType;
        }

        public Py.ForLoop visitForLoop(Py.ForLoop forLoop, SenderContext ctx) {
            ctx.sendValue((Object)forLoop, Py.ForLoop::getId);
            ctx.sendNode((Object)forLoop, Py.ForLoop::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)forLoop, Py.ForLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)forLoop, Py.ForLoop::getTarget, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)forLoop, e -> e.getPadding().getIterable(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)forLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return forLoop;
        }

        public Py.LiteralType visitLiteralType(Py.LiteralType literalType, SenderContext ctx) {
            ctx.sendValue((Object)literalType, Py.LiteralType::getId);
            ctx.sendNode((Object)literalType, Py.LiteralType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)literalType, Py.LiteralType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)literalType, Py.LiteralType::getLiteral, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)literalType, Py.LiteralType::getType);
            return literalType;
        }

        public Py.TypeHint visitTypeHint(Py.TypeHint typeHint, SenderContext ctx) {
            ctx.sendValue((Object)typeHint, Py.TypeHint::getId);
            ctx.sendNode((Object)typeHint, Py.TypeHint::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeHint, Py.TypeHint::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeHint, Py.TypeHint::getTypeTree, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)typeHint, Py.TypeHint::getType);
            return typeHint;
        }

        public Py.CompilationUnit visitCompilationUnit(Py.CompilationUnit compilationUnit, SenderContext ctx) {
            ctx.sendValue((Object)compilationUnit, Py.CompilationUnit::getId);
            ctx.sendNode((Object)compilationUnit, Py.CompilationUnit::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)compilationUnit, Py.CompilationUnit::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)compilationUnit, Py.CompilationUnit::getSourcePath);
            ctx.sendTypedValue((Object)compilationUnit, Py.CompilationUnit::getFileAttributes);
            ctx.sendValue((Object)compilationUnit, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue((Object)compilationUnit, Py.CompilationUnit::isCharsetBomMarked);
            ctx.sendTypedValue((Object)compilationUnit, Py.CompilationUnit::getChecksum);
            ctx.sendNodes((Object)compilationUnit, e -> e.getPadding().getImports(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((J.Import)e.getElement()).getId());
            ctx.sendNodes((Object)compilationUnit, e -> e.getPadding().getStatements(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)compilationUnit, Py.CompilationUnit::getEof, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            return compilationUnit;
        }

        public Py.ExpressionStatement visitExpressionStatement(Py.ExpressionStatement expressionStatement, SenderContext ctx) {
            ctx.sendValue((Object)expressionStatement, Py.ExpressionStatement::getId);
            ctx.sendNode((Object)expressionStatement, Py.ExpressionStatement::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return expressionStatement;
        }

        public Py.ExpressionTypeTree visitExpressionTypeTree(Py.ExpressionTypeTree expressionTypeTree, SenderContext ctx) {
            ctx.sendValue((Object)expressionTypeTree, Py.ExpressionTypeTree::getId);
            ctx.sendNode((Object)expressionTypeTree, Py.ExpressionTypeTree::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)expressionTypeTree, Py.ExpressionTypeTree::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)expressionTypeTree, Py.ExpressionTypeTree::getReference, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return expressionTypeTree;
        }

        public Py.StatementExpression visitStatementExpression(Py.StatementExpression statementExpression, SenderContext ctx) {
            ctx.sendValue((Object)statementExpression, Py.StatementExpression::getId);
            ctx.sendNode((Object)statementExpression, Py.StatementExpression::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return statementExpression;
        }

        public Py.MultiImport visitMultiImport(Py.MultiImport multiImport, SenderContext ctx) {
            ctx.sendValue((Object)multiImport, Py.MultiImport::getId);
            ctx.sendNode((Object)multiImport, Py.MultiImport::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)multiImport, Py.MultiImport::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)multiImport, e -> e.getPadding().getFrom(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendValue((Object)multiImport, Py.MultiImport::isParenthesized);
            ctx.sendNode((Object)multiImport, e -> e.getPadding().getNames(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            return multiImport;
        }

        public Py.KeyValue visitKeyValue(Py.KeyValue keyValue, SenderContext ctx) {
            ctx.sendValue((Object)keyValue, Py.KeyValue::getId);
            ctx.sendNode((Object)keyValue, Py.KeyValue::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)keyValue, Py.KeyValue::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)keyValue, e -> e.getPadding().getKey(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)keyValue, Py.KeyValue::getValue, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)keyValue, Py.KeyValue::getType);
            return keyValue;
        }

        public Py.DictLiteral visitDictLiteral(Py.DictLiteral dictLiteral, SenderContext ctx) {
            ctx.sendValue((Object)dictLiteral, Py.DictLiteral::getId);
            ctx.sendNode((Object)dictLiteral, Py.DictLiteral::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)dictLiteral, Py.DictLiteral::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)dictLiteral, e -> e.getPadding().getElements(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)dictLiteral, Py.DictLiteral::getType);
            return dictLiteral;
        }

        public Py.CollectionLiteral visitCollectionLiteral(Py.CollectionLiteral collectionLiteral, SenderContext ctx) {
            ctx.sendValue((Object)collectionLiteral, Py.CollectionLiteral::getId);
            ctx.sendNode((Object)collectionLiteral, Py.CollectionLiteral::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)collectionLiteral, Py.CollectionLiteral::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)collectionLiteral, Py.CollectionLiteral::getKind);
            ctx.sendNode((Object)collectionLiteral, e -> e.getPadding().getElements(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)collectionLiteral, Py.CollectionLiteral::getType);
            return collectionLiteral;
        }

        public Py.FormattedString visitFormattedString(Py.FormattedString formattedString, SenderContext ctx) {
            ctx.sendValue((Object)formattedString, Py.FormattedString::getId);
            ctx.sendNode((Object)formattedString, Py.FormattedString::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)formattedString, Py.FormattedString::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)formattedString, Py.FormattedString::getDelimiter);
            ctx.sendNodes((Object)formattedString, Py.FormattedString::getParts, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return formattedString;
        }

        public Py.FormattedString.Value visitFormattedStringValue(Py.FormattedString.Value value, SenderContext ctx) {
            ctx.sendValue((Object)value, Py.FormattedString.Value::getId);
            ctx.sendNode((Object)value, Py.FormattedString.Value::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)value, Py.FormattedString.Value::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)value, e -> e.getPadding().getExpression(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)value, e -> e.getPadding().getDebug(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendValue((Object)value, Py.FormattedString.Value::getConversion);
            ctx.sendNode((Object)value, Py.FormattedString.Value::getFormat, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return value;
        }

        public Py.Pass visitPass(Py.Pass pass, SenderContext ctx) {
            ctx.sendValue((Object)pass, Py.Pass::getId);
            ctx.sendNode((Object)pass, Py.Pass::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)pass, Py.Pass::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return pass;
        }

        public Py.TrailingElseWrapper visitTrailingElseWrapper(Py.TrailingElseWrapper trailingElseWrapper, SenderContext ctx) {
            ctx.sendValue((Object)trailingElseWrapper, Py.TrailingElseWrapper::getId);
            ctx.sendNode((Object)trailingElseWrapper, Py.TrailingElseWrapper::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)trailingElseWrapper, Py.TrailingElseWrapper::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)trailingElseWrapper, Py.TrailingElseWrapper::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)trailingElseWrapper, e -> e.getPadding().getElseBlock(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            return trailingElseWrapper;
        }

        public Py.ComprehensionExpression visitComprehensionExpression(Py.ComprehensionExpression comprehensionExpression, SenderContext ctx) {
            ctx.sendValue((Object)comprehensionExpression, Py.ComprehensionExpression::getId);
            ctx.sendNode((Object)comprehensionExpression, Py.ComprehensionExpression::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)comprehensionExpression, Py.ComprehensionExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)comprehensionExpression, Py.ComprehensionExpression::getKind);
            ctx.sendNode((Object)comprehensionExpression, Py.ComprehensionExpression::getResult, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)comprehensionExpression, Py.ComprehensionExpression::getClauses, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)comprehensionExpression, Py.ComprehensionExpression::getSuffix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendTypedValue((Object)comprehensionExpression, Py.ComprehensionExpression::getType);
            return comprehensionExpression;
        }

        public Py.ComprehensionExpression.Condition visitComprehensionCondition(Py.ComprehensionExpression.Condition condition, SenderContext ctx) {
            ctx.sendValue((Object)condition, Py.ComprehensionExpression.Condition::getId);
            ctx.sendNode((Object)condition, Py.ComprehensionExpression.Condition::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)condition, Py.ComprehensionExpression.Condition::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)condition, Py.ComprehensionExpression.Condition::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return condition;
        }

        public Py.ComprehensionExpression.Clause visitComprehensionClause(Py.ComprehensionExpression.Clause clause, SenderContext ctx) {
            ctx.sendValue((Object)clause, Py.ComprehensionExpression.Clause::getId);
            ctx.sendNode((Object)clause, Py.ComprehensionExpression.Clause::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)clause, Py.ComprehensionExpression.Clause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)clause, e -> e.getPadding().getAsync(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)clause, Py.ComprehensionExpression.Clause::getIteratorVariable, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)clause, e -> e.getPadding().getIteratedList(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNodes((Object)clause, Py.ComprehensionExpression.Clause::getConditions, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return clause;
        }

        public Py.TypeAlias visitTypeAlias(Py.TypeAlias typeAlias, SenderContext ctx) {
            ctx.sendValue((Object)typeAlias, Py.TypeAlias::getId);
            ctx.sendNode((Object)typeAlias, Py.TypeAlias::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeAlias, Py.TypeAlias::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeAlias, Py.TypeAlias::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typeAlias, e -> e.getPadding().getValue(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)typeAlias, Py.TypeAlias::getType);
            return typeAlias;
        }

        public Py.YieldFrom visitYieldFrom(Py.YieldFrom yieldFrom, SenderContext ctx) {
            ctx.sendValue((Object)yieldFrom, Py.YieldFrom::getId);
            ctx.sendNode((Object)yieldFrom, Py.YieldFrom::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)yieldFrom, Py.YieldFrom::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)yieldFrom, Py.YieldFrom::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)yieldFrom, Py.YieldFrom::getType);
            return yieldFrom;
        }

        public Py.UnionType visitUnionType(Py.UnionType unionType, SenderContext ctx) {
            ctx.sendValue((Object)unionType, Py.UnionType::getId);
            ctx.sendNode((Object)unionType, Py.UnionType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unionType, Py.UnionType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)unionType, e -> e.getPadding().getTypes(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            ctx.sendTypedValue((Object)unionType, Py.UnionType::getType);
            return unionType;
        }

        public Py.VariableScope visitVariableScope(Py.VariableScope variableScope, SenderContext ctx) {
            ctx.sendValue((Object)variableScope, Py.VariableScope::getId);
            ctx.sendNode((Object)variableScope, Py.VariableScope::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)variableScope, Py.VariableScope::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)variableScope, Py.VariableScope::getKind);
            ctx.sendNodes((Object)variableScope, e -> e.getPadding().getNames(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((J.Identifier)e.getElement()).getId());
            return variableScope;
        }

        public Py.Del visitDel(Py.Del del, SenderContext ctx) {
            ctx.sendValue((Object)del, Py.Del::getId);
            ctx.sendNode((Object)del, Py.Del::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)del, Py.Del::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)del, e -> e.getPadding().getTargets(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            return del;
        }

        public Py.SpecialParameter visitSpecialParameter(Py.SpecialParameter specialParameter, SenderContext ctx) {
            ctx.sendValue((Object)specialParameter, Py.SpecialParameter::getId);
            ctx.sendNode((Object)specialParameter, Py.SpecialParameter::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)specialParameter, Py.SpecialParameter::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)specialParameter, Py.SpecialParameter::getKind);
            ctx.sendNode((Object)specialParameter, Py.SpecialParameter::getTypeHint, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)specialParameter, Py.SpecialParameter::getType);
            return specialParameter;
        }

        public Py.Star visitStar(Py.Star star, SenderContext ctx) {
            ctx.sendValue((Object)star, Py.Star::getId);
            ctx.sendNode((Object)star, Py.Star::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)star, Py.Star::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)star, Py.Star::getKind);
            ctx.sendNode((Object)star, Py.Star::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)star, Py.Star::getType);
            return star;
        }

        public Py.NamedArgument visitNamedArgument(Py.NamedArgument namedArgument, SenderContext ctx) {
            ctx.sendValue((Object)namedArgument, Py.NamedArgument::getId);
            ctx.sendNode((Object)namedArgument, Py.NamedArgument::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)namedArgument, Py.NamedArgument::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)namedArgument, Py.NamedArgument::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)namedArgument, e -> e.getPadding().getValue(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)namedArgument, Py.NamedArgument::getType);
            return namedArgument;
        }

        public Py.TypeHintedExpression visitTypeHintedExpression(Py.TypeHintedExpression typeHintedExpression, SenderContext ctx) {
            ctx.sendValue((Object)typeHintedExpression, Py.TypeHintedExpression::getId);
            ctx.sendNode((Object)typeHintedExpression, Py.TypeHintedExpression::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeHintedExpression, Py.TypeHintedExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeHintedExpression, Py.TypeHintedExpression::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typeHintedExpression, Py.TypeHintedExpression::getTypeHint, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)typeHintedExpression, Py.TypeHintedExpression::getType);
            return typeHintedExpression;
        }

        public Py.ErrorFrom visitErrorFrom(Py.ErrorFrom errorFrom, SenderContext ctx) {
            ctx.sendValue((Object)errorFrom, Py.ErrorFrom::getId);
            ctx.sendNode((Object)errorFrom, Py.ErrorFrom::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)errorFrom, Py.ErrorFrom::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)errorFrom, Py.ErrorFrom::getError, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)errorFrom, e -> e.getPadding().getFrom(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)errorFrom, Py.ErrorFrom::getType);
            return errorFrom;
        }

        public Py.MatchCase visitMatchCase(Py.MatchCase matchCase, SenderContext ctx) {
            ctx.sendValue((Object)matchCase, Py.MatchCase::getId);
            ctx.sendNode((Object)matchCase, Py.MatchCase::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)matchCase, Py.MatchCase::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)matchCase, Py.MatchCase::getPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)matchCase, e -> e.getPadding().getGuard(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)matchCase, Py.MatchCase::getType);
            return matchCase;
        }

        public Py.MatchCase.Pattern visitMatchCasePattern(Py.MatchCase.Pattern pattern, SenderContext ctx) {
            ctx.sendValue((Object)pattern, Py.MatchCase.Pattern::getId);
            ctx.sendNode((Object)pattern, Py.MatchCase.Pattern::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)pattern, Py.MatchCase.Pattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)pattern, Py.MatchCase.Pattern::getKind);
            ctx.sendNode((Object)pattern, e -> e.getPadding().getChildren(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)pattern, Py.MatchCase.Pattern::getType);
            return pattern;
        }

        public Py.Slice visitSlice(Py.Slice slice, SenderContext ctx) {
            ctx.sendValue((Object)slice, Py.Slice::getId);
            ctx.sendNode((Object)slice, Py.Slice::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)slice, Py.Slice::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)slice, e -> e.getPadding().getStart(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)slice, e -> e.getPadding().getStop(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)slice, e -> e.getPadding().getStep(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return slice;
        }

        public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, SenderContext ctx) {
            ctx.sendValue((Object)annotatedType, J.AnnotatedType::getId);
            ctx.sendNode((Object)annotatedType, J.AnnotatedType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)annotatedType, J.AnnotatedType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)annotatedType, J.AnnotatedType::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)annotatedType, J.AnnotatedType::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return annotatedType;
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, SenderContext ctx) {
            ctx.sendValue((Object)annotation, J.Annotation::getId);
            ctx.sendNode((Object)annotation, J.Annotation::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)annotation, J.Annotation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)annotation, J.Annotation::getAnnotationType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)annotation, e -> e.getPadding().getArguments(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            return annotation;
        }

        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, SenderContext ctx) {
            ctx.sendValue((Object)arrayAccess, J.ArrayAccess::getId);
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getIndexed, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getDimension, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)arrayAccess, J.ArrayAccess::getType);
            return arrayAccess;
        }

        public J.ArrayType visitArrayType(J.ArrayType arrayType, SenderContext ctx) {
            ctx.sendValue((Object)arrayType, J.ArrayType::getId);
            ctx.sendNode((Object)arrayType, J.ArrayType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayType, J.ArrayType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayType, J.ArrayType::getElementType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)arrayType, J.ArrayType::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)arrayType, J.ArrayType::getDimension, (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)arrayType, J.ArrayType::getType);
            return arrayType;
        }

        public J.Assert visitAssert(J.Assert assert_, SenderContext ctx) {
            ctx.sendValue((Object)assert_, J.Assert::getId);
            ctx.sendNode((Object)assert_, J.Assert::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assert_, J.Assert::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assert_, J.Assert::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assert_, J.Assert::getDetail, (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            return assert_;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, SenderContext ctx) {
            ctx.sendValue((Object)assignment, J.Assignment::getId);
            ctx.sendNode((Object)assignment, J.Assignment::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assignment, J.Assignment::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assignment, J.Assignment::getVariable, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assignment, e -> e.getPadding().getAssignment(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)assignment, J.Assignment::getType);
            return assignment;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignmentOperation, SenderContext ctx) {
            ctx.sendValue((Object)assignmentOperation, J.AssignmentOperation::getId);
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getVariable, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assignmentOperation, e -> e.getPadding().getOperator(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getAssignment, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)assignmentOperation, J.AssignmentOperation::getType);
            return assignmentOperation;
        }

        public J.Binary visitBinary(J.Binary binary, SenderContext ctx) {
            ctx.sendValue((Object)binary, J.Binary::getId);
            ctx.sendNode((Object)binary, J.Binary::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)binary, J.Binary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)binary, J.Binary::getLeft, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)binary, e -> e.getPadding().getOperator(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)binary, J.Binary::getRight, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)binary, J.Binary::getType);
            return binary;
        }

        public J.Block visitBlock(J.Block block, SenderContext ctx) {
            ctx.sendValue((Object)block, J.Block::getId);
            ctx.sendNode((Object)block, J.Block::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)block, J.Block::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)block, e -> e.getPadding().getStatic(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)block, e -> e.getPadding().getStatements(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)block, J.Block::getEnd, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            return block;
        }

        public J.Break visitBreak(J.Break break_, SenderContext ctx) {
            ctx.sendValue((Object)break_, J.Break::getId);
            ctx.sendNode((Object)break_, J.Break::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)break_, J.Break::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)break_, J.Break::getLabel, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return break_;
        }

        public J.Case visitCase(J.Case case_, SenderContext ctx) {
            ctx.sendValue((Object)case_, J.Case::getId);
            ctx.sendNode((Object)case_, J.Case::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)case_, J.Case::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)case_, J.Case::getType);
            ctx.sendNode((Object)case_, e -> e.getPadding().getExpressions(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)case_, e -> e.getPadding().getStatements(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)case_, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return case_;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)classDeclaration, J.ClassDeclaration::getId);
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)classDeclaration, J.ClassDeclaration::getLeadingAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)classDeclaration, J.ClassDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getKind(), this::sendClassDeclarationKind);
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getPrimaryConstructor(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getExtends(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getImplements(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getPermits(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)classDeclaration, J.ClassDeclaration::getType);
            return classDeclaration;
        }

        private void sendClassDeclarationKind(J.ClassDeclaration.Kind kind, SenderContext ctx) {
            ctx.sendValue((Object)kind, J.ClassDeclaration.Kind::getId);
            ctx.sendNode((Object)kind, J.ClassDeclaration.Kind::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)kind, J.ClassDeclaration.Kind::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)kind, J.ClassDeclaration.Kind::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendValue((Object)kind, J.ClassDeclaration.Kind::getType);
        }

        public J.Continue visitContinue(J.Continue continue_, SenderContext ctx) {
            ctx.sendValue((Object)continue_, J.Continue::getId);
            ctx.sendNode((Object)continue_, J.Continue::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)continue_, J.Continue::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)continue_, J.Continue::getLabel, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return continue_;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SenderContext ctx) {
            ctx.sendValue((Object)doWhileLoop, J.DoWhileLoop::getId);
            ctx.sendNode((Object)doWhileLoop, J.DoWhileLoop::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)doWhileLoop, J.DoWhileLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)doWhileLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)doWhileLoop, e -> e.getPadding().getWhileCondition(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            return doWhileLoop;
        }

        public J.Empty visitEmpty(J.Empty empty, SenderContext ctx) {
            ctx.sendValue((Object)empty, J.Empty::getId);
            ctx.sendNode((Object)empty, J.Empty::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)empty, J.Empty::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return empty;
        }

        public J.EnumValue visitEnumValue(J.EnumValue enumValue, SenderContext ctx) {
            ctx.sendValue((Object)enumValue, J.EnumValue::getId);
            ctx.sendNode((Object)enumValue, J.EnumValue::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)enumValue, J.EnumValue::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)enumValue, J.EnumValue::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)enumValue, J.EnumValue::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)enumValue, J.EnumValue::getInitializer, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return enumValue;
        }

        public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enumValueSet, SenderContext ctx) {
            ctx.sendValue((Object)enumValueSet, J.EnumValueSet::getId);
            ctx.sendNode((Object)enumValueSet, J.EnumValueSet::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)enumValueSet, J.EnumValueSet::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)enumValueSet, e -> e.getPadding().getEnums(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((J.EnumValue)e.getElement()).getId());
            ctx.sendValue((Object)enumValueSet, J.EnumValueSet::isTerminatedWithSemicolon);
            return enumValueSet;
        }

        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, SenderContext ctx) {
            ctx.sendValue((Object)fieldAccess, J.FieldAccess::getId);
            ctx.sendNode((Object)fieldAccess, J.FieldAccess::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)fieldAccess, J.FieldAccess::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)fieldAccess, J.FieldAccess::getTarget, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)fieldAccess, e -> e.getPadding().getName(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)fieldAccess, J.FieldAccess::getType);
            return fieldAccess;
        }

        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, SenderContext ctx) {
            ctx.sendValue((Object)forEachLoop, J.ForEachLoop::getId);
            ctx.sendNode((Object)forEachLoop, J.ForEachLoop::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)forEachLoop, J.ForEachLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)forEachLoop, J.ForEachLoop::getControl, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)forEachLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return forEachLoop;
        }

        public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, SenderContext ctx) {
            ctx.sendValue((Object)control, J.ForEachLoop.Control::getId);
            ctx.sendNode((Object)control, J.ForEachLoop.Control::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)control, J.ForEachLoop.Control::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)control, e -> e.getPadding().getVariable(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)control, e -> e.getPadding().getIterable(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return control;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, SenderContext ctx) {
            ctx.sendValue((Object)forLoop, J.ForLoop::getId);
            ctx.sendNode((Object)forLoop, J.ForLoop::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)forLoop, J.ForLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)forLoop, J.ForLoop::getControl, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)forLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return forLoop;
        }

        public J.ForLoop.Control visitForControl(J.ForLoop.Control control, SenderContext ctx) {
            ctx.sendValue((Object)control, J.ForLoop.Control::getId);
            ctx.sendNode((Object)control, J.ForLoop.Control::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)control, J.ForLoop.Control::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)control, e -> e.getPadding().getInit(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)control, e -> e.getPadding().getCondition(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)control, e -> e.getPadding().getUpdate(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            return control;
        }

        public J.ParenthesizedTypeTree visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedTypeTree, SenderContext ctx) {
            ctx.sendValue((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getId);
            ctx.sendNode((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getParenthesizedType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return parenthesizedTypeTree;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, SenderContext ctx) {
            ctx.sendValue((Object)identifier, J.Identifier::getId);
            ctx.sendNode((Object)identifier, J.Identifier::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)identifier, J.Identifier::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)identifier, J.Identifier::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendValue((Object)identifier, J.Identifier::getSimpleName);
            ctx.sendTypedValue((Object)identifier, J.Identifier::getType);
            ctx.sendTypedValue((Object)identifier, J.Identifier::getFieldType);
            return identifier;
        }

        public J.If visitIf(J.If if_, SenderContext ctx) {
            ctx.sendValue((Object)if_, J.If::getId);
            ctx.sendNode((Object)if_, J.If::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)if_, J.If::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)if_, J.If::getIfCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)if_, e -> e.getPadding().getThenPart(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)if_, J.If::getElsePart, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return if_;
        }

        public J.If.Else visitElse(J.If.Else else_, SenderContext ctx) {
            ctx.sendValue((Object)else_, J.If.Else::getId);
            ctx.sendNode((Object)else_, J.If.Else::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)else_, J.If.Else::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)else_, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return else_;
        }

        public J.Import visitImport(J.Import import_, SenderContext ctx) {
            ctx.sendValue((Object)import_, J.Import::getId);
            ctx.sendNode((Object)import_, J.Import::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)import_, J.Import::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)import_, e -> e.getPadding().getStatic(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)import_, J.Import::getQualid, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)import_, e -> e.getPadding().getAlias(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            return import_;
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, SenderContext ctx) {
            ctx.sendValue((Object)instanceOf, J.InstanceOf::getId);
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)instanceOf, e -> e.getPadding().getExpression(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)instanceOf, J.InstanceOf::getType);
            return instanceOf;
        }

        public J.IntersectionType visitIntersectionType(J.IntersectionType intersectionType, SenderContext ctx) {
            ctx.sendValue((Object)intersectionType, J.IntersectionType::getId);
            ctx.sendNode((Object)intersectionType, J.IntersectionType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)intersectionType, J.IntersectionType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)intersectionType, e -> e.getPadding().getBounds(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            return intersectionType;
        }

        public J.Label visitLabel(J.Label label, SenderContext ctx) {
            ctx.sendValue((Object)label, J.Label::getId);
            ctx.sendNode((Object)label, J.Label::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)label, J.Label::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)label, e -> e.getPadding().getLabel(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)label, J.Label::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return label;
        }

        public J.Lambda visitLambda(J.Lambda lambda, SenderContext ctx) {
            ctx.sendValue((Object)lambda, J.Lambda::getId);
            ctx.sendNode((Object)lambda, J.Lambda::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)lambda, J.Lambda::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)lambda, J.Lambda::getParameters, this::sendLambdaParameters);
            ctx.sendNode((Object)lambda, J.Lambda::getArrow, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)lambda, J.Lambda::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)lambda, J.Lambda::getType);
            return lambda;
        }

        private void sendLambdaParameters(J.Lambda.Parameters parameters, SenderContext ctx) {
            ctx.sendValue((Object)parameters, J.Lambda.Parameters::getId);
            ctx.sendNode((Object)parameters, J.Lambda.Parameters::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parameters, J.Lambda.Parameters::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)parameters, J.Lambda.Parameters::isParenthesized);
            ctx.sendNodes((Object)parameters, e -> e.getPadding().getParameters(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((J)e.getElement()).getId());
        }

        public J.Literal visitLiteral(J.Literal literal, SenderContext ctx) {
            ctx.sendValue((Object)literal, J.Literal::getId);
            ctx.sendNode((Object)literal, J.Literal::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)literal, J.Literal::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendTypedValue((Object)literal, J.Literal::getValue);
            ctx.sendValue((Object)literal, J.Literal::getValueSource);
            ctx.sendValues((Object)literal, J.Literal::getUnicodeEscapes, Function.identity());
            ctx.sendValue((Object)literal, J.Literal::getType);
            return literal;
        }

        public J.MemberReference visitMemberReference(J.MemberReference memberReference, SenderContext ctx) {
            ctx.sendValue((Object)memberReference, J.MemberReference::getId);
            ctx.sendNode((Object)memberReference, J.MemberReference::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)memberReference, J.MemberReference::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)memberReference, e -> e.getPadding().getContaining(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)memberReference, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)memberReference, e -> e.getPadding().getReference(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)memberReference, J.MemberReference::getType);
            ctx.sendTypedValue((Object)memberReference, J.MemberReference::getMethodType);
            ctx.sendTypedValue((Object)memberReference, J.MemberReference::getVariableType);
            return memberReference;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)methodDeclaration, J.MethodDeclaration::getId);
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)methodDeclaration, J.MethodDeclaration::getLeadingAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)methodDeclaration, J.MethodDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)methodDeclaration, e -> e.getAnnotations().getTypeParameters(), this::sendMethodTypeParameters);
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getReturnTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getAnnotations().getName(), this::sendMethodIdentifierWithAnnotations);
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getThrows(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getDefaultValue(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)methodDeclaration, J.MethodDeclaration::getMethodType);
            return methodDeclaration;
        }

        private void sendMethodIdentifierWithAnnotations(J.MethodDeclaration.IdentifierWithAnnotations identifierWithAnnotations, SenderContext ctx) {
            ctx.sendNode((Object)identifierWithAnnotations, J.MethodDeclaration.IdentifierWithAnnotations::getIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)identifierWithAnnotations, J.MethodDeclaration.IdentifierWithAnnotations::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, SenderContext ctx) {
            ctx.sendValue((Object)methodInvocation, J.MethodInvocation::getId);
            ctx.sendNode((Object)methodInvocation, J.MethodInvocation::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)methodInvocation, J.MethodInvocation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)methodInvocation, e -> e.getPadding().getSelect(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)methodInvocation, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodInvocation, J.MethodInvocation::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodInvocation, e -> e.getPadding().getArguments(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)methodInvocation, J.MethodInvocation::getMethodType);
            return methodInvocation;
        }

        public J.Modifier visitModifier(J.Modifier modifier, SenderContext ctx) {
            ctx.sendValue((Object)modifier, J.Modifier::getId);
            ctx.sendNode((Object)modifier, J.Modifier::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)modifier, J.Modifier::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)modifier, J.Modifier::getKeyword);
            ctx.sendValue((Object)modifier, J.Modifier::getType);
            ctx.sendNodes((Object)modifier, J.Modifier::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return modifier;
        }

        public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, SenderContext ctx) {
            ctx.sendValue((Object)multiCatch, J.MultiCatch::getId);
            ctx.sendNode((Object)multiCatch, J.MultiCatch::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)multiCatch, J.MultiCatch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)multiCatch, e -> e.getPadding().getAlternatives(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((NameTree)e.getElement()).getId());
            return multiCatch;
        }

        public J.NewArray visitNewArray(J.NewArray newArray, SenderContext ctx) {
            ctx.sendValue((Object)newArray, J.NewArray::getId);
            ctx.sendNode((Object)newArray, J.NewArray::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newArray, J.NewArray::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)newArray, J.NewArray::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)newArray, J.NewArray::getDimensions, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)newArray, e -> e.getPadding().getInitializer(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)newArray, J.NewArray::getType);
            return newArray;
        }

        public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, SenderContext ctx) {
            ctx.sendValue((Object)arrayDimension, J.ArrayDimension::getId);
            ctx.sendNode((Object)arrayDimension, J.ArrayDimension::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayDimension, J.ArrayDimension::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayDimension, e -> e.getPadding().getIndex(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return arrayDimension;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, SenderContext ctx) {
            ctx.sendValue((Object)newClass, J.NewClass::getId);
            ctx.sendNode((Object)newClass, J.NewClass::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)newClass, e -> e.getPadding().getEnclosing(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getNew, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)newClass, e -> e.getPadding().getArguments(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)newClass, J.NewClass::getConstructorType);
            return newClass;
        }

        public J.NullableType visitNullableType(J.NullableType nullableType, SenderContext ctx) {
            ctx.sendValue((Object)nullableType, J.NullableType::getId);
            ctx.sendNode((Object)nullableType, J.NullableType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)nullableType, J.NullableType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)nullableType, J.NullableType::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)nullableType, e -> e.getPadding().getTypeTree(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return nullableType;
        }

        public J.Package visitPackage(J.Package package_, SenderContext ctx) {
            ctx.sendValue((Object)package_, J.Package::getId);
            ctx.sendNode((Object)package_, J.Package::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)package_, J.Package::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)package_, J.Package::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)package_, J.Package::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return package_;
        }

        public J.ParameterizedType visitParameterizedType(J.ParameterizedType parameterizedType, SenderContext ctx) {
            ctx.sendValue((Object)parameterizedType, J.ParameterizedType::getId);
            ctx.sendNode((Object)parameterizedType, J.ParameterizedType::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parameterizedType, J.ParameterizedType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)parameterizedType, J.ParameterizedType::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)parameterizedType, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)parameterizedType, J.ParameterizedType::getType);
            return parameterizedType;
        }

        public <J2 extends J> J.Parentheses<J2> visitParentheses(J.Parentheses<J2> parentheses, SenderContext ctx) {
            ctx.sendValue(parentheses, J.Parentheses::getId);
            ctx.sendNode(parentheses, J.Parentheses::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode(parentheses, J.Parentheses::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode(parentheses, e -> e.getPadding().getTree(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return parentheses;
        }

        public <J2 extends J> J.ControlParentheses<J2> visitControlParentheses(J.ControlParentheses<J2> controlParentheses, SenderContext ctx) {
            ctx.sendValue(controlParentheses, J.ControlParentheses::getId);
            ctx.sendNode(controlParentheses, J.ControlParentheses::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode(controlParentheses, J.ControlParentheses::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode(controlParentheses, e -> e.getPadding().getTree(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return controlParentheses;
        }

        public J.Primitive visitPrimitive(J.Primitive primitive, SenderContext ctx) {
            ctx.sendValue((Object)primitive, J.Primitive::getId);
            ctx.sendNode((Object)primitive, J.Primitive::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)primitive, J.Primitive::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)primitive, J.Primitive::getType);
            return primitive;
        }

        public J.Return visitReturn(J.Return return_, SenderContext ctx) {
            ctx.sendValue((Object)return_, J.Return::getId);
            ctx.sendNode((Object)return_, J.Return::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)return_, J.Return::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)return_, J.Return::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return return_;
        }

        public J.Switch visitSwitch(J.Switch switch_, SenderContext ctx) {
            ctx.sendValue((Object)switch_, J.Switch::getId);
            ctx.sendNode((Object)switch_, J.Switch::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switch_, J.Switch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switch_, J.Switch::getSelector, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)switch_, J.Switch::getCases, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return switch_;
        }

        public J.SwitchExpression visitSwitchExpression(J.SwitchExpression switchExpression, SenderContext ctx) {
            ctx.sendValue((Object)switchExpression, J.SwitchExpression::getId);
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getSelector, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getCases, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return switchExpression;
        }

        public J.Synchronized visitSynchronized(J.Synchronized synchronized_, SenderContext ctx) {
            ctx.sendValue((Object)synchronized_, J.Synchronized::getId);
            ctx.sendNode((Object)synchronized_, J.Synchronized::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)synchronized_, J.Synchronized::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)synchronized_, J.Synchronized::getLock, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)synchronized_, J.Synchronized::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return synchronized_;
        }

        public J.Ternary visitTernary(J.Ternary ternary, SenderContext ctx) {
            ctx.sendValue((Object)ternary, J.Ternary::getId);
            ctx.sendNode((Object)ternary, J.Ternary::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)ternary, J.Ternary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)ternary, J.Ternary::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)ternary, e -> e.getPadding().getTruePart(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)ternary, e -> e.getPadding().getFalsePart(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)ternary, J.Ternary::getType);
            return ternary;
        }

        public J.Throw visitThrow(J.Throw throw_, SenderContext ctx) {
            ctx.sendValue((Object)throw_, J.Throw::getId);
            ctx.sendNode((Object)throw_, J.Throw::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)throw_, J.Throw::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)throw_, J.Throw::getException, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return throw_;
        }

        public J.Try visitTry(J.Try try_, SenderContext ctx) {
            ctx.sendValue((Object)try_, J.Try::getId);
            ctx.sendNode((Object)try_, J.Try::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)try_, J.Try::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)try_, e -> e.getPadding().getResources(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)try_, J.Try::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)try_, J.Try::getCatches, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)try_, e -> e.getPadding().getFinally(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            return try_;
        }

        public J.Try.Resource visitTryResource(J.Try.Resource resource, SenderContext ctx) {
            ctx.sendValue((Object)resource, J.Try.Resource::getId);
            ctx.sendNode((Object)resource, J.Try.Resource::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)resource, J.Try.Resource::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)resource, J.Try.Resource::getVariableDeclarations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendValue((Object)resource, J.Try.Resource::isTerminatedWithSemicolon);
            return resource;
        }

        public J.Try.Catch visitCatch(J.Try.Catch catch_, SenderContext ctx) {
            ctx.sendValue((Object)catch_, J.Try.Catch::getId);
            ctx.sendNode((Object)catch_, J.Try.Catch::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)catch_, J.Try.Catch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)catch_, J.Try.Catch::getParameter, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)catch_, J.Try.Catch::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return catch_;
        }

        public J.TypeCast visitTypeCast(J.TypeCast typeCast, SenderContext ctx) {
            ctx.sendValue((Object)typeCast, J.TypeCast::getId);
            ctx.sendNode((Object)typeCast, J.TypeCast::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeCast, J.TypeCast::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeCast, J.TypeCast::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typeCast, J.TypeCast::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return typeCast;
        }

        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParameter, SenderContext ctx) {
            ctx.sendValue((Object)typeParameter, J.TypeParameter::getId);
            ctx.sendNode((Object)typeParameter, J.TypeParameter::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeParameter, J.TypeParameter::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)typeParameter, J.TypeParameter::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)typeParameter, J.TypeParameter::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)typeParameter, J.TypeParameter::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typeParameter, e -> e.getPadding().getBounds(), (x$0, x$1) -> PythonSender.sendContainer(x$0, x$1));
            return typeParameter;
        }

        private void sendMethodTypeParameters(J.TypeParameters typeParameters, SenderContext ctx) {
            ctx.sendValue((Object)typeParameters, J.TypeParameters::getId);
            ctx.sendNode((Object)typeParameters, J.TypeParameters::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeParameters, J.TypeParameters::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)typeParameters, J.TypeParameters::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)typeParameters, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((J.TypeParameter)e.getElement()).getId());
        }

        public J.Unary visitUnary(J.Unary unary, SenderContext ctx) {
            ctx.sendValue((Object)unary, J.Unary::getId);
            ctx.sendNode((Object)unary, J.Unary::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unary, J.Unary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unary, e -> e.getPadding().getOperator(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)unary, J.Unary::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)unary, J.Unary::getType);
            return unary;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, SenderContext ctx) {
            ctx.sendValue((Object)variableDeclarations, J.VariableDeclarations::getId);
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)variableDeclarations, J.VariableDeclarations::getLeadingAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)variableDeclarations, J.VariableDeclarations::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getVarargs, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNodes((Object)variableDeclarations, J.VariableDeclarations::getDimensionsBeforeName, (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1), Function.identity());
            ctx.sendNodes((Object)variableDeclarations, e -> e.getPadding().getVariables(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1), e -> ((J.VariableDeclarations.NamedVariable)e.getElement()).getId());
            return variableDeclarations;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable namedVariable, SenderContext ctx) {
            ctx.sendValue((Object)namedVariable, J.VariableDeclarations.NamedVariable::getId);
            ctx.sendNode((Object)namedVariable, J.VariableDeclarations.NamedVariable::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)namedVariable, J.VariableDeclarations.NamedVariable::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)namedVariable, J.VariableDeclarations.NamedVariable::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)namedVariable, J.VariableDeclarations.NamedVariable::getDimensionsAfterName, (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1), Function.identity());
            ctx.sendNode((Object)namedVariable, e -> e.getPadding().getInitializer(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)namedVariable, J.VariableDeclarations.NamedVariable::getVariableType);
            return namedVariable;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SenderContext ctx) {
            ctx.sendValue((Object)whileLoop, J.WhileLoop::getId);
            ctx.sendNode((Object)whileLoop, J.WhileLoop::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)whileLoop, J.WhileLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)whileLoop, J.WhileLoop::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)whileLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> PythonSender.sendRightPadded(x$0, x$1));
            return whileLoop;
        }

        public J.Wildcard visitWildcard(J.Wildcard wildcard, SenderContext ctx) {
            ctx.sendValue((Object)wildcard, J.Wildcard::getId);
            ctx.sendNode((Object)wildcard, J.Wildcard::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)wildcard, J.Wildcard::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)wildcard, e -> e.getPadding().getBound(), (x$0, x$1) -> PythonSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)wildcard, J.Wildcard::getBoundedType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return wildcard;
        }

        public J.Yield visitYield(J.Yield yield, SenderContext ctx) {
            ctx.sendValue((Object)yield, J.Yield::getId);
            ctx.sendNode((Object)yield, J.Yield::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)yield, J.Yield::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)yield, J.Yield::isImplicit);
            ctx.sendNode((Object)yield, J.Yield::getValue, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return yield;
        }

        public J.Unknown visitUnknown(J.Unknown unknown, SenderContext ctx) {
            ctx.sendValue((Object)unknown, J.Unknown::getId);
            ctx.sendNode((Object)unknown, J.Unknown::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unknown, J.Unknown::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unknown, J.Unknown::getSource, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return unknown;
        }

        public J.Unknown.Source visitUnknownSource(J.Unknown.Source source, SenderContext ctx) {
            ctx.sendValue((Object)source, J.Unknown.Source::getId);
            ctx.sendNode((Object)source, J.Unknown.Source::getPrefix, (x$0, x$1) -> PythonSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)source, J.Unknown.Source::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)source, J.Unknown.Source::getText);
            return source;
        }
    }
}

