/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.remote;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.python.PythonIsoVisitor;
import org.openrewrite.python.tree.Py;

class PythonValidator<P>
extends PythonIsoVisitor<P> {
    PythonValidator() {
    }

    private <T extends Tree> @Nullable T visitAndValidate(@Nullable T tree, Class<? extends Tree> expected, P p) {
        if (tree != null && !expected.isInstance(tree)) {
            throw new ClassCastException("Type " + tree.getClass() + " is not assignable to " + expected);
        }
        return (T)this.visit(tree, p);
    }

    private <T extends Tree> T visitAndValidateNonNull(@Nullable T tree, Class<? extends Tree> expected, P p) {
        Objects.requireNonNull(tree);
        if (!expected.isInstance(tree)) {
            throw new ClassCastException("Type " + tree.getClass() + " is not assignable to " + expected);
        }
        return (T)this.visitNonNull(tree, p);
    }

    private <T extends Tree> @Nullable List<T> visitAndValidate(@Nullable List<T> list, Class<? extends Tree> expected, P p) {
        return list == null ? null : ListUtils.map(list, e -> this.visitAndValidateNonNull(e, expected, p));
    }

    public Py.Async visitAsync(Py.Async async, P p) {
        this.visitAndValidateNonNull(async.getStatement(), Statement.class, p);
        return async;
    }

    public Py.Await visitAwait(Py.Await await, P p) {
        this.visitAndValidateNonNull(await.getExpression(), Expression.class, p);
        return await;
    }

    public Py.Binary visitBinary(Py.Binary binary, P p) {
        this.visitAndValidateNonNull(binary.getLeft(), Expression.class, p);
        this.visitAndValidateNonNull(binary.getRight(), Expression.class, p);
        return binary;
    }

    public Py.ChainedAssignment visitChainedAssignment(Py.ChainedAssignment chainedAssignment, P p) {
        ListUtils.map((List)chainedAssignment.getVariables(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        this.visitAndValidateNonNull(chainedAssignment.getAssignment(), Expression.class, p);
        return chainedAssignment;
    }

    public Py.ExceptionType visitExceptionType(Py.ExceptionType exceptionType, P p) {
        this.visitAndValidateNonNull(exceptionType.getExpression(), Expression.class, p);
        return exceptionType;
    }

    public Py.ForLoop visitForLoop(Py.ForLoop forLoop, P p) {
        this.visitAndValidateNonNull(forLoop.getTarget(), Expression.class, p);
        this.visitAndValidateNonNull(forLoop.getIterable(), Expression.class, p);
        this.visitAndValidateNonNull(forLoop.getBody(), Statement.class, p);
        return forLoop;
    }

    public Py.LiteralType visitLiteralType(Py.LiteralType literalType, P p) {
        this.visitAndValidateNonNull(literalType.getLiteral(), Expression.class, p);
        return literalType;
    }

    public Py.TypeHint visitTypeHint(Py.TypeHint typeHint, P p) {
        this.visitAndValidateNonNull(typeHint.getTypeTree(), Expression.class, p);
        return typeHint;
    }

    public Py.CompilationUnit visitCompilationUnit(Py.CompilationUnit compilationUnit, P p) {
        ListUtils.map((List)compilationUnit.getImports(), el -> this.visitAndValidateNonNull(el, J.Import.class, p));
        ListUtils.map((List)compilationUnit.getStatements(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        return compilationUnit;
    }

    public Py.ExpressionStatement visitExpressionStatement(Py.ExpressionStatement expressionStatement, P p) {
        this.visitAndValidateNonNull(expressionStatement.getExpression(), Expression.class, p);
        return expressionStatement;
    }

    public Py.ExpressionTypeTree visitExpressionTypeTree(Py.ExpressionTypeTree expressionTypeTree, P p) {
        this.visitAndValidateNonNull(expressionTypeTree.getReference(), J.class, p);
        return expressionTypeTree;
    }

    public Py.StatementExpression visitStatementExpression(Py.StatementExpression statementExpression, P p) {
        this.visitAndValidateNonNull(statementExpression.getStatement(), Statement.class, p);
        return statementExpression;
    }

    public Py.MultiImport visitMultiImport(Py.MultiImport multiImport, P p) {
        this.visitAndValidate(multiImport.getFrom(), NameTree.class, p);
        this.visitAndValidate(multiImport.getNames(), J.Import.class, p);
        return multiImport;
    }

    public Py.KeyValue visitKeyValue(Py.KeyValue keyValue, P p) {
        this.visitAndValidateNonNull(keyValue.getKey(), Expression.class, p);
        this.visitAndValidateNonNull(keyValue.getValue(), Expression.class, p);
        return keyValue;
    }

    public Py.DictLiteral visitDictLiteral(Py.DictLiteral dictLiteral, P p) {
        this.visitAndValidate(dictLiteral.getElements(), Expression.class, p);
        return dictLiteral;
    }

    public Py.CollectionLiteral visitCollectionLiteral(Py.CollectionLiteral collectionLiteral, P p) {
        this.visitAndValidate(collectionLiteral.getElements(), Expression.class, p);
        return collectionLiteral;
    }

    public Py.FormattedString visitFormattedString(Py.FormattedString formattedString, P p) {
        ListUtils.map((List)formattedString.getParts(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        return formattedString;
    }

    public Py.FormattedString.Value visitFormattedStringValue(Py.FormattedString.Value value, P p) {
        this.visitAndValidateNonNull(value.getExpression(), Expression.class, p);
        this.visitAndValidate(value.getFormat(), Expression.class, p);
        return value;
    }

    public Py.Pass visitPass(Py.Pass pass, P p) {
        return pass;
    }

    public Py.TrailingElseWrapper visitTrailingElseWrapper(Py.TrailingElseWrapper trailingElseWrapper, P p) {
        this.visitAndValidateNonNull(trailingElseWrapper.getStatement(), Statement.class, p);
        this.visitAndValidateNonNull(trailingElseWrapper.getElseBlock(), J.Block.class, p);
        return trailingElseWrapper;
    }

    public Py.ComprehensionExpression visitComprehensionExpression(Py.ComprehensionExpression comprehensionExpression, P p) {
        this.visitAndValidateNonNull(comprehensionExpression.getResult(), Expression.class, p);
        ListUtils.map((List)comprehensionExpression.getClauses(), el -> this.visitAndValidateNonNull(el, Py.ComprehensionExpression.Clause.class, p));
        return comprehensionExpression;
    }

    public Py.ComprehensionExpression.Condition visitComprehensionCondition(Py.ComprehensionExpression.Condition condition, P p) {
        this.visitAndValidateNonNull(condition.getExpression(), Expression.class, p);
        return condition;
    }

    public Py.ComprehensionExpression.Clause visitComprehensionClause(Py.ComprehensionExpression.Clause clause, P p) {
        this.visitAndValidateNonNull(clause.getIteratorVariable(), Expression.class, p);
        this.visitAndValidateNonNull(clause.getIteratedList(), Expression.class, p);
        ListUtils.map((List)clause.getConditions(), el -> this.visitAndValidateNonNull(el, Py.ComprehensionExpression.Condition.class, p));
        return clause;
    }

    public Py.TypeAlias visitTypeAlias(Py.TypeAlias typeAlias, P p) {
        this.visitAndValidateNonNull(typeAlias.getName(), J.Identifier.class, p);
        this.visitAndValidateNonNull(typeAlias.getValue(), J.class, p);
        return typeAlias;
    }

    public Py.YieldFrom visitYieldFrom(Py.YieldFrom yieldFrom, P p) {
        this.visitAndValidateNonNull(yieldFrom.getExpression(), Expression.class, p);
        return yieldFrom;
    }

    public Py.UnionType visitUnionType(Py.UnionType unionType, P p) {
        ListUtils.map((List)unionType.getTypes(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        return unionType;
    }

    public Py.VariableScope visitVariableScope(Py.VariableScope variableScope, P p) {
        ListUtils.map((List)variableScope.getNames(), el -> this.visitAndValidateNonNull(el, J.Identifier.class, p));
        return variableScope;
    }

    public Py.Del visitDel(Py.Del del, P p) {
        ListUtils.map((List)del.getTargets(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        return del;
    }

    public Py.SpecialParameter visitSpecialParameter(Py.SpecialParameter specialParameter, P p) {
        this.visitAndValidate(specialParameter.getTypeHint(), Py.TypeHint.class, p);
        return specialParameter;
    }

    public Py.Star visitStar(Py.Star star, P p) {
        this.visitAndValidateNonNull(star.getExpression(), Expression.class, p);
        return star;
    }

    public Py.NamedArgument visitNamedArgument(Py.NamedArgument namedArgument, P p) {
        this.visitAndValidateNonNull(namedArgument.getName(), J.Identifier.class, p);
        this.visitAndValidateNonNull(namedArgument.getValue(), Expression.class, p);
        return namedArgument;
    }

    public Py.TypeHintedExpression visitTypeHintedExpression(Py.TypeHintedExpression typeHintedExpression, P p) {
        this.visitAndValidateNonNull(typeHintedExpression.getExpression(), Expression.class, p);
        this.visitAndValidateNonNull(typeHintedExpression.getTypeHint(), Py.TypeHint.class, p);
        return typeHintedExpression;
    }

    public Py.ErrorFrom visitErrorFrom(Py.ErrorFrom errorFrom, P p) {
        this.visitAndValidateNonNull(errorFrom.getError(), Expression.class, p);
        this.visitAndValidateNonNull(errorFrom.getFrom(), Expression.class, p);
        return errorFrom;
    }

    public Py.MatchCase visitMatchCase(Py.MatchCase matchCase, P p) {
        this.visitAndValidateNonNull(matchCase.getPattern(), Py.MatchCase.Pattern.class, p);
        this.visitAndValidate(matchCase.getGuard(), Expression.class, p);
        return matchCase;
    }

    public Py.MatchCase.Pattern visitMatchCasePattern(Py.MatchCase.Pattern pattern, P p) {
        this.visitAndValidate(pattern.getChildren(), Expression.class, p);
        return pattern;
    }

    public Py.Slice visitSlice(Py.Slice slice, P p) {
        this.visitAndValidate(slice.getStart(), Expression.class, p);
        this.visitAndValidate(slice.getStop(), Expression.class, p);
        this.visitAndValidate(slice.getStep(), Expression.class, p);
        return slice;
    }

    public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        ListUtils.map((List)annotatedType.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(annotatedType.getTypeExpression(), TypeTree.class, p);
        return annotatedType;
    }

    public J.Annotation visitAnnotation(J.Annotation annotation, P p) {
        this.visitAndValidateNonNull(annotation.getAnnotationType(), NameTree.class, p);
        this.visitAndValidate(annotation.getArguments(), Expression.class, p);
        return annotation;
    }

    public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        this.visitAndValidateNonNull(arrayAccess.getIndexed(), Expression.class, p);
        this.visitAndValidateNonNull(arrayAccess.getDimension(), J.ArrayDimension.class, p);
        return arrayAccess;
    }

    public J.ArrayType visitArrayType(J.ArrayType arrayType, P p) {
        this.visitAndValidateNonNull(arrayType.getElementType(), TypeTree.class, p);
        ListUtils.map((List)arrayType.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return arrayType;
    }

    public J.Assert visitAssert(J.Assert assert_, P p) {
        this.visitAndValidateNonNull(assert_.getCondition(), Expression.class, p);
        this.visitAndValidate(assert_.getDetail() != null ? (Expression)assert_.getDetail().getElement() : null, Expression.class, p);
        return assert_;
    }

    public J.Assignment visitAssignment(J.Assignment assignment, P p) {
        this.visitAndValidateNonNull(assignment.getVariable(), Expression.class, p);
        this.visitAndValidateNonNull(assignment.getAssignment(), Expression.class, p);
        return assignment;
    }

    public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignmentOperation, P p) {
        this.visitAndValidateNonNull(assignmentOperation.getVariable(), Expression.class, p);
        this.visitAndValidateNonNull(assignmentOperation.getAssignment(), Expression.class, p);
        return assignmentOperation;
    }

    public J.Binary visitBinary(J.Binary binary, P p) {
        this.visitAndValidateNonNull(binary.getLeft(), Expression.class, p);
        this.visitAndValidateNonNull(binary.getRight(), Expression.class, p);
        return binary;
    }

    public J.Block visitBlock(J.Block block, P p) {
        ListUtils.map((List)block.getStatements(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        return block;
    }

    public J.Break visitBreak(J.Break break_, P p) {
        this.visitAndValidate(break_.getLabel(), J.Identifier.class, p);
        return break_;
    }

    public J.Case visitCase(J.Case case_, P p) {
        this.visitAndValidate(case_.getExpressions(), Expression.class, p);
        this.visitAndValidate(case_.getStatements(), Statement.class, p);
        this.visitAndValidate(case_.getBody(), J.class, p);
        return case_;
    }

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, P p) {
        ListUtils.map((List)classDeclaration.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)classDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(classDeclaration.getPadding().getKind().getAnnotations(), J.Annotation.class, p);
        this.visitAndValidateNonNull(classDeclaration.getName(), J.Identifier.class, p);
        this.visitAndValidate(classDeclaration.getTypeParameters(), J.TypeParameter.class, p);
        this.visitAndValidate(classDeclaration.getPrimaryConstructor(), Statement.class, p);
        this.visitAndValidate(classDeclaration.getExtends(), TypeTree.class, p);
        this.visitAndValidate(classDeclaration.getImplements(), TypeTree.class, p);
        this.visitAndValidate(classDeclaration.getPermits(), TypeTree.class, p);
        this.visitAndValidateNonNull(classDeclaration.getBody(), J.Block.class, p);
        return classDeclaration;
    }

    public J.Continue visitContinue(J.Continue continue_, P p) {
        this.visitAndValidate(continue_.getLabel(), J.Identifier.class, p);
        return continue_;
    }

    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        this.visitAndValidateNonNull(doWhileLoop.getBody(), Statement.class, p);
        this.visitAndValidateNonNull(doWhileLoop.getWhileCondition(), Expression.class, p);
        return doWhileLoop;
    }

    public J.Empty visitEmpty(J.Empty empty, P p) {
        return empty;
    }

    public J.EnumValue visitEnumValue(J.EnumValue enumValue, P p) {
        ListUtils.map((List)enumValue.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(enumValue.getName(), J.Identifier.class, p);
        this.visitAndValidate(enumValue.getInitializer(), J.NewClass.class, p);
        return enumValue;
    }

    public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enumValueSet, P p) {
        ListUtils.map((List)enumValueSet.getEnums(), el -> this.visitAndValidateNonNull(el, J.EnumValue.class, p));
        return enumValueSet;
    }

    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        this.visitAndValidateNonNull(fieldAccess.getTarget(), Expression.class, p);
        this.visitAndValidateNonNull(fieldAccess.getName(), J.Identifier.class, p);
        return fieldAccess;
    }

    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        this.visitAndValidateNonNull(forEachLoop.getControl(), J.ForEachLoop.Control.class, p);
        this.visitAndValidateNonNull(forEachLoop.getBody(), Statement.class, p);
        return forEachLoop;
    }

    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        this.visitAndValidateNonNull(control.getVariable(), J.VariableDeclarations.class, p);
        this.visitAndValidateNonNull(control.getIterable(), Expression.class, p);
        return control;
    }

    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        this.visitAndValidateNonNull(forLoop.getControl(), J.ForLoop.Control.class, p);
        this.visitAndValidateNonNull(forLoop.getBody(), Statement.class, p);
        return forLoop;
    }

    public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
        ListUtils.map((List)control.getInit(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        this.visitAndValidateNonNull(control.getCondition(), Expression.class, p);
        ListUtils.map((List)control.getUpdate(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        return control;
    }

    public J.ParenthesizedTypeTree visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedTypeTree, P p) {
        ListUtils.map((List)parenthesizedTypeTree.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(parenthesizedTypeTree.getParenthesizedType(), J.Parentheses.class, p);
        return parenthesizedTypeTree;
    }

    public J.Identifier visitIdentifier(J.Identifier identifier, P p) {
        ListUtils.map((List)identifier.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return identifier;
    }

    public J.If visitIf(J.If if_, P p) {
        this.visitAndValidateNonNull(if_.getIfCondition(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(if_.getThenPart(), Statement.class, p);
        this.visitAndValidate(if_.getElsePart(), J.If.Else.class, p);
        return if_;
    }

    public J.If.Else visitElse(J.If.Else else_, P p) {
        this.visitAndValidateNonNull(else_.getBody(), Statement.class, p);
        return else_;
    }

    public J.Import visitImport(J.Import import_, P p) {
        this.visitAndValidateNonNull(import_.getQualid(), J.FieldAccess.class, p);
        this.visitAndValidate(import_.getAlias(), J.Identifier.class, p);
        return import_;
    }

    public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, P p) {
        this.visitAndValidateNonNull(instanceOf.getExpression(), Expression.class, p);
        this.visitAndValidateNonNull(instanceOf.getClazz(), J.class, p);
        this.visitAndValidate(instanceOf.getPattern(), J.class, p);
        return instanceOf;
    }

    public J.IntersectionType visitIntersectionType(J.IntersectionType intersectionType, P p) {
        this.visitAndValidate(intersectionType.getBounds(), TypeTree.class, p);
        return intersectionType;
    }

    public J.Label visitLabel(J.Label label, P p) {
        this.visitAndValidateNonNull(label.getLabel(), J.Identifier.class, p);
        this.visitAndValidateNonNull(label.getStatement(), Statement.class, p);
        return label;
    }

    public J.Lambda visitLambda(J.Lambda lambda, P p) {
        this.visitAndValidate(lambda.getParameters().getParameters(), J.class, p);
        this.visitAndValidateNonNull(lambda.getBody(), J.class, p);
        return lambda;
    }

    public J.Literal visitLiteral(J.Literal literal, P p) {
        return literal;
    }

    public J.MemberReference visitMemberReference(J.MemberReference memberReference, P p) {
        this.visitAndValidateNonNull(memberReference.getContaining(), Expression.class, p);
        this.visitAndValidate(memberReference.getTypeParameters(), Expression.class, p);
        this.visitAndValidateNonNull(memberReference.getReference(), J.Identifier.class, p);
        return memberReference;
    }

    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, P p) {
        ListUtils.map((List)methodDeclaration.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)methodDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(methodDeclaration.getPadding().getTypeParameters(), J.TypeParameters.class, p);
        this.visitAndValidate(methodDeclaration.getReturnTypeExpression(), TypeTree.class, p);
        this.visitAndValidate(methodDeclaration.getParameters(), Statement.class, p);
        this.visitAndValidate(methodDeclaration.getThrows(), NameTree.class, p);
        this.visitAndValidate(methodDeclaration.getBody(), J.Block.class, p);
        this.visitAndValidate(methodDeclaration.getDefaultValue(), Expression.class, p);
        return methodDeclaration;
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, P p) {
        this.visitAndValidate(methodInvocation.getSelect(), Expression.class, p);
        this.visitAndValidate(methodInvocation.getTypeParameters(), Expression.class, p);
        this.visitAndValidateNonNull(methodInvocation.getName(), J.Identifier.class, p);
        this.visitAndValidate(methodInvocation.getArguments(), Expression.class, p);
        return methodInvocation;
    }

    public J.Modifier visitModifier(J.Modifier modifier, P p) {
        ListUtils.map((List)modifier.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return modifier;
    }

    public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, P p) {
        ListUtils.map((List)multiCatch.getAlternatives(), el -> this.visitAndValidateNonNull(el, NameTree.class, p));
        return multiCatch;
    }

    public J.NewArray visitNewArray(J.NewArray newArray, P p) {
        this.visitAndValidate(newArray.getTypeExpression(), TypeTree.class, p);
        ListUtils.map((List)newArray.getDimensions(), el -> this.visitAndValidateNonNull(el, J.ArrayDimension.class, p));
        this.visitAndValidate(newArray.getInitializer(), Expression.class, p);
        return newArray;
    }

    public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        this.visitAndValidateNonNull(arrayDimension.getIndex(), Expression.class, p);
        return arrayDimension;
    }

    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        this.visitAndValidate(newClass.getEnclosing(), Expression.class, p);
        this.visitAndValidate(newClass.getClazz(), TypeTree.class, p);
        this.visitAndValidate(newClass.getArguments(), Expression.class, p);
        this.visitAndValidate(newClass.getBody(), J.Block.class, p);
        return newClass;
    }

    public J.NullableType visitNullableType(J.NullableType nullableType, P p) {
        ListUtils.map((List)nullableType.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(nullableType.getTypeTree(), TypeTree.class, p);
        return nullableType;
    }

    public J.Package visitPackage(J.Package package_, P p) {
        this.visitAndValidateNonNull(package_.getExpression(), Expression.class, p);
        ListUtils.map((List)package_.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return package_;
    }

    public J.ParameterizedType visitParameterizedType(J.ParameterizedType parameterizedType, P p) {
        this.visitAndValidateNonNull(parameterizedType.getClazz(), NameTree.class, p);
        this.visitAndValidate(parameterizedType.getTypeParameters(), Expression.class, p);
        return parameterizedType;
    }

    public <J2 extends J> J.Parentheses<J2> visitParentheses(J.Parentheses<J2> parentheses, P p) {
        this.visitAndValidateNonNull(parentheses.getTree(), J.class, p);
        return parentheses;
    }

    public <J2 extends J> J.ControlParentheses<J2> visitControlParentheses(J.ControlParentheses<J2> controlParentheses, P p) {
        this.visitAndValidateNonNull(controlParentheses.getTree(), J.class, p);
        return controlParentheses;
    }

    public J.Primitive visitPrimitive(J.Primitive primitive, P p) {
        return primitive;
    }

    public J.Return visitReturn(J.Return return_, P p) {
        this.visitAndValidate(return_.getExpression(), Expression.class, p);
        return return_;
    }

    public J.Switch visitSwitch(J.Switch switch_, P p) {
        this.visitAndValidateNonNull(switch_.getSelector(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(switch_.getCases(), J.Block.class, p);
        return switch_;
    }

    public J.SwitchExpression visitSwitchExpression(J.SwitchExpression switchExpression, P p) {
        this.visitAndValidateNonNull(switchExpression.getSelector(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(switchExpression.getCases(), J.Block.class, p);
        return switchExpression;
    }

    public J.Synchronized visitSynchronized(J.Synchronized synchronized_, P p) {
        this.visitAndValidateNonNull(synchronized_.getLock(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(synchronized_.getBody(), J.Block.class, p);
        return synchronized_;
    }

    public J.Ternary visitTernary(J.Ternary ternary, P p) {
        this.visitAndValidateNonNull(ternary.getCondition(), Expression.class, p);
        this.visitAndValidateNonNull(ternary.getTruePart(), Expression.class, p);
        this.visitAndValidateNonNull(ternary.getFalsePart(), Expression.class, p);
        return ternary;
    }

    public J.Throw visitThrow(J.Throw throw_, P p) {
        this.visitAndValidateNonNull(throw_.getException(), Expression.class, p);
        return throw_;
    }

    public J.Try visitTry(J.Try try_, P p) {
        this.visitAndValidate(try_.getResources(), J.Try.Resource.class, p);
        this.visitAndValidateNonNull(try_.getBody(), J.Block.class, p);
        ListUtils.map((List)try_.getCatches(), el -> this.visitAndValidateNonNull(el, J.Try.Catch.class, p));
        this.visitAndValidate(try_.getFinally(), J.Block.class, p);
        return try_;
    }

    public J.Try.Resource visitTryResource(J.Try.Resource resource, P p) {
        this.visitAndValidateNonNull(resource.getVariableDeclarations(), TypedTree.class, p);
        return resource;
    }

    public J.Try.Catch visitCatch(J.Try.Catch catch_, P p) {
        this.visitAndValidateNonNull(catch_.getParameter(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(catch_.getBody(), J.Block.class, p);
        return catch_;
    }

    public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
        this.visitAndValidateNonNull(typeCast.getClazz(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(typeCast.getExpression(), Expression.class, p);
        return typeCast;
    }

    public J.TypeParameter visitTypeParameter(J.TypeParameter typeParameter, P p) {
        ListUtils.map((List)typeParameter.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)typeParameter.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidateNonNull(typeParameter.getName(), Expression.class, p);
        this.visitAndValidate(typeParameter.getBounds(), TypeTree.class, p);
        return typeParameter;
    }

    public J.Unary visitUnary(J.Unary unary, P p) {
        this.visitAndValidateNonNull(unary.getExpression(), Expression.class, p);
        return unary;
    }

    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, P p) {
        ListUtils.map((List)variableDeclarations.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)variableDeclarations.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(variableDeclarations.getTypeExpression(), TypeTree.class, p);
        ListUtils.map((List)variableDeclarations.getVariables(), el -> this.visitAndValidateNonNull(el, J.VariableDeclarations.NamedVariable.class, p));
        return variableDeclarations;
    }

    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable namedVariable, P p) {
        this.visitAndValidateNonNull(namedVariable.getName(), J.Identifier.class, p);
        this.visitAndValidate(namedVariable.getInitializer(), Expression.class, p);
        return namedVariable;
    }

    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        this.visitAndValidateNonNull(whileLoop.getCondition(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(whileLoop.getBody(), Statement.class, p);
        return whileLoop;
    }

    public J.Wildcard visitWildcard(J.Wildcard wildcard, P p) {
        this.visitAndValidate(wildcard.getBoundedType(), NameTree.class, p);
        return wildcard;
    }

    public J.Yield visitYield(J.Yield yield, P p) {
        this.visitAndValidateNonNull(yield.getValue(), Expression.class, p);
        return yield;
    }

    public J.Unknown visitUnknown(J.Unknown unknown, P p) {
        this.visitAndValidateNonNull(unknown.getSource(), J.Unknown.Source.class, p);
        return unknown;
    }

    public J.Unknown.Source visitUnknownSource(J.Unknown.Source source, P p) {
        return source;
    }
}

