/*
 * Copyright 2024 the original author or authors.
 * <p>
 * Licensed under the Moderne Source Available License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://docs.moderne.io/licensing/moderne-source-available-license
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * -------------------THIS FILE IS AUTO GENERATED--------------------------
 * Changes to this file may cause incorrect behavior and will be lost if
 * the code is regenerated.
*/

package org.openrewrite.python.remote;

import com.fasterxml.jackson.core.type.TypeReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.*;
import org.openrewrite.remote.model.*;
import org.openrewrite.tree.*;
import org.openrewrite.java.tree.*;
import org.openrewrite.python.tree.*;

import java.util.List;

public class Python implements LstModel {

    public static final int PYTHON_ASYNC = 8000;
    public static final int PYTHON_AWAIT = 8001;
    public static final int PYTHON_BINARY = 8002;
    public static final int PYTHON_CHAINED_ASSIGNMENT = 8003;
    public static final int PYTHON_EXCEPTION_TYPE = 8004;
    public static final int PYTHON_FOR_LOOP = 8005;
    public static final int PYTHON_LITERAL_TYPE = 8006;
    public static final int PYTHON_TYPE_HINT = 8007;
    public static final int PYTHON_COMPILATION_UNIT = 8008;
    public static final int PYTHON_EXPRESSION_STATEMENT = 8009;
    public static final int PYTHON_EXPRESSION_TYPE_TREE = 8010;
    public static final int PYTHON_STATEMENT_EXPRESSION = 8011;
    public static final int PYTHON_MULTI_IMPORT = 8012;
    public static final int PYTHON_KEY_VALUE = 8013;
    public static final int PYTHON_DICT_LITERAL = 8014;
    public static final int PYTHON_COLLECTION_LITERAL = 8015;
    public static final int PYTHON_FORMATTED_STRING = 8016;
    public static final int PYTHON_FORMATTED_STRING_VALUE = 8017;
    public static final int PYTHON_PASS = 8018;
    public static final int PYTHON_TRAILING_ELSE_WRAPPER = 8019;
    public static final int PYTHON_COMPREHENSION_EXPRESSION = 8020;
    public static final int PYTHON_COMPREHENSION_EXPRESSION_CONDITION = 8021;
    public static final int PYTHON_COMPREHENSION_EXPRESSION_CLAUSE = 8022;
    public static final int PYTHON_TYPE_ALIAS = 8023;
    public static final int PYTHON_YIELD_FROM = 8024;
    public static final int PYTHON_UNION_TYPE = 8025;
    public static final int PYTHON_VARIABLE_SCOPE = 8026;
    public static final int PYTHON_DEL = 8027;
    public static final int PYTHON_SPECIAL_PARAMETER = 8028;
    public static final int PYTHON_STAR = 8029;
    public static final int PYTHON_NAMED_ARGUMENT = 8030;
    public static final int PYTHON_TYPE_HINTED_EXPRESSION = 8031;
    public static final int PYTHON_ERROR_FROM = 8032;
    public static final int PYTHON_MATCH_CASE = 8033;
    public static final int PYTHON_MATCH_CASE_PATTERN = 8034;
    public static final int PYTHON_SLICE = 8035;

    private static final LstModel.Info INFO = LstModel.Info.builder()
            .id(8)
            .name("Python")
            .shortName("Py")
            .type(LstType.Info.builder()
                    .id(PYTHON_ASYNC)
                    .type(Py.Async.class)
                    .name("Async")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("statement")
                        .type(org.openrewrite.java.tree.Statement.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_AWAIT)
                    .type(Py.Await.class)
                    .name("Await")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_BINARY)
                    .type(Py.Binary.class)
                    .name("Binary")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("left")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("operator")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.python.tree.Py.Binary.Type>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("negation")
                        .type(org.openrewrite.java.tree.Space.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("right")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_CHAINED_ASSIGNMENT)
                    .type(Py.ChainedAssignment.class)
                    .name("ChainedAssignment")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("variables")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("assignment")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_EXCEPTION_TYPE)
                    .type(Py.ExceptionType.class)
                    .name("ExceptionType")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("exceptionGroup")
                        .type(boolean.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_FOR_LOOP)
                    .type(Py.ForLoop.class)
                    .name("ForLoop")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("target")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("iterable")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("body")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Statement>>() {})
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_LITERAL_TYPE)
                    .type(Py.LiteralType.class)
                    .name("LiteralType")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("literal")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_TYPE_HINT)
                    .type(Py.TypeHint.class)
                    .name("TypeHint")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("typeTree")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_COMPILATION_UNIT)
                    .type(Py.CompilationUnit.class)
                    .name("CompilationUnit")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("sourcePath")
                        .type(java.nio.file.Path.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("fileAttributes")
                        .type(org.openrewrite.FileAttributes.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("charsetName")
                        .type(java.lang.String.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("charsetBomMarked")
                        .type(boolean.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("checksum")
                        .type(org.openrewrite.Checksum.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("imports")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.J.Import>>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("statements")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Statement>>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("eof")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_EXPRESSION_STATEMENT)
                    .type(Py.ExpressionStatement.class)
                    .name("ExpressionStatement")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_EXPRESSION_TYPE_TREE)
                    .type(Py.ExpressionTypeTree.class)
                    .name("ExpressionTypeTree")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("reference")
                        .type(org.openrewrite.java.tree.J.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_STATEMENT_EXPRESSION)
                    .type(Py.StatementExpression.class)
                    .name("StatementExpression")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("statement")
                        .type(org.openrewrite.java.tree.Statement.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_MULTI_IMPORT)
                    .type(Py.MultiImport.class)
                    .name("MultiImport")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("from")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.NameTree>>() {})
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("parenthesized")
                        .type(boolean.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("names")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JContainer<org.openrewrite.java.tree.J.Import>>() {})
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_KEY_VALUE)
                    .type(Py.KeyValue.class)
                    .name("KeyValue")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("key")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("value")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_DICT_LITERAL)
                    .type(Py.DictLiteral.class)
                    .name("DictLiteral")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("elements")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JContainer<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_COLLECTION_LITERAL)
                    .type(Py.CollectionLiteral.class)
                    .name("CollectionLiteral")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("kind")
                        .type(org.openrewrite.python.tree.Py.CollectionLiteral.Kind.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("elements")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JContainer<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_FORMATTED_STRING)
                    .type(Py.FormattedString.class)
                    .name("FormattedString")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("delimiter")
                        .type(java.lang.String.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("parts")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_FORMATTED_STRING_VALUE)
                    .type(Py.FormattedString.Value.class)
                    .name("FormattedString.Value")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("debug")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<java.lang.Boolean>>() {})
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("conversion")
                        .type(org.openrewrite.python.tree.Py.FormattedString.Value.Conversion.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("format")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_PASS)
                    .type(Py.Pass.class)
                    .name("Pass")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_TRAILING_ELSE_WRAPPER)
                    .type(Py.TrailingElseWrapper.class)
                    .name("TrailingElseWrapper")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("statement")
                        .type(org.openrewrite.java.tree.Statement.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("elseBlock")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.J.Block>>() {})
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_COMPREHENSION_EXPRESSION)
                    .type(Py.ComprehensionExpression.class)
                    .name("ComprehensionExpression")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("kind")
                        .type(org.openrewrite.python.tree.Py.ComprehensionExpression.Kind.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("result")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("clauses")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.python.tree.Py.ComprehensionExpression.Clause>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("suffix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_COMPREHENSION_EXPRESSION_CONDITION)
                    .type(Py.ComprehensionExpression.Condition.class)
                    .name("ComprehensionExpression.Condition")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_COMPREHENSION_EXPRESSION_CLAUSE)
                    .type(Py.ComprehensionExpression.Clause.class)
                    .name("ComprehensionExpression.Clause")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("async")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<java.lang.Boolean>>() {})
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("iteratorVariable")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("iteratedList")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("conditions")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.python.tree.Py.ComprehensionExpression.Condition>>() {})
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_TYPE_ALIAS)
                    .type(Py.TypeAlias.class)
                    .name("TypeAlias")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("name")
                        .type(org.openrewrite.java.tree.J.Identifier.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("value")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.J>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_YIELD_FROM)
                    .type(Py.YieldFrom.class)
                    .name("YieldFrom")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_UNION_TYPE)
                    .type(Py.UnionType.class)
                    .name("UnionType")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("types")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_VARIABLE_SCOPE)
                    .type(Py.VariableScope.class)
                    .name("VariableScope")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("kind")
                        .type(org.openrewrite.python.tree.Py.VariableScope.Kind.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("names")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.J.Identifier>>>() {})
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_DEL)
                    .type(Py.Del.class)
                    .name("Del")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("targets")
                        .typeReference(new TypeReference<java.util.List<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>>() {})
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_SPECIAL_PARAMETER)
                    .type(Py.SpecialParameter.class)
                    .name("SpecialParameter")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("kind")
                        .type(org.openrewrite.python.tree.Py.SpecialParameter.Kind.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("typeHint")
                        .type(org.openrewrite.python.tree.Py.TypeHint.class)
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_STAR)
                    .type(Py.Star.class)
                    .name("Star")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("kind")
                        .type(org.openrewrite.python.tree.Py.Star.Kind.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_NAMED_ARGUMENT)
                    .type(Py.NamedArgument.class)
                    .name("NamedArgument")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("name")
                        .type(org.openrewrite.java.tree.J.Identifier.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("value")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_TYPE_HINTED_EXPRESSION)
                    .type(Py.TypeHintedExpression.class)
                    .name("TypeHintedExpression")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("expression")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("typeHint")
                        .type(org.openrewrite.python.tree.Py.TypeHint.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_ERROR_FROM)
                    .type(Py.ErrorFrom.class)
                    .name("ErrorFrom")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("error")
                        .type(org.openrewrite.java.tree.Expression.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("from")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_MATCH_CASE)
                    .type(Py.MatchCase.class)
                    .name("MatchCase")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("pattern")
                        .type(org.openrewrite.python.tree.Py.MatchCase.Pattern.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("guard")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JLeftPadded<org.openrewrite.java.tree.Expression>>() {})
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_MATCH_CASE_PATTERN)
                    .type(Py.MatchCase.Pattern.class)
                    .name("MatchCase.Pattern")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("kind")
                        .type(org.openrewrite.python.tree.Py.MatchCase.Pattern.Kind.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("children")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JContainer<org.openrewrite.java.tree.Expression>>() {})
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("type")
                        .type(org.openrewrite.java.tree.JavaType.class)
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .type(LstType.Info.builder()
                    .id(PYTHON_SLICE)
                    .type(Py.Slice.class)
                    .name("Slice")
                    .property(LstProperty.Info.builder()
                        .name("id")
                        .type(java.util.UUID.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("prefix")
                        .type(org.openrewrite.java.tree.Space.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("markers")
                        .type(org.openrewrite.marker.Markers.class)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("start")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>() {})
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("stop")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>() {})
                        .nullable(true)
                        .build()
                    )
                    .property(LstProperty.Info.builder()
                        .name("step")
                        .typeReference(new TypeReference<org.openrewrite.java.tree.JRightPadded<org.openrewrite.java.tree.Expression>>() {})
                        .nullable(true)
                        .build()
                    )
                    .build()
            )
            .build();

    public static void register() {
        LstModel.Info.Registry.INSTANCE.register(INFO);
    }
}
