/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.stubs.PyImportElementStub;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportElementImpl
extends PyBaseElementImpl<PyImportElementStub>
implements PyImportElement {
    public PyImportElementImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyImportElementImpl(PyImportElementStub stub) {
        this(stub, (IStubElementType)PyElementTypes.IMPORT_ELEMENT);
    }

    public PyImportElementImpl(PyImportElementStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    @Nullable
    public PyReferenceExpression getImportReferenceExpression() {
        ASTNode node = this.getNode().findChildByType(PythonDialectsTokenSetProvider.getInstance().getReferenceExpressionTokens());
        return node == null ? null : (PyReferenceExpression)node.getPsi();
    }

    @Override
    public QualifiedName getImportedQName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            return stub.getImportedQName();
        }
        PyReferenceExpression importReference = this.getImportReferenceExpression();
        return importReference != null ? importReference.asQualifiedName() : null;
    }

    @Override
    public PyTargetExpression getAsNameElement() {
        return (PyTargetExpression)this.findChildByType(PyElementTypes.TARGET_EXPRESSION);
    }

    @Override
    public String getAsName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            String asName = stub.getAsName();
            return StringUtil.isEmpty(asName) ? null : asName;
        }
        PyTargetExpression element = this.getAsNameElement();
        return element != null ? element.getName() : null;
    }

    @Override
    @Nullable
    public String getVisibleName() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        if (stub != null) {
            String asName = stub.getAsName();
            if (!StringUtil.isEmpty(asName)) {
                return asName;
            }
            QualifiedName importedName = stub.getImportedQName();
            if (importedName != null && importedName.getComponentCount() > 0) {
                return importedName.getComponents().get(0);
            }
        } else {
            PyTargetExpression asNameElement = this.getAsNameElement();
            if (asNameElement != null) {
                return asNameElement.getName();
            }
            QualifiedName importedName = this.getImportedQName();
            if (importedName != null && importedName.getComponentCount() > 0) {
                return importedName.getComponents().get(0);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public PyStatement getContainingImportStatement() {
        PyImportElementStub stub = (PyImportElementStub)this.getStub();
        PsiElement parent = stub != null ? stub.getParentStub().getPsi() : this.getParent();
        return parent instanceof PyStatement ? (PyStatement)parent : null;
    }

    @Override
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @NotNull
            private String getRefName(String default_name) {
                String refName;
                PyReferenceExpression ref = PyImportElementImpl.this.getImportReferenceExpression();
                if (ref != null && (refName = ref.getName()) != null) {
                    String string = refName;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = default_name;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public String getPresentableText() {
                return this.getRefName("<none>");
            }

            @Override
            public String getLocationString() {
                PyElement elt = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)PyImportElementImpl.this, PyImportStatement.class, PyFromImportStatement.class);
                StringBuilder buf = new StringBuilder("| ");
                if (elt != null) {
                    if (elt instanceof PyFromImportStatement) {
                        buf.append("from ");
                        PyReferenceExpression imp_src = ((PyFromImportStatement)elt).getImportSource();
                        if (imp_src != null) {
                            buf.append(PyPsiUtils.toPath(imp_src));
                        } else {
                            buf.append("<?>");
                        }
                        buf.append(" import ");
                    } else {
                        buf.append("import ");
                    }
                    buf.append(this.getRefName("<?>"));
                } else {
                    buf.append("import?.. ");
                }
                PyTargetExpression as_part = PyImportElementImpl.this.getAsNameElement();
                if (as_part != null) {
                    buf.append(" as ").append(as_part.getName());
                }
                return buf.toString();
            }

            @Override
            public Icon getIcon(boolean open) {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/psi/impl/PyImportElementImpl$1", "getRefName"));
            }
        };
    }

    @Override
    public String getName() {
        return this.getVisibleName();
    }

    @Override
    @NotNull
    public Iterable<PyElement> iterateNames() {
        String visibleName = this.getVisibleName();
        List<PyElement> list = visibleName != null ? Collections.singletonList(this) : Collections.emptyList();
        if (list == null) {
            PyImportElementImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolveName(@NotNull String name) {
        if (name == null) {
            PyImportElementImpl.$$$reportNull$$$0(1);
        }
        return this.getElementsNamed(name, true);
    }

    @Override
    @Nullable
    public PsiElement getElementNamed(String name, boolean resolveImportElement) {
        List<RatedResolveResult> results = this.getElementsNamed(name, resolveImportElement);
        return results.isEmpty() ? null : RatedResolveResult.sorted(results).get(0).getElement();
    }

    @NotNull
    private List<RatedResolveResult> getElementsNamed(@NotNull String name, boolean resolveImportElement) {
        String asName;
        if (name == null) {
            PyImportElementImpl.$$$reportNull$$$0(2);
        }
        if ((asName = this.getAsName()) != null) {
            if (!Objects.equals(name, asName)) {
                List<RatedResolveResult> list = Collections.emptyList();
                if (list == null) {
                    PyImportElementImpl.$$$reportNull$$$0(3);
                }
                return list;
            }
            if (resolveImportElement) {
                List<RatedResolveResult> list = this.multiResolve();
                if (list == null) {
                    PyImportElementImpl.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<RatedResolveResult> list = ResolveResultList.to(this);
            if (list == null) {
                PyImportElementImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        QualifiedName qName = this.getImportedQName();
        if (qName == null || qName.getComponentCount() == 0 || !qName.getComponents().get(0).equals(name)) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                PyImportElementImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        if (qName.getComponentCount() == 1) {
            if (resolveImportElement) {
                List<RatedResolveResult> list = this.multiResolve();
                if (list == null) {
                    PyImportElementImpl.$$$reportNull$$$0(7);
                }
                return list;
            }
            List<RatedResolveResult> list = ResolveResultList.to(this);
            if (list == null) {
                PyImportElementImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<RatedResolveResult> list = ResolveResultList.to(this.createImportedModule(name));
        if (list == null) {
            PyImportElementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        List<RatedResolveResult> results = this.multiResolve();
        return results.isEmpty() ? null : RatedResolveResult.sorted(results).get(0).getElement();
    }

    @Override
    @NotNull
    public List<RatedResolveResult> multiResolve() {
        QualifiedName qName = this.getImportedQName();
        List list = qName == null ? Collections.emptyList() : ResolveImportUtil.multiResolveImportElement((PyImportElement)this, (QualifiedName)qName);
        if (list == null) {
            PyImportElementImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyImportElement(this);
    }

    @Override
    public String toString() {
        QualifiedName qName = this.getImportedQName();
        return String.format("%s:%s", super.toString(), qName != null ? qName : "null");
    }

    @Nullable
    private PsiElement createImportedModule(String name) {
        PsiFile file = this.getContainingFile();
        if (file instanceof PyFile) {
            return new PyImportedModule(this, (PyFile)file, QualifiedName.fromComponents(name));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyImportElementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyImportElementImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsNamed";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementsNamed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

