/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.Parent;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class ProcessingInstruction
extends Content {
    private static final long serialVersionUID = 200L;
    private String target;
    private String rawData;

    public ProcessingInstruction(String target) {
        this(target, "");
    }

    public ProcessingInstruction(String target, Map<String, String> data) {
        super(Content.CType.ProcessingInstruction);
        this.setTarget(target);
        this.setData(data);
    }

    public ProcessingInstruction(String target, String data) {
        super(Content.CType.ProcessingInstruction);
        this.setTarget(target);
        this.setData(data);
    }

    private void setTarget(String newTarget) {
        String reason = Verifier.checkProcessingInstructionTarget((String)newTarget);
        if (reason != null) {
            throw new IllegalTargetException(newTarget, reason);
        }
        this.target = newTarget;
    }

    @Override
    public String getValue() {
        return this.rawData;
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.rawData;
    }

    public ProcessingInstruction setData(String data) {
        String reason = Verifier.checkProcessingInstructionData((String)data);
        if (reason != null) {
            throw new IllegalDataException(data, reason);
        }
        this.rawData = data;
        return this;
    }

    private void setData(Map<String, String> data) {
        String temp = ProcessingInstruction.toString(data);
        String reason = Verifier.checkProcessingInstructionData((String)temp);
        if (reason != null) {
            throw new IllegalDataException(temp, reason);
        }
        this.rawData = temp;
    }

    private static String toString(Map<String, String> mapData) {
        StringBuilder stringData = new StringBuilder();
        for (Map.Entry<String, String> me : mapData.entrySet()) {
            stringData.append(me.getKey()).append("=\"").append(me.getValue()).append("\" ");
        }
        if (stringData.length() > 0) {
            stringData.setLength(stringData.length() - 1);
        }
        return stringData.toString();
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            XMLOutputter.DEFAULT_PROCESSOR.process((Writer)out, Format.getRawFormat(), this);
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "[ProcessingInstruction: " + out + "]";
    }

    @Override
    public ProcessingInstruction clone() {
        return (ProcessingInstruction)super.clone();
    }

    @Override
    public ProcessingInstruction detach() {
        return (ProcessingInstruction)super.detach();
    }

    @Override
    protected ProcessingInstruction setParent(Parent parent) {
        return (ProcessingInstruction)super.setParent(parent);
    }

    private static final class IllegalTargetException
    extends IllegalArgumentException {
        private IllegalTargetException(String target, String reason) {
            super("The target \"" + target + "\" is not legal for JDOM/XML Processing Instructions: " + reason + ".");
        }
    }
}

