/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.python.internal.PsiPythonMapper;
import org.openrewrite.python.tree.Py;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PythonParser
implements Parser {
    private final LanguageLevel languageLevel;
    private final List<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;

    public Stream<SourceFile> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("p" + i + ".py", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> inputs, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(inputs).map(sourceFile -> {
            Py.CompilationUnit compilationUnit;
            block8: {
                Path path = sourceFile.getRelativePath(relativeTo);
                EncodingDetectingInputStream is = sourceFile.getSource(ctx);
                try {
                    Py.CompilationUnit py = new PsiPythonMapper(path, is.getCharset(), is.isCharsetBomMarked(), PythonParser.mapLanguageLevel(this.languageLevel)).mapSource(is.readFully());
                    parsingListener.parsed(sourceFile, (SourceFile)py);
                    compilationUnit = py;
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        ctx.getOnError().accept(t);
                        return ParseError.build((Parser)this, (Parser.Input)sourceFile, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                    }
                }
                is.close();
            }
            return compilationUnit;
        });
    }

    private static com.jetbrains.python.psi.LanguageLevel mapLanguageLevel(LanguageLevel languageLevel) {
        com.jetbrains.python.psi.LanguageLevel level;
        switch (languageLevel) {
            case PYTHON_24: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON24;
                break;
            }
            case PYTHON_25: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON25;
                break;
            }
            case PYTHON_26: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON26;
                break;
            }
            case PYTHON_27: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON27;
                break;
            }
            case PYTHON_30: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON30;
                break;
            }
            case PYTHON_31: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON31;
                break;
            }
            case PYTHON_32: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON32;
                break;
            }
            case PYTHON_33: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON33;
                break;
            }
            case PYTHON_34: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON34;
                break;
            }
            case PYTHON_35: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON35;
                break;
            }
            case PYTHON_36: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON36;
                break;
            }
            case PYTHON_37: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON37;
                break;
            }
            case PYTHON_38: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON38;
                break;
            }
            case PYTHON_39: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON39;
                break;
            }
            case PYTHON_310: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON310;
                break;
            }
            case PYTHON_311: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON311;
                break;
            }
            case PYTHON_312: {
                level = com.jetbrains.python.psi.LanguageLevel.PYTHON312;
                break;
            }
            default: {
                level = com.jetbrains.python.psi.LanguageLevel.getLatest();
            }
        }
        return level;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".py");
    }

    public PythonParser reset() {
        this.typeCache.clear();
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.py");
    }

    public static Builder builder() {
        return new Builder();
    }

    private PythonParser(LanguageLevel languageLevel, List<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache) {
        this.languageLevel = languageLevel;
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
    }

    public static enum LanguageLevel {
        PYTHON_24,
        PYTHON_25,
        PYTHON_26,
        PYTHON_27,
        PYTHON_30,
        PYTHON_31,
        PYTHON_32,
        PYTHON_33,
        PYTHON_34,
        PYTHON_35,
        PYTHON_36,
        PYTHON_37,
        PYTHON_38,
        PYTHON_39,
        PYTHON_310,
        PYTHON_311,
        PYTHON_312;

    }

    public static class Builder
    extends Parser.Builder {
        private LanguageLevel languageLevel = LanguageLevel.PYTHON_312;
        private JavaTypeCache typeCache = new JavaTypeCache();
        private boolean logCompilationWarningsAndErrors;
        private final List<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(Py.CompilationUnit.class);
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder languageLevel(LanguageLevel languageLevel) {
            this.languageLevel = languageLevel;
            return this;
        }

        public PythonParser build() {
            return new PythonParser(this.languageLevel, this.styles, this.logCompilationWarningsAndErrors, this.typeCache);
        }

        public String getDslName() {
            return "python";
        }
    }
}

