/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAsPattern;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyBoolLiteralExpression;
import com.jetbrains.python.psi.PyBreakStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCapturePattern;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyComprehensionComponent;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyComprehensionIfComponent;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyContinueStatement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyDoubleStarPattern;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyEmptyExpression;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGeneratorExpression;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyGroupPattern;
import com.jetbrains.python.psi.PyIfPart;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeyValuePattern;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyLiteralPattern;
import com.jetbrains.python.psi.PyMappingPattern;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyOrPattern;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyPatternArgumentList;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySequencePattern;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PySingleStarPattern;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyValuePattern;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWildcardPattern;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.openrewrite.FileAttributes;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.internal.IntelliJUtils;
import org.openrewrite.python.internal.PsiPaddingCursor;
import org.openrewrite.python.internal.PsiUtils;
import org.openrewrite.python.internal.PythonOperatorLookup;
import org.openrewrite.python.marker.BuiltinDesugar;
import org.openrewrite.python.marker.GroupedStatement;
import org.openrewrite.python.marker.ImplicitNone;
import org.openrewrite.python.marker.ImportParens;
import org.openrewrite.python.marker.MagicMethodDesugar;
import org.openrewrite.python.marker.PythonExtraPadding;
import org.openrewrite.python.marker.SuppressNewline;
import org.openrewrite.python.tree.Py;
import org.openrewrite.python.tree.PySpace;
import org.openrewrite.style.NamedStyles;

public class PsiPythonMapper {
    private final Path path;
    private final Charset charset;
    private final boolean isCharsetBomMarked;
    private final Collection<NamedStyles> styles;
    private final LanguageLevel languageLevel;
    private static final Map<IElementType, J.AssignmentOperation.Type> augAssignmentOps;
    private static final Map<PyElementType, String> binaryOperatorSpecialMethods;
    private static final Map<PyElementType, J.Binary.Type> binaryOperatorMapping;

    public PsiPythonMapper(Path path, Charset charset, boolean isCharsetBomMarked, Collection<NamedStyles> styles, LanguageLevel languageLevel) {
        this.path = path;
        this.charset = charset;
        this.isCharsetBomMarked = isCharsetBomMarked;
        this.styles = styles;
        this.languageLevel = languageLevel;
    }

    public Py.CompilationUnit mapSource(String sourceText) {
        PyFile pyFile;
        boolean addedNewline = false;
        if (!sourceText.endsWith("\n")) {
            addedNewline = true;
            sourceText = sourceText + "\n";
        }
        if ((pyFile = IntelliJUtils.parsePythonSource(this.path.toString(), sourceText, this.languageLevel)) == null) {
            throw new IllegalStateException("Unexpected null PyFile on source: " + this.path);
        }
        Py.CompilationUnit compilationUnit = this.mapFile(pyFile);
        if (addedNewline) {
            compilationUnit = compilationUnit.withMarkers(compilationUnit.getMarkers().add((Marker)new SuppressNewline(Tree.randomId())));
        }
        return compilationUnit;
    }

    public Py.CompilationUnit mapFile(PyFile element) {
        BlockContext ctx = BlockContext.root(element);
        List<J.Block> statements = Collections.singletonList(this.mapBlock(element, null, element.getStatements(), ctx));
        Markers markers = Markers.build(this.styles);
        if (!element.getText().endsWith("\n")) {
            markers = markers.addIfAbsent((Marker)new SuppressNewline(Tree.randomId()));
        }
        Space eof = ctx.paddingCursor.consumeRemainingAndExpectEOF();
        return new Py.CompilationUnit(Tree.randomId(), Space.EMPTY, markers, this.path, FileAttributes.fromPath((Path)this.path), this.charset.name(), this.isCharsetBomMarked, null, Collections.emptyList(), Collections.emptyList(), eof).withStatements(statements);
    }

    public List<Statement> mapStatement(PsiElement element, BlockContext ctx) {
        try {
            if (element instanceof PyClass) {
                return Collections.singletonList(this.mapClassDeclarationStatement((PyClass)element, ctx));
            }
            if (element instanceof PyForStatement) {
                return Collections.singletonList(this.mapForStatement((PyForStatement)element, ctx));
            }
            if (element instanceof PyFunction) {
                return Collections.singletonList(this.mapFunction((PyFunction)element, ctx));
            }
            if (element instanceof PyIfStatement) {
                return Collections.singletonList(this.mapIfStatement((PyIfStatement)element, ctx));
            }
            if (element instanceof PyMatchStatement) {
                return Collections.singletonList(this.mapMatchStatement((PyMatchStatement)element, ctx));
            }
            if (element instanceof PyTryExceptStatement) {
                return Collections.singletonList(this.mapTry((PyTryExceptStatement)element, ctx));
            }
            if (element instanceof PyWhileStatement) {
                return Collections.singletonList(this.mapWhile((PyWhileStatement)element, ctx));
            }
            if (element instanceof PyWithStatement) {
                return Collections.singletonList(this.mapWithStatement((PyWithStatement)element, ctx));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("error processing compound statement of type %s in:\n--\n%s\n--", element.getClass().getSimpleName(), element.getText()), e);
        }
        return this.mapSimpleStatement(element);
    }

    private List<Statement> mapSimpleStatement(PsiElement element) {
        try {
            if (element instanceof PyAugAssignmentStatement) {
                return Collections.singletonList(this.mapAugAssignmentStatement((PyAugAssignmentStatement)element));
            }
            if (element instanceof PyAssertStatement) {
                return Collections.singletonList(this.mapAssertStatement((PyAssertStatement)element));
            }
            if (element instanceof PyAssignmentStatement) {
                return Collections.singletonList(this.mapAssignmentStatement((PyAssignmentStatement)element));
            }
            if (element instanceof PyBreakStatement) {
                return Collections.singletonList(this.mapBreakStatement((PyBreakStatement)element));
            }
            if (element instanceof PyContinueStatement) {
                return Collections.singletonList(this.mapContinueStatement((PyContinueStatement)element));
            }
            if (element instanceof PyDelStatement) {
                return Collections.singletonList(this.mapDelStatement((PyDelStatement)element));
            }
            if (element instanceof PyExpressionStatement) {
                return Collections.singletonList(this.mapExpressionStatement((PyExpressionStatement)element));
            }
            if (element instanceof PyFromImportStatement) {
                return this.mapFromImportStatement((PyFromImportStatement)element);
            }
            if (element instanceof PyGlobalStatement) {
                return Collections.singletonList(this.mapVariableScopeStatement((PyGlobalStatement)element));
            }
            if (element instanceof PyImportStatement) {
                return this.mapImportStatement((PyImportStatement)element);
            }
            if (element instanceof PyNonlocalStatement) {
                return Collections.singletonList(this.mapVariableScopeStatement((PyNonlocalStatement)element));
            }
            if (element instanceof PyPassStatement) {
                return Collections.singletonList(this.mapPassStatement((PyPassStatement)element));
            }
            if (element instanceof PyPrintStatement) {
                return Collections.singletonList(this.mapPrintStatement((PyPrintStatement)element));
            }
            if (element instanceof PyRaiseStatement) {
                return Collections.singletonList(this.mapRaiseStatement((PyRaiseStatement)element));
            }
            if (element instanceof PyReturnStatement) {
                return Collections.singletonList(this.mapReturnStatement((PyReturnStatement)element));
            }
            if (element instanceof PyTypeDeclarationStatement) {
                return Collections.singletonList(this.mapTypeDeclarationStatement((PyTypeDeclarationStatement)element));
            }
            throw new IllegalArgumentException("unknown PSI element type " + element.getNode().getElementType());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("error processing compound statement of type %s in:\n--\n%s\n--", element.getClass().getSimpleName(), element.getText()), e);
        }
    }

    private J.VariableDeclarations mapTypeDeclarationStatement(PyTypeDeclarationStatement element) {
        return new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), (TypeTree)this.mapTypeHint(Objects.requireNonNull(element.getAnnotation())), null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.expectIdentifier(element.getTarget()), Collections.emptyList(), null, null))));
    }

    private J.MethodInvocation mapPrintStatement(PyPrintStatement element) {
        PsiElement print = PsiUtils.findChildToken(element, PyTokenTypes.PRINT_KEYWORD);
        Markers markers = Markers.EMPTY.addIfAbsent((Marker)new OmitParentheses(Tree.randomId()));
        JContainer args = JContainer.build((Space)Space.EMPTY, element.getChildren().length == 0 ? Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY))) : this.mapExpressionsAsRightPadded(element.getChildren()), (Markers)Markers.EMPTY);
        return new J.MethodInvocation(Tree.randomId(), PsiUtils.spaceBefore(print), markers, null, null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, print.getText(), null, null), args, null);
    }

    private J.Throw mapRaiseStatement(PyRaiseStatement element) {
        Object expression;
        if (element.getExpressions().length > 2) {
            throw new IllegalArgumentException("no support for a `raise` statement with >1 expression");
        }
        if (element.getExpressions().length == 0) {
            expression = new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
        } else {
            expression = this.mapExpression(element.getExpressions()[0]);
            if (element.getExpressions().length == 2) {
                JLeftPadded from = JLeftPadded.build((Object)((Expression)this.mapExpression(element.getExpressions()[1]).withPrefix(PsiUtils.spaceBefore(element.getExpressions()[1])))).withBefore(PsiUtils.spaceAfter(element.getExpressions()[0]));
                expression = new Py.ErrorFromExpression(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)expression, (JLeftPadded<Expression>)from, null);
            }
        }
        return new J.Throw(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)expression);
    }

    private Py.VariableScopeStatement mapVariableScopeStatement(PyGlobalStatement element) {
        return this.mapVariableScopeStatement(element, Py.VariableScopeStatement.Kind.GLOBAL);
    }

    private Py.VariableScopeStatement mapVariableScopeStatement(PyNonlocalStatement element) {
        return this.mapVariableScopeStatement(element, Py.VariableScopeStatement.Kind.NONLOCAL);
    }

    private Py.VariableScopeStatement mapVariableScopeStatement(PyStatement element, Py.VariableScopeStatement.Kind kind) {
        ArrayList<JRightPadded<J.Identifier>> names = new ArrayList<JRightPadded<J.Identifier>>();
        for (PsiElement child : element.getChildren()) {
            if (!(child instanceof PyTargetExpression)) continue;
            J.Identifier identifier = this.expectIdentifier(child).withPrefix(PsiUtils.spaceBefore(child));
            names.add((JRightPadded<J.Identifier>)JRightPadded.build((Object)identifier).withAfter(PsiUtils.spaceAfter(child)));
        }
        return new Py.VariableScopeStatement(Tree.randomId(), Space.EMPTY, Markers.EMPTY, kind, names);
    }

    private List<Statement> mapImportElements(PyImportStatementBase element, @Nullable Expression importSource) {
        List<Object> imports = new ArrayList<J.Import>(element.getImportElements().length);
        for (PyImportElement pyImportElement : element.getImportElements()) {
            imports.add(this.mapImportElement(pyImportElement, element, importSource));
        }
        if (imports.size() > 1) {
            UUID groupId = Tree.randomId();
            imports = ListUtils.map(imports, import_ -> (Statement)import_.withMarkers(import_.getMarkers().add((Marker)new GroupedStatement(Tree.randomId(), groupId))));
        }
        PsiElement openParen = PsiUtils.maybeFindChildToken(element, PyTokenTypes.LPAR);
        PsiElement closeParen = PsiUtils.maybeFindChildToken(element, PyTokenTypes.RPAR);
        if (openParen != null && closeParen != null) {
            imports = ListUtils.map(imports, statement -> {
                statement = PythonExtraPadding.set(statement, PythonExtraPadding.Location.IMPORT_PARENS_PREFIX, PsiUtils.spaceBefore(openParen));
                statement = PythonExtraPadding.set(statement, PythonExtraPadding.Location.IMPORT_PARENS_SUFFIX, PsiUtils.spaceBefore(closeParen));
                statement = (Statement)statement.withMarkers(statement.getMarkers().addIfAbsent((Marker)new ImportParens(Tree.randomId())));
                return statement;
            });
        }
        return imports;
    }

    private J.Import mapImportElement(PyImportElement element, PyImportStatementBase parent, @Nullable Expression importSource) {
        PsiElement importKeyword = PsiUtils.findChildToken(parent, PyTokenTypes.IMPORT_KEYWORD);
        NameTree importNameExpr = (NameTree)this.mapQualifiedNameAsNameTree(Objects.requireNonNull(element.getImportReferenceExpression()).asQualifiedName()).withPrefix(PsiUtils.spaceBefore(element));
        J.FieldAccess fieldAccess = importSource == null ? new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)importNameExpr, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null)).withBefore(PsiUtils.spaceBefore(importKeyword)), null) : new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, importSource, JLeftPadded.build((Object)((J.Identifier)importNameExpr)).withBefore(PsiUtils.spaceBefore(importKeyword)), null);
        PyTargetExpression pyAlias = element.getAsNameElement();
        JLeftPadded alias = null;
        if (pyAlias != null) {
            PsiElement asKeyword = PsiUtils.findChildToken(element, PyTokenTypes.AS_KEYWORD);
            J.Identifier aliasId = this.expectIdentifier(this.mapExpression(pyAlias));
            alias = JLeftPadded.build((Object)aliasId.withPrefix(PsiUtils.spaceAfter(asKeyword))).withBefore(PsiUtils.spaceBefore(asKeyword));
        }
        return new J.Import(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JLeftPadded.build((Object)false), fieldAccess, alias);
    }

    private List<Statement> mapImportStatement(PyImportStatement element) {
        return this.mapImportElements(element, null);
    }

    private List<Statement> mapFromImportStatement(PyFromImportStatement element) {
        Expression importSource;
        PsiElement fromKeyword = PsiUtils.findChildToken(element, PyTokenTypes.FROM_KEYWORD);
        Expression fromModuleExpr = element.getImportSource() == null ? null : this.mapReferenceExpression(element.getImportSource());
        Object fromModuleDots = null;
        int relativeLevel = element.getRelativeLevel();
        if (fromModuleExpr == null) {
            ++relativeLevel;
        }
        for (int i = 0; i < relativeLevel; ++i) {
            fromModuleDots = fromModuleDots == null ? new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY) : new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, fromModuleDots, JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null)), null);
        }
        if (fromModuleDots == null && fromModuleExpr == null) {
            throw new IllegalStateException("attempting to map import with no source");
        }
        if (fromModuleDots != null && fromModuleExpr == null) {
            importSource = fromModuleDots;
        } else if (fromModuleDots == null) {
            importSource = fromModuleExpr;
        } else {
            importSource = fromModuleDots;
            Stack<J.FieldAccess> fieldAccessStack = new Stack<J.FieldAccess>();
            J.Identifier originalTarget = null;
            while (originalTarget == null) {
                if (fromModuleExpr instanceof J.FieldAccess) {
                    J.FieldAccess fieldAccess = (J.FieldAccess)fromModuleExpr;
                    fieldAccessStack.add(fieldAccess);
                    fromModuleExpr = fieldAccess.getTarget();
                    continue;
                }
                if (fromModuleExpr instanceof J.Identifier) {
                    originalTarget = (J.Identifier)fromModuleExpr;
                    continue;
                }
                throw new IllegalStateException(String.format("didn't expect a %s in an import qualifier", fromModuleExpr.getClass()));
            }
            importSource = new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, importSource, JLeftPadded.build(originalTarget), null);
            while (!fieldAccessStack.isEmpty()) {
                J.FieldAccess oldFieldAccess = (J.FieldAccess)fieldAccessStack.pop();
                importSource = oldFieldAccess.withTarget(importSource);
            }
        }
        importSource = (Expression)importSource.withPrefix(PsiUtils.spaceAfter(fromKeyword));
        return this.mapImportElements(element, importSource);
    }

    private Statement mapReturnStatement(PyReturnStatement element) {
        return new J.Return(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(element.getExpression()));
    }

    private Statement mapMatchStatement(PyMatchStatement element, BlockContext ctx) {
        Space prefix = ctx.nextStatementPrefix(element);
        JRightPadded<Expression> subject = this.mapExpressionAsRightPadded(Objects.requireNonNull(element.getSubject()));
        J.Block block = this.mapBlock(element, PsiUtils.findChildToken(element, PyTokenTypes.COLON), element.getCaseClauses(), ctx, (clause, innerCtx) -> Collections.singletonList(this.mapCaseClause((PyCaseClause)clause, (BlockContext)innerCtx)));
        return new J.Switch(Tree.randomId(), prefix, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, subject), block);
    }

    private Statement mapCaseClause(PyCaseClause element, BlockContext ctx) {
        Space prefix = ctx.nextStatementPrefix(element);
        JRightPadded pattern = element.getGuardCondition() != null ? JRightPadded.build((Object)new Py.MatchCase(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.mapPattern(Objects.requireNonNull(element.getPattern())), (JLeftPadded<Expression>)JLeftPadded.build((Object)this.mapExpression(element.getGuardCondition())).withBefore(PsiUtils.spaceBefore(PsiUtils.findChildToken(element, PyTokenTypes.IF_KEYWORD))), null)) : this.mapExpressionAsRightPadded(Objects.requireNonNull(element.getPattern()));
        J.Block block = this.mapCompoundBlock(element, ctx);
        return new J.Case(Tree.randomId(), prefix, Markers.EMPTY, J.Case.Type.Statement, JContainer.build(Collections.singletonList(pattern)), JContainer.empty(), JRightPadded.build((Object)block));
    }

    private Statement mapWhile(PyWhileStatement element, BlockContext ctx) {
        Space prefix = ctx.nextStatementPrefix(element);
        return new J.WhileLoop(Tree.randomId(), prefix, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)this.mapExpression(element.getWhilePart().getCondition()))), JRightPadded.build((Object)this.mapCompoundBlock(element.getWhilePart(), ctx)));
    }

    private Statement mapTry(PyTryExceptStatement element, BlockContext ctx) {
        Space tryPrefix = ctx.nextStatementPrefix(element);
        J.Block tryBlock = this.mapCompoundBlock(element.getTryPart(), ctx);
        List catches = Collections.emptyList();
        if (element.getExceptParts().length > 0) {
            catches = new ArrayList(element.getExceptParts().length);
            for (PyExceptPart pyExceptPart : element.getExceptParts()) {
                catches.add(this.mapExcept(pyExceptPart, ctx));
            }
        }
        if (element.getElsePart() != null) {
            Space elsePrefix = ctx.nextStatementPrefix(element.getElsePart());
            tryBlock = tryBlock.getPadding().withStatements(ListUtils.concat((List)tryBlock.getPadding().getStatements(), (Object)JRightPadded.build((Object)this.mapCompoundBlock(element.getElsePart(), ctx)).withAfter(elsePrefix)));
        }
        JLeftPadded finally_ = null;
        if (element.getFinallyPart() != null) {
            Space finallyPrefix = ctx.nextStatementPrefix(element.getFinallyPart());
            finally_ = JLeftPadded.build((Object)this.mapCompoundBlock(element.getFinallyPart(), ctx)).withBefore(finallyPrefix);
        }
        return new J.Try(Tree.randomId(), tryPrefix, Markers.EMPTY, null, tryBlock, catches, finally_);
    }

    private J.Try.Catch mapExcept(PyExceptPart element, BlockContext ctx) {
        Space exceptPrefix = ctx.nextStatementPrefix(element);
        List<Object> parameters = Collections.emptyList();
        PyExpression pyExceptClass = element.getExceptClass();
        PyExpression pyTarget = element.getTarget();
        Py.ExceptionType typeExpression = null;
        if (pyExceptClass != null) {
            String name = "";
            if (pyTarget != null) {
                name = pyTarget.getText();
            }
            typeExpression = new Py.ExceptionType(Tree.randomId(), PsiUtils.spaceAfter(PsiUtils.findChildToken(element, PyTokenTypes.EXCEPT_KEYWORD)), Markers.EMPTY, null, element.isStar(), (Expression)this.mapExpression(pyExceptClass).withPrefix(element.isStar() ? PsiUtils.spaceBefore(pyExceptClass) : Space.EMPTY));
            parameters = Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), PsiUtils.spaceAfter(pyExceptClass), Markers.EMPTY, new J.Identifier(Tree.randomId(), PsiUtils.spaceBefore(pyTarget), Markers.EMPTY, name, null, null), Collections.emptyList(), null, null)));
        }
        return new J.Try.Catch(Tree.randomId(), exceptPrefix, Markers.EMPTY, new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), typeExpression, null, Collections.emptyList(), parameters))), this.mapCompoundBlock(element, ctx));
    }

    private Statement mapWithStatement(PyWithStatement element, BlockContext ctx) {
        Space statementPrefix = ctx.nextStatementPrefix();
        List<JRightPadded> resources = new ArrayList(element.getWithItems().length);
        for (PyWithItem pyWithItem : element.getWithItems()) {
            @Nullable PsiElement asToken = PsiUtils.maybeFindChildToken(pyWithItem, PyTokenTypes.AS_KEYWORD);
            Object variable = pyWithItem.getTarget() != null ? (Expression)this.mapExpression(pyWithItem.getTarget()).withPrefix(PsiUtils.spaceAfter(asToken)) : new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY);
            JLeftPadded assignment = JLeftPadded.build((Object)((Expression)this.mapExpression(pyWithItem.getExpression()).withPrefix(Space.EMPTY))).withBefore(PsiUtils.spaceBefore(asToken));
            J.Try.Resource resource2 = new J.Try.Resource(Tree.randomId(), PsiUtils.spaceBefore(pyWithItem), Markers.EMPTY, (TypedTree)new J.Assignment(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)variable, assignment, null), false);
            resources.add(JRightPadded.build((Object)resource2).withAfter(PsiUtils.spaceAfter(pyWithItem)));
        }
        resources = ListUtils.mapLast(resources, resource -> resource.withAfter(Space.EMPTY));
        return new J.Try(Tree.randomId(), statementPrefix, Markers.EMPTY, JContainer.build(resources), this.mapCompoundBlock(element, ctx), Collections.emptyList(), null);
    }

    private Statement mapContinueStatement(PyContinueStatement element) {
        return new J.Continue(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null);
    }

    private Statement mapBreakStatement(PyBreakStatement element) {
        return new J.Break(Tree.randomId(), Space.EMPTY, Markers.EMPTY, null);
    }

    private Statement mapForStatement(PyForStatement element, BlockContext ctx) {
        Space prefix = ctx.nextStatementPrefix(element);
        PyForPart forPart = element.getForPart();
        J.VariableDeclarations target = this.mapAsVariableDeclarations(Objects.requireNonNull(forPart.getTarget()));
        J.ForEachLoop loop = new J.ForEachLoop(Tree.randomId(), prefix, Markers.EMPTY, new J.ForEachLoop.Control(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)target).withAfter(PsiUtils.spaceAfter(forPart.getTarget())), JRightPadded.build((Object)this.mapExpression(forPart.getSource()))), JRightPadded.build((Object)this.mapCompoundBlock(forPart, ctx)));
        if (element.getElsePart() != null) {
            Space elsePrefix = ctx.nextStatementPrefix(element.getElsePart());
            return new Py.TrailingElseWrapper(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Statement)loop, (JLeftPadded<J.Block>)JLeftPadded.build((Object)this.mapCompoundBlock(element.getElsePart(), ctx)).withBefore(elsePrefix));
        }
        return loop;
    }

    private J.VariableDeclarations mapAsVariableDeclarations(PyExpression pyExpression) {
        if (pyExpression instanceof PyTargetExpression) {
            return this.mapTargetExpressionAsVariableDeclarations((PyTargetExpression)pyExpression);
        }
        if (pyExpression instanceof PyTupleExpression) {
            return this.mapTupleAsVariableDeclarations((PyTupleExpression)pyExpression);
        }
        return new J.VariableDeclarations(Tree.randomId(), PsiUtils.spaceBefore(pyExpression), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)this.mapAssignmentTarget(pyExpression).withPrefix(Space.EMPTY))));
    }

    private J.VariableDeclarations mapTargetExpressionAsVariableDeclarations(PyTargetExpression element) {
        return new J.VariableDeclarations(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), PsiUtils.spaceBefore(element.getNameIdentifier()), Markers.EMPTY, this.expectIdentifier(element.getNameIdentifier()), Collections.emptyList(), null, null))));
    }

    private J.VariableDeclarations mapTupleAsVariableDeclarations(PyTupleExpression element) {
        PyExpression[] pyTargets;
        ArrayList<JRightPadded> namedVariables = new ArrayList<JRightPadded>(element.getElements().length);
        for (PyExpression pyExpression : pyTargets = element.getElements()) {
            namedVariables.add(JRightPadded.build((Object)this.mapAssignmentTarget(pyExpression)).withAfter(PsiUtils.spaceBefore(pyExpression.getNextSibling())));
        }
        return new J.VariableDeclarations(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), null, null, Collections.emptyList(), namedVariables);
    }

    private J.VariableDeclarations.NamedVariable mapAssignmentTarget(PyExpression pyExpression) {
        JLeftPadded initializer;
        J.Identifier name;
        Expression mapped = (Expression)this.mapExpression(pyExpression).withPrefix(Space.EMPTY);
        if (mapped instanceof J.Identifier) {
            name = (J.Identifier)mapped;
            initializer = null;
        } else {
            name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null);
            initializer = JLeftPadded.build((Object)mapped);
        }
        return new J.VariableDeclarations.NamedVariable(Tree.randomId(), PsiUtils.spaceBefore(pyExpression), Markers.EMPTY, name, Collections.emptyList(), initializer, null);
    }

    private Statement mapFunction(PyFunction element, BlockContext ctx) {
        JContainer params;
        Space after;
        List<J.Annotation> annotations = this.mapDecoratorList(element.getDecoratorList(), ctx);
        PsiElement rParen = PsiUtils.maybeFindChildToken(element.getParameterList(), PyTokenTypes.RPAR);
        Space space = after = rParen == null ? Space.EMPTY : PsiUtils.spaceBefore(rParen);
        if (element.getParameterList().getParameters().length == 0) {
            params = JContainer.build((Space)PsiUtils.spaceAfter(element.getNameIdentifier()), Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), after, Markers.EMPTY))), (Markers)Markers.EMPTY);
        } else {
            PyParameter @NotNull [] pyParameters = element.getParameterList().getParameters();
            ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(pyParameters.length);
            for (int i = 0; i < pyParameters.length; ++i) {
                PyParameter parameter = pyParameters[i];
                statements.add(JRightPadded.build((Object)((Statement)this.mapFunctionParameter(parameter).withPrefix(PsiUtils.spaceBefore(parameter)))).withAfter(i < pyParameters.length - 1 ? PsiUtils.spaceAfter(parameter) : after));
            }
            params = JContainer.build((Space)PsiUtils.spaceAfter(element.getNameIdentifier()), statements, (Markers)Markers.EMPTY);
        }
        List<Object> modifiers = new ArrayList<J.Modifier>();
        PsiElement asyncToken = PsiUtils.maybeFindChildToken(element, PyTokenTypes.ASYNC_KEYWORD);
        if (asyncToken != null) {
            modifiers.add(new J.Modifier(Tree.randomId(), PsiUtils.spaceBefore(asyncToken), Markers.EMPTY, J.Modifier.Type.Async, Collections.emptyList()));
        }
        PsiElement defToken = PsiUtils.findChildToken(element, PyTokenTypes.DEF_KEYWORD);
        modifiers.add(new J.Modifier(Tree.randomId(), PsiUtils.spaceBefore(defToken), Markers.EMPTY, J.Modifier.Type.Default, Collections.emptyList()));
        Space firstModifierPrefix = ctx.nextStatementPrefix();
        modifiers = ListUtils.mapFirst(modifiers, mod -> mod.withPrefix(firstModifierPrefix));
        return new J.MethodDeclaration(Tree.randomId(), Space.EMPTY, Markers.EMPTY, annotations, modifiers, null, (TypeTree)this.mapTypeHintNullable(element.getAnnotation()), new J.MethodDeclaration.IdentifierWithAnnotations(this.mapIdentifier(element).withPrefix(PsiUtils.spaceBefore(element.getNameIdentifier())), Collections.emptyList()), params, null, this.mapCompoundBlock(element, ctx), null, null);
    }

    private Statement mapFunctionParameter(PyElement element) {
        JLeftPadded defaultValue;
        Py.SpecialParameter.Kind specialParamKind;
        Py.TypeHint typeHint;
        J.Identifier name;
        if (element instanceof PyNamedParameter) {
            PyNamedParameter namedParameter = (PyNamedParameter)element;
            name = this.expectIdentifier(namedParameter.getNameIdentifier());
            typeHint = this.mapTypeHintNullable(namedParameter.getAnnotation());
            specialParamKind = namedParameter.isKeywordContainer() ? Py.SpecialParameter.Kind.KWARGS : (namedParameter.isPositionalContainer() ? Py.SpecialParameter.Kind.ARGS : null);
            defaultValue = null;
            if (namedParameter.hasDefaultValue()) {
                defaultValue = JLeftPadded.build((Object)this.mapExpression(namedParameter.getDefaultValue())).withBefore(PsiUtils.spaceBefore(namedParameter.getDefaultValue()));
            }
        } else if (element instanceof PySingleStarParameter) {
            specialParamKind = Py.SpecialParameter.Kind.ARGS;
            name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "", null, null);
            defaultValue = null;
            typeHint = null;
        } else {
            throw new IllegalArgumentException(String.format("expected function parameter to be a NamedParameter or StarArgument; found: %s\n%s", element.getClass().getSimpleName(), element.getText()));
        }
        Py type = specialParamKind != null ? new Py.SpecialParameter(Tree.randomId(), Space.EMPTY, Markers.EMPTY, specialParamKind, typeHint, null) : typeHint;
        return new J.VariableDeclarations(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), (TypeTree)type, null, Collections.emptyList(), Collections.singletonList(JRightPadded.build((Object)new J.VariableDeclarations.NamedVariable(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, Collections.emptyList(), defaultValue, null))));
    }

    public Statement mapAssertStatement(PyAssertStatement element) {
        return new Py.AssertStatement(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpressionsAsRightPadded(element.getArguments()));
    }

    public Statement mapAugAssignmentStatement(PyAugAssignmentStatement element) {
        PyExpression pyLhs = element.getTarget();
        PyExpression pyRhs = element.getValue();
        Expression lhs = this.mapExpression(pyLhs);
        Expression rhs = (Expression)this.mapExpression(pyRhs).withPrefix(PsiUtils.spaceBefore(pyRhs));
        IElementType pyOp = element.getOperation().getNode().getElementType();
        J.AssignmentOperation.Type type = augAssignmentOps.get(pyOp);
        return new J.AssignmentOperation(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, lhs, JLeftPadded.build((Object)type).withBefore(PsiUtils.spaceAfter(pyLhs)), rhs, null);
    }

    public Statement mapAssignmentStatement(PyAssignmentStatement element) {
        PyExpression pyLhs = element.getLeftHandSideExpression();
        PyExpression pyRhs = element.getAssignedValue();
        PsiElement equalsToken = PsiUtils.findChildToken(element, PyTokenTypes.EQ);
        Expression lhs = this.mapExpression(pyLhs);
        JLeftPadded rhs = JLeftPadded.build((Object)((Expression)this.mapExpression(pyRhs).withPrefix(PsiUtils.spaceAfter(equalsToken)))).withBefore(PsiUtils.spaceBefore(equalsToken));
        return new J.Assignment(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, lhs, rhs, null);
    }

    public Expression mapAssignmentExpression(PyAssignmentExpression element) {
        PyTargetExpression pyLhs = element.getTarget();
        PyExpression pyRhs = element.getAssignedValue();
        Expression lhs = this.mapExpression(pyLhs);
        Expression rhs = (Expression)this.mapExpression(pyRhs).withPrefix(PsiUtils.spaceBefore(pyRhs));
        return new J.Assignment(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, lhs, JLeftPadded.build((Object)rhs).withBefore(PsiUtils.spaceAfter(pyLhs)), null);
    }

    public Statement mapClassDeclarationStatement(PyClass element, BlockContext ctx) {
        JContainer implementings;
        List<J.Annotation> decorators = this.mapDecoratorList(element.getDecoratorList(), ctx);
        Space kindPrefix = ctx.nextStatementPrefix(PsiUtils.findChildToken(element, PyTokenTypes.CLASS_KEYWORD));
        J.ClassDeclaration.Kind kind = new J.ClassDeclaration.Kind(Tree.randomId(), kindPrefix, Markers.EMPTY, decorators, J.ClassDeclaration.Kind.Type.Class);
        PyArgumentList pyClassBase = element.getSuperClassExpressionList();
        if (pyClassBase != null) {
            if (element.getSuperClassExpressions().length > 0) {
                PyExpression[] superClassExpressions;
                ArrayList<JRightPadded> superClasses = new ArrayList<JRightPadded>(element.getSuperClassExpressions().length);
                for (PyExpression superClass : superClassExpressions = element.getSuperClassExpressions()) {
                    if (!(superClass instanceof PyReferenceExpression)) {
                        throw new RuntimeException("cannot support non-constant base classes");
                    }
                    superClasses.add(JRightPadded.build((Object)((TypeTree)this.mapReferenceExpression((PyReferenceExpression)superClass).withPrefix(PsiUtils.spaceBefore(superClass)))).withAfter(PsiUtils.spaceAfter(superClass)));
                }
                implementings = JContainer.build(superClasses);
            } else {
                implementings = JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), PsiUtils.spaceBefore(pyClassBase.getNode().getLastChildNode().getPsi()), Markers.EMPTY))));
            }
        } else {
            implementings = JContainer.empty();
            implementings = implementings.withMarkers(implementings.getMarkers().add((Marker)new OmitParentheses(Tree.randomId())));
        }
        return new J.ClassDeclaration(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), Collections.emptyList(), kind, this.expectIdentifier(element.getNameNode()), null, null, null, implementings.withBefore(PsiUtils.spaceBefore(element.getSuperClassExpressionList())), null, this.mapCompoundBlock(element, ctx), null);
    }

    public J.Annotation mapDecorator(PyDecorator pyDecorator) {
        NameTree name = this.mapQualifiedNameAsNameTree(Objects.requireNonNull(pyDecorator.getQualifiedName()));
        JContainer<Expression> arguments = this.mapArgumentList(pyDecorator.getArgumentList());
        return new J.Annotation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, name, arguments);
    }

    public List<J.Annotation> mapDecoratorList(@Nullable PyDecoratorList pyDecoratorList, BlockContext ctx) {
        if (pyDecoratorList == null || pyDecoratorList.getDecorators().length == 0) {
            return Collections.emptyList();
        }
        PyDecorator[] pyDecorators = pyDecoratorList.getDecorators();
        ArrayList<J.Annotation> decorators = new ArrayList<J.Annotation>(pyDecorators.length);
        for (PyDecorator pyDecorator : pyDecorators) {
            J.Annotation mapped = this.mapDecorator(pyDecorator);
            Space prefix = ctx.nextStatementPrefix(pyDecorator);
            mapped = mapped.withPrefix(prefix);
            ctx.paddingCursor.resetToSpaceAfter(pyDecorator);
            Space suffix = ctx.paddingCursor.consumeUntilExpectedNewline();
            suffix = PySpace.deindent(suffix, ctx.fullIndent, PySpace.IndentStartMode.AFTER_STATEMENT, PySpace.IndentEndMode.REST_OF_LINE);
            mapped = PythonExtraPadding.set(mapped, PythonExtraPadding.Location.AFTER_DECORATOR, suffix);
            decorators.add(mapped);
        }
        return decorators;
    }

    public Statement mapDelStatement(PyDelStatement element) {
        return new Py.DelStatement(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpressionsAsRightPadded(element.getTargets()));
    }

    public Statement mapIfStatement(PyIfStatement element, BlockContext ctx) {
        Space ifPrefix = ctx.nextStatementPrefix();
        PyExpression pyIfCondition = element.getIfPart().getCondition();
        if (pyIfCondition == null) {
            throw new RuntimeException("if condition is null");
        }
        J.Block ifBody = this.mapCompoundBlock(element.getIfPart(), ctx);
        J.If.Else elsePart = this.mapElsePart(element, 0, ctx);
        return new J.If(Tree.randomId(), ifPrefix, Markers.EMPTY, this.mapExpressionAsControlParentheses(pyIfCondition), JRightPadded.build((Object)ifBody), elsePart);
    }

    private J.If.Else mapElsePart(PyIfStatement parent, int elifIndex, BlockContext ctx) {
        if (elifIndex < parent.getElifParts().length) {
            PyIfPart pyElifPart = parent.getElifParts()[elifIndex];
            PyExpression pyIfCondition = pyElifPart.getCondition();
            if (pyIfCondition == null) {
                throw new RuntimeException("if condition is null");
            }
            Space prefix = ctx.nextStatementPrefix(pyElifPart);
            J.Block thenPart = this.mapCompoundBlock(pyElifPart, ctx);
            J.If.Else elsePart = this.mapElsePart(parent, elifIndex + 1, ctx);
            J.If nestedIf = new J.If(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.mapExpressionAsControlParentheses(pyIfCondition), JRightPadded.build((Object)thenPart), elsePart);
            return new J.If.Else(Tree.randomId(), prefix, Markers.EMPTY, JRightPadded.build((Object)nestedIf));
        }
        if (parent.getElsePart() != null) {
            Space prefix = ctx.nextStatementPrefix(parent.getElsePart());
            J.Block elsePart = this.mapCompoundBlock(parent.getElsePart(), ctx);
            return new J.If.Else(Tree.randomId(), prefix, Markers.EMPTY, JRightPadded.build((Object)elsePart));
        }
        return null;
    }

    public Py.PassStatement mapPassStatement(PyPassStatement element) {
        return new Py.PassStatement(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY);
    }

    public <T extends PyStatement> J.Block mapBlock(PsiElement container, @Nullable PsiElement colonToken, List<T> pyStatements, BlockContext ctx) {
        return this.mapBlock(container, colonToken, pyStatements, ctx, this::mapStatement);
    }

    /*
     * WARNING - void declaration
     */
    public <T extends PsiElement> J.Block mapBlock(PsiElement container, @Nullable PsiElement colonToken, List<T> pyStatements, BlockContext outerCtx, BiFunction<T, BlockContext, List<? extends Statement>> mapFn) {
        BlockContext innerCtx;
        Space blockPrefix;
        PsiPaddingCursor paddingCursor = outerCtx.paddingCursor;
        ArrayList<JRightPadded> statements = new ArrayList<JRightPadded>(pyStatements.size());
        if (colonToken != null) {
            blockPrefix = paddingCursor.consumeUntilNewlineOrRollback();
            if (blockPrefix == null) {
                blockPrefix = Space.EMPTY;
            }
            paddingCursor.resetToSpaceAfter(colonToken);
            Space firstPrefix = paddingCursor.withRollback(paddingCursor::consumeRemaining);
            String containerIndent = outerCtx.fullIndent;
            String fullIndent = firstPrefix.getIndent();
            if (!fullIndent.startsWith(containerIndent)) {
                throw new IllegalStateException(String.format("expected full block indent (%s) to start with container indent (%s)", Space.build((String)fullIndent, Collections.emptyList()), Space.build((String)containerIndent, Collections.emptyList())));
            }
            String blockIndent = fullIndent.substring(containerIndent.length());
            blockPrefix = PySpace.appendWhitespace(blockPrefix, "\n" + blockIndent);
            innerCtx = new BlockContext(fullIndent, false, paddingCursor);
        } else {
            blockPrefix = PySpace.appendWhitespace(paddingCursor.consumeRemaining(), "\n");
            innerCtx = new BlockContext("", true, paddingCursor);
        }
        boolean precededBySemicolon = false;
        for (PsiElement pyStatement : pyStatements) {
            PsiElement semicolon;
            Space after;
            Space prefix;
            List<Statement> mapped = mapFn.apply(pyStatement, innerCtx);
            JRightPadded maybeEmptyStatement = null;
            if (paddingCursor.isPast(pyStatement)) {
                prefix = null;
                after = Space.EMPTY;
                semicolon = null;
            } else {
                PsiElement maybeSemicolon;
                prefix = paddingCursor.consumeRemainingAndExpect(pyStatement);
                semicolon = PsiUtils.maybeFindChildToken(pyStatement, PyTokenTypes.SEMICOLON);
                if (semicolon == null && PsiUtils.isLeafToken(maybeSemicolon = PsiUtils.nextSiblingSkipWhitespace(pyStatement), PyTokenTypes.SEMICOLON)) {
                    semicolon = maybeSemicolon;
                }
                if (semicolon != null) {
                    paddingCursor.resetToSpaceBefore(semicolon);
                    after = paddingCursor.consumeRemainingAndExpect(semicolon);
                    paddingCursor.resetToSpaceAfter(semicolon);
                    maybeEmptyStatement = paddingCursor.consumeUntilNewlineOrRollback(newlineAfterSemicolon -> JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(newlineAfterSemicolon));
                } else {
                    paddingCursor.resetToTrailingSpaceWithin(pyStatement);
                    after = paddingCursor.consumeUntilNewline();
                }
                if (!precededBySemicolon) {
                    prefix = PySpace.deindent(prefix, innerCtx.fullIndent, PySpace.IndentStartMode.LINE_START, PySpace.IndentEndMode.STATEMENT_START);
                }
            }
            for (Statement statement : mapped) {
                void var19_20;
                if (prefix != null) {
                    Statement statement2 = (Statement)statement.withPrefix(prefix);
                }
                statements.add(JRightPadded.build((Object)var19_20).withAfter(after));
            }
            if (maybeEmptyStatement != null) {
                statements.add(maybeEmptyStatement);
            }
            precededBySemicolon = semicolon != null && maybeEmptyStatement == null;
        }
        Markers markers = Markers.EMPTY;
        Space spaceBeforeColon = PsiUtils.spaceBefore(colonToken);
        if (!spaceBeforeColon.isEmpty()) {
            markers = Markers.build(Collections.singletonList(new PythonExtraPadding(Tree.randomId(), PythonExtraPadding.Location.BEFORE_COMPOUND_BLOCK_COLON, spaceBeforeColon)));
        }
        return new J.Block(Tree.randomId(), blockPrefix, markers, JRightPadded.build((Object)false), statements, Space.EMPTY);
    }

    public J.Block mapCompoundBlock(PyStatementListContainer pyElement, BlockContext ctx) {
        return this.mapBlock(pyElement, PsiUtils.findChildToken(pyElement, PyTokenTypes.COLON), Arrays.asList(pyElement.getStatementList().getStatements()), ctx);
    }

    public Expression mapExpression(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        try {
            if (element instanceof LeafPsiElement && PsiUtils.isLeafToken(element, PyTokenTypes.IDENTIFIER)) {
                return this.expectIdentifier(element);
            }
            if (element instanceof PyPattern) {
                return this.mapPattern((PyPattern)element);
            }
            if (element instanceof PyAssignmentExpression) {
                return this.mapAssignmentExpression((PyAssignmentExpression)element);
            }
            if (element instanceof PyBinaryExpression) {
                return this.mapBinaryExpression((PyBinaryExpression)element);
            }
            if (element instanceof PyBoolLiteralExpression) {
                return this.mapBooleanLiteral((PyBoolLiteralExpression)element);
            }
            if (element instanceof PyCallExpression) {
                return this.mapCallExpression((PyCallExpression)element);
            }
            if (element instanceof PyComprehensionElement) {
                return this.mapComprehensionElement((PyComprehensionElement)element);
            }
            if (element instanceof PyConditionalExpression) {
                return this.mapConditionalExpression((PyConditionalExpression)element);
            }
            if (element instanceof PyDictLiteralExpression) {
                return this.mapDictLiteralExpression((PyDictLiteralExpression)element);
            }
            if (element instanceof PyKeyValueExpression) {
                return this.mapKeyValueExpression((PyKeyValueExpression)element);
            }
            if (element instanceof PyKeywordArgument) {
                return this.mapKeywordArgument((PyKeywordArgument)element);
            }
            if (element instanceof PyLambdaExpression) {
                return this.mapLambdaExpression((PyLambdaExpression)element);
            }
            if (element instanceof PyListLiteralExpression) {
                return this.mapListLiteral((PyListLiteralExpression)element);
            }
            if (element instanceof PyNoneLiteralExpression) {
                return this.mapNoneLiteral((PyNoneLiteralExpression)element);
            }
            if (element instanceof PyNumericLiteralExpression) {
                return this.mapNumericLiteral((PyNumericLiteralExpression)element);
            }
            if (element instanceof PyParenthesizedExpression) {
                return this.mapParenthesizedExpression((PyParenthesizedExpression)element);
            }
            if (element instanceof PyPrefixExpression) {
                return this.mapPrefixExpression((PyPrefixExpression)element);
            }
            if (element instanceof PyReferenceExpression) {
                return this.mapReferenceExpression((PyReferenceExpression)element);
            }
            if (element instanceof PySetLiteralExpression) {
                return this.mapSetLiteral((PySetLiteralExpression)element);
            }
            if (element instanceof PySliceExpression) {
                return this.mapSliceExpression((PySliceExpression)element);
            }
            if (element instanceof PyStarArgument) {
                return this.mapStarArgument((PyStarArgument)element);
            }
            if (element instanceof PyStarExpression) {
                return this.mapStarExpression((PyStarExpression)element);
            }
            if (element instanceof PySubscriptionExpression) {
                return this.mapSubscription((PySubscriptionExpression)element);
            }
            if (element instanceof PyStringLiteralExpression) {
                return this.mapStringLiteral((PyStringLiteralExpression)element);
            }
            if (element instanceof PyTargetExpression) {
                return this.mapTargetExpression((PyTargetExpression)element);
            }
            if (element instanceof PyTupleExpression) {
                return this.mapTupleLiteral((PyTupleExpression)element);
            }
            if (element instanceof PyYieldExpression) {
                return this.mapYieldExpression((PyYieldExpression)element);
            }
            throw new IllegalArgumentException("unknown PSI element type " + element.getNode().getElementType());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("error processing expression of type %s in:\n--\n%s\n--", element.getClass().getSimpleName(), element.getText()), e);
        }
    }

    private Expression mapStarArgument(PyStarArgument element) {
        return new Py.SpecialArgument(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, element.isKeyword() ? Py.SpecialArgument.Kind.KWARGS : Py.SpecialArgument.Kind.ARGS, this.mapExpression(element.getLastChild()), null);
    }

    private Expression mapStarExpression(PyStarExpression element) {
        return new Py.SpecialArgument(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, Py.SpecialArgument.Kind.ARGS, this.mapExpression(element.getLastChild()), null);
    }

    private Expression mapConditionalExpression(PyConditionalExpression element) {
        return new J.Ternary(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(element.getCondition()), new JLeftPadded(PsiUtils.spaceBefore(PsiUtils.findChildToken(element, PyTokenTypes.IF_KEYWORD)), (Object)this.mapExpression(element.getTruePart()), Markers.EMPTY), new JLeftPadded(PsiUtils.spaceBefore(PsiUtils.findChildToken(element, PyTokenTypes.ELSE_KEYWORD)), (Object)this.mapExpression(element.getFalsePart()), Markers.EMPTY), null);
    }

    private Py.MatchCase.Pattern mapPattern(PyPattern pattern) {
        JContainer children;
        Py.MatchCase.Pattern.Kind kind;
        if (pattern instanceof PyAsPattern) {
            kind = Py.MatchCase.Pattern.Kind.AS;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PyCapturePattern) {
            kind = Py.MatchCase.Pattern.Kind.CAPTURE;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PyClassPattern) {
            kind = Py.MatchCase.Pattern.Kind.CLASS;
            JRightPadded<Expression> className = this.mapExpressionAsRightPadded(pattern.getChildren()[0]);
            PyPatternArgumentList pyArgList = (PyPatternArgumentList)pattern.getChildren()[1];
            List<JRightPadded<Expression>> args = this.mapExpressionsAsRightPadded(pyArgList.getChildren());
            children = JContainer.build((List)ListUtils.concat(className, args));
        } else if (pattern instanceof PyDoubleStarPattern) {
            kind = Py.MatchCase.Pattern.Kind.DOUBLE_STAR;
            children = JContainer.build((Space)PsiUtils.spaceAfter(PsiUtils.findChildToken(pattern, PyTokenTypes.EXP)), this.mapExpressionsAsRightPadded(pattern.getChildren()), (Markers)Markers.EMPTY);
        } else if (pattern instanceof PyGroupPattern) {
            kind = Py.MatchCase.Pattern.Kind.GROUP;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PyKeyValuePattern) {
            kind = Py.MatchCase.Pattern.Kind.KEY_VALUE;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PyKeywordPattern) {
            kind = Py.MatchCase.Pattern.Kind.KEYWORD;
            PyKeywordPattern keywordPattern = (PyKeywordPattern)pattern;
            children = JContainer.build(this.mapExpressionsAsRightPadded(new PsiElement[]{keywordPattern.getKeywordElement(), keywordPattern.getValuePattern()}));
        } else if (pattern instanceof PyLiteralPattern) {
            kind = Py.MatchCase.Pattern.Kind.LITERAL;
            children = JContainer.build(Collections.singletonList(this.mapExpressionAsRightPadded(((PyLiteralPattern)pattern).getExpression())));
        } else if (pattern instanceof PyMappingPattern) {
            kind = Py.MatchCase.Pattern.Kind.MAPPING;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PyOrPattern) {
            kind = Py.MatchCase.Pattern.Kind.OR;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PySequencePattern) {
            PsiElement openToken = PsiUtils.maybeFindFirstChildToken(pattern, PyTokenTypes.LBRACKET, PyTokenTypes.LPAR);
            kind = openToken == null ? Py.MatchCase.Pattern.Kind.SEQUENCE : (openToken.getNode().getElementType() == PyTokenTypes.LBRACKET ? Py.MatchCase.Pattern.Kind.SEQUENCE_LIST : Py.MatchCase.Pattern.Kind.SEQUENCE_TUPLE);
            children = JContainer.build((Space)PsiUtils.spaceAfter(openToken), this.mapExpressionsAsRightPadded(pattern.getChildren()), (Markers)Markers.EMPTY);
        } else if (pattern instanceof PySingleStarPattern) {
            kind = Py.MatchCase.Pattern.Kind.STAR;
            children = JContainer.build((Space)PsiUtils.spaceAfter(PsiUtils.findChildToken(pattern, PyTokenTypes.MULT)), this.mapExpressionsAsRightPadded(pattern.getChildren()), (Markers)Markers.EMPTY);
        } else if (pattern instanceof PyValuePattern) {
            kind = Py.MatchCase.Pattern.Kind.VALUE;
            children = JContainer.build(this.mapExpressionsAsRightPadded(pattern.getChildren()));
        } else if (pattern instanceof PyWildcardPattern) {
            kind = Py.MatchCase.Pattern.Kind.WILDCARD;
            children = JContainer.empty();
        } else {
            throw new IllegalArgumentException(String.format("unhandled case pattern of type %s", pattern.getClass().getSimpleName()));
        }
        return new Py.MatchCase.Pattern(Tree.randomId(), PsiUtils.spaceBefore(pattern), Markers.EMPTY, kind, (JContainer<Expression>)children, null);
    }

    @Nullable
    private Py.TypeHint mapTypeHintNullable(@Nullable PyAnnotation element) {
        if (element == null) {
            return null;
        }
        return this.mapTypeHint(element);
    }

    private Py.TypeHint mapTypeHint(PyAnnotation element) {
        Py.TypeHint.Kind kind;
        IElementType kindToken = element.getNode().getFirstChildNode().getElementType();
        if (kindToken == PyTokenTypes.RARROW) {
            kind = Py.TypeHint.Kind.RETURN_TYPE;
        } else if (kindToken == PyTokenTypes.COLON) {
            kind = Py.TypeHint.Kind.VARIABLE_TYPE;
        } else {
            throw new IllegalArgumentException(String.format("unrecognized type hint start token: %s", kindToken));
        }
        return new Py.TypeHint(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, kind, this.mapExpression(element.getValue()), null);
    }

    private J.Lambda mapLambdaExpression(PyLambdaExpression pyExpression) {
        PyParameterList pyParams = pyExpression.getParameterList();
        ArrayList<JRightPadded> params = new ArrayList<JRightPadded>(pyParams.getParameters().length);
        for (PyParameter pyParam : pyParams.getParameters()) {
            params.add(JRightPadded.build((Object)this.mapFunctionParameter(pyParam).withPrefix(PsiUtils.spaceBefore(pyParam))).withAfter(PsiUtils.spaceAfter(pyParam)));
        }
        return new J.Lambda(Tree.randomId(), PsiUtils.spaceBefore(pyExpression), Markers.EMPTY, new J.Lambda.Parameters(Tree.randomId(), PsiUtils.spaceBefore(pyParams), Markers.EMPTY, false, params), PsiUtils.spaceAfter(pyParams), (J)this.mapExpression(pyExpression.getBody()), null);
    }

    private J.ControlParentheses<Expression> mapExpressionAsControlParentheses(PyExpression pyExpression) {
        return new J.ControlParentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, this.mapExpressionAsRightPadded(pyExpression));
    }

    private JRightPadded<Expression> mapExpressionAsRightPadded(PsiElement pyExpression) {
        Expression expression = this.mapExpression(pyExpression);
        return JRightPadded.build((Object)expression).withAfter(PsiUtils.spaceAfter(pyExpression));
    }

    private List<JRightPadded<Expression>> mapExpressionsAsRightPadded(PsiElement[] pyExpressions) {
        if (pyExpressions.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<JRightPadded<Expression>> expressions = new ArrayList<JRightPadded<Expression>>(pyExpressions.length);
        for (PsiElement pyExpression : pyExpressions) {
            Expression expression = this.mapExpression(pyExpression);
            expressions.add((JRightPadded<Expression>)JRightPadded.build((Object)expression).withAfter(PsiUtils.spaceAfter(pyExpression)));
        }
        return expressions;
    }

    private Expression mapDictLiteralExpression(PyDictLiteralExpression element) {
        ArrayList<JRightPadded> elements = new ArrayList<JRightPadded>(element.getElements().length);
        for (PyKeyValueExpression e : element.getElements()) {
            elements.add(JRightPadded.build((Object)this.mapKeyValueExpression(e)).withAfter(PsiUtils.spaceAfter(e)));
        }
        Py.DictLiteral literal = new Py.DictLiteral(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, (JContainer<Py.KeyValue>)JContainer.build(elements), null);
        if (elements.isEmpty()) {
            literal = PythonExtraPadding.set(literal, PythonExtraPadding.Location.EMPTY_INITIALIZER, PsiUtils.spaceAfter(PsiUtils.findChildToken(element, PyTokenTypes.LBRACE)));
        }
        return literal;
    }

    private Py.KeyValue mapKeyValueExpression(PyKeyValueExpression element) {
        return new Py.KeyValue(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpressionAsRightPadded(element.getKey()), this.mapExpression(element.getValue()), null);
    }

    private Expression mapSequenceExpressionAsArray(PySequenceExpression element) {
        List<JRightPadded<Expression>> exprs;
        if (element.getElements().length == 0) {
            Space space = Space.EMPTY;
            if (element.getNode().getChildren(null).length > 0) {
                PsiElement lastChild = element.getNode().getLastChildNode().getPsi();
                space = lastChild instanceof PsiWhiteSpace ? PsiUtils.trailingSpace(element) : PsiUtils.spaceBefore(lastChild);
            }
            exprs = Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY)).withAfter(space));
        } else {
            exprs = this.mapExpressionsAsRightPadded(element.getElements());
        }
        return new J.NewArray(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, null, Collections.emptyList(), JContainer.build(exprs), null);
    }

    public Expression mapComprehensionElement(PyComprehensionElement element) {
        Py.ComprehensionExpression.Kind kind;
        if (element instanceof PyListCompExpression) {
            kind = Py.ComprehensionExpression.Kind.LIST;
        } else if (element instanceof PySetCompExpression) {
            kind = Py.ComprehensionExpression.Kind.SET;
        } else if (element instanceof PyDictCompExpression) {
            kind = Py.ComprehensionExpression.Kind.DICT;
        } else if (element instanceof PyGeneratorExpression) {
            kind = Py.ComprehensionExpression.Kind.GENERATOR;
        } else {
            throw new IllegalArgumentException(String.format("unknown comprehension type: %s", element.getNode().getElementType()));
        }
        List<Py.ComprehensionExpression.Clause> clauses = new ArrayList<Py.ComprehensionExpression.Clause>();
        for (PyComprehensionComponent ifOrFor : element.getComponents()) {
            if (ifOrFor instanceof PyComprehensionForComponent) {
                PyComprehensionForComponent pyFor = (PyComprehensionForComponent)ifOrFor;
                LeafPsiElement forKeyword = PsiUtils.findPreviousSiblingToken(pyFor.getIteratorVariable(), PyTokenTypes.FOR_KEYWORD);
                LeafPsiElement inKeyword = PsiUtils.findPreviousSiblingToken(pyFor.getIteratedList(), PyTokenTypes.IN_KEYWORD);
                Expression iteratorVariable = this.mapExpression(pyFor.getIteratorVariable());
                Expression iteratedList = this.mapExpression(pyFor.getIteratedList());
                clauses.add(new Py.ComprehensionExpression.Clause(Tree.randomId(), PsiUtils.spaceBefore(forKeyword), Markers.EMPTY, iteratorVariable, (JLeftPadded<Expression>)JLeftPadded.build((Object)iteratedList).withBefore(PsiUtils.spaceBefore(inKeyword)), null));
                continue;
            }
            if (ifOrFor instanceof PyComprehensionIfComponent) {
                PyComprehensionIfComponent pyif = (PyComprehensionIfComponent)ifOrFor;
                LeafPsiElement ifKeyword = PsiUtils.findPreviousSiblingToken(pyif.getTest(), PyTokenTypes.IF_KEYWORD);
                Py.ComprehensionExpression.Condition condition = new Py.ComprehensionExpression.Condition(Tree.randomId(), PsiUtils.spaceBefore(ifKeyword), Markers.EMPTY, this.mapExpression(pyif.getTest()));
                clauses = ListUtils.mapLast(clauses, clause -> clause.withConditions(ListUtils.concat(clause.getConditions(), (Object)condition)));
                continue;
            }
            throw new IllegalStateException("expected comprehension component to be an `if` or a `for`");
        }
        PsiElement closing = element.getNode().getLastChildNode().getPsi();
        return new Py.ComprehensionExpression(Tree.randomId(), Space.EMPTY, Markers.EMPTY, kind, this.mapExpression(element.getResultExpression()), clauses, PsiUtils.spaceBefore(closing), null);
    }

    private Expression mapListLiteral(PyListLiteralExpression element) {
        return this.mapSequenceExpressionAsArray(element);
    }

    private Expression mapSetLiteral(PySetLiteralExpression element) {
        J.Identifier builtins = this.makeBuiltinsIdentifier();
        JContainer args = JContainer.build(Collections.singletonList(JRightPadded.build((Object)this.mapSequenceExpressionAsArray(element)))).withBefore(PsiUtils.spaceBefore(element));
        return new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(new BuiltinDesugar(Tree.randomId()))), JRightPadded.build((Object)builtins), null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "set", null, null), args, null);
    }

    private Expression mapTupleLiteral(PyTupleExpression element) {
        Markers markers = Markers.build(Collections.singletonList(new BuiltinDesugar(Tree.randomId())));
        if (!(element.getParent() instanceof PyParenthesizedExpression) && PsiUtils.maybeFindChildToken(element, PyTokenTypes.LPAR) == null) {
            markers = markers.add((Marker)new OmitParentheses(Tree.randomId()));
        }
        J.Identifier builtins = this.makeBuiltinsIdentifier();
        JContainer args = JContainer.build(Collections.singletonList(JRightPadded.build((Object)this.mapSequenceExpressionAsArray(element)))).withBefore(PsiUtils.spaceBefore(element));
        return new J.MethodInvocation(Tree.randomId(), PsiUtils.spaceBefore(element), markers, JRightPadded.build((Object)builtins), null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "tuple", null, null), args, null);
    }

    private Expression mapYieldExpression(PyYieldExpression element) {
        List<JRightPadded<Expression>> expressions;
        JLeftPadded from;
        if (element.isDelegating()) {
            PsiElement fromKeyword = PsiUtils.findChildToken(element, PyTokenTypes.FROM_KEYWORD);
            from = JLeftPadded.build((Object)true).withBefore(PsiUtils.spaceBefore(fromKeyword));
        } else {
            from = JLeftPadded.build((Object)false);
        }
        PyExpression pyExpression = element.getExpression();
        if (pyExpression == null) {
            expressions = Collections.emptyList();
        } else if (pyExpression instanceof PyTupleExpression) {
            expressions = this.mapExpressionsAsRightPadded(((PyTupleExpression)pyExpression).getElements());
            expressions = ListUtils.mapFirst(expressions, expr -> expr.withElement((Object)((Expression)((Expression)expr.getElement()).withPrefix(PsiUtils.spaceBefore(pyExpression)))));
        } else {
            expressions = Collections.singletonList(this.mapExpressionAsRightPadded(pyExpression));
        }
        return new Py.YieldExpression(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, (JLeftPadded<Boolean>)from, expressions, null);
    }

    private Expression mapKeywordArgument(PyKeywordArgument element) {
        return new Py.NamedArgument(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.expectIdentifier(element.getKeywordNode()), (JLeftPadded<Expression>)JLeftPadded.build((Object)this.mapExpression(Objects.requireNonNull(element.getValueExpression()))).withBefore(PsiUtils.spaceAfter(element.getKeywordNode().getPsi())), null);
    }

    private Expression mapParenthesizedExpression(PyParenthesizedExpression element) {
        if (element.getContainedExpression() instanceof PyTupleExpression) {
            return (Expression)this.mapTupleLiteral((PyTupleExpression)element.getContainedExpression()).withPrefix(PsiUtils.spaceBefore(element));
        }
        return new J.Parentheses(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpressionAsRightPadded(Objects.requireNonNull(element.getContainedExpression())));
    }

    public Expression mapBinaryExpression(PyBinaryExpression element) {
        PsiElement psiOperator = Objects.requireNonNull(element.getPsiOperator());
        if (PsiUtils.matchesTokenSequence(psiOperator, PyTokenTypes.IS_KEYWORD, PyTokenTypes.NOT_KEYWORD)) {
            return PythonExtraPadding.set(this.mapBinaryExpressionAsOperator(element, J.Binary.Type.NotEqual), PythonExtraPadding.Location.WITHIN_OPERATOR_NAME, PsiUtils.spaceAfter(psiOperator));
        }
        if (PsiUtils.matchesTokenSequence(psiOperator, PyTokenTypes.NOT_KEYWORD, PyTokenTypes.IN_KEYWORD)) {
            Expression containsMethodCall = PythonExtraPadding.set((Expression)this.mapBinaryExpressionAsMagicMethod(element, "__contains__").withPrefix(Space.EMPTY), PythonExtraPadding.Location.WITHIN_OPERATOR_NAME, PsiUtils.spaceAfter(psiOperator));
            return new J.Unary(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.build(Collections.singletonList(new MagicMethodDesugar(Tree.randomId()))), JLeftPadded.build((Object)J.Unary.Type.Not), (Expression)new J.Parentheses(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JRightPadded.build((Object)containsMethodCall)), null);
        }
        PyElementType pyOperatorType = element.getOperator();
        J.Binary.Type operatorType = binaryOperatorMapping.get(pyOperatorType);
        if (operatorType != null) {
            return this.mapBinaryExpressionAsOperator(element, operatorType);
        }
        String magicMethod = binaryOperatorSpecialMethods.get(pyOperatorType);
        if (magicMethod != null) {
            return this.mapBinaryExpressionAsMagicMethod(element, magicMethod);
        }
        throw new IllegalArgumentException("unsupported binary operator type " + pyOperatorType);
    }

    public Expression mapBinaryExpressionAsOperator(PyBinaryExpression element, J.Binary.Type operatorType) {
        PyExpression lhs = Objects.requireNonNull(element.getLeftExpression());
        PyExpression rhs = Objects.requireNonNull(element.getRightExpression());
        Space beforeOperatorSpace = PsiUtils.spaceAfter(element.getLeftExpression());
        return new J.Binary(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(lhs), JLeftPadded.build((Object)operatorType).withBefore(beforeOperatorSpace), this.mapExpression(rhs), null);
    }

    public Expression mapBinaryExpressionAsMagicMethod(PyBinaryExpression element, String magicMethod) {
        boolean isReversed = PythonOperatorLookup.doesMagicMethodReverseOperands(magicMethod);
        PyExpression originalLhs = element.getLeftExpression();
        PyExpression originalRhs = element.getRightExpression();
        PyExpression pyLhs = Objects.requireNonNull(isReversed ? element.getRightExpression() : element.getLeftExpression());
        PyExpression pyRhs = Objects.requireNonNull(element.getOppositeExpression(pyLhs));
        Space beforeOperator = PsiUtils.spaceAfter(originalLhs);
        Space afterOperator = PsiUtils.spaceBefore(originalRhs);
        Expression lhs = (Expression)this.mapExpression(pyLhs).withPrefix(Space.EMPTY);
        Expression rhs = (Expression)this.mapExpression(pyRhs).withPrefix(afterOperator);
        JRightPadded paddedLhs = JRightPadded.build((Object)lhs).withAfter(beforeOperator);
        JRightPadded paddedRhs = JRightPadded.build((Object)rhs);
        return new J.MethodInvocation(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.build(Collections.singletonList(new MagicMethodDesugar(Tree.randomId()))), paddedLhs, null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, magicMethod, null, null), JContainer.build((Space)Space.EMPTY, Collections.singletonList(paddedRhs), (Markers)Markers.EMPTY), null);
    }

    private Expression mapPrefixExpression(PyPrefixExpression element) {
        J.Unary.Type ot;
        PyElementType op = element.getOperator();
        if (op == PyTokenTypes.AWAIT_KEYWORD) {
            return new Py.AwaitExpression(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(element.getOperand()), null);
        }
        JavaType.Primitive type = null;
        if (op == PyTokenTypes.NOT_KEYWORD) {
            ot = J.Unary.Type.Not;
            type = JavaType.Primitive.Boolean;
        } else if (op == PyTokenTypes.PLUS) {
            ot = J.Unary.Type.Positive;
        } else if (op == PyTokenTypes.MINUS) {
            ot = J.Unary.Type.Negative;
        } else if (op == PyTokenTypes.TILDE) {
            ot = J.Unary.Type.Complement;
        } else {
            throw new IllegalArgumentException(String.format("unhandled prefix expression with type %s", op));
        }
        return new J.Unary(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, JLeftPadded.build((Object)ot), this.mapExpression(element.getOperand()), (JavaType)type);
    }

    public J.Literal mapBooleanLiteral(PyBoolLiteralExpression element) {
        return new J.Literal(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, (Object)element.getValue(), element.getText(), Collections.emptyList(), JavaType.Primitive.Boolean);
    }

    public J.Literal mapNoneLiteral(PyNoneLiteralExpression element) {
        return new J.Literal(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, null, "null", null, JavaType.Primitive.Null);
    }

    @Nullable
    public JContainer<Expression> mapArgumentList(@Nullable PyArgumentList pyArgumentList) {
        if (pyArgumentList == null) {
            return null;
        }
        if (pyArgumentList.getArguments().length == 0) {
            return JContainer.build(Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), PsiUtils.spaceBefore(PsiUtils.maybeFindChildToken(pyArgumentList, PyTokenTypes.RPAR)), Markers.EMPTY)))).withBefore(PsiUtils.spaceBefore(pyArgumentList));
        }
        List<JRightPadded<Expression>> expressions = this.mapExpressionsAsRightPadded(pyArgumentList.getArguments());
        return JContainer.build(expressions).withBefore(PsiUtils.spaceBefore(pyArgumentList));
    }

    public J.MethodInvocation mapCallExpression(PyCallExpression element) {
        JRightPadded select;
        J.Identifier functionName;
        PyExpression pyCallee = (PyExpression)element.getFirstChild();
        Expression callee = this.mapExpression(pyCallee);
        PyArgumentList pyArgumentList = element.getArgumentList();
        Markers markers = Markers.EMPTY;
        if (callee instanceof J.Identifier) {
            functionName = (J.Identifier)callee;
            select = null;
        } else if (callee instanceof J.FieldAccess) {
            J.FieldAccess fieldAccess = (J.FieldAccess)callee;
            functionName = fieldAccess.getName();
            select = JRightPadded.build((Object)fieldAccess.getTarget()).withAfter(fieldAccess.getPadding().getName().getBefore());
        } else {
            markers = Markers.build(Collections.singletonList(new MagicMethodDesugar(Tree.randomId())));
            functionName = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "__call__", null, null);
            select = JRightPadded.build((Object)callee);
        }
        return new J.MethodInvocation(Tree.randomId(), PsiUtils.spaceBefore(element), markers, select, null, functionName, Objects.requireNonNull(this.mapArgumentList(pyArgumentList)).withBefore(PsiUtils.spaceBefore(pyArgumentList)), null);
    }

    public Py.ExpressionStatement mapExpressionStatement(PyExpressionStatement element) {
        Expression expression = this.mapExpression(element.getExpression());
        return new Py.ExpressionStatement(Tree.randomId(), expression);
    }

    public J.ArrayAccess mapSliceExpression(PySliceExpression element) {
        PyExpression pyTarget = Objects.requireNonNull(element.getOperand());
        PySliceItem pySlice = Objects.requireNonNull(element.getSliceItem());
        J.Identifier builtins = this.makeBuiltinsIdentifier();
        ArrayList<@Nullable PyExpression> pyArgs = new ArrayList<PyExpression>();
        boolean lastPartWasColon = false;
        for (ASTNode slicePartNode : pySlice.getNode().getChildren(null)) {
            PsiElement slicePart = slicePartNode.getPsi();
            if (slicePart instanceof PyExpression) {
                pyArgs.add((PyExpression)slicePart);
                lastPartWasColon = false;
                continue;
            }
            lastPartWasColon = true;
        }
        if (lastPartWasColon) {
            pyArgs.add(null);
        }
        List<JRightPadded> args = new ArrayList(pyArgs.size());
        for (PyExpression pyExpression : pyArgs) {
            if (pyExpression instanceof PyEmptyExpression || pyExpression == null) {
                J.Literal none = new J.Literal(Tree.randomId(), PsiUtils.spaceBefore(pyExpression), Markers.build(Collections.singletonList(new ImplicitNone(Tree.randomId()))), null, "null", null, JavaType.Primitive.Null);
                args.add(JRightPadded.build((Object)none).withAfter(PsiUtils.spaceAfter(pyExpression)));
                continue;
            }
            args.add(this.mapExpressionAsRightPadded(pyExpression));
        }
        args = ListUtils.mapLast(args, padded -> padded.withAfter(PsiUtils.spaceAfter(pySlice)));
        J.MethodInvocation sliceCall = new J.MethodInvocation(Tree.randomId(), Space.EMPTY, Markers.build(Collections.singletonList(new BuiltinDesugar(Tree.randomId()))), JRightPadded.build((Object)builtins), null, new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "slice", null, null), JContainer.build(args).withBefore(PsiUtils.spaceBefore(pySlice)), null);
        return new J.ArrayAccess(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(pyTarget), new J.ArrayDimension(Tree.randomId(), PsiUtils.spaceAfter(pyTarget), Markers.EMPTY, JRightPadded.build((Object)sliceCall)), null);
    }

    public J.ArrayAccess mapSubscription(PySubscriptionExpression element) {
        PyExpression pyTarget = Objects.requireNonNull(element.getOperand());
        PyExpression pyIndex = Objects.requireNonNull(element.getIndexExpression());
        return new J.ArrayAccess(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(pyTarget), new J.ArrayDimension(Tree.randomId(), PsiUtils.spaceAfter(pyTarget), Markers.EMPTY, this.mapExpressionAsRightPadded(pyIndex)), null);
    }

    public J.Literal mapStringLiteral(PyStringLiteralExpression element) {
        return new J.Literal(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, (Object)element.getStringValue(), element.getText(), Collections.emptyList(), JavaType.Primitive.String);
    }

    public Expression mapTargetExpression(PyTargetExpression element) {
        Py.TypeHint typeHint = this.mapTypeHintNullable(element.getAnnotation());
        Expression typeTree = (Expression)TypeTree.build((String)element.getText());
        typeTree = (Expression)typeTree.withPrefix(PsiUtils.spaceBefore(element));
        if (typeHint == null) {
            return typeTree;
        }
        return new Py.TypeHintedExpression(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, typeHint, typeTree, null);
    }

    public J.Identifier mapIdentifier(PsiNamedElement element) {
        return new J.Identifier(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, Objects.requireNonNull(element.getName()), null, null);
    }

    public J.Literal mapNumericLiteral(PyNumericLiteralExpression element) {
        return new J.Literal(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, (Object)(element.isIntegerLiteral() ? element.getLongValue() : element.getBigDecimalValue()), element.getText(), Collections.emptyList(), JavaType.Primitive.Long);
    }

    public Expression mapReferenceExpression(PyReferenceExpression element) {
        J.Identifier nameId = new J.Identifier(Tree.randomId(), PsiUtils.spaceBefore(element.getNameElement().getPsi()), Markers.EMPTY, element.getName(), null, null);
        if (element.getQualifier() == null) {
            return nameId.withPrefix(PsiUtils.spaceBefore(element));
        }
        return new J.FieldAccess(Tree.randomId(), PsiUtils.spaceBefore(element), Markers.EMPTY, this.mapExpression(element.getQualifier()), JLeftPadded.build((Object)nameId).withBefore(PsiUtils.spaceAfter(element.getQualifier())), null);
    }

    private boolean isCompoundStatement(PsiElement element) {
        return element instanceof PyStatementListContainer || element instanceof PyFile;
    }

    private J.Identifier expectIdentifier(Expression expression) {
        if (expression instanceof J.Identifier) {
            return (J.Identifier)expression;
        }
        throw new RuntimeException("expected Identifier, but found: " + expression.getClass().getSimpleName());
    }

    private J.Identifier expectIdentifier(@Nullable PsiElement element) {
        ASTNode node;
        if (element == null) {
            throw new RuntimeException("expected Identifier, but element was null");
        }
        if (element instanceof PyTargetExpression) {
            if (element.getNode().getChildren(null).length != 1) {
                throw new RuntimeException("expected Identifier, but found a TargetExpression with " + element.getChildren().length + " children");
            }
            node = element.getNode().getFirstChildNode();
        } else {
            node = element.getNode();
        }
        return this.expectIdentifier(node);
    }

    private J.Identifier expectIdentifier(@Nullable ASTNode node) {
        if (node == null) {
            throw new RuntimeException("expected Identifier, but element was null");
        }
        if (node.getElementType() != PyTokenTypes.IDENTIFIER) {
            throw new RuntimeException("expected Identifier, but node type was: " + node.getElementType());
        }
        return new J.Identifier(Tree.randomId(), PsiUtils.spaceBefore(node.getPsi()), Markers.EMPTY, node.getText(), null, null);
    }

    private J.Identifier makeBuiltinsIdentifier() {
        return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, "__builtins__", null, null);
    }

    private String expectSimpleName(@Nullable QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            throw new RuntimeException("expected QualifiedName, but element was null");
        }
        if (qualifiedName.getComponentCount() != 1) {
            throw new UnsupportedOperationException("only simple names are supported; found: " + qualifiedName);
        }
        return qualifiedName.getLastComponent();
    }

    private NameTree mapQualifiedNameAsNameTree(QualifiedName pyQualifiedName) {
        J.Identifier name = new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Objects.requireNonNull(pyQualifiedName.getLastComponent()), null, null);
        if (pyQualifiedName.getComponentCount() == 1) {
            return name;
        }
        NameTree inner = this.mapQualifiedNameAsNameTree(pyQualifiedName.removeLastComponent());
        if (!(inner instanceof Expression)) {
            throw new IllegalStateException("expected qualified name to be both NameTree and Expression; found: " + inner.getClass().getSimpleName());
        }
        return new J.FieldAccess(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Expression)inner, JLeftPadded.build((Object)name), null);
    }

    static {
        HashMap<PyElementType, Object> map = new HashMap<PyElementType, Object>();
        map.put(PyTokenTypes.PLUSEQ, J.AssignmentOperation.Type.Addition);
        map.put(PyTokenTypes.MINUSEQ, J.AssignmentOperation.Type.Subtraction);
        map.put(PyTokenTypes.ATEQ, J.AssignmentOperation.Type.MatrixMultiplication);
        map.put(PyTokenTypes.MULTEQ, J.AssignmentOperation.Type.Multiplication);
        map.put(PyTokenTypes.DIVEQ, J.AssignmentOperation.Type.Division);
        map.put(PyTokenTypes.PERCEQ, J.AssignmentOperation.Type.Modulo);
        map.put(PyTokenTypes.ANDEQ, J.AssignmentOperation.Type.BitAnd);
        map.put(PyTokenTypes.OREQ, J.AssignmentOperation.Type.BitOr);
        map.put(PyTokenTypes.XOREQ, J.AssignmentOperation.Type.BitXor);
        map.put(PyTokenTypes.LTLTEQ, J.AssignmentOperation.Type.LeftShift);
        map.put(PyTokenTypes.GTGTEQ, J.AssignmentOperation.Type.RightShift);
        map.put(PyTokenTypes.EXPEQ, J.AssignmentOperation.Type.Exponentiation);
        map.put(PyTokenTypes.FLOORDIVEQ, J.AssignmentOperation.Type.FloorDivision);
        augAssignmentOps = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(PyTokenTypes.EQEQ, "__eq__");
        map.put(PyTokenTypes.NE, "__ne__");
        map.put(PyTokenTypes.EXP, "__pow__");
        map.put(PyTokenTypes.FLOORDIV, "__floordiv__");
        map.put(PyTokenTypes.IN_KEYWORD, "__contains__");
        map.put(PyTokenTypes.AT, "__matmul__");
        binaryOperatorSpecialMethods = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(PyTokenTypes.LT, J.Binary.Type.LessThan);
        map.put(PyTokenTypes.LE, J.Binary.Type.LessThanOrEqual);
        map.put(PyTokenTypes.GT, J.Binary.Type.GreaterThan);
        map.put(PyTokenTypes.GE, J.Binary.Type.GreaterThanOrEqual);
        map.put(PyTokenTypes.IS_KEYWORD, J.Binary.Type.Equal);
        map.put(PyTokenTypes.DIV, J.Binary.Type.Division);
        map.put(PyTokenTypes.MINUS, J.Binary.Type.Subtraction);
        map.put(PyTokenTypes.MULT, J.Binary.Type.Multiplication);
        map.put(PyTokenTypes.PLUS, J.Binary.Type.Addition);
        map.put(PyTokenTypes.PERC, J.Binary.Type.Modulo);
        map.put(PyTokenTypes.OR_KEYWORD, J.Binary.Type.Or);
        map.put(PyTokenTypes.AND_KEYWORD, J.Binary.Type.And);
        map.put(PyTokenTypes.AND, J.Binary.Type.BitAnd);
        map.put(PyTokenTypes.OR, J.Binary.Type.BitOr);
        map.put(PyTokenTypes.XOR, J.Binary.Type.BitXor);
        map.put(PyTokenTypes.GTGT, J.Binary.Type.RightShift);
        map.put(PyTokenTypes.LTLT, J.Binary.Type.LeftShift);
        binaryOperatorMapping = Collections.unmodifiableMap(map);
    }

    public static final class BlockContext {
        private final String fullIndent;
        private final boolean isInline;
        private final PsiPaddingCursor paddingCursor;

        public static BlockContext root(PyFile element) {
            PsiPaddingCursor paddingCursor = new PsiPaddingCursor(element);
            paddingCursor.resetTo(element.getNode().getFirstChildNode().getPsi());
            return new BlockContext("", false, paddingCursor);
        }

        public Space nextStatementPrefix() {
            return this.nextStatementPrefix(null);
        }

        public Space nextStatementPrefix(@Nullable PsiElement expected) {
            Space prefix = expected == null ? this.paddingCursor.consumeRemaining() : this.paddingCursor.consumeRemainingAndExpect(expected);
            return PySpace.deindent(prefix, this.fullIndent, PySpace.IndentStartMode.LINE_START, PySpace.IndentEndMode.STATEMENT_START);
        }

        public BlockContext(String fullIndent, boolean isInline, PsiPaddingCursor paddingCursor) {
            this.fullIndent = fullIndent;
            this.isInline = isInline;
            this.paddingCursor = paddingCursor;
        }

        public String getFullIndent() {
            return this.fullIndent;
        }

        public boolean isInline() {
            return this.isInline;
        }

        public PsiPaddingCursor getPaddingCursor() {
            return this.paddingCursor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockContext)) {
                return false;
            }
            BlockContext other = (BlockContext)o;
            if (this.isInline() != other.isInline()) {
                return false;
            }
            String this$fullIndent = this.getFullIndent();
            String other$fullIndent = other.getFullIndent();
            if (this$fullIndent == null ? other$fullIndent != null : !this$fullIndent.equals(other$fullIndent)) {
                return false;
            }
            PsiPaddingCursor this$paddingCursor = this.getPaddingCursor();
            PsiPaddingCursor other$paddingCursor = other.getPaddingCursor();
            return !(this$paddingCursor == null ? other$paddingCursor != null : !this$paddingCursor.equals(other$paddingCursor));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isInline() ? 79 : 97);
            String $fullIndent = this.getFullIndent();
            result = result * 59 + ($fullIndent == null ? 43 : $fullIndent.hashCode());
            PsiPaddingCursor $paddingCursor = this.getPaddingCursor();
            result = result * 59 + ($paddingCursor == null ? 43 : $paddingCursor.hashCode());
            return result;
        }

        public String toString() {
            return "PsiPythonMapper.BlockContext(fullIndent=" + this.getFullIndent() + ", isInline=" + this.isInline() + ", paddingCursor=" + this.getPaddingCursor() + ")";
        }
    }
}

