/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.concurrency;

import com.intellij.concurrency.ContextCallable;
import com.intellij.concurrency.ContextRunnable;
import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\u001a\b\u0010\t\u001a\u00020\nH\u0007\u001a\u0006\u0010\u000b\u001a\u00020\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a\u0006\u0010\u000f\u001a\u00020\r\u001a \u0010\u0010\u001a\u00020\r2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0012H\u0002\u001a\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002\u001a'\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u000e\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u0017\"\u0016\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"tlCoroutineContext", "Ljava/lang/ThreadLocal;", "Lkotlin/coroutines/CoroutineContext;", "captureThreadContext", "Ljava/lang/Runnable;", "runnable", "Ljava/util/concurrent/Callable;", "V", "callable", "checkUninitializedThreadContext", "", "currentThreadContext", "replaceThreadContext", "Lcom/intellij/openapi/application/AccessToken;", "coroutineContext", "resetThreadContext", "updateThreadContext", "update", "Lkotlin/Function1;", "withThreadContext", "X", "action", "Lkotlin/Function0;", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.util"})
@JvmName(name="ThreadContext")
@ApiStatus.Experimental
public final class ThreadContext {
    @NotNull
    private static final ThreadLocal<CoroutineContext> tlCoroutineContext = new ThreadLocal();

    @ApiStatus.Internal
    @VisibleForTesting
    public static final void checkUninitializedThreadContext() {
        if (!(tlCoroutineContext.get() == null)) {
            boolean bl = false;
            String string = "Thread context was already set";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public static final CoroutineContext currentThreadContext() {
        CoroutineContext coroutineContext = tlCoroutineContext.get();
        if (coroutineContext == null) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        return coroutineContext;
    }

    @NotNull
    public static final AccessToken resetThreadContext() {
        return ThreadContext.updateThreadContext((Function1<? super CoroutineContext, ? extends CoroutineContext>)((Function1)resetThreadContext.1.INSTANCE));
    }

    @NotNull
    public static final AccessToken replaceThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.updateThreadContext((Function1<? super CoroutineContext, ? extends CoroutineContext>)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <X> X withThreadContext(@NotNull CoroutineContext coroutineContext, @NotNull Function0<? extends X> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        AutoCloseable autoCloseable = (AutoCloseable)ThreadContext.withThreadContext(coroutineContext);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            object = action.invoke();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (X)object;
    }

    @NotNull
    public static final AccessToken withThreadContext(@NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        return ThreadContext.updateThreadContext((Function1<? super CoroutineContext, ? extends CoroutineContext>)((Function1)new /* Unavailable Anonymous Inner Class!! */));
    }

    private static final AccessToken updateThreadContext(Function1<? super CoroutineContext, ? extends CoroutineContext> update) {
        CoroutineContext previousContext = tlCoroutineContext.get();
        CoroutineContext newContext = (CoroutineContext)update.invoke((Object)previousContext);
        tlCoroutineContext.set(newContext);
        return (AccessToken)new /* Unavailable Anonymous Inner Class!! */;
    }

    @NotNull
    public static final Runnable captureThreadContext(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        return (Runnable)new ContextRunnable(true, runnable);
    }

    @NotNull
    public static final <V> Callable<V> captureThreadContext(@NotNull Callable<V> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        return (Callable)new ContextCallable(true, callable);
    }

    public static final /* synthetic */ ThreadLocal access$getTlCoroutineContext$p() {
        return tlCoroutineContext;
    }
}

