/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.impl.MessageBusFactoryImpl;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager,
MessageBusOwner {
    private final MessageBus myMessageBus;
    private final DefaultPicoContainer myPicoContainer;
    private final ExtensionsAreaImpl myExtensionArea;
    private final Map<Class<?>, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(0);
        }
        this.myMessageBus = MessageBusFactoryImpl.createRootBus(this);
        this.myComponents = new HashMap();
        this.myDisposableComponents = ContainerUtil.newConcurrentSet();
        this.myPicoContainer = new DefaultPicoContainer((DefaultPicoContainer)parent){

            @Override
            @Nullable
            public Object getComponentInstance(@NotNull Object componentKey) {
                if (componentKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + this);
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/mock/MockComponentManager$1", "getComponentInstance"));
            }
        };
        this.myPicoContainer.registerComponentInstance(this.getClass(), this);
        this.myExtensionArea = new ExtensionsAreaImpl(this);
        Disposer.register(parentDisposable, this);
    }

    @Override
    @NotNull
    public ExtensionsAreaImpl getExtensionArea() {
        ExtensionsAreaImpl extensionsAreaImpl = this.myExtensionArea;
        if (extensionsAreaImpl == null) {
            MockComponentManager.$$$reportNull$$$0(1);
        }
        return extensionsAreaImpl;
    }

    @Override
    public <T> T instantiateClassWithConstructorInjection(@NotNull Class<T> aClass, @NotNull Object key, @NotNull PluginId pluginId) {
        if (aClass == null) {
            MockComponentManager.$$$reportNull$$$0(2);
        }
        if (key == null) {
            MockComponentManager.$$$reportNull$$$0(3);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        if (error == null) {
            MockComponentManager.$$$reportNull$$$0(5);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(6);
        }
        ExceptionUtilRt.rethrowUnchecked((Throwable)error);
        return new RuntimeException(error);
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message, @NotNull PluginId pluginId) {
        if (message == null) {
            MockComponentManager.$$$reportNull$$$0(7);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(8);
        }
        return new RuntimeException(message);
    }

    @Override
    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message, @Nullable Throwable error, @NotNull PluginId pluginId, @Nullable Map<String, String> attachments) {
        if (message == null) {
            MockComponentManager.$$$reportNull$$$0(9);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(10);
        }
        return new RuntimeException(message);
    }

    protected void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register(this, (Disposable)o);
        }
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(11);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(12);
        }
        this.myPicoContainer.unregisterComponent(serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(13);
        }
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(14);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(15);
        }
        this.myPicoContainer.registerComponentInstance(serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation, @NotNull Disposable parentDisposable) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(16);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(17);
        }
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(18);
        }
        String key = serviceInterface.getName();
        this.registerService(serviceInterface, serviceImplementation);
        Disposer.register(parentDisposable, () -> this.myPicoContainer.unregisterComponent(key));
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(19);
        }
        if (instance == null) {
            MockComponentManager.$$$reportNull$$$0(20);
        }
        this.myComponents.put(interfaceClass, instance);
        this.registerComponentInDisposer(instance);
    }

    @Override
    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o;
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(21);
        }
        return (T)((o = this.myPicoContainer.getComponentInstance(interfaceClass)) != null ? o : this.myComponents.get(interfaceClass));
    }

    @Override
    public <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            MockComponentManager.$$$reportNull$$$0(22);
        }
        T result = this.myPicoContainer.getService(serviceClass);
        this.registerComponentInDisposer(result);
        return result;
    }

    @Override
    @NotNull
    public final MutablePicoContainer getPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myPicoContainer;
        if (defaultPicoContainer == null) {
            MockComponentManager.$$$reportNull$$$0(23);
        }
        return defaultPicoContainer;
    }

    public final ComponentAdapter getComponentAdapter(@NotNull Object componentKey) {
        if (componentKey == null) {
            MockComponentManager.$$$reportNull$$$0(24);
        }
        return this.myPicoContainer.getComponentAdapter(componentKey);
    }

    @Override
    public final boolean hasComponent(@NotNull Class<?> interfaceClass) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(25);
        }
        return this.getComponentAdapter(interfaceClass) != null;
    }

    @Override
    public boolean isInjectionForExtensionSupported() {
        return false;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            MockComponentManager.$$$reportNull$$$0(26);
        }
        return messageBus;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.myMessageBus);
        this.myDisposed = true;
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            MockComponentManager.$$$reportNull$$$0(27);
        }
        return condition;
    }

    @Override
    @NotNull
    public Object createListener(@NotNull ListenerDescriptor descriptor) {
        if (descriptor == null) {
            MockComponentManager.$$$reportNull$$$0(28);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> Class<T> loadClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) throws ClassNotFoundException {
        if (className == null) {
            MockComponentManager.$$$reportNull$$$0(29);
        }
        if (pluginDescriptor == null) {
            MockComponentManager.$$$reportNull$$$0(30);
        }
        Class<?> clazz = Class.forName(className);
        if (clazz == null) {
            MockComponentManager.$$$reportNull$$$0(31);
        }
        return clazz;
    }

    @Override
    @NotNull
    public ActivityCategory getActivityCategory(boolean isExtension) {
        ActivityCategory activityCategory = isExtension ? ActivityCategory.APP_EXTENSION : ActivityCategory.APP_SERVICE;
        if (activityCategory == null) {
            MockComponentManager.$$$reportNull$$$0(32);
        }
        return activityCategory;
    }

    @Override
    @NotNull
    public final <T> T instantiateClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) {
        T t;
        if (className == null) {
            MockComponentManager.$$$reportNull$$$0(33);
        }
        if (pluginDescriptor == null) {
            MockComponentManager.$$$reportNull$$$0(34);
        }
        try {
            t = ReflectionUtil.newInstance(this.loadClass(className, pluginDescriptor));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (t == null) {
            MockComponentManager.$$$reportNull$$$0(35);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 23: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 23: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 23: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 19: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionArea";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 23: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClassWithConstructorInjection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasComponent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 23: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

