/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProfiler;
import com.intellij.psi.util.CachedValueProvider;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@ApiStatus.Internal
public final class CachedValueProfiler {
    private static final Logger LOG = Logger.getInstance(CachedValueProfiler.class);
    private static volatile GlobalContext ourGlobalContext = new GlobalContext(null, 0);
    private static final ThreadLocal<ThreadContext> ourContext = ThreadLocal.withInitial(() -> new ThreadContext(ourGlobalContext));
    private static final AtomicLong ourFrameId = new AtomicLong();
    private static final Overhead ourFrameOverhead = new Overhead();
    private static final Overhead ourTrackerOverhead = new Overhead();

    public static boolean isProfiling() {
        return CachedValueProfiler.ourGlobalContext.consumer != null;
    }

    @Nullable
    public static EventConsumer setEventConsumer(@Nullable EventConsumer eventConsumer) {
        GlobalContext prev = ourGlobalContext;
        if (prev.consumer == null && eventConsumer == null) {
            return null;
        }
        ourGlobalContext = new GlobalContext(eventConsumer, prev.epoch + 1);
        if (prev.consumer != null) {
            LOG.info(ourFrameOverhead.resetAndReport("doCompute()"));
            LOG.info(ourTrackerOverhead.resetAndReport("getValue()"));
        }
        return prev.consumer;
    }

    @NotNull
    public static Frame newFrame() {
        return new Frame();
    }

    static void onResultCreated(@NotNull CachedValueProvider.Result<?> result2, @Nullable Object original) {
        EventPlace place;
        if (result2 == null) {
            CachedValueProfiler.$$$reportNull$$$0(0);
        }
        long time = CachedValueProfiler.currentTime();
        ThreadContext context = ourContext.get();
        if (context.consumer == null || context.epoch != CachedValueProfiler.ourGlobalContext.epoch) {
            return;
        }
        Frame frame = context.topFrame;
        if (frame == null) {
            return;
        }
        EventPlace eventPlace = original == null ? CachedValueProfiler.place(CachedValueProfiler::findComputationPlace) : (original instanceof CachedValueProvider.Result ? (EventPlace)Frame.access$600((Frame)frame).get(original) : (place = original instanceof Function ? CachedValueProfiler.place(CachedValueProfiler::findCallerPlace) : null));
        if (place == null) {
            return;
        }
        Frame.access$600((Frame)frame).put(result2, place);
        CachedValueProfiler.ourFrameOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
    }

    @Nullable
    static ValueTracker onResultReturned(@NotNull Frame frame, @NotNull CachedValueProvider.Result<?> result2) {
        if (frame == null) {
            CachedValueProfiler.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            CachedValueProfiler.$$$reportNull$$$0(2);
        }
        long time = CachedValueProfiler.currentTime();
        ThreadContext context = ourContext.get();
        if (context.consumer == null) {
            return null;
        }
        EventPlace place = (EventPlace)Frame.access$600((Frame)frame).get(result2);
        if (place == null) {
            place = CachedValueProfiler.place(CachedValueProfiler::findCallerPlace);
        }
        context.consumer.onValueComputed(frame.id, place, Frame.access$700((Frame)frame), time);
        return new ValueTracker(place, Frame.access$700((Frame)frame), time, context.epoch);
    }

    static EventPlace place(Function<? super Throwable, ? extends StackTraceElement> function) {
        Throwable throwable = new Throwable();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nullable
    static StackTraceElement findComputationPlace(Throwable stackTraceHolder) {
        String className;
        int idx;
        StackTraceElement[] stackTrace = stackTraceHolder.getStackTrace();
        int len = stackTrace.length;
        for (idx = 2; idx < len; ++idx) {
            String method = stackTrace[idx].getMethodName();
            String className2 = stackTrace[idx].getClassName();
            if (!(!"doCompute".equals(method) || !className2.endsWith("CachedValueImpl") && !className2.endsWith("CachedValue") || !className2.startsWith("com.intellij.util.") && !className2.startsWith("com.intellij.psi."))) break;
        }
        if (idx >= len) {
            return null;
        }
        --idx;
        while (idx > 0 && ((className = stackTrace[idx].getClassName()).startsWith("com.intellij.util.CachedValue") || className.startsWith("com.intellij.psi.util.CachedValue") || className.startsWith("com.intellij.psi.impl.PsiCachedValue") || className.startsWith("com.intellij.openapi.util.Recursion"))) {
            --idx;
        }
        if (idx > 0) {
            return stackTrace[idx];
        }
        return null;
    }

    @NotNull
    static StackTraceElement findCallerPlace(Throwable stackTraceHolder) {
        StackTraceElement[] stackTrace = stackTraceHolder.getStackTrace();
        int len = stackTrace.length;
        for (int idx = 2; idx < len; ++idx) {
            String className = stackTrace[idx].getClassName();
            if (className.startsWith("com.intellij.util.CachedValue") || className.startsWith("com.intellij.psi.util.CachedValue") || className.startsWith("com.intellij.psi.impl.PsiCachedValue") || className.startsWith("com.intellij.openapi.util.Recursion") || className.startsWith("com.intellij.psi.impl.PsiParameterizedCachedValue")) continue;
            StackTraceElement stackTraceElement = stackTrace[idx];
            if (stackTraceElement == null) {
                CachedValueProfiler.$$$reportNull$$$0(3);
            }
            return stackTraceElement;
        }
        return new StackTraceElement("unknown", "unknown", "", -1);
    }

    static long currentTime() {
        return System.nanoTime();
    }

    static /* synthetic */ AtomicLong access$100() {
        return ourFrameId;
    }

    static /* synthetic */ Overhead access$400() {
        return ourFrameOverhead;
    }

    static /* synthetic */ Logger access$500() {
        return LOG;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/CachedValueProfiler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/CachedValueProfiler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findCallerPlace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onResultCreated";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onResultReturned";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Overhead {
        final AtomicLong total = new AtomicLong();
        final AtomicLong overhead = new AtomicLong();
        final AtomicLong count = new AtomicLong();

        private Overhead() {
        }

        String resetAndReport(String eventName) {
            long total = this.total.getAndSet(0L);
            long overhead = this.overhead.getAndSet(0L);
            long count = this.count.getAndSet(0L);
            NumberFormat format = NumberFormat.getInstance(Locale.US);
            return format.format(count) + " " + eventName + " calls, " + format.format(overhead) + " overhead ns" + (count == 0L && total == 0L ? "" : " (" + StringUtil.join(Arrays.asList(count == 0L ? null : format.format(overhead / count) + " ns/call", total == 0L ? null : String.format("%.2f", (double)overhead / (double)(total / 100L)) + " %"), ", ") + ")");
        }
    }

    private static class GlobalContext {
        final EventConsumer consumer;
        final int epoch;

        GlobalContext(@Nullable EventConsumer consumer, int epoch) {
            this.consumer = consumer;
            this.epoch = epoch;
        }
    }

    private static class ThreadContext {
        @Nullable
        final EventConsumer consumer;
        final int epoch;
        @Nullable
        Frame topFrame;

        ThreadContext(@NotNull GlobalContext globalContext) {
            if (globalContext == null) {
                ThreadContext.$$$reportNull$$$0(0);
            }
            this.consumer = globalContext.consumer;
            this.epoch = globalContext.epoch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/psi/util/CachedValueProfiler$ThreadContext", "<init>"));
        }
    }

    public static interface EventPlace {
        @Nullable
        public StackTraceElement getStackFrame();

        public StackTraceElement @Nullable [] getStackTrace();
    }

    public static final class ValueTracker {
        final EventPlace place;
        final long start;
        final long computed;
        final int epoch;
        volatile long used;

        /*
         * WARNING - void declaration
         */
        ValueTracker(@NotNull EventPlace place, long start, long computed, int n) {
            void epoch;
            if (place == null) {
                ValueTracker.$$$reportNull$$$0(0);
            }
            this.place = place;
            this.start = start;
            this.computed = computed;
            this.epoch = epoch;
        }

        public void onValueInvalidated() {
            long time = CachedValueProfiler.currentTime();
            ThreadContext context = (ThreadContext)ourContext.get();
            if (context.consumer == null || context.epoch != ourGlobalContext.epoch) {
                return;
            }
            if (this.epoch != context.epoch) {
                return;
            }
            context.consumer.onValueInvalidated(context.topFrame == null ? 0L : context.topFrame.id, this.place, this.used, time);
            ourTrackerOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
        }

        public void onValueUsed() {
            long time;
            this.used = time = CachedValueProfiler.currentTime();
            ThreadContext context = (ThreadContext)ourContext.get();
            if (context.consumer == null || context.epoch != ourGlobalContext.epoch) {
                return;
            }
            if (this.epoch != context.epoch) {
                return;
            }
            context.consumer.onValueUsed(context.topFrame == null ? 0L : context.topFrame.id, this.place, this.computed, time);
            ourTrackerOverhead.count.incrementAndGet();
            ourTrackerOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
        }

        public void onValueRejected() {
            long time = CachedValueProfiler.currentTime();
            ThreadContext context = (ThreadContext)ourContext.get();
            if (context.consumer == null || context.epoch != ourGlobalContext.epoch) {
                return;
            }
            if (this.epoch != context.epoch) {
                return;
            }
            context.consumer.onValueRejected(context.topFrame == null ? 0L : context.topFrame.id, this.place, this.start, this.computed, time);
            ourTrackerOverhead.overhead.addAndGet(CachedValueProfiler.currentTime() - time);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/util/CachedValueProfiler$ValueTracker", "<init>"));
        }
    }
}

