/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefValueHashMapUtil;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
HashingStrategy<K> {
    final ReferenceQueue<K> myReferenceQueue;
    private final ConcurrentMap<KeyReference<K>, V> myMap;
    @NotNull
    private final HashingStrategy<? super K> myHashingStrategy;
    private static final float LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CAPACITY = 16;
    static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(Runtime.getRuntime().availableProcessors(), 4);
    private static final HashingStrategy<?> THIS = new HashingStrategy<Object>(){

        @Override
        public int hashCode(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<HardKey<?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());
    private Set<Map.Entry<K, V>> entrySet;

    @NotNull
    abstract KeyReference<K> createKeyReference(@NotNull K var1, @NotNull HashingStrategy<? super K> var2);

    @NotNull
    private KeyReference<K> createKeyReference(@NotNull K key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(0);
        }
        KeyReference<? super K> keyReference = this.createKeyReference(key, this.myHashingStrategy);
        if (keyReference == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(1);
        }
        return keyReference;
    }

    private boolean processQueue() {
        KeyReference wk;
        boolean processed = false;
        while ((wk = (KeyReference)((Object)this.myReferenceQueue.poll())) != null) {
            this.myMap.remove(wk);
            processed = true;
        }
        return processed;
    }

    ConcurrentRefHashMap() {
        this(16);
    }

    private ConcurrentRefHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    private ConcurrentRefHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, DEFAULT_CONCURRENCY_LEVEL, THIS);
    }

    ConcurrentRefHashMap(@NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(2);
        }
        this(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL, hashingStrategy);
    }

    ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @Nullable HashingStrategy<? super K> hashingStrategy) {
        this.myReferenceQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy == THIS ? this : (hashingStrategy == null ? HashingStrategy.canonical() : hashingStrategy);
        this.myMap = new ConcurrentHashMap<KeyReference<K>, V>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(3);
        }
        if (this.myMap.isEmpty()) {
            return false;
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            boolean bl = this.myMap.containsKey(hardKey);
            return bl;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @NotNull
    private HardKey<K> createHardKey(@NotNull Object o) {
        if (o == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(4);
        }
        Object key = o;
        HardKey<?> hardKey = HARD_KEY.get();
        hardKey.setKey(key, this.myHashingStrategy.hashCode(key));
        HardKey<?> hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(5);
        }
        return hardKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(6);
        }
        if (this.myMap.isEmpty()) {
            return null;
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v = this.myMap.get(hardKey);
            return v;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(7);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(8);
        }
        KeyReference<K> weakKey = this.createKeyReference(key);
        V prev = this.myMap.put(weakKey, value);
        this.processQueue();
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(9);
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v = this.myMap.remove(hardKey);
            return v;
        }
        finally {
            this.processQueue();
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet(this, null);
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(10);
        }
        return entrySet;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(11);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(12);
        }
        V prev = this.myMap.putIfAbsent(this.createKeyReference(key), value);
        this.processQueue();
        return prev;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(13);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(14);
        }
        boolean removed = this.myMap.remove(this.createKeyReference(key), value);
        this.processQueue();
        return removed;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(15);
        }
        if (oldValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(16);
        }
        if (newValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(17);
        }
        boolean replaced = this.myMap.replace(this.createKeyReference(key), oldValue, newValue);
        this.processQueue();
        return replaced;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(18);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(19);
        }
        V replaced = this.myMap.replace(this.createKeyReference(key), value);
        this.processQueue();
        return replaced;
    }

    @Override
    public int hashCode(@Nullable K object) {
        int h = object == null ? 0 : object.hashCode();
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    @Override
    public boolean equals(K o1, K o2) {
        return Objects.equals(o1, o2);
    }

    static /* synthetic */ ConcurrentMap access$100(ConcurrentRefHashMap x0) {
        return x0.myMap;
    }

    static /* synthetic */ HardKey access$300(ConcurrentRefHashMap x0, Object x1) {
        return x0.createHardKey(x1);
    }

    static /* synthetic */ boolean access$400(ConcurrentRefHashMap x0) {
        return x0.processQueue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createHardKey";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HardKey<K>
    implements KeyReference<K> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        void setKey(K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private void clear() {
            this.setKey(null, 0);
        }
    }

    @FunctionalInterface
    static interface KeyReference<K> {
        public K get();

        public boolean equals(Object var1);

        public int hashCode();
    }
}

