/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.FilesTooBigForDiffException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx {
    private static final Logger LOG = Logger.getInstance(RangeMarkerImpl.class);
    @NotNull
    private final Object myDocumentOrFile;
    RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    private volatile long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register, boolean forceDocumentStrongReference) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(0);
        }
        this(forceDocumentStrongReference ? document : ObjectUtils.notNull(FileDocumentManager.getInstance().getFile(document), document), document.getTextLength(), start, end, register, false, false);
    }

    RangeMarkerImpl(@NotNull VirtualFile virtualFile, int start, int end, int estimatedDocumentLength, boolean register) {
        if (virtualFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(1);
        }
        this(virtualFile, estimatedDocumentLength, start, end, register, false, false);
    }

    private RangeMarkerImpl(@NotNull Object documentOrFile, int documentTextLength, int start, int end, boolean register, boolean greedyToLeft, boolean greedyToRight) {
        if (documentOrFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(2);
        }
        if (end > documentTextLength) {
            throw new IllegalArgumentException("Invalid offsets: start=" + start + "; end=" + end + "; document length=" + documentTextLength);
        }
        this.myDocumentOrFile = documentOrFile;
        this.myId = counter.next();
        if (register) {
            this.registerInTree(start, end, greedyToLeft, greedyToRight, 0);
        }
    }

    static int estimateDocumentLength(@NotNull VirtualFile virtualFile) {
        Document document;
        if (virtualFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(3);
        }
        return (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) == null ? Math.max(0, (int)virtualFile.getLength()) : document.getTextLength();
    }

    protected void registerInTree(int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.getDocument().registerRangeMarker(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    protected void unregisterInTree() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (!this.isValid()) {
            return;
        }
        IntervalTreeImpl tree = node.getTree();
        tree.checkMax(true);
        DocumentEx document = this.getCachedDocument();
        if (document == null) {
            this.storeOffsetsBeforeDying(node);
            this.myNode = null;
        } else {
            document.removeRangeMarker(this);
        }
        tree.checkMax(true);
    }

    @Override
    public long getId() {
        long id = this.myId;
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            throw new IllegalStateException("Already disposed");
        }
        return id;
    }

    @Override
    public void dispose() {
        this.unregisterInTree();
    }

    @Override
    public int getStartOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? TextRangeScalarUtil.startOffset((long)this.myId) : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    @Override
    public int getEndOffset() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null ? TextRangeScalarUtil.endOffset((long)this.myId) : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            TextRange textRange = TextRangeScalarUtil.create((long)this.myId);
            if (textRange == null) {
                RangeMarkerImpl.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        int delta = node.computeDeltaUpToRoot();
        TextRange textRange = TextRangeScalarUtil.create((long)TextRangeScalarUtil.shift((long)node.toScalarRange(), (int)delta, (int)delta));
        if (textRange == null) {
            RangeMarkerImpl.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    void invalidate() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.invalidate();
        }
    }

    @Override
    @NotNull
    public final DocumentEx getDocument() {
        DocumentEx document;
        Object file = this.myDocumentOrFile;
        DocumentEx documentEx = document = file instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getDocument((VirtualFile)file) : (DocumentEx)file;
        if (document == null) {
            LOG.error("document is null; isValid=" + this.isValid() + "; file=" + file);
        }
        DocumentEx documentEx2 = document;
        if (documentEx2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(6);
        }
        return documentEx2;
    }

    DocumentEx getCachedDocument() {
        Object file = this.myDocumentOrFile;
        return file instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file) : (DocumentEx)file;
    }

    public int getLayer() {
        return 0;
    }

    @Override
    public void setGreedyToLeft(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToLeft()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), greedy, this.isGreedyToRight(), this.isStickingToRight(), this.getLayer());
    }

    @Override
    public void setGreedyToRight(boolean greedy) {
        if (!this.isValid() || greedy == this.isGreedyToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), greedy, this.isStickingToRight(), this.getLayer());
    }

    public void setStickingToRight(boolean value) {
        if (!this.isValid() || value == this.isStickingToRight()) {
            return;
        }
        this.myNode.getTree().changeData(this, this.getStartOffset(), this.getEndOffset(), this.isGreedyToLeft(), this.isGreedyToRight(), value, this.getLayer());
    }

    @Override
    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    @Override
    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public boolean isStickingToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isStickingToRight();
    }

    @Deprecated
    public final void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(7);
        }
        this.doChangeUpdate(e);
    }

    final void onDocumentChanged(@NotNull DocumentEvent e) {
        int newEnd;
        int newStart;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(8);
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = e.getDocument().getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (oldStart > oldEnd || oldStart < 0 || oldEnd > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate();
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && ((newStart = this.intervalStart()) > (newEnd = this.intervalEnd()) || newStart < 0 || newEnd > docLength)) {
            LOG.error("Update failed. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass() + ". Before update: " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " After update: '" + this + "'");
            this.invalidate();
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(9);
        }
        this.doChangeUpdate(e);
    }

    private void doChangeUpdate(@NotNull DocumentEvent e) {
        long newRange;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(10);
        }
        if (!this.isValid()) {
            return;
        }
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        long l = newRange = node == null ? -1L : RangeMarkerImpl.applyChange(e, node.toScalarRange(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
        if (newRange == -1L) {
            this.invalidate();
        } else {
            node.setRange(newRange);
        }
    }

    protected void persistentHighlighterUpdate(@NotNull DocumentEvent e, boolean wholeLineRange) {
        boolean viaDiff;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(11);
        }
        int line = 0;
        DocumentEventImpl event = (DocumentEventImpl)e;
        boolean bl = viaDiff = this.isValid() && PersistentRangeMarkerUtil.shouldTranslateViaDiff((DocumentEvent)event, (long)this.toScalarRange());
        if (viaDiff) {
            try {
                line = event.getLineNumberBeforeUpdate(this.getStartOffset());
                line = this.translatedViaDiff(event, line);
            }
            catch (FilesTooBigForDiffException exception) {
                viaDiff = false;
            }
        }
        if (!viaDiff) {
            this.doChangeUpdate(e);
            if (this.isValid()) {
                int startOffset = this.getStartOffset();
                line = this.getDocument().getLineNumber(startOffset);
                int endLine = this.getDocument().getLineNumber(this.getEndOffset());
                if (endLine != line) {
                    this.setRange(TextRangeScalarUtil.toScalarRange((int)startOffset, (int)this.getDocument().getLineEndOffset(line)));
                }
            }
        }
        if (this.isValid() && wholeLineRange) {
            int newStart = DocumentUtil.getFirstNonSpaceCharOffset((Document)this.getDocument(), (int)line);
            int newEnd = this.getDocument().getLineEndOffset(line);
            this.setRange(TextRangeScalarUtil.toScalarRange((int)newStart, (int)newEnd));
        }
    }

    private int translatedViaDiff(@NotNull DocumentEventImpl e, int line) throws FilesTooBigForDiffException {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(12);
        }
        if ((line = e.translateLineViaDiff(line)) < 0 || line >= this.getDocument().getLineCount()) {
            this.invalidate();
        } else {
            DocumentEx document = this.getDocument();
            this.setRange(TextRangeScalarUtil.toScalarRange((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line)));
        }
        return line;
    }

    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(13);
        }
    }

    /*
     * WARNING - void declaration
     */
    static long applyChange(@NotNull DocumentEvent e, long range, boolean isGreedyToLeft, boolean isGreedyToRight, boolean bl) {
        int intervalEnd;
        int intervalStart;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(14);
        }
        if ((intervalStart = TextRangeScalarUtil.startOffset((long)range)) == (intervalEnd = TextRangeScalarUtil.endOffset((long)range))) {
            void isStickingToRight;
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight, (boolean)isStickingToRight);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (offset > intervalEnd) {
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset) {
                return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalEnd + newLength));
            }
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)intervalEnd);
        }
        if (intervalStart > offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange((int)(intervalStart + newLength - oldLength), (int)(intervalEnd + newLength - oldLength));
        }
        if (!isGreedyToLeft && intervalStart == offset + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset) {
                return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalEnd + newLength));
            }
            return TextRangeScalarUtil.toScalarRange((int)(intervalStart + newLength - oldLength), (int)(intervalEnd + newLength - oldLength));
        }
        if (intervalStart <= offset && intervalEnd >= offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalEnd + newLength - oldLength));
        }
        if (intervalStart >= offset && intervalStart <= offset + oldLength && intervalEnd > offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange((int)(offset + newLength), (int)(intervalEnd + newLength - oldLength));
        }
        if (intervalEnd <= offset + oldLength && intervalStart < offset) {
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)offset);
        }
        return -1L;
    }

    private static long processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight, boolean stickyRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(15);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < intervalStart && intervalStart < oldEnd) {
            return -1L;
        }
        if (offset == intervalStart && oldLength == 0) {
            if (greedyRight) {
                return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalStart + e.getNewLength()));
            }
            if (stickyRight) {
                int off = intervalStart + e.getNewLength();
                return TextRangeScalarUtil.toScalarRange((int)off, (int)off);
            }
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            int off = intervalStart + e.getNewLength() - oldLength;
            return TextRangeScalarUtil.toScalarRange((int)off, (int)off);
        }
        return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)intervalStart);
    }

    @Override
    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + (this.isValid() ? Long.valueOf(this.getId()) : "");
    }

    void setRange(long scalarRange) {
        this.myNode.setRange(scalarRange);
    }

    @Override
    public boolean isValid() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null || !node.isValid()) {
            return false;
        }
        Object file = this.myDocumentOrFile;
        return file instanceof Document || RangeMarkerImpl.canHaveDocument((VirtualFile)file);
    }

    private static boolean canHaveDocument(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            RangeMarkerImpl.$$$reportNull$$$0(16);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            return true;
        }
        if (!file.isValid() || file.isDirectory() || RangeMarkerImpl.isBinaryWithoutDecompiler(file)) {
            return false;
        }
        return !file.getFileType().isBinary() || !FileUtilRt.isTooLarge(file.getLength());
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file) {
        FileType fileType;
        if (file == null) {
            RangeMarkerImpl.$$$reportNull$$$0(17);
        }
        return (fileType = file.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(fileType) == null;
    }

    protected boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }

    long toScalarRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1L;
        }
        return node.toScalarRange();
    }

    public RangeMarker findRangeMarkerAfter() {
        return this.myNode.getTree().findRangeMarkerAfter(this);
    }

    public RangeMarker findRangeMarkerBefore() {
        return this.myNode.getTree().findRangeMarkerBefore(this);
    }

    @NotNull
    TextRange reCalcTextRangeAfterReload(@NotNull DocumentImpl document, int tabSize) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(18);
        }
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            RangeMarkerImpl.$$$reportNull$$$0(19);
        }
        return textRange;
    }

    void storeOffsetsBeforeDying(@NotNull IntervalTreeImpl.IntervalNode<?> node) {
        if (node == null) {
            RangeMarkerImpl.$$$reportNull$$$0(20);
        }
        int delta = node.computeDeltaUpToRoot();
        long range = TextRangeScalarUtil.shift((long)node.toScalarRange(), (int)delta, (int)delta);
        int startOffset = Math.max(0, TextRangeScalarUtil.startOffset((long)range));
        int endOffset = Math.max(startOffset, TextRangeScalarUtil.endOffset((long)range));
        this.myId = TextRangeScalarUtil.toScalarRange((int)startOffset, (int)endOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentOrFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "reCalcTextRangeAfterReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "estimateDocumentLength";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doChangeUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "persistentHighlighterUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "translatedViaDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processIfOnePoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDocument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reCalcTextRangeAfterReload";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "storeOffsetsBeforeDying";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

