/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.EpydocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.NumpyDocString;
import com.jetbrains.python.documentation.docstrings.PlainDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.toolbox.Substring;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocStringUtil {
    private DocStringUtil() {
    }

    @Nullable
    public static String getDocStringValue(@NotNull PyDocStringOwner owner) {
        if (owner == null) {
            DocStringUtil.$$$reportNull$$$0(0);
        }
        return PyPsiUtils.strValue(owner.getDocStringExpression());
    }

    @NotNull
    public static StructuredDocString parse(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(1);
        }
        return DocStringUtil.parse(text, null);
    }

    @NotNull
    public static StructuredDocString parse(@NotNull String text, @Nullable PsiElement anchor) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(2);
        }
        DocStringFormat format = DocStringUtil.guessDocStringFormat(text, anchor);
        return DocStringUtil.parseDocStringContent(format, text);
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull PyStringLiteralExpression stringLiteral) {
        if (stringLiteral == null) {
            DocStringUtil.$$$reportNull$$$0(3);
        }
        return DocStringUtil.parseDocString(DocStringUtil.guessDocStringFormat(stringLiteral.getStringValue(), stringLiteral), stringLiteral);
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull PyStringLiteralExpression stringLiteral) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(4);
        }
        if (stringLiteral == null) {
            DocStringUtil.$$$reportNull$$$0(5);
        }
        return DocStringUtil.parseDocString(format, stringLiteral.getStringNodes().get(0));
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull ASTNode node) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(6);
        }
        if (node == null) {
            DocStringUtil.$$$reportNull$$$0(7);
        }
        return DocStringUtil.parseDocString(format, node.getText());
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull String stringText) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(8);
        }
        if (stringText == null) {
            DocStringUtil.$$$reportNull$$$0(9);
        }
        return DocStringUtil.parseDocString(format, DocStringUtil.stripPrefixAndQuotes(stringText));
    }

    @NotNull
    public static StructuredDocString parseDocStringContent(@NotNull DocStringFormat format, @NotNull String stringContent) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(10);
        }
        if (stringContent == null) {
            DocStringUtil.$$$reportNull$$$0(11);
        }
        return DocStringUtil.parseDocString(format, new Substring(stringContent));
    }

    @NotNull
    public static StructuredDocString parseDocString(@NotNull DocStringFormat format, @NotNull Substring content) {
        if (format == null) {
            DocStringUtil.$$$reportNull$$$0(12);
        }
        if (content == null) {
            DocStringUtil.$$$reportNull$$$0(13);
        }
        return switch (1.$SwitchMap$com$jetbrains$python$documentation$docstrings$DocStringFormat[format.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> new SphinxDocString(content);
            case 2 -> new EpydocString(content);
            case 3 -> new GoogleCodeStyleDocString(content);
            case 4 -> new NumpyDocString(content);
            case 5 -> new PlainDocString(content);
        };
    }

    @NotNull
    private static Substring stripPrefixAndQuotes(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(14);
        }
        TextRange contentRange = PyStringLiteralUtil.getContentRange(text);
        return new Substring(text, contentRange.getStartOffset(), contentRange.getEndOffset());
    }

    @NotNull
    public static DocStringFormat guessDocStringFormat(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(15);
        }
        if (DocStringUtil.isLikeEpydocDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.EPYTEXT;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(16);
            }
            return docStringFormat;
        }
        if (DocStringUtil.isLikeSphinxDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.REST;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(17);
            }
            return docStringFormat;
        }
        if (DocStringUtil.isLikeNumpyDocstring(text)) {
            DocStringFormat docStringFormat = DocStringFormat.NUMPY;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(18);
            }
            return docStringFormat;
        }
        if (DocStringUtil.isLikeGoogleDocString(text)) {
            DocStringFormat docStringFormat = DocStringFormat.GOOGLE;
            if (docStringFormat == null) {
                DocStringUtil.$$$reportNull$$$0(19);
            }
            return docStringFormat;
        }
        DocStringFormat docStringFormat = DocStringFormat.PLAIN;
        if (docStringFormat == null) {
            DocStringUtil.$$$reportNull$$$0(20);
        }
        return docStringFormat;
    }

    @NotNull
    public static DocStringFormat guessDocStringFormat(@NotNull String text, @Nullable PsiElement anchor) {
        DocStringFormat guessed;
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(21);
        }
        DocStringFormat docStringFormat = (guessed = DocStringUtil.guessDocStringFormat(text)) == DocStringFormat.PLAIN && anchor != null ? DocStringUtil.getConfiguredDocStringFormatOrPlain(anchor) : guessed;
        if (docStringFormat == null) {
            DocStringUtil.$$$reportNull$$$0(22);
        }
        return docStringFormat;
    }

    @Nullable
    public static DocStringFormat getConfiguredDocStringFormat(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            DocStringUtil.$$$reportNull$$$0(23);
        }
        if ((module = DocStringUtil.getModuleForElement(anchor)) == null) {
            return null;
        }
        PyDocumentationSettings settings = PyDocumentationSettings.getInstance((Module)module);
        return settings.getFormatForFile(anchor.getContainingFile());
    }

    @NotNull
    public static DocStringFormat getConfiguredDocStringFormatOrPlain(@NotNull PsiElement anchor) {
        if (anchor == null) {
            DocStringUtil.$$$reportNull$$$0(24);
        }
        DocStringFormat docStringFormat = ObjectUtils.chooseNotNull(DocStringUtil.getConfiguredDocStringFormat(anchor), DocStringFormat.PLAIN);
        if (docStringFormat == null) {
            DocStringUtil.$$$reportNull$$$0(25);
        }
        return docStringFormat;
    }

    public static boolean isLikeSphinxDocString(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(26);
        }
        return text.contains(":param ") || text.contains(":key ") || text.contains(":keyword ") || text.contains(":return:") || text.contains(":returns:") || text.contains(":raise ") || text.contains(":raises ") || text.contains(":except ") || text.contains(":exception ") || text.contains(":rtype") || text.contains(":type") || text.contains(":var") || text.contains(":ivar") || text.contains(":cvar");
    }

    public static boolean isLikeEpydocDocString(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(27);
        }
        return text.contains("@param ") || text.contains("@kwarg ") || text.contains("@keyword ") || text.contains("@kwparam ") || text.contains("@raise ") || text.contains("@raises ") || text.contains("@except ") || text.contains("@exception ") || text.contains("@return:") || text.contains("@rtype") || text.contains("@type") || text.contains("@var") || text.contains("@ivar") || text.contains("@cvar");
    }

    public static boolean isLikeGoogleDocString(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(28);
        }
        for (String title : StringUtil.findMatches(text, GoogleCodeStyleDocString.SECTION_HEADER, 1)) {
            if (!SectionBasedDocString.isValidSectionTitle(title)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLikeNumpyDocstring(@NotNull String text) {
        if (text == null) {
            DocStringUtil.$$$reportNull$$$0(29);
        }
        String[] lines = StringUtil.splitByLines(text, false);
        for (int i = 0; i < lines.length; ++i) {
            String lineBefore;
            String line = lines[i];
            if (!NumpyDocString.SECTION_HEADER.matcher(line).matches() || i <= 0 || !SectionBasedDocString.SECTION_NAMES.contains(StringUtil.toLowerCase((lineBefore = lines[i - 1]).trim()))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PyStringLiteralExpression findDocStringExpression(@Nullable PyElement parent) {
        if (parent != null) {
            PsiElement seeker = PyPsiUtils.getNextNonCommentSibling(parent.getFirstChild(), false);
            if (seeker instanceof PyExpressionStatement) {
                seeker = PyPsiUtils.getNextNonCommentSibling(seeker.getFirstChild(), false);
            }
            if (seeker instanceof PyStringLiteralExpression) {
                return (PyStringLiteralExpression)seeker;
            }
        }
        return null;
    }

    @Nullable
    public static StructuredDocString getStructuredDocString(@NotNull PyDocStringOwner owner) {
        String value;
        if (owner == null) {
            DocStringUtil.$$$reportNull$$$0(30);
        }
        return (value = owner.getDocStringValue()) == null ? null : DocStringUtil.parse(value, owner);
    }

    @Nullable
    public static PyStringLiteralExpression getParentDefinitionDocString(@NotNull PsiElement element) {
        PyStringLiteralExpression docString;
        PyDocStringOwner docStringOwner;
        if (element == null) {
            DocStringUtil.$$$reportNull$$$0(31);
        }
        if ((docStringOwner = PsiTreeUtil.getParentOfType(element, PyDocStringOwner.class)) != null && PsiTreeUtil.isAncestor(docString = docStringOwner.getDocStringExpression(), element, false)) {
            return docString;
        }
        return null;
    }

    public static boolean isDocStringExpression(@NotNull PyExpression expression) {
        if (expression == null) {
            DocStringUtil.$$$reportNull$$$0(32);
        }
        if (DocStringUtil.getParentDefinitionDocString(expression) == expression) {
            return true;
        }
        if (expression instanceof PyStringLiteralExpression) {
            return DocStringUtil.isVariableDocString((PyStringLiteralExpression)expression);
        }
        return false;
    }

    @Nullable
    public static String getAttributeDocComment(@NotNull PyTargetExpression attr) {
        PyAssignmentStatement assignment;
        PsiElement prevSibling;
        PsiElement psiElement;
        if (attr == null) {
            DocStringUtil.$$$reportNull$$$0(33);
        }
        if ((psiElement = attr.getParent()) instanceof PyAssignmentStatement && (prevSibling = PyPsiUtils.getPrevNonWhitespaceSibling(assignment = (PyAssignmentStatement)psiElement)) instanceof PsiComment && prevSibling.getText().startsWith("#:")) {
            return prevSibling.getText().substring(2);
        }
        return null;
    }

    public static boolean isVariableDocString(@NotNull PyStringLiteralExpression expr) {
        PsiElement parent;
        if (expr == null) {
            DocStringUtil.$$$reportNull$$$0(34);
        }
        if (!((parent = expr.getParent()) instanceof PyExpressionStatement)) {
            return false;
        }
        PsiElement prevElement = PyPsiUtils.getPrevNonCommentSibling(parent, true);
        if (prevElement instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)prevElement;
            if (expr.getText().contains("type:")) {
                return true;
            }
            ScopeOwner scope = PsiTreeUtil.getParentOfType(prevElement, ScopeOwner.class);
            if (scope instanceof PyClass || scope instanceof PyFile) {
                return true;
            }
            if (scope instanceof PyFunction) {
                for (PyExpression target : assignmentStatement.getTargets()) {
                    if (!PyUtil.isInstanceAttribute(target)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static Module getModuleForElement(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            DocStringUtil.$$$reportNull$$$0(35);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement(element.getContainingFile())) != null) {
            return module;
        }
        return ArrayUtil.getFirstElement(ModuleManager.getInstance(element.getProject()).getModules());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 16, 17, 18, 19, 20, 22, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 15: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringLiteral";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringContent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringUtil";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attr";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringUtil";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDocStringFormat";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredDocStringFormatOrPlain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocStringValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseDocString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseDocStringContent";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "stripPrefixAndQuotes";
                break;
            }
            case 15: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "guessDocStringFormat";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: {
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDocStringFormat";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredDocStringFormatOrPlain";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isLikeSphinxDocString";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isLikeEpydocDocString";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isLikeGoogleDocString";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isLikeNumpyDocstring";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getStructuredDocString";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getParentDefinitionDocString";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDocStringExpression";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeDocComment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDocString";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 16, 17, 18, 19, 20, 22, 25 -> new IllegalStateException(string);
        };
    }
}

