/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.openapi.util.Pair;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralCoreUtil {
    public static final String PREFIX_CHARACTERS = "ubcrf";
    public static final int MAX_PREFIX_LENGTH = 3;
    private static final List<String> QUOTES = List.of("'''", "\"\"\"", "'", "\"");

    protected PyStringLiteralCoreUtil() {
    }

    @Nullable
    public static Pair<String, String> getQuotes(@NotNull String text) {
        if (text == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(0);
        }
        String prefix = PyStringLiteralCoreUtil.getPrefix(text);
        String mainText = text.substring(prefix.length());
        for (String quote : QUOTES) {
            Pair<String, String> quotes = PyStringLiteralCoreUtil.getQuotes(mainText, prefix, quote);
            if (quotes == null) continue;
            return quotes;
        }
        return null;
    }

    public static int getPrefixEndOffset(@NotNull CharSequence text, int startOffset) {
        int offset;
        if (text == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(1);
        }
        for (offset = startOffset; offset < Math.min(startOffset + 3, text.length()) && PREFIX_CHARACTERS.indexOf(Character.toLowerCase(text.charAt(offset))) >= 0; ++offset) {
        }
        return offset;
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text) {
        if (text == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(2);
        }
        return PyStringLiteralCoreUtil.getPrefix(text, 0);
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text, int startOffset) {
        if (text == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(3);
        }
        String string = text.subSequence(startOffset, PyStringLiteralCoreUtil.getPrefixEndOffset(text, startOffset)).toString();
        if (string == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static Pair<String, String> getQuotes(@NotNull String text, @NotNull String prefix, @NotNull String quote) {
        int n;
        int length;
        if (text == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(6);
        }
        if (quote == null) {
            PyStringLiteralCoreUtil.$$$reportNull$$$0(7);
        }
        if ((length = text.length()) >= 2 * (n = quote.length()) && text.startsWith(quote) && text.endsWith(quote)) {
            return Pair.create(prefix + text.substring(0, n), text.substring(length - n));
        }
        return null;
    }

    public static String stripQuotesAroundValue(String text) {
        Pair<String, String> quotes = PyStringLiteralCoreUtil.getQuotes(text);
        if (quotes == null) {
            return text;
        }
        return text.substring(((String)quotes.first).length(), text.length() - ((String)quotes.second).length());
    }

    public static boolean isQuoted(@Nullable String text) {
        return text != null && PyStringLiteralCoreUtil.getQuotes(text) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyStringLiteralCoreUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyStringLiteralCoreUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuotes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixEndOffset";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

