/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.impl.PyElementImpl;
import com.jetbrains.python.psi.impl.PyStringLiteralDecoder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyFormattedStringElementImpl
extends PyElementImpl
implements PyFormattedStringElement {
    public PyFormattedStringElementImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyFormattedStringElement(this);
    }

    @Override
    @NotNull
    public List<PyFStringFragment> getFragments() {
        List<PyFStringFragment> list = this.findChildrenByType(PyElementTypes.FSTRING_FRAGMENT);
        if (list == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<TextRange> getLiteralPartRanges() {
        List textTokens = this.findChildrenByType(PyTokenTypes.FSTRING_TEXT_TOKENS);
        List<TextRange> list = ContainerUtil.map(textTokens, PsiElement::getTextRangeInParent);
        if (list == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public String getPrefix() {
        String string = PyStringLiteralCoreUtil.getPrefix(this.getText());
        if (string == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public int getPrefixLength() {
        return PyStringLiteralUtil.getPrefixLength(this.getText());
    }

    @Override
    @NotNull
    public TextRange getContentRange() {
        TextRange textRange = this.getTextRange();
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        Object startToken = this.findNotNullChildByType(PyTokenTypes.FSTRING_START);
        Object endToken = this.findChildByType(PyTokenTypes.FSTRING_END);
        TextRange absoluteRange = TextRange.create(startToken.getTextRange().getEndOffset(), endToken != null ? endToken.getTextRange().getStartOffset() : endOffset);
        TextRange textRange2 = absoluteRange.shiftLeft(startOffset);
        if (textRange2 == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(3);
        }
        return textRange2;
    }

    @Override
    @NotNull
    public String getContent() {
        String string = this.getContentRange().substring(this.getText());
        if (string == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public List<Pair<TextRange, String>> getDecodedFragments() {
        ArrayList<Pair<TextRange, String>> result2 = new ArrayList<Pair<TextRange, String>>();
        PyStringLiteralDecoder decoder = new PyStringLiteralDecoder(this);
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType childType = child.getNode().getElementType();
            TextRange relChildRange = child.getTextRangeInParent();
            if (PyTokenTypes.FSTRING_TEXT_TOKENS.contains(childType)) {
                result2.addAll(decoder.decodeRange(relChildRange));
                continue;
            }
            if (childType != PyElementTypes.FSTRING_FRAGMENT) continue;
            result2.add(Pair.create(relChildRange, child.getText()));
        }
        ArrayList<Pair<TextRange, String>> arrayList = result2;
        if (arrayList == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getQuote() {
        Object start = this.findNotNullChildByType(PyTokenTypes.FSTRING_START);
        String string = start.getText().substring(this.getPrefixLength());
        if (string == null) {
            PyFormattedStringElementImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isTripleQuoted() {
        return this.getQuote().length() == 3;
    }

    @Override
    public boolean isTerminated() {
        return this.findChildByType(PyTokenTypes.FSTRING_END) != null;
    }

    @Override
    public boolean isUnicode() {
        return StringUtil.containsIgnoreCase(this.getPrefix(), "u");
    }

    @Override
    public boolean isRaw() {
        return StringUtil.containsIgnoreCase(this.getPrefix(), "r");
    }

    @Override
    public boolean isBytes() {
        return StringUtil.containsIgnoreCase(this.getPrefix(), "b");
    }

    @Override
    public final boolean isFormatted() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/psi/impl/PyFormattedStringElementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPartRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

