/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.graph.OutboundSemiGraph;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DFSTBuilder<Node> {
    @NotNull
    private final OutboundSemiGraph<Node> myGraph;
    private final ToIntFunction<Node> myNodeToNNumber;
    private final Node[] myInvN;
    private Map.Entry<Node, Node> myBackEdge;
    private final Node[] allNodes;
    private Comparator<Node> myNComparator;
    private Comparator<Node> myTComparator;
    private final IntList mySCCs;
    private final ToIntFunction<Node> myNodeToTNumber;
    private final Node[] myInvT;

    public DFSTBuilder(@NotNull OutboundSemiGraph<Node> graph2) {
        if (graph2 == null) {
            DFSTBuilder.$$$reportNull$$$0(0);
        }
        this(graph2, null, false);
    }

    public DFSTBuilder(@NotNull OutboundSemiGraph<Node> graph2, @Nullable Node entryNode) {
        if (graph2 == null) {
            DFSTBuilder.$$$reportNull$$$0(1);
        }
        this(graph2, entryNode, false);
    }

    @ApiStatus.Internal
    public DFSTBuilder(@NotNull OutboundSemiGraph<Node> graph2, @Nullable Node entryNode, boolean useIdentityStrategy) {
        if (graph2 == null) {
            DFSTBuilder.$$$reportNull$$$0(2);
        }
        this.mySCCs = new IntArrayList();
        this.myGraph = graph2;
        this.allNodes = graph2.getNodes().toArray();
        if (entryNode != null) {
            int index;
            int n = index = useIdentityStrategy ? ArrayUtil.indexOfIdentity(this.allNodes, entryNode) : ArrayUtil.indexOf(this.allNodes, entryNode);
            if (index != -1) {
                ArrayUtil.swap(this.allNodes, 0, index);
            }
        }
        int size = this.allNodes.length;
        this.myInvN = new Object[size];
        this.myInvT = new Object[size];
        if (useIdentityStrategy) {
            Reference2IntOpenHashMap nMap = new Reference2IntOpenHashMap(size * 2, 0.5f);
            Reference2IntOpenHashMap tMap = new Reference2IntOpenHashMap();
            this.myNodeToNNumber = nMap;
            this.myNodeToTNumber = tMap;
            new Tarjan((arg_0, arg_1) -> ((Reference2IntOpenHashMap)tMap).put(arg_0, arg_1), (arg_0, arg_1) -> ((Reference2IntOpenHashMap)nMap).put(arg_0, arg_1), this.allNodes, true);
        } else {
            Object2IntOpenHashMap nMap = new Object2IntOpenHashMap(size * 2, 0.5f);
            Object2IntOpenHashMap tMap = new Object2IntOpenHashMap();
            this.myNodeToNNumber = nMap;
            this.myNodeToTNumber = tMap;
            new Tarjan((arg_0, arg_1) -> ((Object2IntOpenHashMap)tMap).put(arg_0, arg_1), (arg_0, arg_1) -> ((Object2IntOpenHashMap)nMap).put(arg_0, arg_1), this.allNodes, false);
        }
    }

    @NotNull
    public Comparator<Node> comparator() {
        Comparator<Node> comparator = this.comparator(this.isAcyclic());
        if (comparator == null) {
            DFSTBuilder.$$$reportNull$$$0(3);
        }
        return comparator;
    }

    @NotNull
    public Comparator<Node> comparator(boolean useNNumber) {
        if (useNNumber) {
            if (this.myNComparator == null) {
                this.myNComparator = Comparator.comparingInt(this.myNodeToNNumber);
            }
            Comparator<Node> comparator = this.myNComparator;
            if (comparator == null) {
                DFSTBuilder.$$$reportNull$$$0(4);
            }
            return comparator;
        }
        if (this.myTComparator == null) {
            this.myTComparator = Comparator.comparingInt(this.myNodeToTNumber);
        }
        Comparator<Node> comparator = this.myTComparator;
        if (comparator == null) {
            DFSTBuilder.$$$reportNull$$$0(5);
        }
        return comparator;
    }

    @Nullable
    public Map.Entry<Node, Node> getCircularDependency() {
        return this.myBackEdge;
    }

    public boolean isAcyclic() {
        return this.getCircularDependency() == null;
    }

    @NotNull
    public Node getNodeByNNumber(int n) {
        Node Node2 = this.myInvN[n];
        if (Node2 == null) {
            DFSTBuilder.$$$reportNull$$$0(6);
        }
        return Node2;
    }

    @NotNull
    public Node getNodeByTNumber(int n) {
        Node Node2 = this.myInvT[n];
        if (Node2 == null) {
            DFSTBuilder.$$$reportNull$$$0(7);
        }
        return Node2;
    }

    @NotNull
    public IntList getSCCs() {
        IntList intList = this.mySCCs;
        if (intList == null) {
            DFSTBuilder.$$$reportNull$$$0(8);
        }
        return intList;
    }

    @NotNull
    public Collection<Collection<Node>> getComponents() {
        final IntList componentSizes = this.getSCCs();
        if (componentSizes.isEmpty()) {
            List<Collection<Node>> list = Collections.emptyList();
            if (list == null) {
                DFSTBuilder.$$$reportNull$$$0(9);
            }
            return list;
        }
        return new MyCollection<Collection<Node>>(componentSizes.size()){

            @Override
            @NotNull
            public Iterator<Collection<Node>> iterator() {
                return new MyIterator<Collection<Node>>(componentSizes.size()){
                    private int offset;

                    @Override
                    protected Collection<Node> get(int i) {
                        final int cSize = componentSizes.getInt(i);
                        final int cOffset = this.offset;
                        if (cSize == 0) {
                            return Collections.emptyList();
                        }
                        this.offset += cSize;
                        return new MyCollection<Node>(cSize){

                            @Override
                            @NotNull
                            public Iterator<Node> iterator() {
                                return new MyIterator<Node>(cSize){

                                    @Override
                                    public Node get(int i) {
                                        return DFSTBuilder.this.getNodeByTNumber(cOffset + i);
                                    }
                                };
                            }
                        };
                    }
                };
            }
        };
    }

    @NotNull
    public List<Node> getSortedNodes() {
        Object[] result2 = (Object[])this.allNodes.clone();
        Arrays.sort(result2, this.comparator());
        List<Object> list = Arrays.asList(result2);
        if (list == null) {
            DFSTBuilder.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/graph/DFSTBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/graph/DFSTBuilder";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "comparator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeByNNumber";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeByTNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSCCs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class Tarjan {
        private final int[] lowLink;
        private final int[] index;
        private final IntStack nodesOnStack;
        private final boolean[] isOnStack;
        private final Deque<TarjanFrame<Node>> frames;
        private int dfsIndex;
        private int sccsSizeCombined;
        private final IntList topo;
        private final ToIntFunction<? super Node> myNodeIndex;

        private Tarjan(ObjIntConsumer<Node> putTNumber, ObjIntConsumer<Node> putNNumber, Node[] allNodes, boolean useIdentityStrategy) {
            this.lowLink = new int[DFSTBuilder.this.myInvN.length];
            this.index = new int[DFSTBuilder.this.myInvN.length];
            this.nodesOnStack = new IntArrayList();
            this.isOnStack = new boolean[this.index.length];
            this.frames = new ArrayDeque();
            this.topo = new IntArrayList(this.index.length);
            this.myNodeIndex = useIdentityStrategy ? this.createReference2IntMap(allNodes) : this.createObject2IntMap(allNodes);
            Arrays.fill(this.index, -1);
            this.build(putTNumber, putNNumber, allNodes);
        }

        private void build(ObjIntConsumer<? super Node> putTNumber, ObjIntConsumer<? super Node> putNNumber, Node[] allNodes) {
            int i;
            for (i = 0; i < this.index.length; ++i) {
                if (this.index[i] != -1) continue;
                this.frames.addLast(new TarjanFrame(i, allNodes, this.buildOuts(allNodes[i])));
                ArrayList sccs = new ArrayList();
                this.strongConnect(sccs, allNodes);
                for (List scc : sccs) {
                    int sccSize = scc.size();
                    DFSTBuilder.this.mySCCs.add(sccSize);
                    int sccBase = this.index.length - this.sccsSizeCombined - sccSize;
                    Object rootNode = allNodes[i];
                    int rIndex = scc.indexOf(rootNode);
                    if (rIndex != -1) {
                        Object e1 = scc.get(rIndex);
                        Object e2 = scc.get(0);
                        scc.set(rIndex, e2);
                        scc.set(0, e1);
                    }
                    for (int j = 0; j < scc.size(); ++j) {
                        Object sccNode = scc.get(j);
                        int tIndex = sccBase + j;
                        ((DFSTBuilder)DFSTBuilder.this).myInvT[tIndex] = sccNode;
                        putTNumber.accept(sccNode, tIndex);
                    }
                    this.sccsSizeCombined += sccSize;
                }
            }
            for (i = 0; i < this.topo.size(); ++i) {
                int nodeI = this.topo.getInt(i);
                Object node = allNodes[nodeI];
                putNNumber.accept(node, this.index.length - 1 - i);
                ((DFSTBuilder)DFSTBuilder.this).myInvN[this.index.length - 1 - i] = node;
            }
            i = 0;
            for (int j = DFSTBuilder.this.mySCCs.size() - 1; i < j; ++i, --j) {
                int tmp = DFSTBuilder.this.mySCCs.getInt(i);
                DFSTBuilder.this.mySCCs.set(i, DFSTBuilder.this.mySCCs.getInt(j));
                DFSTBuilder.this.mySCCs.set(j, tmp);
            }
        }

        private void strongConnect(@NotNull List<? super List<Node>> sccs, Node[] allNodes) {
            if (sccs == null) {
                Tarjan.$$$reportNull$$$0(0);
            }
            int successor = -1;
            block0: while (!this.frames.isEmpty()) {
                int pushedI;
                TarjanFrame pair = this.frames.peekLast();
                int i = pair.nodeI;
                if (this.index[i] == -1) {
                    this.index[i] = this.dfsIndex;
                    this.lowLink[i] = this.dfsIndex++;
                    this.nodesOnStack.push(i);
                    this.isOnStack[i] = true;
                }
                if (ArrayUtil.indexOf(pair.out, successor) != -1) {
                    this.lowLink[i] = Math.min(this.lowLink[i], this.lowLink[successor]);
                }
                successor = i;
                while (pair.nextUnexploredIndex < pair.out.length) {
                    int nextI = pair.out[pair.nextUnexploredIndex++];
                    if (this.index[nextI] == -1) {
                        this.frames.addLast(new TarjanFrame(nextI, allNodes, this.buildOuts(allNodes[nextI])));
                        continue block0;
                    }
                    if (!this.isOnStack[nextI]) continue;
                    this.lowLink[i] = Math.min(this.lowLink[i], this.index[nextI]);
                    if (DFSTBuilder.this.myBackEdge != null) continue;
                    DFSTBuilder.this.myBackEdge = new AbstractMap.SimpleImmutableEntry(allNodes[nextI], allNodes[i]);
                }
                this.frames.removeLast();
                this.topo.add(i);
                if (this.lowLink[i] != this.index[i]) continue;
                ArrayList scc = new ArrayList();
                do {
                    pushedI = this.nodesOnStack.popInt();
                    Object pushed = allNodes[pushedI];
                    this.isOnStack[pushedI] = false;
                    scc.add(pushed);
                } while (pushedI != i);
                sccs.add(scc);
            }
        }

        private int[] buildOuts(@NotNull Node node) {
            if (node == null) {
                Tarjan.$$$reportNull$$$0(1);
            }
            IntArrayList list = new IntArrayList();
            Iterator out = DFSTBuilder.this.myGraph.getOut(node);
            while (out.hasNext()) {
                list.add(this.myNodeIndex.applyAsInt(out.next()));
            }
            return list.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : list.toIntArray();
        }

        @NotNull
        private Object2IntMap<Node> createObject2IntMap(Node[] nodes) {
            Object2IntOpenHashMap result2 = new Object2IntOpenHashMap(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                result2.put(nodes[i], i);
            }
            Object2IntOpenHashMap object2IntOpenHashMap = result2;
            if (object2IntOpenHashMap == null) {
                Tarjan.$$$reportNull$$$0(2);
            }
            return object2IntOpenHashMap;
        }

        @NotNull
        private Reference2IntOpenHashMap<Node> createReference2IntMap(Node[] nodes) {
            Reference2IntOpenHashMap nodeIndex = new Reference2IntOpenHashMap(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                nodeIndex.put(nodes[i], i);
            }
            Reference2IntOpenHashMap reference2IntOpenHashMap = nodeIndex;
            if (reference2IntOpenHashMap == null) {
                Tarjan.$$$reportNull$$$0(3);
            }
            return reference2IntOpenHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sccs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/graph/DFSTBuilder$Tarjan";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/graph/DFSTBuilder$Tarjan";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createObject2IntMap";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReference2IntMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "strongConnect";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "buildOuts";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class MyIterator<T>
    implements Iterator<T> {
        private final int size;
        private int i;

        protected MyIterator(int size) {
            this.size = size;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public T next() {
            if (this.i == this.size) {
                throw new NoSuchElementException();
            }
            return this.get(this.i++);
        }

        protected abstract T get(int var1);

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class MyCollection<T>
    extends AbstractCollection<T> {
        private final int size;

        protected MyCollection(int size) {
            this.size = size;
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static final class TarjanFrame<Node> {
        private final int nodeI;
        private final Node[] allNodes;
        private final int[] out;
        int nextUnexploredIndex;

        TarjanFrame(int nodeI, Node[] allNodes, int[] out) {
            this.nodeI = nodeI;
            this.allNodes = allNodes;
            this.out = out;
        }

        public String toString() {
            StringBuilder o = new StringBuilder();
            o.append(this.allNodes[this.nodeI]).append(" -> [");
            for (int id : this.out) {
                o.append(this.allNodes[id]).append(", ");
            }
            return o.append(']').toString();
        }
    }
}

