/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentRangeMarker
extends RangeMarkerImpl {
    @NotNull
    private LinesCols myLinesCols;
    private volatile boolean documentLoaded;

    PersistentRangeMarker(@NotNull DocumentEx document, int startOffset, int endOffset, boolean register) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(0);
        }
        super(document, startOffset, endOffset, register, false);
        this.myLinesCols = Objects.requireNonNull(PersistentRangeMarker.storeLinesAndCols(document, TextRangeScalarUtil.toScalarRange((int)startOffset, (int)endOffset)));
        this.documentLoaded = true;
    }

    PersistentRangeMarker(@NotNull VirtualFile virtualFile, int startOffset, int endOffset, int startLine, int startCol, int endLine, int endCol, int estimatedDocumentLength, boolean register) {
        if (virtualFile == null) {
            PersistentRangeMarker.$$$reportNull$$$0(1);
        }
        super(virtualFile, startOffset, endOffset, estimatedDocumentLength, register);
        this.myLinesCols = new LinesCols(startLine, startCol, endLine, endCol);
        this.documentLoaded = FileDocumentManager.getInstance().getCachedDocument(virtualFile) != null;
    }

    @Nullable
    static LinesCols storeLinesAndCols(@NotNull Document document, long range) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(2);
        }
        LineCol start = PersistentRangeMarker.calcLineCol(document, TextRangeScalarUtil.startOffset((long)range));
        LineCol end = PersistentRangeMarker.calcLineCol(document, TextRangeScalarUtil.endOffset((long)range));
        if (start == null || end == null) {
            return null;
        }
        return new LinesCols(start.line, start.col, end.line, end.col);
    }

    private static LineCol calcLineCol(@NotNull Document document, int offset) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(3);
        }
        if (offset <= document.getTextLength()) {
            int line = document.getLineNumber(offset);
            int col = offset - document.getLineStartOffset(line);
            if (col < 0) {
                return null;
            }
            return new LineCol(line, col);
        }
        return null;
    }

    @Nullable
    static Pair.NonNull<TextRange, LinesCols> translateViaDiff(@NotNull DocumentEventImpl event, @NotNull LinesCols linesCols) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(4);
        }
        if (linesCols == null) {
            PersistentRangeMarker.$$$reportNull$$$0(5);
        }
        try {
            int myStartLine = event.translateLineViaDiffStrict(linesCols.myStartLine);
            Document document = event.getDocument();
            if (myStartLine < 0 || myStartLine >= document.getLineCount()) {
                return null;
            }
            int start = document.getLineStartOffset(myStartLine) + linesCols.myStartColumn;
            if (start >= document.getTextLength()) {
                return null;
            }
            int myEndLine = event.translateLineViaDiffStrict(linesCols.myEndLine);
            if (myEndLine < 0 || myEndLine >= document.getLineCount()) {
                return null;
            }
            int end = document.getLineStartOffset(myEndLine) + linesCols.myEndColumn;
            if (end > document.getTextLength() || end < start) {
                return null;
            }
            if (end > event.getDocument().getTextLength() || myEndLine < myStartLine || myStartLine == myEndLine && linesCols.myEndColumn < linesCols.myStartColumn || event.getDocument().getLineCount() < myEndLine) {
                return null;
            }
            return Pair.createNonNull(new TextRange(start, end), new LinesCols(myStartLine, linesCols.myStartColumn, myEndLine, linesCols.myEndColumn));
        }
        catch (FilesTooBigForDiffException e) {
            return null;
        }
    }

    @Override
    protected void changedUpdateImpl(@NotNull DocumentEvent event) {
        if (event == null) {
            PersistentRangeMarker.$$$reportNull$$$0(6);
        }
        if (!this.isValid()) {
            return;
        }
        long translatedRange = -1L;
        LinesCols translatedLineCols = null;
        if (PersistentRangeMarkerUtil.shouldTranslateViaDiff((DocumentEvent)event, (long)this.toScalarRange())) {
            Pair.NonNull<TextRange, LinesCols> translated = PersistentRangeMarker.translateViaDiff((DocumentEventImpl)event, this.myLinesCols);
            translatedRange = translated == null ? -1L : TextRangeScalarUtil.toScalarRange((Segment)((Segment)translated.first));
            translatedLineCols = Pair.getSecond(translated);
        }
        if (translatedRange == -1L) {
            RangeMarkerTree.RMNode node = this.myNode;
            long l = translatedRange = node == null ? -1L : PersistentRangeMarker.applyChange(event, node.toScalarRange(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
            if (translatedRange != -1L) {
                translatedLineCols = PersistentRangeMarker.storeLinesAndCols(event.getDocument(), translatedRange);
            }
        }
        if (translatedRange == -1L || translatedLineCols == null) {
            this.invalidate();
        } else {
            this.setRange(translatedRange);
            this.myLinesCols = translatedLineCols;
        }
    }

    @Override
    public String toString() {
        return "PersistentRangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "valid" : "invalid") + "," + this.getStartOffset() + "," + this.getEndOffset() + " " + this.myLinesCols + (this.isGreedyToRight() ? "]" : ")");
    }

    @Override
    public int getStartOffset() {
        if (!this.isDocumentLoaded()) {
            ReadAction.run(() -> this.getDocument());
        }
        return super.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        if (!this.isDocumentLoaded()) {
            ReadAction.run(() -> this.getDocument());
        }
        return super.getEndOffset();
    }

    @Override
    @NotNull
    TextRange reCalcTextRangeAfterReload(@NotNull DocumentImpl document, int tabSize) {
        if (document == null) {
            PersistentRangeMarker.$$$reportNull$$$0(7);
        }
        LinesCols linesCols = this.myLinesCols;
        int startOffset = DocumentUtil.calculateOffset((Document)document, (int)linesCols.myStartLine, (int)linesCols.myStartColumn, (int)tabSize);
        int endOffset = DocumentUtil.calculateOffset((Document)document, (int)linesCols.myEndLine, (int)linesCols.myEndColumn, (int)tabSize);
        this.documentLoaded = true;
        return new UnfairTextRange(startOffset, endOffset);
    }

    private boolean isDocumentLoaded() {
        return this.documentLoaded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linesCols";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/PersistentRangeMarker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "storeLinesAndCols";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcLineCol";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "translateViaDiff";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "changedUpdateImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "reCalcTextRangeAfterReload";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class LinesCols {
        private final int myStartLine;
        private final int myStartColumn;
        private final int myEndLine;
        private final int myEndColumn;

        private LinesCols(int startLine, int startColumn, int endLine, int endColumn) {
            this.myStartLine = startLine;
            this.myStartColumn = startColumn;
            this.myEndLine = endLine;
            this.myEndColumn = endColumn;
        }

        public String toString() {
            return this.myStartLine + ":" + this.myStartColumn + "-" + this.myEndLine + ":" + this.myEndColumn;
        }
    }

    private static class LineCol {
        private final int line;
        private final int col;

        LineCol(int line, int col) {
            this.line = line;
            this.col = col;
        }
    }
}

