/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubstrateRef {
    private static final Logger LOG = Logger.getInstance(SubstrateRef.class);

    @NotNull
    public abstract ASTNode getNode();

    @Nullable
    public Stub getStub() {
        return null;
    }

    @Nullable
    public Stub getGreenStub() {
        return this.getStub();
    }

    public abstract boolean isValid();

    @NotNull
    public abstract PsiFile getContainingFile();

    @NotNull
    static SubstrateRef createInvalidRef(final @NotNull StubBasedPsiElementBase<?> psi) {
        if (psi == null) {
            SubstrateRef.$$$reportNull$$$0(0);
        }
        return new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                throw new PsiInvalidElementAccessException(psi);
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                throw new PsiInvalidElementAccessException(psi);
            }
        };
    }

    @NotNull
    public static SubstrateRef createAstStrongRef(final @NotNull ASTNode node) {
        if (node == null) {
            SubstrateRef.$$$reportNull$$$0(1);
        }
        return new SubstrateRef(){

            @Override
            @NotNull
            public ASTNode getNode() {
                ASTNode aSTNode = node;
                if (aSTNode == null) {
                    2.$$$reportNull$$$0(0);
                }
                return aSTNode;
            }

            @Override
            public boolean isValid() {
                FileASTNode fileElement = SharedImplUtil.findFileElement(node);
                PsiElement file = fileElement == null ? null : fileElement.getPsi();
                return file != null && file.isValid();
            }

            @Override
            @NotNull
            public PsiFile getContainingFile() {
                PsiFile file = SharedImplUtil.getContainingFile(node);
                if (file == null) {
                    throw PsiInvalidElementAccessException.createByNode(node, null);
                }
                PsiFile psiFile = file;
                if (psiFile == null) {
                    2.$$$reportNull$$$0(1);
                }
                return psiFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/psi/impl/source/SubstrateRef$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNode";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getContainingFile";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/SubstrateRef";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInvalidRef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createAstStrongRef";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class StubRef
    extends SubstrateRef {
        private final StubElement<?> myStub;

        public StubRef(@NotNull StubElement<?> stub) {
            if (stub == null) {
                StubRef.$$$reportNull$$$0(0);
            }
            this.myStub = stub;
        }

        @Override
        @NotNull
        public ASTNode getNode() {
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public Stub getStub() {
            StubElement<?> stubElement = this.myStub;
            if (stubElement == null) {
                StubRef.$$$reportNull$$$0(1);
            }
            return stubElement;
        }

        @Override
        public boolean isValid() {
            PsiFileStub<?> fileStub = this.myStub.getContainingFileStub();
            if (fileStub == null) {
                return false;
            }
            PsiFile psi = (PsiFile)fileStub.getPsi();
            return psi != null && psi.isValid();
        }

        @Override
        @NotNull
        public PsiFile getContainingFile() {
            PsiFileStub<?> stub = this.myStub.getContainingFileStub();
            if (stub == null) {
                throw new PsiInvalidElementAccessException((PsiElement)this.myStub.getPsi(), "stub hierarchy is invalid: " + this + " (" + this.getClass() + ") has null containing file stub", null);
            }
            PsiFile psi = (PsiFile)stub.getPsi();
            if (psi != null) {
                PsiFile psiFile = psi;
                if (psiFile == null) {
                    StubRef.$$$reportNull$$$0(2);
                }
                return psiFile;
            }
            PsiFile psiFile = this.reportFileInvalidError(stub);
            if (psiFile == null) {
                StubRef.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        private PsiFile reportFileInvalidError(@NotNull PsiFileStub<?> stub) {
            if (stub == null) {
                StubRef.$$$reportNull$$$0(4);
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            String reason = stub.getInvalidationReason();
            PsiInvalidElementAccessException exception = new PsiInvalidElementAccessException((PsiElement)this.myStub.getPsi(), "no psi for file stub " + stub + " (" + stub.getClass() + "), invalidation reason=" + reason, null);
            if ("stub-psi mismatch".equals(reason)) {
                throw new ProcessCanceledException(exception);
            }
            throw exception;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stub";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/SubstrateRef$StubRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/SubstrateRef$StubRef";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStub";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "reportFileInvalidError";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

