/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.collect.Maps;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FilePropertyKey;
import com.intellij.psi.FilePropertyKeyImpl;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeNodeProcessingResult;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PythonLanguageLevelPusher
implements FilePropertyPusher<LanguageLevel> {
    private static final Key<String> PROJECT_LANGUAGE_LEVEL = new Key("python.project.language.level");
    private static final FilePropertyKey<LanguageLevel> KEY = FilePropertyKeyImpl.createPersistentEnumKey("python.language.level", "python_language_level_persistence", 3, LanguageLevel.class);
    private static final Map<LanguageLevel, LanguageLevel> COMPATIBLE_LEVELS;
    private final Map<Module, Sdk> myModuleSdks = new WeakHashMap<Module, Sdk>();

    private static void addCompatiblePair(Map<LanguageLevel, LanguageLevel> levels, LanguageLevel l1, LanguageLevel l2) {
        levels.put(l1, l2);
        levels.put(l2, l1);
    }

    @Override
    public void initExtra(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        Map<Module, Sdk> moduleSdks = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        this.myModuleSdks.putAll(moduleSdks);
        PythonLanguageLevelPusher.resetProjectLanguageLevel(project);
        this.updateSdkLanguageLevels(project, moduleSdks);
        PythonLanguageLevelPusher.guessLanguageLevelWithCaching(project, moduleSdks::values);
    }

    @Override
    @NotNull
    public FilePropertyKey<LanguageLevel> getFilePropertyKey() {
        FilePropertyKey<LanguageLevel> filePropertyKey = KEY;
        if (filePropertyKey == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return filePropertyKey;
    }

    @Override
    public boolean pushDirectoriesOnly() {
        return true;
    }

    @Override
    @NotNull
    public LanguageLevel getDefaultValue() {
        LanguageLevel languageLevel = LanguageLevel.getDefault();
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    private static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile file) {
        Module module;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        if ((module = ModuleUtilCore.findModuleForFile(file, project)) != null) {
            return PythonSdkUtil.findPythonSdk((Module)module);
        }
        return PythonLanguageLevelPusher.findSdkForFileOutsideTheProject(project, file);
    }

    @Nullable
    private static Sdk findSdkForFileOutsideTheProject(Project project, VirtualFile file) {
        if (file != null) {
            List<OrderEntry> orderEntries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(file);
            for (OrderEntry orderEntry : orderEntries) {
                if (!(orderEntry instanceof JdkOrderEntry)) continue;
                return ((JdkOrderEntry)orderEntry).getJdk();
            }
        }
        return null;
    }

    @Override
    @NotNull
    public LanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && LanguageLevel.FORCE_LANGUAGE_LEVEL != null) {
            LanguageLevel languageLevel = LanguageLevel.FORCE_LANGUAGE_LEVEL;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(7);
            }
            return languageLevel;
        }
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
        LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        return languageLevel;
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        return true;
    }

    private static boolean areLanguageLevelsCompatible(LanguageLevel oldLevel, LanguageLevel newLevel) {
        return oldLevel != null && newLevel != null && COMPATIBLE_LEVELS.get((Object)oldLevel) == newLevel;
    }

    @Override
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull LanguageLevel level) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (fileOrDir == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (level == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        LanguageLevel oldLanguageLevel = KEY.getPersistentValue(fileOrDir);
        boolean changed = KEY.setPersistentValue(fileOrDir, level);
        if (!changed) {
            return;
        }
        if (!PythonLanguageLevelPusher.areLanguageLevelsCompatible(oldLanguageLevel, level) || !ProjectFileIndex.getInstance(project).isInContent(fileOrDir)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, PythonLanguageLevelPusher::isPythonFile);
        }
        for (VirtualFile child : fileOrDir.getChildren()) {
            if (child.isDirectory() || !PythonLanguageLevelPusher.isPythonFile(child)) continue;
            PythonLanguageLevelPusher.clearSdkPathCache(child);
        }
    }

    private static boolean isPythonFile(VirtualFile child) {
        return PythonFileType.INSTANCE.equals(FileTypeRegistry.getInstance().getFileTypeByFileName(child.getNameSequence()));
    }

    private static void clearSdkPathCache(@NotNull VirtualFile child) {
        Project[] projects;
        if (child == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            Sdk sdk = PythonLanguageLevelPusher.getFileSdk(project, child);
            if (sdk == null) continue;
            PythonSdkPathCache pathCache = PythonSdkPathCache.getInstance((Project)project, (Sdk)sdk);
            pathCache.clearCache();
        }
    }

    @Override
    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        Map<Module, Sdk> moduleSdks = PythonLanguageLevelPusher.getPythonModuleSdks(project);
        boolean needToReparseOpenFiles = ContainerUtil.exists(moduleSdks.entrySet(), entry -> {
            Module module = (Module)entry.getKey();
            Sdk newSdk = (Sdk)entry.getValue();
            Sdk oldSdk = this.myModuleSdks.get(module);
            return this.myModuleSdks.containsKey(module) && newSdk != oldSdk;
        });
        this.myModuleSdks.putAll(moduleSdks);
        PythonLanguageLevelPusher.resetProjectLanguageLevel(project);
        this.updateSdkLanguageLevels(project, moduleSdks);
        if (needToReparseOpenFiles) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project.isDisposed()) {
                    return;
                }
                PythonCodeStyleService.getInstance().reparseOpenEditorFiles(project);
            });
        }
    }

    @NotNull
    private static @NotNull Map<@NotNull Module, @NotNull Sdk> getPythonModuleSdks(@NotNull Project project) {
        ModuleManager moduleManager;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        if ((moduleManager = ModuleManager.Companion.getInstanceIfDefined(project)) == null) {
            Map<Module, Sdk> map = Collections.emptyMap();
            if (map == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(19);
            }
            return map;
        }
        LinkedHashMap<Module, Sdk> result2 = new LinkedHashMap<Module, Sdk>();
        for (Module module : moduleManager.getModules()) {
            Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module);
            if (sdk == null) continue;
            result2.put(module, sdk);
        }
        LinkedHashMap<Module, Sdk> linkedHashMap = result2;
        if (linkedHashMap == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(20);
        }
        return linkedHashMap;
    }

    private void updateSdkLanguageLevels(@NotNull Project project, @NotNull Map<Module, Sdk> moduleSdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(21);
        }
        if (moduleSdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(22);
        }
        if (moduleSdks.isEmpty()) {
            return;
        }
        new MyDumbModeTask(project, moduleSdks).queue(project);
    }

    private List<Runnable> getRootUpdateTasks(@NotNull Project project, @NotNull Map<Module, Sdk> moduleSdks) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(23);
        }
        if (moduleSdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(24);
        }
        ArrayList<Runnable> results = new ArrayList<Runnable>();
        for (Map.Entry<Module, Sdk> moduleToSdk : moduleSdks.entrySet()) {
            Module module = moduleToSdk.getKey();
            if (module.isDisposed()) continue;
            Sdk sdk = moduleToSdk.getValue();
            LanguageLevel languageLevel = PythonSdkUtil.isDisposed((Sdk)sdk) ? LanguageLevel.getDefault() : PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            for (VirtualFile root : PyUtil.getSourceRoots(module)) {
                this.addRootIndexingTask(root, results, project, languageLevel, true);
            }
        }
        LinkedHashSet<Sdk> distinctSdks = new LinkedHashSet<Sdk>(moduleSdks.values());
        for (Sdk sdk : distinctSdks) {
            if (PythonSdkUtil.isDisposed((Sdk)sdk)) continue;
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            for (VirtualFile root : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                if (!root.isValid() || PyTypeShed.INSTANCE.isInside(root)) continue;
                this.addRootIndexingTask(root, results, project, languageLevel, false);
            }
        }
        return results;
    }

    private void addRootIndexingTask(@NotNull VirtualFile root, @NotNull List<Runnable> results, @NotNull Project project, @NotNull LanguageLevel languageLevel, boolean iterateAsContent) {
        VirtualFile parent;
        if (root == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(25);
        }
        if (results == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(26);
        }
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(27);
        }
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(28);
        }
        boolean shouldSuppressSizeLimit = (parent = root.getParent()) != null && parent.getName().equals("python_stubs");
        results.add(new UpdateRootTask(project, root, languageLevel, shouldSuppressSizeLimit, iterateAsContent));
    }

    @NotNull
    private static LanguageLevel guessLanguageLevelWithCaching(@NotNull Project project, @NotNull @NotNull Supplier<@NotNull Collection<? extends Sdk>> pythonModuleSdks) {
        LanguageLevel languageLevel;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(29);
        }
        if (pythonModuleSdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(30);
        }
        if ((languageLevel = LanguageLevel.fromPythonVersion(PROJECT_LANGUAGE_LEVEL.get(project))) == null) {
            languageLevel = PythonLanguageLevelPusher.guessLanguageLevel(pythonModuleSdks.get());
            PROJECT_LANGUAGE_LEVEL.set(project, languageLevel.toPythonVersion());
        }
        LanguageLevel languageLevel2 = languageLevel;
        if (languageLevel2 == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(31);
        }
        return languageLevel2;
    }

    private static void resetProjectLanguageLevel(@NotNull Project project) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(32);
        }
        PROJECT_LANGUAGE_LEVEL.set(project, null);
    }

    @NotNull
    private static LanguageLevel guessLanguageLevel(@NotNull @NotNull Collection<? extends @NotNull Sdk> pythonModuleSdks) {
        if (pythonModuleSdks == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(33);
        }
        PythonRuntimeService pythonRuntimeService = PythonRuntimeService.getInstance();
        LanguageLevel languageLevel = pythonModuleSdks.stream().distinct().map(sdk -> pythonRuntimeService.getLanguageLevelForSdk((Sdk)sdk)).max(LanguageLevel.VERSION_COMPARATOR).orElse(LanguageLevel.getDefault());
        if (languageLevel == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(34);
        }
        return languageLevel;
    }

    @NotNull
    public static LanguageLevel getLanguageLevelForVirtualFile(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Sdk sdk;
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(35);
        }
        if (virtualFile == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(36);
        }
        if (virtualFile instanceof VirtualFileWindow) {
            virtualFile = ((VirtualFileWindow)((Object)virtualFile)).getDelegate();
        }
        virtualFile = BackedVirtualFile.getOriginFileIfBacked(virtualFile);
        LanguageLevel forced = LanguageLevel.FORCE_LANGUAGE_LEVEL;
        if (ApplicationManager.getApplication().isUnitTestMode() && forced != null) {
            LanguageLevel languageLevel = forced;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(37);
            }
            return languageLevel;
        }
        LanguageLevel specified = PythonLanguageLevelPusher.specifiedFileLanguageLevel(virtualFile);
        if (specified != null) {
            LanguageLevel languageLevel = specified;
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(38);
            }
            return languageLevel;
        }
        Sdk sdk2 = sdk = virtualFile instanceof LightVirtualFile ? null : PythonLanguageLevelPusher.getFileSdk(project, virtualFile);
        if (sdk != null) {
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk);
            if (languageLevel == null) {
                PythonLanguageLevelPusher.$$$reportNull$$$0(39);
            }
            return languageLevel;
        }
        return PythonLanguageLevelPusher.guessLanguageLevelWithCaching(project, () -> PythonLanguageLevelPusher.getPythonModuleSdks(project).values());
    }

    @TestOnly
    public static void setForcedLanguageLevel(@NotNull Project project, @Nullable LanguageLevel languageLevel) {
        if (project == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(40);
        }
        LanguageLevel.FORCE_LANGUAGE_LEVEL = languageLevel;
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new PythonLanguageLevelPusher()});
    }

    public static void specifyFileLanguageLevel(@NotNull VirtualFile file, @Nullable LanguageLevel languageLevel) {
        if (file == null) {
            PythonLanguageLevelPusher.$$$reportNull$$$0(41);
        }
        KEY.setPersistentValue(file, languageLevel);
    }

    @Nullable
    private static LanguageLevel specifiedFileLanguageLevel(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        LanguageLevel specified = KEY.getPersistentValue(file);
        if (file.isDirectory()) {
            return specified;
        }
        return specified == null ? PythonLanguageLevelPusher.specifiedFileLanguageLevel(file.getParent()) : specified;
    }

    @TestOnly
    public void flushLanguageLevelCache() {
        this.myModuleSdks.clear();
    }

    static {
        EnumMap compatLevels = Maps.newEnumMap(LanguageLevel.class);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON26, LanguageLevel.PYTHON27);
        PythonLanguageLevelPusher.addCompatiblePair(compatLevels, LanguageLevel.PYTHON33, LanguageLevel.PYTHON34);
        COMPATIBLE_LEVELS = Maps.immutableEnumMap((Map)compatLevels);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 7, 8, 19, 20, 31, 34, 37, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 5: 
            case 9: 
            case 11: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSdks";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonModuleSdks";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePropertyKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateValue";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonModuleSdks";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevelWithCaching";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "guessLanguageLevel";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: 
            case 19: 
            case 20: 
            case 31: 
            case 34: 
            case 37: 
            case 38: 
            case 39: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileSdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "clearSdkPathCache";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPythonModuleSdks";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateSdkLanguageLevels";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRootUpdateTasks";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addRootIndexingTask";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevelWithCaching";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "resetProjectLanguageLevel";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "guessLanguageLevel";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageLevelForVirtualFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setForcedLanguageLevel";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "specifyFileLanguageLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 7, 8, 19, 20, 31, 34, 37, 38, 39 -> new IllegalStateException(string);
        };
    }

    private final class MyDumbModeTask
    extends DumbModeTask {
        @NotNull
        private final Project project;
        @NotNull
        private final Map<Module, Sdk> moduleSdks;
        private final SimpleMessageBusConnection connection;

        private MyDumbModeTask(final @NotNull Project project, Map<Module, Sdk> moduleSdks) {
            if (project == null) {
                MyDumbModeTask.$$$reportNull$$$0(0);
            }
            if (moduleSdks == null) {
                MyDumbModeTask.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.moduleSdks = moduleSdks;
            this.connection = project.getMessageBus().simpleConnect();
            this.connection.subscribe(ModuleRootListener.TOPIC, new ModuleRootListener(){

                @Override
                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    DumbService.getInstance(project).cancelTask(MyDumbModeTask.this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$MyDumbModeTask$1", "rootsChanged"));
                }
            });
        }

        @Override
        public void dispose() {
            this.connection.disconnect();
        }

        @Override
        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MyDumbModeTask.$$$reportNull$$$0(2);
            }
            if (this.project.isDisposed()) {
                return;
            }
            indicator.setIndeterminate(true);
            indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
            List tasks = ReadAction.compute(() -> PythonLanguageLevelPusher.this.getRootUpdateTasks(this.project, this.moduleSdks));
            PushedFilePropertiesUpdater.getInstance((Project)this.project).runConcurrentlyIfPossible(tasks);
        }

        @Override
        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            if (taskFromQueue == null) {
                MyDumbModeTask.$$$reportNull$$$0(3);
            }
            if (taskFromQueue instanceof MyDumbModeTask && ((MyDumbModeTask)taskFromQueue).project.equals(this.project) && ((MyDumbModeTask)taskFromQueue).moduleSdks.equals(this.moduleSdks)) {
                return this;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleSdks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskFromQueue";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$MyDumbModeTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performInDumbMode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryMergeWith";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class UpdateRootTask
    implements Runnable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myRoot;
        @NotNull
        private final LanguageLevel myLanguageLevel;
        private final boolean myShouldSuppressSizeLimit;
        private final boolean myIterateAsContent;

        UpdateRootTask(@NotNull Project project, @NotNull VirtualFile root, LanguageLevel languageLevel, boolean shouldSuppressSizeLimit, boolean iterateAsContent) {
            if (project == null) {
                UpdateRootTask.$$$reportNull$$$0(0);
            }
            if (root == null) {
                UpdateRootTask.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                UpdateRootTask.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myRoot = root;
            this.myLanguageLevel = languageLevel;
            this.myShouldSuppressSizeLimit = shouldSuppressSizeLimit;
            this.myIterateAsContent = iterateAsContent;
        }

        @Override
        public void run() {
            if (this.myIterateAsContent) {
                ModuleFileIndex index = ReadAction.compute(() -> {
                    if (this.myProject.isDisposed() || !this.myRoot.isValid()) {
                        return null;
                    }
                    Module module = ProjectFileIndex.getInstance(this.myProject).getModuleForFile(this.myRoot, false);
                    if (module == null) {
                        return null;
                    }
                    return ModuleRootManager.getInstance((Module)module).getFileIndex();
                });
                if (index == null) {
                    return;
                }
                PushedFilePropertiesUpdater propertiesUpdater = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
                index.iterateContentUnderDirectory(this.myRoot, (ContentIterator)((ContentIteratorEx)file -> {
                    if (this.visitFileToPush(file, propertiesUpdater).booleanValue()) {
                        return TreeNodeProcessingResult.CONTINUE;
                    }
                    return TreeNodeProcessingResult.SKIP_CHILDREN;
                }));
                return;
            }
            if (this.myProject.isDisposed() || !ReadAction.compute(() -> this.myRoot.isValid()).booleanValue()) {
                return;
            }
            final PushedFilePropertiesUpdater propertiesUpdater = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
            final ProjectFileIndex projectFileIndex = ReadAction.compute(() -> {
                if (this.myProject.isDisposed()) {
                    return null;
                }
                return ProjectFileIndex.getInstance(this.myProject);
            });
            if (projectFileIndex == null) {
                return;
            }
            VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                @Override
                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!UpdateRootTask.shouldVisit(file, projectFileIndex, UpdateRootTask.this.myRoot)) {
                        return false;
                    }
                    return UpdateRootTask.this.visitFileToPush(file, propertiesUpdater);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask$1", "visitFile"));
                }
            });
        }

        private static boolean shouldVisit(@NotNull VirtualFile file, @NotNull ProjectFileIndex index, @NotNull VirtualFile root) {
            if (file == null) {
                UpdateRootTask.$$$reportNull$$$0(3);
            }
            if (index == null) {
                UpdateRootTask.$$$reportNull$$$0(4);
            }
            if (root == null) {
                UpdateRootTask.$$$reportNull$$$0(5);
            }
            if (file.is(VFileProperty.SYMLINK)) {
                if (!Registry.is("indexer.follows.symlinks")) {
                    return false;
                }
                VirtualFile targetFile = file.getCanonicalFile();
                if (targetFile == null || targetFile.is(VFileProperty.SYMLINK)) {
                    return false;
                }
                if (root.equals(file)) {
                    return true;
                }
                return UpdateRootTask.shouldVisit(targetFile, index, root);
            }
            if (!(file instanceof VirtualFileWithId) || ((VirtualFileWithId)((Object)file)).getId() <= 0) {
                return false;
            }
            return ReadAction.compute(() -> index.isExcluded(file)) == false;
        }

        private Boolean visitFileToPush(@NotNull VirtualFile file, PushedFilePropertiesUpdater propertiesUpdater) {
            if (file == null) {
                UpdateRootTask.$$$reportNull$$$0(6);
            }
            return ReadAction.compute(() -> {
                if (!file.isValid() || PyModuleService.getInstance().isFileIgnored(file)) {
                    return false;
                }
                if (file.isDirectory()) {
                    propertiesUpdater.findAndUpdateValue(file, (FilePropertyPusher)PythonLanguageLevelPusher.this, (Object)this.myLanguageLevel);
                }
                if (this.myShouldSuppressSizeLimit) {
                    SingleRootFileViewProvider.doNotCheckFileSizeLimit(file);
                }
                return true;
            });
        }

        public String toString() {
            return "UpdateRootTask{myRoot=" + this.myRoot + ", myLanguageLevel=" + this.myLanguageLevel + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "index";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/psi/impl/PythonLanguageLevelPusher$UpdateRootTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldVisit";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFileToPush";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

