/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import com.fasterxml.jackson.dataformat.cbor.CBORParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FileAttributes;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.python.tree.Py;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.Validator;
import org.openrewrite.remote.java.RemotingClient;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class PythonParser
implements Parser {
    private final Collection<NamedStyles> styles;
    private final boolean logCompilationWarningsAndErrors;
    private final JavaTypeCache typeCache;
    private final List<Path> pythonPath;
    private final @Nullable Path logFile;
    private final int parseTimeoutMs;
    private @Nullable Process pythonProcess;
    private @Nullable RemotingContext remotingContext;
    private @Nullable RemotingClient client;

    public Stream<SourceFile> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("p" + i + ".py", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> inputs, @Nullable Path relativeTo, ExecutionContext ctx) {
        if (!this.ensureServerRunning(ctx) || this.client == null || this.remotingContext == null) {
            return PlainTextParser.builder().build().parseInputs(inputs, relativeTo, ctx);
        }
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        ParsingEventListener parsingListener = pctx.getParsingListener();
        return this.acceptedInputs(inputs).map(input -> {
            Path path = input.getRelativePath(relativeTo);
            parsingListener.startedParsing(input);
            try {
                SourceFile sourceFile;
                block19: {
                    SourceFile sourceFile2;
                    EncodingDetectingInputStream is;
                    block17: {
                        ParseError parseError;
                        block18: {
                            SourceFile parsed;
                            block15: {
                                SourceFile sourceFile3;
                                block16: {
                                    is = input.getSource(ctx);
                                    try {
                                        parsed = ((SourceFile)this.client.withNewSocket((socket, messenger) -> Objects.requireNonNull((SourceFile)messenger.sendRequest(generator -> {
                                            if (input.isSynthetic() || !Files.isRegularFile(input.getPath(), new LinkOption[0])) {
                                                generator.writeString("parse-python-source");
                                                generator.writeString(is.readFully());
                                            } else {
                                                generator.writeString("parse-python-file");
                                                generator.writeString(input.getPath().toString());
                                            }
                                            if (this.parseTimeoutMs > 0) {
                                                socket.setSoTimeout(this.parseTimeoutMs);
                                            }
                                        }, parser -> {
                                            Tree tree = RemotingMessenger.receiveTree((RemotingContext)this.remotingContext, (CBORParser)parser, null);
                                            return (SourceFile)tree;
                                        }, socket)))).withSourcePath(path).withFileAttributes(FileAttributes.fromPath((Path)input.getPath())).withCharset(this.getCharset(ctx));
                                        if (!(parsed instanceof ParseError)) break block15;
                                        ctx.getOnError().accept(new AssertionError(parsed));
                                        sourceFile3 = parsed;
                                        if (is == null) break block16;
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if (is != null) {
                                                try {
                                                    is.close();
                                                }
                                                catch (Throwable throwable2) {
                                                    throwable.addSuppressed(throwable2);
                                                }
                                            }
                                            throw throwable;
                                        }
                                        catch (Throwable t) {
                                            ctx.getOnError().accept(t);
                                            ParseError parseError2 = ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
                                            return parseError2;
                                        }
                                    }
                                    is.close();
                                }
                                return sourceFile3;
                            }
                            Py.CompilationUnit py = (Py.CompilationUnit)parsed;
                            parsingListener.parsed(input, (SourceFile)py);
                            sourceFile2 = this.validate(py, (Parser.Input)input, relativeTo, ctx);
                            if (!(sourceFile2 instanceof ParseError)) break block17;
                            parseError = ((ParseError)sourceFile2).withErroneous(null);
                            if (is == null) break block18;
                            is.close();
                        }
                        return parseError;
                    }
                    sourceFile = sourceFile2;
                    if (is == null) break block19;
                    is.close();
                }
                return sourceFile;
            }
            finally {
                this.client.getContext().reset();
            }
        });
    }

    private SourceFile validate(SourceFile sourceFile, Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx) {
        assert (this.remotingContext != null);
        Validator validator = this.remotingContext.getProvider(sourceFile.getClass()).newValidator();
        try {
            validator.validate((Tree)sourceFile, ctx);
        }
        catch (Exception e) {
            return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)e);
        }
        return this.requirePrintEqualsInput(sourceFile, input, relativeTo, ctx);
    }

    private boolean ensureServerRunning(ExecutionContext ctx) {
        if (this.client == null || !this.isAlive()) {
            try {
                this.initializeRemoting(ctx);
            }
            catch (IOException e) {
                return false;
            }
        } else {
            Objects.requireNonNull(this.remotingContext).reset();
        }
        return this.client != null && this.isAlive();
    }

    private boolean isAlive() {
        try {
            return (Boolean)Objects.requireNonNull(this.client).runUsingSocket((socket, messenger) -> {
                messenger.sendReset(socket);
                return true;
            });
        }
        catch (Exception e) {
            return false;
        }
    }

    private void initializeRemoting(ExecutionContext ctx) throws IOException {
        RemotingExecutionContextView view = RemotingExecutionContextView.view((ExecutionContext)ctx);
        this.remotingContext = view.getRemotingContext();
        if (this.remotingContext == null) {
            this.remotingContext = new RemotingContext(PythonParser.class.getClassLoader(), false);
            view.setRemotingContext(this.remotingContext);
        } else {
            this.remotingContext.reset();
        }
        int port = 54322;
        if (!PythonParser.isServerRunning(port)) {
            ProcessBuilder processBuilder = new ProcessBuilder("python3", "-m", "rewrite.remote.server", Integer.toString(port));
            if (!this.pythonPath.isEmpty()) {
                Map<String, String> environment = processBuilder.environment();
                environment.compute("PYTHONPATH", (k, current) -> (current != null ? current + File.pathSeparator : "") + this.pythonPath.stream().map(Path::toString).collect(Collectors.joining(File.pathSeparator)));
            }
            File redirectTo = this.logFile != null ? this.logFile.toFile() : new File(System.getProperty("os.name").startsWith("Windows") ? "NULL" : "/dev/null");
            processBuilder.redirectOutput(redirectTo);
            processBuilder.redirectError(redirectTo);
            this.pythonProcess = processBuilder.start();
            for (int i = 0; i < 30 && this.pythonProcess.isAlive() && !PythonParser.isServerRunning(port); ++i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.pythonProcess == null || !this.pythonProcess.isAlive()) {
                this.remotingContext = null;
                return;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.pythonProcess != null && this.pythonProcess.isAlive()) {
                    this.pythonProcess.destroy();
                }
            }));
        }
        this.client = RemotingClient.create((ExecutionContext)ctx, PythonParser.class, () -> {
            try {
                return new Socket(InetAddress.getLoopbackAddress(), port);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public static boolean isServerRunning(int port) {
        boolean bl;
        Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".py");
    }

    public PythonParser reset() {
        this.typeCache.clear();
        if (this.remotingContext != null) {
            this.remotingContext.reset();
            this.remotingContext = null;
        }
        if (this.pythonProcess != null) {
            this.pythonProcess.destroy();
            this.pythonProcess = null;
        }
        this.client = null;
        return this;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.py");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder usingRemotingInstallation(Path dir) {
        return new Builder(dir);
    }

    private static boolean verifyRemotingInstallation(Path dir, @Nullable Path logFile) throws IOException, InterruptedException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        try (InputStream inputStream = Objects.requireNonNull(PythonParser.class.getClassLoader().getResourceAsStream("META-INF/python-requirements.txt"));){
            List packages = new BufferedReader(new InputStreamReader(inputStream)).lines().filter(l -> !l.isEmpty()).collect(Collectors.toList());
            ArrayList<String> command = new ArrayList<String>(Arrays.asList("python3", "-m", "pip", "install", "--target", dir.toString()));
            command.addAll(packages);
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            File redirectTo = logFile != null ? logFile.toFile() : new File(System.getProperty("os.name").startsWith("Windows") ? "NULL" : "/dev/null");
            processBuilder.redirectOutput(redirectTo);
            processBuilder.redirectError(redirectTo);
            Process process = processBuilder.start();
            boolean bl = process.waitFor() == 0;
            return bl;
        }
    }

    @Generated
    private PythonParser(Collection<NamedStyles> styles, boolean logCompilationWarningsAndErrors, JavaTypeCache typeCache, List<Path> pythonPath, @Nullable Path logFile, int parseTimeoutMs) {
        this.styles = styles;
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
        this.typeCache = typeCache;
        this.pythonPath = pythonPath;
        this.logFile = logFile;
        this.parseTimeoutMs = parseTimeoutMs;
    }

    public static class Builder
    extends Parser.Builder {
        private JavaTypeCache typeCache = new JavaTypeCache();
        private @Nullable Path installationDir;
        private boolean logCompilationWarningsAndErrors;
        private final Collection<NamedStyles> styles = new ArrayList<NamedStyles>();
        private List<Path> pythonPath = new ArrayList<Path>();
        private @Nullable Path logFile;
        private long parseTimeoutMs = -1L;

        private Builder() {
            super(Py.CompilationUnit.class);
        }

        private Builder(Path installationDir) {
            super(Py.CompilationUnit.class);
            this.installationDir = installationDir;
        }

        public Builder logCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
            this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
            return this;
        }

        public Builder typeCache(JavaTypeCache typeCache) {
            this.typeCache = typeCache;
            return this;
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public Builder logFile(Path path) {
            this.logFile = path;
            return this;
        }

        public Builder parseTimeout(long timeout, TimeUnit timeUnit) {
            this.parseTimeoutMs = timeUnit.toMillis(timeout);
            return this;
        }

        public Builder pythonPath(List<Path> path) {
            this.pythonPath = new ArrayList<Path>(path);
            return this;
        }

        public PythonParser build() {
            if (this.installationDir != null) {
                try {
                    if (PythonParser.verifyRemotingInstallation(this.installationDir, this.logFile) && !this.pythonPath.contains(this.installationDir)) {
                        this.pythonPath.add(this.installationDir);
                    }
                }
                catch (IOException | InterruptedException exception) {
                    // empty catch block
                }
            }
            return new PythonParser(this.styles, this.logCompilationWarningsAndErrors, this.typeCache, this.pythonPath, this.logFile, (int)this.parseTimeoutMs);
        }

        public String getDslName() {
            return "python";
        }
    }
}

