/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python;

import org.jspecify.annotations.Nullable;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.python.tree.Py;
import org.openrewrite.python.tree.PyContainer;
import org.openrewrite.python.tree.PyLeftPadded;
import org.openrewrite.python.tree.PyRightPadded;
import org.openrewrite.python.tree.PySpace;

public class PythonVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Py.CompilationUnit;
    }

    public String getLanguage() {
        return "python";
    }

    public J visitAsync(Py.Async async, P p) {
        Py.Async a = async;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), PySpace.Location.ASYNC_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(a = a.withMarkers(this.visitMarkers(a.getMarkers(), p)), p);
        if (!(temp instanceof Py.Async)) {
            return temp;
        }
        a = (Py.Async)temp;
        a = a.withStatement((Statement)this.visitAndCast((Tree)a.getStatement(), p));
        return a;
    }

    public J visitAwait(Py.Await ogAwait, P p) {
        Py.Await await = ogAwait;
        await = await.withPrefix(this.visitSpace(await.getPrefix(), PySpace.Location.AWAIT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(await = await.withMarkers(this.visitMarkers(await.getMarkers(), p)), p);
        if (!(temp instanceof Py.Await)) {
            return temp;
        }
        await = (Py.Await)temp;
        await = await.withExpression((Expression)this.visitAndCast((Tree)await.getExpression(), p));
        await = await.withType(this.visitType(await.getType(), p));
        return await;
    }

    public J visitBinary(Py.Binary binary, P p) {
        Py.Binary b = binary;
        b = b.withPrefix(this.visitSpace(b.getPrefix(), PySpace.Location.BINARY_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(b = b.withMarkers(this.visitMarkers(b.getMarkers(), p)), p);
        if (!(temp instanceof Py.Binary)) {
            return temp;
        }
        b = (Py.Binary)temp;
        b = b.withLeft((Expression)this.visitAndCast((Tree)b.getLeft(), p));
        b = b.getPadding().withOperator(this.visitLeftPadded(b.getPadding().getOperator(), PyLeftPadded.Location.BINARY_OPERATOR, p));
        b = b.withRight((Expression)this.visitAndCast((Tree)b.getRight(), p));
        b = b.withType(this.visitType(b.getType(), p));
        return b;
    }

    public J visitChainedAssignment(Py.ChainedAssignment chainedAssignment, P p) {
        Py.ChainedAssignment ca = chainedAssignment;
        ca = ca.withPrefix(this.visitSpace(ca.getPrefix(), PySpace.Location.CHAINED_ASSIGNMENT_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(ca = ca.withMarkers(this.visitMarkers(ca.getMarkers(), p)), p);
        if (!(temp instanceof Py.ChainedAssignment)) {
            return temp;
        }
        ca = (Py.ChainedAssignment)temp;
        ca = ca.getPadding().withVariables(ListUtils.map(ca.getPadding().getVariables(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.CHAINED_ASSIGNMENT_VARIABLE, p)));
        ca = ca.withAssignment((Expression)this.visitAndCast((Tree)ca.getAssignment(), p));
        return ca;
    }

    public J visitCollectionLiteral(Py.CollectionLiteral coll, P p) {
        Py.CollectionLiteral c = coll;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), PySpace.Location.COLLECTION_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(c = c.withMarkers(this.visitMarkers(c.getMarkers(), p)), p);
        if (!(temp instanceof Py.CollectionLiteral)) {
            return temp;
        }
        c = (Py.CollectionLiteral)temp;
        c = c.getPadding().withElements(this.visitContainer(c.getPadding().getElements(), PyContainer.Location.DICT_LITERAL_ELEMENTS, p));
        return c;
    }

    public J visitCompilationUnit(Py.CompilationUnit cu, P p) {
        Py.CompilationUnit c = cu;
        c = c.withPrefix(this.visitSpace(c.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        c = c.withMarkers(this.visitMarkers(c.getMarkers(), p));
        c = c.getPadding().withImports(ListUtils.map(c.getPadding().getImports(), t -> this.visitRightPadded((JRightPadded)t, JRightPadded.Location.IMPORT, p)));
        c = c.withStatements(ListUtils.map(c.getStatements(), e -> (Statement)this.visitAndCast((Tree)e, p)));
        c = c.withEof(this.visitSpace(c.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return c;
    }

    public J visitComprehensionExpression(Py.ComprehensionExpression ogComp, P p) {
        Py.ComprehensionExpression comp = ogComp;
        comp = comp.withPrefix(this.visitSpace(comp.getPrefix(), PySpace.Location.COMPREHENSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(comp = comp.withMarkers(this.visitMarkers(comp.getMarkers(), p)), p);
        if (!(temp instanceof Py.ComprehensionExpression)) {
            return temp;
        }
        comp = (Py.ComprehensionExpression)temp;
        comp = comp.withResult((Expression)this.visitAndCast((Tree)comp.getResult(), p));
        comp = comp.withClauses(ListUtils.map(comp.getClauses(), clause -> (Py.ComprehensionExpression.Clause)this.visitAndCast((Tree)clause, p)));
        comp = comp.withSuffix(this.visitSpace(comp.getSuffix(), PySpace.Location.COMPREHENSION_SUFFIX, p));
        comp = comp.withType(this.visitType(comp.getType(), p));
        return comp;
    }

    public J visitComprehensionClause(Py.ComprehensionExpression.Clause ogClause, P p) {
        Py.ComprehensionExpression.Clause clause = ogClause;
        clause = clause.withPrefix(this.visitSpace(clause.getPrefix(), PySpace.Location.COMPREHENSION_CLAUSE_PREFIX, p));
        clause = clause.withMarkers(this.visitMarkers(clause.getMarkers(), p));
        clause = clause.withIteratorVariable((Expression)this.visitAndCast((Tree)clause.getIteratorVariable(), p));
        clause = clause.withConditions(ListUtils.map(clause.getConditions(), condition -> (Py.ComprehensionExpression.Condition)this.visitAndCast((Tree)condition, p)));
        return clause;
    }

    public J visitComprehensionCondition(Py.ComprehensionExpression.Condition ogCondition, P p) {
        Py.ComprehensionExpression.Condition condition = ogCondition;
        condition = condition.withPrefix(this.visitSpace(condition.getPrefix(), PySpace.Location.COMPREHENSION_CONDITION_PREFIX, p));
        condition = condition.withMarkers(this.visitMarkers(condition.getMarkers(), p));
        condition = condition.withExpression((Expression)this.visitAndCast((Tree)condition.getExpression(), p));
        return condition;
    }

    public J visitDel(Py.Del ogDel, P p) {
        Py.Del del = ogDel;
        del = del.withPrefix(this.visitSpace(del.getPrefix(), PySpace.Location.DEL_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(del = del.withMarkers(this.visitMarkers(del.getMarkers(), p)), p);
        if (!(temp instanceof Py.Del)) {
            return temp;
        }
        del = (Py.Del)temp;
        del = del.getPadding().withTargets(ListUtils.map(del.getPadding().getTargets(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.DEL_ELEMENT, p)));
        return del;
    }

    public J visitDictLiteral(Py.DictLiteral dict, P p) {
        Py.DictLiteral d = dict;
        d = d.withPrefix(this.visitSpace(d.getPrefix(), PySpace.Location.DICT_LITERAL_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(d = d.withMarkers(this.visitMarkers(d.getMarkers(), p)), p);
        if (!(temp instanceof Py.DictLiteral)) {
            return temp;
        }
        d = (Py.DictLiteral)temp;
        d = d.getPadding().withElements(this.visitContainer(d.getPadding().getElements(), PyContainer.Location.DICT_LITERAL_ELEMENTS, p));
        return d;
    }

    public J visitExpressionStatement(Py.ExpressionStatement expressionStatement, P p) {
        Py.ExpressionStatement stmt = expressionStatement;
        stmt = stmt.withExpression((Expression)this.visitAndCast((Tree)stmt.getExpression(), p));
        return this.visitStatement(stmt, p);
    }

    public J visitExceptionType(Py.ExceptionType ogType, P p) {
        Py.ExceptionType type = ogType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), PySpace.Location.EXCEPTION_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withExpression((Expression)this.visitAndCast((Tree)type.getExpression(), p));
        return type;
    }

    public J visitErrorFrom(Py.ErrorFrom ogExpr, P p) {
        Py.ErrorFrom expr = ogExpr;
        expr = expr.withPrefix(this.visitSpace(expr.getPrefix(), PySpace.Location.ERROR_FROM_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(expr = expr.withMarkers(this.visitMarkers(expr.getMarkers(), p)), p);
        if (!(temp instanceof Py.ErrorFrom)) {
            return temp;
        }
        expr = (Py.ErrorFrom)temp;
        expr = expr.withError((Expression)this.visitAndCast((Tree)expr.getError(), p));
        expr = expr.getPadding().withFrom(this.visitLeftPadded(expr.getPadding().getFrom(), PyLeftPadded.Location.ERROR_FROM, p));
        return expr;
    }

    public J visitExpressionTypeTree(Py.ExpressionTypeTree expressionTypeTree, P p) {
        Py.ExpressionTypeTree t = expressionTypeTree;
        t = t.withPrefix(this.visitSpace(t.getPrefix(), PySpace.Location.EXPRESSION_TYPE_TREE_PREFIX, p));
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        t = t.withReference((J)this.visit((Tree)t.getReference(), p));
        return t;
    }

    public J visitForLoop(Py.ForLoop forLoop, P p) {
        Py.ForLoop fl = forLoop;
        fl = fl.withPrefix(this.visitSpace(fl.getPrefix(), PySpace.Location.FOR_LOOP_PREFIX, p));
        fl = fl.withMarkers(this.visitMarkers(fl.getMarkers(), p));
        fl = fl.withTarget((Expression)this.visitAndCast((Tree)fl.getTarget(), p));
        fl = fl.getPadding().withIterable(this.visitLeftPadded(fl.getPadding().getIterable(), PyLeftPadded.Location.FOR_LOOP_ITERABLE, p));
        fl = fl.getPadding().withBody(this.visitRightPadded(fl.getPadding().getBody(), PyRightPadded.Location.FOR_LOOP_BODY, p));
        return fl;
    }

    public J visitFormattedString(Py.FormattedString fString, P p) {
        Py.FormattedString fs = fString;
        fs = fs.withPrefix(this.visitSpace(fs.getPrefix(), PySpace.Location.FORMATTED_STRING_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(fs = fs.withMarkers(this.visitMarkers(fs.getMarkers(), p)), p);
        if (!(temp instanceof Py.FormattedString)) {
            return temp;
        }
        fs = (Py.FormattedString)temp;
        fs = fs.withParts(ListUtils.map(fs.getParts(), part -> (Expression)this.visitAndCast((Tree)part, p)));
        return fs;
    }

    public J visitFormattedStringValue(Py.FormattedString.Value value, P p) {
        Py.FormattedString.Value fv = value;
        fv = fv.withPrefix(this.visitSpace(fv.getPrefix(), PySpace.Location.FORMATTED_STRING_VALUE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(fv = fv.withMarkers(this.visitMarkers(fv.getMarkers(), p)), p);
        if (!(temp instanceof Py.FormattedString.Value)) {
            return temp;
        }
        fv = (Py.FormattedString.Value)temp;
        fv = fv.getPadding().withExpression(this.visitRightPadded(fv.getPadding().getExpression(), PyRightPadded.Location.FORMATTED_STRING_VALUE_EXPRESSION, p));
        fv = fv.getPadding().withDebug(this.visitRightPadded(fv.getPadding().getDebug(), PyRightPadded.Location.FORMATTED_STRING_VALUE_DEBUG, p));
        fv = fv.withFormat((Expression)this.visitAndCast((Tree)fv.getFormat(), p));
        return fv;
    }

    public J visitKeyValue(Py.KeyValue keyValue, P p) {
        Py.KeyValue e = keyValue;
        Expression temp = (Expression)this.visitExpression(e = e.withPrefix(this.visitSpace(e.getPrefix(), PySpace.Location.DICT_ENTRY, p)), p);
        if (!(temp instanceof Py.KeyValue)) {
            return temp;
        }
        e = (Py.KeyValue)temp;
        e = e.getPadding().withKey(this.visitRightPadded(e.getPadding().getKey(), PyRightPadded.Location.DICT_ENTRY_KEY, p));
        e = e.withValue((Expression)this.visitAndCast((Tree)e.getValue(), p));
        e = e.withType(this.visitType(e.getType(), p));
        return e;
    }

    public J visitLiteralType(Py.LiteralType literalType, P p) {
        Py.LiteralType type = literalType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), PySpace.Location.LITERAL_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withLiteral((Expression)this.visitAndCast((Tree)type.getLiteral(), p));
        return type;
    }

    public J visitMatchCasePattern(Py.MatchCase.Pattern ogPattern, P p) {
        Py.MatchCase.Pattern pattern = ogPattern;
        pattern = pattern.withPrefix(this.visitSpace(pattern.getPrefix(), PySpace.Location.MATCH_PATTERN_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(pattern = pattern.withMarkers(this.visitMarkers(pattern.getMarkers(), p)), p);
        if (!(temp instanceof Py.MatchCase.Pattern)) {
            return temp;
        }
        pattern = (Py.MatchCase.Pattern)temp;
        pattern.withChildren(ListUtils.map(pattern.getChildren(), child -> (Expression)this.visitAndCast((Tree)child, p)));
        return pattern;
    }

    public J visitMatchCase(Py.MatchCase ogMatch, P p) {
        Py.MatchCase case_ = ogMatch;
        case_ = case_.withPrefix(this.visitSpace(case_.getPrefix(), PySpace.Location.MATCH_CASE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(case_ = case_.withMarkers(this.visitMarkers(case_.getMarkers(), p)), p);
        if (!(temp instanceof Py.MatchCase)) {
            return temp;
        }
        case_ = (Py.MatchCase)temp;
        case_ = case_.getPadding().withGuard(this.visitLeftPadded(case_.getPadding().getGuard(), PyLeftPadded.Location.MATCH_CASE_GUARD, p));
        case_ = case_.withPattern((Py.MatchCase.Pattern)this.visitAndCast((Tree)case_.getPattern(), p));
        return case_;
    }

    public J visitMultiImport(Py.MultiImport multiImport_, P p) {
        Py.MultiImport mi = multiImport_;
        mi = mi.withPrefix(this.visitSpace(mi.getPrefix(), PySpace.Location.MULTI_IMPORT_PREFIX, p));
        mi = mi.withMarkers(this.visitMarkers(mi.getMarkers(), p));
        mi = mi.getPadding().withFrom(this.visitRightPadded(mi.getPadding().getFrom(), PyRightPadded.Location.MULTI_IMPORT_FROM, p));
        mi = mi.getPadding().withNames(this.visitContainer(mi.getPadding().getNames(), PyContainer.Location.MULTI_IMPORT_NAMES, p));
        return mi;
    }

    public J visitNamedArgument(Py.NamedArgument ogArg, P p) {
        Py.NamedArgument arg = ogArg;
        arg = arg.withPrefix(this.visitSpace(arg.getPrefix(), PySpace.Location.NAMED_ARGUMENT_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(arg = arg.withMarkers(this.visitMarkers(arg.getMarkers(), p)), p);
        if (!(temp instanceof Py.NamedArgument)) {
            return temp;
        }
        arg = (Py.NamedArgument)temp;
        arg = arg.withName((J.Identifier)this.visitAndCast((Tree)arg.getName(), p));
        arg = arg.withType(this.visitType(arg.getType(), p));
        return arg;
    }

    public J visitPass(Py.Pass pass, P p) {
        pass = pass.withPrefix(this.visitSpace(pass.getPrefix(), PySpace.Location.PASS_PREFIX, p));
        pass = pass.withMarkers(this.visitMarkers(pass.getMarkers(), p));
        return this.visitStatement(pass, p);
    }

    public J visitSpecialParameter(Py.SpecialParameter ogParam, P p) {
        Py.SpecialParameter param = ogParam;
        param = param.withPrefix(this.visitSpace(param.getPrefix(), PySpace.Location.SPECIAL_PARAM_PREFIX, p));
        param = param.withMarkers(this.visitMarkers(param.getMarkers(), p));
        param = param.withTypeHint((Py.TypeHint)this.visitAndCast((Tree)param.getTypeHint(), p));
        return param;
    }

    public J visitStar(Py.Star star, P p) {
        Py.Star arg = star;
        arg = arg.withPrefix(this.visitSpace(arg.getPrefix(), PySpace.Location.STAR_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(arg = arg.withMarkers(this.visitMarkers(arg.getMarkers(), p)), p);
        if (!(temp instanceof Py.Star)) {
            return temp;
        }
        arg = (Py.Star)temp;
        arg = arg.withExpression((Expression)this.visitAndCast((Tree)arg.getExpression(), p));
        arg = arg.withType(this.visitType(arg.getType(), p));
        return arg;
    }

    public J visitSlice(Py.Slice slice, P p) {
        Py.Slice sl = slice;
        sl = sl.withPrefix(this.visitSpace(sl.getPrefix(), PySpace.Location.SLICE_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(sl = sl.withMarkers(this.visitMarkers(sl.getMarkers(), p)), p);
        if (!(temp instanceof Py.Slice)) {
            return temp;
        }
        sl = (Py.Slice)temp;
        sl = sl.getPadding().withStart(this.visitRightPadded(sl.getPadding().getStart(), PyRightPadded.Location.SLICE_EXPRESSION_START, p));
        sl = sl.getPadding().withStop(this.visitRightPadded(sl.getPadding().getStop(), PyRightPadded.Location.SLICE_EXPRESSION_STOP, p));
        sl = sl.getPadding().withStep(this.visitRightPadded(sl.getPadding().getStep(), PyRightPadded.Location.SLICE_EXPRESSION_STEP, p));
        return sl;
    }

    public J visitStatementExpression(Py.StatementExpression statementExpression, P p) {
        Py.StatementExpression expr = statementExpression;
        expr = expr.withStatement((Statement)this.visitAndCast((Tree)expr.getStatement(), p));
        return this.visitExpression(expr, p);
    }

    public J visitTypeHint(Py.TypeHint ogType, P p) {
        Py.TypeHint type = ogType;
        type = type.withPrefix(this.visitSpace(type.getPrefix(), PySpace.Location.EXCEPTION_TYPE_PREFIX, p));
        type = type.withMarkers(this.visitMarkers(type.getMarkers(), p));
        type = type.withTypeTree((Expression)this.visitAndCast((Tree)type.getTypeTree(), p));
        return type;
    }

    public J visitTypeHintedExpression(Py.TypeHintedExpression ogExpr, P p) {
        Py.TypeHintedExpression expr = ogExpr;
        expr = expr.withPrefix(this.visitSpace(expr.getPrefix(), PySpace.Location.TYPE_HINTED_EXPRESSION_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(expr = expr.withMarkers(this.visitMarkers(expr.getMarkers(), p)), p);
        if (!(temp instanceof Py.TypeHintedExpression)) {
            return temp;
        }
        expr = (Py.TypeHintedExpression)temp;
        expr = expr.withTypeHint((Py.TypeHint)this.visitAndCast((Tree)expr.getTypeHint(), p));
        expr = expr.withExpression((Expression)this.visitAndCast((Tree)expr.getExpression(), p));
        return expr;
    }

    public J visitTrailingElseWrapper(Py.TrailingElseWrapper ogWrapper, P p) {
        Py.TrailingElseWrapper wrapper = ogWrapper;
        wrapper = wrapper.withPrefix(this.visitSpace(wrapper.getPrefix(), PySpace.Location.TRAILING_ELSE_WRAPPER_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(wrapper = wrapper.withMarkers(this.visitMarkers(wrapper.getMarkers(), p)), p);
        if (!(temp instanceof Py.TrailingElseWrapper)) {
            return temp;
        }
        wrapper = (Py.TrailingElseWrapper)temp;
        wrapper = wrapper.getPadding().withElseBlock((JLeftPadded<J.Block>)this.visitLeftPadded(wrapper.getPadding().getElseBlock(), JLeftPadded.Location.LANGUAGE_EXTENSION, p));
        return wrapper;
    }

    public J visitTypeAlias(Py.TypeAlias typeAlias, P p) {
        Py.TypeAlias a = typeAlias;
        a = a.withPrefix(this.visitSpace(a.getPrefix(), PySpace.Location.TYPE_ALIAS_PREFIX, p));
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.withName((J.Identifier)this.visitAndCast((Tree)a.getName(), p));
        a = a.withValue((J)this.visitAndCast((Tree)a.getValue(), p));
        return a;
    }

    public J visitUnionType(Py.UnionType unionType, P p) {
        Py.UnionType u = unionType;
        u = u.withPrefix(this.visitSpace(u.getPrefix(), PySpace.Location.UNION_TYPE_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(u = u.withMarkers(this.visitMarkers(u.getMarkers(), p)), p);
        if (!(temp instanceof Py.UnionType)) {
            return temp;
        }
        u = (Py.UnionType)temp;
        u = u.getPadding().withTypes(ListUtils.map(u.getPadding().getTypes(), e -> this.visitRightPadded((JRightPadded)e, PyRightPadded.Location.UNION_TYPE_TYPE, p)));
        return u;
    }

    public J visitVariableScope(Py.VariableScope ogStmt, P p) {
        Py.VariableScope stmt = ogStmt;
        stmt = stmt.withPrefix(this.visitSpace(stmt.getPrefix(), PySpace.Location.VARIABLE_SCOPE_PREFIX, p));
        Statement temp = (Statement)this.visitStatement(stmt = stmt.withMarkers(this.visitMarkers(stmt.getMarkers(), p)), p);
        if (!(temp instanceof Py.VariableScope)) {
            return temp;
        }
        stmt = (Py.VariableScope)temp;
        stmt = stmt.getPadding().withNames(ListUtils.map(stmt.getPadding().getNames(), t -> this.visitRightPadded((JRightPadded)t, PyRightPadded.Location.VARIABLE_SCOPE_ELEMENT, p)));
        return stmt;
    }

    public J visitYieldFrom(Py.YieldFrom ogYield, P p) {
        Py.YieldFrom yield = ogYield;
        yield = yield.withPrefix(this.visitSpace(yield.getPrefix(), PySpace.Location.YIELD_FROM_PREFIX, p));
        Expression temp = (Expression)this.visitExpression(yield = yield.withMarkers(this.visitMarkers(yield.getMarkers(), p)), p);
        if (!(temp instanceof Py.YieldFrom)) {
            return temp;
        }
        yield = (Py.YieldFrom)temp;
        return yield;
    }

    public J visitCompilationUnit(J.CompilationUnit cu, P p) {
        throw new UnsupportedOperationException("Python has a different structure for its compilation unit. See P.CompilationUnit.");
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, PyRightPadded.Location loc, P p) {
        return super.visitRightPadded(right, JRightPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, PyLeftPadded.Location loc, P p) {
        return super.visitLeftPadded(left, JLeftPadded.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, PySpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public <J2 extends J> JContainer<J2> visitContainer(JContainer<J2> container, PyContainer.Location loc, P p) {
        return super.visitContainer(container, JContainer.Location.LANGUAGE_EXTENSION, p);
    }
}

