/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.PythonVisitor;
import org.openrewrite.python.marker.KeywordArguments;
import org.openrewrite.python.marker.KeywordOnlyArguments;
import org.openrewrite.python.marker.Quoted;
import org.openrewrite.python.marker.SuppressNewline;
import org.openrewrite.python.tree.Py;
import org.openrewrite.python.tree.PyContainer;
import org.openrewrite.python.tree.PyLeftPadded;
import org.openrewrite.python.tree.PyRightPadded;
import org.openrewrite.python.tree.PySpace;

public class PythonPrinter<P>
extends PythonVisitor<PrintOutputCapture<P>> {
    private final PythonJavaPrinter delegate = new PythonJavaPrinter();
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof Py)) {
            return (J)this.delegate.visitNonNull(Objects.requireNonNull(tree), p);
        }
        return (J)super.visit(tree, p);
    }

    public void setCursor(@Nullable Cursor cursor) {
        super.setCursor(cursor);
        this.delegate.internalSetCursor(cursor);
    }

    private void internalSetCursor(@Nullable Cursor cursor) {
        super.setCursor(cursor);
    }

    @Override
    public J visitCompilationUnit(Py.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        for (JRightPadded<J.Import> jRightPadded : cu.getPadding().getImports()) {
            this.visitRightPadded(jRightPadded, PyRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        for (JRightPadded<J.Import> jRightPadded : cu.getPadding().getStatements()) {
            this.visitRightPadded(jRightPadded, PyRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        if (cu.getMarkers().findFirst(SuppressNewline.class).isPresent() && PythonPrinter.lastCharIs(p, '\n')) {
            p.out.setLength(p.out.length() - 1);
        }
        this.afterSyntax(cu, p);
        return cu;
    }

    @Override
    public J visitBinary(Py.Binary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)binary, PySpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), PySpace.Location.BINARY_OPERATOR, p);
        switch (binary.getOperator()) {
            case NotIn: {
                p.append("not");
                if (binary.getNegation() != null) {
                    this.visitSpace(binary.getNegation(), PySpace.Location.BINARY_NEGATION, p);
                } else {
                    p.append(' ');
                }
                p.append("in");
                break;
            }
            case In: {
                p.append("in");
                break;
            }
            case Is: {
                p.append("is");
                break;
            }
            case IsNot: {
                p.append("is");
                if (binary.getNegation() != null) {
                    this.visitSpace(binary.getNegation(), PySpace.Location.BINARY_NEGATION, p);
                } else {
                    p.append(' ');
                }
                p.append("not");
                break;
            }
            case FloorDivision: {
                p.append("//");
                break;
            }
            case MatrixMultiplication: {
                p.append("@");
                break;
            }
            case Power: {
                p.append("**");
                break;
            }
        }
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitChainedAssignment(Py.ChainedAssignment chainedAssignment, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)chainedAssignment, PySpace.Location.CHAINED_ASSIGNMENT_PREFIX, p);
        this.visitRightPadded(chainedAssignment.getPadding().getVariables(), PyRightPadded.Location.CHAINED_ASSIGNMENT_VARIABLE, "=", p);
        p.append('=');
        this.visit((Tree)chainedAssignment.getAssignment(), p);
        this.afterSyntax(chainedAssignment, p);
        return chainedAssignment;
    }

    @Override
    public J visitCollectionLiteral(Py.CollectionLiteral coll, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)coll, PySpace.Location.COLLECTION_LITERAL_PREFIX, p);
        JContainer<Expression> elements = coll.getPadding().getElements();
        switch (coll.getKind()) {
            case LIST: {
                this.visitContainer("[", elements, PyContainer.Location.COLLECTION_LITERAL_ELEMENTS, ",", "]", p);
                break;
            }
            case SET: {
                this.visitContainer("{", elements, PyContainer.Location.COLLECTION_LITERAL_ELEMENTS, ",", "}", p);
                break;
            }
            case TUPLE: {
                if (elements.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    this.visitContainer("", elements, PyContainer.Location.COLLECTION_LITERAL_ELEMENTS, ",", "", p);
                    break;
                }
                this.visitContainer("(", elements, PyContainer.Location.COLLECTION_LITERAL_ELEMENTS, ",", ")", p);
            }
        }
        this.afterSyntax(coll, p);
        return coll;
    }

    @Override
    public J visitDictLiteral(Py.DictLiteral dict, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)dict, PySpace.Location.DICT_LITERAL_PREFIX, p);
        this.visitContainer("{", dict.getPadding().getElements(), PyContainer.Location.DICT_LITERAL_ELEMENTS, ",", "}", p);
        this.afterSyntax(dict, p);
        return dict;
    }

    @Override
    public J visitForLoop(Py.ForLoop forLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)forLoop, PySpace.Location.FOR_LOOP_PREFIX, p);
        p.append("for");
        this.visit((Tree)forLoop.getTarget(), p);
        this.visitLeftPadded("in", forLoop.getPadding().getIterable(), PyLeftPadded.Location.FOR_LOOP_ITERABLE, p);
        this.visitRightPadded(forLoop.getPadding().getBody(), PyRightPadded.Location.FOR_LOOP_BODY, p);
        return forLoop;
    }

    @Override
    public J visitFormattedString(Py.FormattedString fString, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)fString, PySpace.Location.FORMATTED_STRING_PREFIX, p);
        p.append(fString.getDelimiter());
        this.visit(fString.getParts(), p);
        if (!fString.getDelimiter().isEmpty()) {
            int idx = Math.max(fString.getDelimiter().indexOf(39), fString.getDelimiter().indexOf(34));
            p.append(fString.getDelimiter().substring(idx));
        }
        return fString;
    }

    @Override
    public J visitFormattedStringValue(Py.FormattedString.Value value, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)value, PySpace.Location.FORMATTED_STRING_VALUE_PREFIX, p);
        p.append('{');
        this.visitRightPadded(value.getPadding().getExpression(), PyRightPadded.Location.FORMATTED_STRING_VALUE_EXPRESSION, p);
        if (value.getPadding().getDebug() != null) {
            p.append('=');
            this.visitSpace(value.getPadding().getDebug().getAfter(), PySpace.Location.FORMATTED_STRING_VALUE_DEBUG_SUFFIX, p);
        }
        if (value.getConversion() != null) {
            p.append('!');
            switch (value.getConversion()) {
                case STR: {
                    p.append('s');
                    break;
                }
                case REPR: {
                    p.append('r');
                    break;
                }
                case ASCII: {
                    p.append('a');
                }
            }
        }
        if (value.getFormat() != null) {
            p.append(':');
            this.visit((Tree)value.getFormat(), p);
        }
        p.append('}');
        return value;
    }

    @Override
    public J visitMultiImport(Py.MultiImport multiImport_, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)multiImport_, PySpace.Location.MULTI_IMPORT_PREFIX, p);
        if (multiImport_.getFrom() != null) {
            p.append("from");
            this.visitRightPadded(multiImport_.getPadding().getFrom(), PyRightPadded.Location.MULTI_IMPORT_FROM, p);
        }
        p.append("import");
        if (multiImport_.isParenthesized()) {
            this.visitContainer("(", multiImport_.getPadding().getNames(), PyContainer.Location.MULTI_IMPORT_NAMES, ",", ")", p);
        } else {
            this.visitContainer("", multiImport_.getPadding().getNames(), PyContainer.Location.MULTI_IMPORT_NAMES, ",", "", p);
        }
        this.afterSyntax(multiImport_, p);
        return multiImport_;
    }

    @Override
    public J visitKeyValue(Py.KeyValue keyValue, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)keyValue, PySpace.Location.KEY_VALUE_PREFIX, p);
        this.visitRightPadded(keyValue.getPadding().getKey(), PyRightPadded.Location.KEY_VALUE_KEY_SUFFIX, p);
        p.append(':');
        this.visit((Tree)keyValue.getValue(), p);
        this.afterSyntax(keyValue, p);
        return keyValue;
    }

    @Override
    public J visitPass(Py.Pass pass, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)pass, PySpace.Location.PASS_PREFIX, p);
        p.append("pass");
        this.afterSyntax(pass, p);
        return pass;
    }

    @Override
    public J visitComprehensionExpression(Py.ComprehensionExpression comp, PrintOutputCapture<P> p) {
        String close;
        String open;
        this.beforeSyntax((Py)comp, PySpace.Location.COMPREHENSION_PREFIX, p);
        switch (comp.getKind()) {
            case DICT: 
            case SET: {
                open = "{";
                close = "}";
                break;
            }
            case LIST: {
                open = "[";
                close = "]";
                break;
            }
            case GENERATOR: {
                if (comp.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    open = "";
                    close = "";
                    break;
                }
                open = "(";
                close = ")";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        p.append(open);
        this.visit((Tree)comp.getResult(), p);
        for (Py.ComprehensionExpression.Clause clause : comp.getClauses()) {
            this.visit((Tree)clause, p);
        }
        this.visitSpace(comp.getSuffix(), PySpace.Location.COMPREHENSION_SUFFIX, p);
        p.append(close);
        this.afterSyntax(comp, p);
        return comp;
    }

    @Override
    public J visitComprehensionClause(Py.ComprehensionExpression.Clause clause, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)clause, PySpace.Location.COMPREHENSION_CLAUSE_PREFIX, p);
        if (clause.isAsync()) {
            p.append("async");
            this.visitSpace(clause.getPadding().getAsync().getAfter(), PySpace.Location.COMPREHENSION_CLAUSE_ASYNC, p);
        }
        p.append("for");
        this.visit((Tree)clause.getIteratorVariable(), p);
        this.visitSpace(clause.getPadding().getIteratedList().getBefore(), PySpace.Location.COMPREHENSION_IN, p);
        p.append("in");
        this.visit((Tree)clause.getIteratedList(), p);
        if (clause.getConditions() != null) {
            for (Py.ComprehensionExpression.Condition condition : clause.getConditions()) {
                this.visit((Tree)condition, p);
            }
        }
        return clause;
    }

    @Override
    public J visitComprehensionCondition(Py.ComprehensionExpression.Condition condition, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)condition, PySpace.Location.COMPREHENSION_CONDITION_PREFIX, p);
        p.append("if");
        this.visit((Tree)condition.getExpression(), p);
        return condition;
    }

    @Override
    public J visitAsync(Py.Async async, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)async, PySpace.Location.ASYNC_PREFIX, p);
        p.append("async");
        this.visit((Tree)async.getStatement(), p);
        return async;
    }

    @Override
    public J visitAwait(Py.Await await, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)await, PySpace.Location.AWAIT_PREFIX, p);
        p.append("await");
        this.visit((Tree)await.getExpression(), p);
        return await;
    }

    @Override
    public J visitYieldFrom(Py.YieldFrom yield, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)yield, PySpace.Location.YIELD_FROM_PREFIX, p);
        p.append("from");
        this.visit((Tree)yield.getExpression(), p);
        return yield;
    }

    @Override
    public J visitVariableScope(Py.VariableScope scope, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)scope, PySpace.Location.VARIABLE_SCOPE_PREFIX, p);
        switch (scope.getKind()) {
            case GLOBAL: {
                p.append("global");
                break;
            }
            case NONLOCAL: {
                p.append("nonlocal");
            }
        }
        this.visitRightPadded(scope.getPadding().getNames(), PyRightPadded.Location.VARIABLE_SCOPE_ELEMENT, ",", p);
        return scope;
    }

    @Override
    public J visitDel(Py.Del del, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)del, PySpace.Location.DEL_PREFIX, p);
        p.append("del");
        this.visitRightPadded(del.getPadding().getTargets(), PyRightPadded.Location.DEL_ELEMENT, ",", p);
        return del;
    }

    @Override
    public J visitExceptionType(Py.ExceptionType type, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)type, PySpace.Location.EXCEPTION_TYPE_PREFIX, p);
        if (type.isExceptionGroup()) {
            p.append("*");
        }
        this.visit((Tree)type.getExpression(), p);
        return type;
    }

    @Override
    public J visitErrorFrom(Py.ErrorFrom expr, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)expr, PySpace.Location.ERROR_FROM_PREFIX, p);
        this.visit((Tree)expr.getError(), p);
        this.visitSpace(expr.getPadding().getFrom().getBefore(), PySpace.Location.ERROR_FROM_SOURCE, p);
        p.append("from");
        this.visit((Tree)expr.getFrom(), p);
        return expr;
    }

    @Override
    public J visitLiteralType(Py.LiteralType literalType, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)literalType, PySpace.Location.LITERAL_TYPE_PREFIX, p);
        this.visit((Tree)literalType.getLiteral(), p);
        this.afterSyntax(literalType, p);
        return literalType;
    }

    @Override
    public J visitMatchCase(Py.MatchCase match, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)match, PySpace.Location.MATCH_CASE_PREFIX, p);
        this.visit((Tree)match.getPattern(), p);
        if (match.getPadding().getGuard() != null) {
            this.visitSpace(match.getPadding().getGuard().getBefore(), PySpace.Location.MATCH_CASE_GUARD, p);
            p.append("if");
            this.visit((Tree)match.getGuard(), p);
        }
        return match;
    }

    @Override
    public J visitMatchCasePattern(Py.MatchCase.Pattern pattern, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)pattern, PySpace.Location.MATCH_PATTERN_PREFIX, p);
        JContainer<Expression> children = pattern.getPadding().getChildren();
        switch (pattern.getKind()) {
            case AS: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "as", "", p);
                break;
            }
            case CAPTURE: 
            case LITERAL: {
                this.visitContainer(children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, p);
                break;
            }
            case CLASS: {
                this.visitSpace(children.getBefore(), PySpace.Location.MATCH_PATTERN_ELEMENT_PREFIX, p);
                this.visitRightPadded((JRightPadded)children.getPadding().getElements().get(0), PyRightPadded.Location.MATCH_PATTERN_ELEMENT, p);
                this.visitContainer("(", (JContainer<J>)JContainer.build(children.getPadding().getElements().subList(1, children.getElements().size())), PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", ")", p);
                break;
            }
            case DOUBLE_STAR: {
                this.visitContainer("**", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
                break;
            }
            case KEY_VALUE: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ":", "", p);
                break;
            }
            case KEYWORD: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "=", "", p);
                break;
            }
            case MAPPING: {
                this.visitContainer("{", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", "}", p);
                break;
            }
            case OR: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "|", "", p);
                break;
            }
            case SEQUENCE: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", "", p);
                break;
            }
            case SEQUENCE_LIST: {
                this.visitContainer("[", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", "]", p);
                break;
            }
            case GROUP: 
            case SEQUENCE_TUPLE: {
                this.visitContainer("(", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", ")", p);
                break;
            }
            case STAR: {
                this.visitContainer("*", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
                break;
            }
            case VALUE: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
                break;
            }
            case WILDCARD: {
                this.visitContainer("_", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
            }
        }
        return pattern;
    }

    @Override
    public J visitSpecialParameter(Py.SpecialParameter param, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)param, PySpace.Location.SPECIAL_PARAM_PREFIX, p);
        switch (param.getKind()) {
            case ARGS: {
                p.append("*");
                break;
            }
            case KWARGS: {
                p.append("**");
            }
        }
        this.afterSyntax(param, p);
        return param;
    }

    @Override
    public J visitNamedArgument(Py.NamedArgument arg, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)arg, PySpace.Location.NAMED_ARGUMENT, p);
        this.visit((Tree)arg.getName(), p);
        this.visitLeftPadded("=", arg.getPadding().getValue(), PyLeftPadded.Location.NAMED_ARGUMENT, p);
        return arg;
    }

    @Override
    public J visitSlice(Py.Slice slice, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)slice, PySpace.Location.SLICE_EXPRESSION_PREFIX, p);
        this.visitRightPadded(slice.getPadding().getStart(), PyRightPadded.Location.SLICE_EXPRESSION_START, p);
        p.append(':');
        if (slice.getPadding().getStop() != null) {
            this.visitRightPadded(slice.getPadding().getStop(), PyRightPadded.Location.SLICE_EXPRESSION_STOP, p);
            if (slice.getPadding().getStep() != null) {
                p.append(':');
                this.visitRightPadded(slice.getPadding().getStep(), PyRightPadded.Location.SLICE_EXPRESSION_STEP, p);
            }
        }
        return slice;
    }

    @Override
    public J visitStar(Py.Star star, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)star, PySpace.Location.STAR_PREFIX, p);
        switch (star.getKind()) {
            case LIST: {
                p.append("*");
                break;
            }
            case DICT: {
                p.append("**");
            }
        }
        this.visit((Tree)star.getExpression(), p);
        this.afterSyntax(star, p);
        return star;
    }

    @Override
    public J visitTrailingElseWrapper(Py.TrailingElseWrapper wrapper, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)wrapper, PySpace.Location.TRAILING_ELSE_WRAPPER_PREFIX, p);
        this.visit((Tree)wrapper.getStatement(), p);
        if (!(wrapper.getStatement() instanceof J.Try)) {
            this.visitSpace(wrapper.getPadding().getElseBlock().getBefore(), Space.Location.ELSE_PREFIX, p);
            p.append("else");
            this.visit((Tree)wrapper.getElseBlock(), p);
        }
        this.afterSyntax(wrapper, p);
        return wrapper;
    }

    @Override
    public J visitTypeHint(Py.TypeHint type, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)type, PySpace.Location.TYPE_HINT_PREFIX, p);
        J parent = (J)this.getCursor().getParentTreeCursor().getValue();
        if (parent instanceof J.MethodDeclaration) {
            p.append("->");
        } else {
            p.append(':');
        }
        this.visit((Tree)type.getTypeTree(), p);
        this.afterSyntax(type, p);
        return type;
    }

    @Override
    public J visitTypeHintedExpression(Py.TypeHintedExpression expr, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)expr, PySpace.Location.TYPE_HINTED_EXPRESSION_PREFIX, p);
        this.visit((Tree)expr.getExpression(), p);
        this.visit((Tree)expr.getTypeHint(), p);
        this.afterSyntax(expr, p);
        return expr;
    }

    @Override
    public J visitTypeAlias(Py.TypeAlias typeAlias, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)typeAlias, PySpace.Location.UNION_TYPE_PREFIX, p);
        p.append("type");
        this.visit((Tree)typeAlias.getName(), p);
        this.visitLeftPadded("=", typeAlias.getPadding().getValue(), PyLeftPadded.Location.TYPE_ALIAS_VALUE, p);
        this.afterSyntax(typeAlias, p);
        return typeAlias;
    }

    @Override
    public J visitUnionType(Py.UnionType unionType, PrintOutputCapture<P> p) {
        this.beforeSyntax((Py)unionType, PySpace.Location.UNION_TYPE_PREFIX, p);
        this.visitRightPadded(unionType.getPadding().getTypes(), PyRightPadded.Location.UNION_TYPE_TYPE, "|", p);
        this.afterSyntax(unionType, p);
        return unionType;
    }

    private static boolean lastCharIs(PrintOutputCapture<?> p, char c) {
        return p.out.length() != 0 && p.out.charAt(p.out.length() - 1) == c;
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private void beforeSyntax(Py py, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(py.getPrefix(), py.getMarkers(), loc, p);
    }

    private void beforeSyntax(Py py, PySpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(py.getPrefix(), py.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable PySpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void beforeSyntax(Space prefix, Markers markers, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Py py, PrintOutputCapture<P> p) {
        this.afterSyntax(py.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    @Override
    public Space visitSpace(Space space, PySpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, PyContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after == null ? "" : after);
    }

    private <T extends Tree> void visitLeftPadded(String s, JLeftPadded<T> left, PyLeftPadded.Location loc, PrintOutputCapture<P> p) {
        this.delegate.visitSpace(left.getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
        p.append(s);
        this.setCursor(new Cursor(this.getCursor(), left));
        Tree t = (Tree)left.getElement();
        if (t instanceof J) {
            this.visitAndCast((Tree)left.getElement(), p);
        }
        this.setCursor(this.getCursor().getParent());
        this.visitMarkers(left.getMarkers(), p);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, PyRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    private class PythonJavaPrinter
    extends JavaPrinter<P> {
        private PythonJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof Py) {
                return (J)PythonPrinter.this.visitNonNull(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public void setCursor(@Nullable Cursor cursor) {
            super.setCursor(cursor);
            PythonPrinter.this.internalSetCursor(cursor);
        }

        public void internalSetCursor(@Nullable Cursor cursor) {
            super.setCursor(cursor);
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            p.append("@");
            this.visit((Tree)annotation.getAnnotationType(), p);
            this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitArrayDimension(J.ArrayDimension arrayDimension, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)arrayDimension, Space.Location.DIMENSION_PREFIX, p);
            p.append("[");
            this.visitRightPadded(arrayDimension.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, "]", p);
            this.afterSyntax((J)arrayDimension, p);
            return arrayDimension;
        }

        public J visitAssert(J.Assert azzert, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)azzert, Space.Location.ASSERT_PREFIX, p);
            p.append("assert");
            this.visit((Tree)azzert.getCondition(), p);
            if (azzert.getDetail() != null) {
                this.visitLeftPadded(",", azzert.getDetail(), JLeftPadded.Location.ASSERT_DETAIL, p);
            }
            this.afterSyntax((J)azzert, p);
            return azzert;
        }

        public J visitAssignment(J.Assignment assignment, PrintOutputCapture<P> p) {
            J parentTree = (J)this.getCursor().getParentTreeCursor().getValue();
            String symbol = parentTree instanceof J.Block || parentTree instanceof Py.CompilationUnit || parentTree instanceof J.If && ((J.If)parentTree).getThenPart() == assignment || parentTree instanceof J.If.Else && ((J.If.Else)parentTree).getBody() == assignment || parentTree instanceof Loop && ((Loop)parentTree).getBody() == assignment ? "=" : ":=";
            this.beforeSyntax((J)assignment, Space.Location.ASSIGNMENT_PREFIX, p);
            this.visit((Tree)assignment.getVariable(), p);
            this.visitLeftPadded(symbol, assignment.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, p);
            this.afterSyntax((J)assignment, p);
            return assignment;
        }

        public J visitAssignmentOperation(J.AssignmentOperation assignOp, PrintOutputCapture<P> p) {
            String keyword = "";
            switch (assignOp.getOperator()) {
                case Addition: {
                    keyword = "+=";
                    break;
                }
                case Subtraction: {
                    keyword = "-=";
                    break;
                }
                case Multiplication: {
                    keyword = "*=";
                    break;
                }
                case Division: {
                    keyword = "/=";
                    break;
                }
                case Modulo: {
                    keyword = "%=";
                    break;
                }
                case BitAnd: {
                    keyword = "&=";
                    break;
                }
                case BitOr: {
                    keyword = "|=";
                    break;
                }
                case BitXor: {
                    keyword = "^=";
                    break;
                }
                case LeftShift: {
                    keyword = "<<=";
                    break;
                }
                case RightShift: {
                    keyword = ">>=";
                    break;
                }
                case UnsignedRightShift: {
                    keyword = ">>>=";
                    break;
                }
                case Exponentiation: {
                    keyword = "**=";
                    break;
                }
                case FloorDivision: {
                    keyword = "//=";
                    break;
                }
                case MatrixMultiplication: {
                    keyword = "@=";
                }
            }
            this.beforeSyntax((J)assignOp, Space.Location.ASSIGNMENT_OPERATION_PREFIX, p);
            this.visit((Tree)assignOp.getVariable(), p);
            this.visitSpace(assignOp.getPadding().getOperator().getBefore(), Space.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
            p.append(keyword);
            this.visit((Tree)assignOp.getAssignment(), p);
            this.afterSyntax((J)assignOp, p);
            return assignOp;
        }

        public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
            String keyword = "";
            switch (binary.getOperator()) {
                case Addition: {
                    keyword = "+";
                    break;
                }
                case Subtraction: {
                    keyword = "-";
                    break;
                }
                case Multiplication: {
                    keyword = "*";
                    break;
                }
                case Division: {
                    keyword = "/";
                    break;
                }
                case Modulo: {
                    keyword = "%";
                    break;
                }
                case LessThan: {
                    keyword = "<";
                    break;
                }
                case GreaterThan: {
                    keyword = ">";
                    break;
                }
                case LessThanOrEqual: {
                    keyword = "<=";
                    break;
                }
                case GreaterThanOrEqual: {
                    keyword = ">=";
                    break;
                }
                case Equal: {
                    keyword = "==";
                    break;
                }
                case NotEqual: {
                    keyword = "!=";
                    break;
                }
                case BitAnd: {
                    keyword = "&";
                    break;
                }
                case BitOr: {
                    keyword = "|";
                    break;
                }
                case BitXor: {
                    keyword = "^";
                    break;
                }
                case LeftShift: {
                    keyword = "<<";
                    break;
                }
                case RightShift: {
                    keyword = ">>";
                    break;
                }
                case UnsignedRightShift: {
                    keyword = ">>>";
                    break;
                }
                case Or: {
                    keyword = "or";
                    break;
                }
                case And: {
                    keyword = "and";
                }
            }
            this.beforeSyntax((J)binary, Space.Location.BINARY_PREFIX, p);
            this.visit((Tree)binary.getLeft(), p);
            this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
            p.append(keyword);
            this.visit((Tree)binary.getRight(), p);
            this.afterSyntax((J)binary, p);
            return binary;
        }

        public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)block, Space.Location.BLOCK_PREFIX, p);
            p.append(':');
            this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
            this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            this.afterSyntax((J)block, p);
            return block;
        }

        public J visitCase(J.Case ca, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ca, Space.Location.CASE_PREFIX, p);
            Expression elem = (Expression)ca.getExpressions().get(0);
            if (!(elem instanceof J.Identifier) || !((J.Identifier)elem).getSimpleName().equals("default")) {
                p.append("case");
            }
            this.visitContainer("", ca.getPadding().getExpressions(), JContainer.Location.CASE_EXPRESSION, ",", "", p);
            this.visitSpace(ca.getPadding().getStatements().getBefore(), Space.Location.CASE, p);
            this.visitStatements(ca.getPadding().getStatements().getPadding().getElements(), JRightPadded.Location.CASE, p);
            if (ca.getBody() instanceof Statement) {
                this.visitRightPadded(ca.getPadding().getBody(), JRightPadded.Location.LANGUAGE_EXTENSION, p);
            } else {
                this.visitRightPadded(ca.getPadding().getBody(), JRightPadded.Location.CASE_BODY, ";", p);
            }
            this.afterSyntax((J)ca, p);
            return ca;
        }

        public J visitCatch(J.Try.Catch ca, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ca, Space.Location.CATCH_PREFIX, p);
            p.append("except");
            J.VariableDeclarations multiVariable = (J.VariableDeclarations)ca.getParameter().getTree();
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visit((Tree)multiVariable.getTypeExpression(), p);
            for (JRightPadded paddedVariable : multiVariable.getPadding().getVariables()) {
                J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)paddedVariable.getElement();
                if (variable.getName().getSimpleName().isEmpty()) continue;
                this.visitSpace(paddedVariable.getAfter(), Space.Location.LANGUAGE_EXTENSION, p);
                this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
                p.append("as");
                this.visit((Tree)variable.getName(), p);
                this.afterSyntax((J)variable, p);
            }
            this.afterSyntax((J)multiVariable, p);
            this.visit((Tree)ca.getBody(), p);
            this.afterSyntax((J)ca, p);
            return ca;
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(classDecl.getLeadingAnnotations(), p);
            this.visit(classDecl.getPadding().getKind().getAnnotations(), p);
            this.visitSpace(classDecl.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
            p.append("class");
            this.visit((Tree)classDecl.getName(), p);
            if (classDecl.getPadding().getImplements() != null) {
                boolean omitParens = classDecl.getPadding().getImplements().getMarkers().findFirst(OmitParentheses.class).isPresent();
                this.visitContainer(omitParens ? "" : "(", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", omitParens ? "" : ")", p);
            }
            this.visit((Tree)classDecl.getBody(), p);
            this.afterSyntax((J)classDecl, p);
            return classDecl;
        }

        public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
            this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, "", p);
            this.afterSyntax((J)controlParens, p);
            return controlParens;
        }

        public J visitElse(J.If.Else else_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)else_, Space.Location.ELSE_PREFIX, p);
            if (this.getCursor().getParentTreeCursor().getValue() instanceof J.If && else_.getBody() instanceof J.If) {
                p.append("el");
                this.visit((Tree)else_.getBody(), p);
            } else if (else_.getBody() instanceof J.Block) {
                p.append("else");
                this.visit((Tree)else_.getBody(), p);
            } else {
                p.append("else");
                p.append(':');
                this.visit((Tree)else_.getBody(), p);
            }
            this.afterSyntax((J)else_, p);
            return else_;
        }

        public J visitForEachControl(J.ForEachLoop.Control control, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)control, Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            this.visitRightPadded(control.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, p);
            p.append("in");
            this.visitRightPadded(control.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, p);
            this.afterSyntax((J)control, p);
            return control;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("for");
            this.visit((Tree)forEachLoop.getControl(), p);
            this.visit((Tree)forEachLoop.getBody(), p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ident, Space.Location.IDENTIFIER_PREFIX, p);
            Optional quoted = ident.getMarkers().findFirst(Quoted.class);
            quoted.ifPresent(value -> p.append(value.getStyle().getQuote()));
            p.append(ident.getSimpleName());
            quoted.ifPresent(value -> p.append(value.getStyle().getQuote()));
            this.afterSyntax((J)ident, p);
            return ident;
        }

        public J visitIf(J.If iff, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)iff, Space.Location.IF_PREFIX, p);
            p.append("if");
            this.visit((Tree)iff.getIfCondition(), p);
            JRightPadded thenPart = iff.getPadding().getThenPart();
            if (!(thenPart.getElement() instanceof J.Block)) {
                p.append(":");
            }
            this.visitStatement(thenPart, JRightPadded.Location.IF_THEN, p);
            this.visit((Tree)iff.getElsePart(), p);
            this.afterSyntax((J)iff, p);
            return iff;
        }

        public J visitImport(J.Import im, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)im, Space.Location.IMPORT_PREFIX, p);
            if (im.getQualid().getTarget() instanceof J.Empty) {
                this.visit((Tree)im.getQualid().getName(), p);
            } else {
                this.visit((Tree)im.getQualid(), p);
            }
            this.visitLeftPadded("as", im.getPadding().getAlias(), JLeftPadded.Location.IMPORT_ALIAS_PREFIX, p);
            this.afterSyntax((J)im, p);
            return im;
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
            p.append("lambda");
            this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            this.visitMarkers(lambda.getParameters().getMarkers(), p);
            this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
            p.append(":");
            this.visit((Tree)lambda.getBody(), p);
            this.afterSyntax((J)lambda, p);
            return lambda;
        }

        public J visitLiteral(J.Literal literal, PrintOutputCapture<P> p) {
            if (literal.getValue() == null && literal.getValueSource() == null) {
                literal = literal.withValueSource("None");
            }
            this.beforeSyntax((J)literal, Space.Location.LITERAL_PREFIX, p);
            List unicodeEscapes = literal.getUnicodeEscapes();
            if (unicodeEscapes == null) {
                p.append(literal.getValueSource());
            } else if (literal.getValueSource() != null) {
                char[] valueSourceArr;
                Iterator surrogateIter = unicodeEscapes.iterator();
                J.Literal.UnicodeEscape surrogate = surrogateIter.hasNext() ? (J.Literal.UnicodeEscape)surrogateIter.next() : null;
                int i = 0;
                if (surrogate != null && surrogate.getValueSourceIndex() == 0) {
                    p.append("\\u").append(surrogate.getCodePoint());
                    if (surrogateIter.hasNext()) {
                        surrogate = (J.Literal.UnicodeEscape)surrogateIter.next();
                    }
                }
                for (char c : valueSourceArr = literal.getValueSource().toCharArray()) {
                    p.append(c);
                    if (surrogate == null || surrogate.getValueSourceIndex() != ++i) continue;
                    while (surrogate != null && surrogate.getValueSourceIndex() == i) {
                        p.append("\\u").append(surrogate.getCodePoint());
                        surrogate = surrogateIter.hasNext() ? (J.Literal.UnicodeEscape)surrogateIter.next() : null;
                    }
                }
            }
            this.afterSyntax((J)literal, p);
            return literal;
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon) {
                p.append(';');
            } else if (marker instanceof TrailingComma) {
                p.append(',');
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.ANY, p);
            }
            return (M)marker;
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            for (J.Modifier m : method.getModifiers()) {
                this.visitModifier(m, p);
            }
            this.visit((Tree)method.getName(), p);
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            this.visit((Tree)method.getReturnTypeExpression(), p);
            this.visit((Tree)method.getBody(), p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, method.getSimpleName().isEmpty() ? "" : ".", p);
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visit((Tree)method.getName(), p);
            String before = "(";
            String after = ")";
            if (method.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                before = "";
                after = "";
            }
            this.visitContainer(before, method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", after, p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
            String keyword = null;
            switch (mod.getType()) {
                case Default: {
                    keyword = "def";
                    break;
                }
                case Async: {
                    keyword = "async";
                }
            }
            if (keyword != null) {
                this.visit(mod.getAnnotations(), p);
                this.beforeSyntax((J)mod, Space.Location.MODIFIER_PREFIX, p);
                p.append(keyword);
                this.afterSyntax((J)mod, p);
            }
            return mod;
        }

        public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newArray, Space.Location.NEW_ARRAY_PREFIX, p);
            this.visitContainer("[", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "]", p);
            this.afterSyntax((J)newArray, p);
            return newArray;
        }

        public J visitParameterizedType(J.ParameterizedType type, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)type, Space.Location.PARAMETERIZED_TYPE_PREFIX, p);
            this.visit((Tree)type.getClazz(), p);
            this.visitContainer("[", type.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", "]", p);
            this.afterSyntax((J)type, p);
            return type;
        }

        public J visitSwitch(J.Switch sw, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)sw, Space.Location.SWITCH_PREFIX, p);
            p.append("match");
            this.visit((Tree)sw.getSelector(), p);
            this.visit((Tree)sw.getCases(), p);
            this.afterSyntax((J)sw, p);
            return sw;
        }

        public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)ternary, Space.Location.TERNARY_PREFIX, p);
            this.visit((Tree)ternary.getTruePart(), p);
            this.visitSpace(ternary.getPadding().getTruePart().getBefore(), Space.Location.TERNARY_TRUE, p);
            p.append("if");
            this.visit((Tree)ternary.getCondition(), p);
            this.visitLeftPadded("else", ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
            this.afterSyntax((J)ternary, p);
            return ternary;
        }

        public J visitThrow(J.Throw thrown, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)thrown, Space.Location.THROW_PREFIX, p);
            p.append("raise");
            this.visit((Tree)thrown.getException(), p);
            this.afterSyntax((J)thrown, p);
            return thrown;
        }

        public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
            boolean isWithStatement = tryable.getResources() != null && !tryable.getResources().isEmpty();
            this.beforeSyntax((J)tryable, Space.Location.TRY_PREFIX, p);
            if (isWithStatement) {
                p.append("with");
            } else {
                p.append("try");
            }
            JContainer resources = tryable.getPadding().getResources();
            if (isWithStatement && resources != null) {
                this.visitSpace(resources.getBefore(), Space.Location.TRY_RESOURCES, p);
                boolean omitParentheses = resources.getMarkers().findFirst(OmitParentheses.class).isPresent();
                if (!omitParentheses) {
                    p.append("(");
                }
                boolean first = true;
                for (JRightPadded resource : resources.getPadding().getElements()) {
                    if (!first) {
                        p.append(",");
                    } else {
                        first = false;
                    }
                    this.visitSpace(((J.Try.Resource)resource.getElement()).getPrefix(), Space.Location.TRY_RESOURCE, p);
                    this.visitMarkers(((J.Try.Resource)resource.getElement()).getMarkers(), p);
                    TypedTree decl = ((J.Try.Resource)resource.getElement()).getVariableDeclarations();
                    if (decl instanceof J.Assignment) {
                        J.Assignment assignment = (J.Assignment)decl;
                        this.visit((Tree)assignment.getAssignment(), p);
                        if (!(assignment.getVariable() instanceof J.Empty)) {
                            this.visitSpace(assignment.getPadding().getAssignment().getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
                            p.append("as");
                            this.visit((Tree)assignment.getVariable(), p);
                        }
                    } else {
                        this.visit((Tree)decl, p);
                    }
                    this.visitSpace(resource.getAfter(), Space.Location.TRY_RESOURCE_SUFFIX, p);
                    this.visitMarkers(resource.getMarkers(), p);
                }
                this.visitMarkers(resources.getMarkers(), p);
                if (!omitParentheses) {
                    p.append(")");
                }
            }
            J.Block tryBody = tryable.getBody();
            Py.TrailingElseWrapper elseWrapper = this.getCursor().getParentTreeCursor().getValue() instanceof Py.TrailingElseWrapper ? (Py.TrailingElseWrapper)this.getCursor().getParentTreeCursor().getValue() : null;
            this.visit((Tree)tryBody, p);
            this.visit(tryable.getCatches(), p);
            if (elseWrapper != null) {
                this.visitSpace(elseWrapper.getPadding().getElseBlock().getBefore(), Space.Location.ELSE_PREFIX, p);
                p.append("else");
                this.visit((Tree)elseWrapper.getElseBlock(), p);
            }
            this.visitLeftPadded("finally", tryable.getPadding().getFinally(), JLeftPadded.Location.TRY_FINALLY, p);
            this.afterSyntax((J)tryable, p);
            return tryable;
        }

        public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)unary, Space.Location.UNARY_PREFIX, p);
            switch (unary.getOperator()) {
                case Not: {
                    p.append("not");
                    break;
                }
                case Positive: {
                    p.append("+");
                    break;
                }
                case Negative: {
                    p.append("-");
                    break;
                }
                case Complement: {
                    p.append("~");
                }
            }
            this.visit((Tree)unary.getExpression(), p);
            this.afterSyntax((J)unary, p);
            return unary;
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            J.VariableDeclarations vd = (J.VariableDeclarations)this.getCursor().getParentTreeCursor().getValue();
            JRightPadded padding = (JRightPadded)this.getCursor().getParent().getValue();
            TypeTree type = vd.getTypeExpression();
            if (type instanceof Py.SpecialParameter) {
                Py.SpecialParameter special = (Py.SpecialParameter)type;
                this.visit((Tree)special, p);
                type = special.getTypeHint();
            }
            if (variable.getName().getSimpleName().isEmpty()) {
                this.visit((Tree)variable.getInitializer(), p);
            } else {
                if (vd.getVarargs() != null) {
                    this.visitSpace(vd.getVarargs(), Space.Location.VARARGS, p);
                    p.append('*');
                }
                if (vd.getMarkers().findFirst(KeywordArguments.class).isPresent()) {
                    p.append("**");
                }
                this.visit((Tree)variable.getName(), p);
                if (type != null) {
                    this.visitSpace(padding.getAfter(), JRightPadded.Location.NAMED_VARIABLE.getAfterLocation(), p);
                    p.append(':');
                    this.visit((Tree)type, p);
                }
                this.visitLeftPadded("=", variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
            }
            this.afterSyntax((J)variable, p);
            return variable;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            for (J.Modifier m : multiVariable.getModifiers()) {
                this.visitModifier(m, p);
            }
            if (multiVariable.getMarkers().findFirst(KeywordOnlyArguments.class).isPresent()) {
                p.append("*");
            }
            List nodes = multiVariable.getPadding().getVariables();
            for (int i = 0; i < nodes.size(); ++i) {
                JRightPadded node = (JRightPadded)nodes.get(i);
                this.setCursor(new Cursor(this.getCursor(), (Object)node));
                this.visit((Tree)node.getElement(), p);
                this.visitMarkers(node.getMarkers(), p);
                if (i < nodes.size() - 1) {
                    p.append(",");
                }
                this.setCursor(this.getCursor().getParent());
            }
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        protected void printStatementTerminator(Statement s, PrintOutputCapture<P> p) {
        }
    }
}

