/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.tree;

import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.CoordinateBuilder;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Loop;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.PythonVisitor;
import org.openrewrite.python.internal.PythonPrinter;

public interface Py
extends J {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        String visitorName = v.getClass().getCanonicalName();
        if (visitorName != null && visitorName.startsWith("io.moderne.serialization.")) {
            return (R)this;
        }
        return (R)this.acceptPython((PythonVisitor)v.adapt(PythonVisitor.class), p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(PythonVisitor.class);
    }

    default public <P> @Nullable J acceptPython(PythonVisitor<P> v, P p) {
        return (J)v.defaultValue((Tree)this, p);
    }

    public Space getPrefix();

    default public List<Comment> getComments() {
        return this.getPrefix().getComments();
    }

    public static final class Slice
    implements Py,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JRightPadded<Expression> start;
        private final @Nullable JRightPadded<Expression> stop;
        private final @Nullable JRightPadded<Expression> step;

        public @Nullable Expression getStart() {
            return this.start != null ? (Expression)this.start.getElement() : null;
        }

        public Slice withStart(@Nullable Expression start) {
            return this.getPadding().withStart((JRightPadded<Expression>)JRightPadded.withElement(this.start, (Object)start));
        }

        public @Nullable Expression getStop() {
            return this.stop != null ? (Expression)this.stop.getElement() : null;
        }

        public Slice withStop(@Nullable Expression stop) {
            return this.getPadding().withStop((JRightPadded<Expression>)JRightPadded.withElement(this.stop, (Object)stop));
        }

        public @Nullable Expression getStep() {
            return this.step != null ? (Expression)this.step.getElement() : null;
        }

        public Slice withStep(@Nullable Expression step) {
            return this.getPadding().withStep((JRightPadded<Expression>)JRightPadded.withElement(this.step, (Object)step));
        }

        public @Nullable JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this;
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitSlice(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Slice)) {
                return false;
            }
            Slice other = (Slice)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$start = this.getStart();
            Expression other$start = other.getStart();
            if (this$start == null ? other$start != null : !this$start.equals(other$start)) {
                return false;
            }
            Expression this$stop = this.getStop();
            Expression other$stop = other.getStop();
            if (this$stop == null ? other$stop != null : !this$stop.equals(other$stop)) {
                return false;
            }
            Expression this$step = this.getStep();
            Expression other$step = other.getStep();
            return !(this$step == null ? other$step != null : !this$step.equals(other$step));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : $start.hashCode());
            Expression $stop = this.getStop();
            result = result * 59 + ($stop == null ? 43 : $stop.hashCode());
            Expression $step = this.getStep();
            result = result * 59 + ($step == null ? 43 : $step.hashCode());
            return result;
        }

        @Generated
        public Slice(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> start, @Nullable JRightPadded<Expression> stop, @Nullable JRightPadded<Expression> step) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.start = start;
            this.stop = stop;
            this.step = step;
        }

        @Generated
        private Slice(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Expression> start, @Nullable JRightPadded<Expression> stop, @Nullable JRightPadded<Expression> step) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.start = start;
            this.stop = stop;
            this.step = step;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Slice withId(UUID id) {
            return this.id == id ? this : new Slice(this.padding, id, this.prefix, this.markers, this.start, this.stop, this.step);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Slice withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Slice(this.padding, this.id, prefix, this.markers, this.start, this.stop, this.step);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Slice withMarkers(Markers markers) {
            return this.markers == markers ? this : new Slice(this.padding, this.id, this.prefix, markers, this.start, this.stop, this.step);
        }

        public static class Padding {
            private final Slice t;

            public @Nullable JRightPadded<Expression> getStart() {
                return this.t.start;
            }

            public Slice withStart(@Nullable JRightPadded<Expression> start) {
                return this.t.start == start ? this.t : new Slice(this.t.id, this.t.prefix, this.t.markers, start, (JRightPadded<Expression>)this.t.stop, (JRightPadded<Expression>)this.t.step);
            }

            public @Nullable JRightPadded<Expression> getStop() {
                return this.t.stop;
            }

            public Slice withStop(@Nullable JRightPadded<Expression> stop) {
                return this.t.stop == stop ? this.t : new Slice(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Expression>)this.t.start, stop, (JRightPadded<Expression>)this.t.step);
            }

            public @Nullable JRightPadded<Expression> getStep() {
                return this.t.step;
            }

            public Slice withStep(@Nullable JRightPadded<Expression> step) {
                return this.t.step == step ? this.t : new Slice(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Expression>)this.t.start, step, (JRightPadded<Expression>)this.t.step);
            }

            @Generated
            public Padding(Slice t) {
                this.t = t;
            }
        }
    }

    public static final class MatchCase
    implements Py,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Pattern pattern;
        private final @Nullable JLeftPadded<Expression> guard;
        private final @Nullable JavaType type;

        public @Nullable Expression getGuard() {
            return this.guard == null ? null : (Expression)this.guard.getElement();
        }

        public MatchCase withGuard(Expression guard) {
            return this.getPadding().withGuard((JLeftPadded<Expression>)JLeftPadded.withElement(this.guard, (Object)guard));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitMatchCase(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchCase)) {
                return false;
            }
            MatchCase other = (MatchCase)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Pattern this$pattern = this.getPattern();
            Pattern other$pattern = other.getPattern();
            if (this$pattern == null ? other$pattern != null : !((Object)this$pattern).equals(other$pattern)) {
                return false;
            }
            Expression this$guard = this.getGuard();
            Expression other$guard = other.getGuard();
            if (this$guard == null ? other$guard != null : !this$guard.equals(other$guard)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Pattern $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : ((Object)$pattern).hashCode());
            Expression $guard = this.getGuard();
            result = result * 59 + ($guard == null ? 43 : $guard.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public MatchCase(UUID id, Space prefix, Markers markers, Pattern pattern, @Nullable JLeftPadded<Expression> guard, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.guard = guard;
            this.type = type;
        }

        @Generated
        private MatchCase(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Pattern pattern, @Nullable JLeftPadded<Expression> guard, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.pattern = pattern;
            this.guard = guard;
            this.type = type;
        }

        @Generated
        public MatchCase withId(UUID id) {
            return this.id == id ? this : new MatchCase(this.padding, id, this.prefix, this.markers, this.pattern, this.guard, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public MatchCase withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MatchCase(this.padding, this.id, prefix, this.markers, this.pattern, this.guard, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public MatchCase withMarkers(Markers markers) {
            return this.markers == markers ? this : new MatchCase(this.padding, this.id, this.prefix, markers, this.pattern, this.guard, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public MatchCase withPattern(Pattern pattern) {
            return this.pattern == pattern ? this : new MatchCase(this.padding, this.id, this.prefix, this.markers, pattern, this.guard, this.type);
        }

        @Generated
        public Pattern getPattern() {
            return this.pattern;
        }

        @Generated
        public MatchCase withType(@Nullable JavaType type) {
            return this.type == type ? this : new MatchCase(this.padding, this.id, this.prefix, this.markers, this.pattern, this.guard, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static final class Pattern
        implements Py,
        Expression {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Kind kind;
            private final JContainer<Expression> children;
            private final @Nullable JavaType type;

            public List<Expression> getChildren() {
                return this.children.getElements();
            }

            public Pattern withChildren(List<Expression> children) {
                return this.getPadding().withChildren((JContainer<Expression>)JContainer.withElements(this.children, children));
            }

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitMatchCasePattern(this, p);
            }

            public CoordinateBuilder.Expression getCoordinates() {
                return new CoordinateBuilder.Expression((J)this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pattern)) {
                    return false;
                }
                Pattern other = (Pattern)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                    return false;
                }
                Space this$prefix = this.getPrefix();
                Space other$prefix = other.getPrefix();
                if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                    return false;
                }
                Markers this$markers = this.getMarkers();
                Markers other$markers = other.getMarkers();
                if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                    return false;
                }
                Kind this$kind = this.getKind();
                Kind other$kind = other.getKind();
                if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                    return false;
                }
                List<Expression> this$children = this.getChildren();
                List<Expression> other$children = other.getChildren();
                if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
                    return false;
                }
                JavaType this$type = this.getType();
                JavaType other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                Space $prefix = this.getPrefix();
                result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
                Markers $markers = this.getMarkers();
                result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
                Kind $kind = this.getKind();
                result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
                List<Expression> $children = this.getChildren();
                result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
                JavaType $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            @Generated
            public Pattern(UUID id, Space prefix, Markers markers, Kind kind, JContainer<Expression> children, @Nullable JavaType type) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.kind = kind;
                this.children = children;
                this.type = type;
            }

            @Generated
            private Pattern(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Kind kind, JContainer<Expression> children, @Nullable JavaType type) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.kind = kind;
                this.children = children;
                this.type = type;
            }

            @Generated
            public Pattern withId(UUID id) {
                return this.id == id ? this : new Pattern(this.padding, id, this.prefix, this.markers, this.kind, this.children, this.type);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public Pattern withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Pattern(this.padding, this.id, prefix, this.markers, this.kind, this.children, this.type);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Pattern withMarkers(Markers markers) {
                return this.markers == markers ? this : new Pattern(this.padding, this.id, this.prefix, markers, this.kind, this.children, this.type);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public Pattern withKind(Kind kind) {
                return this.kind == kind ? this : new Pattern(this.padding, this.id, this.prefix, this.markers, kind, this.children, this.type);
            }

            @Generated
            public Kind getKind() {
                return this.kind;
            }

            @Generated
            public Pattern withType(@Nullable JavaType type) {
                return this.type == type ? this : new Pattern(this.padding, this.id, this.prefix, this.markers, this.kind, this.children, type);
            }

            @Generated
            public @Nullable JavaType getType() {
                return this.type;
            }

            public static enum Kind {
                AS,
                CAPTURE,
                CLASS,
                DOUBLE_STAR,
                GROUP,
                KEY_VALUE,
                KEYWORD,
                LITERAL,
                MAPPING,
                OR,
                SEQUENCE,
                SEQUENCE_LIST,
                SEQUENCE_TUPLE,
                STAR,
                VALUE,
                WILDCARD;

            }

            public static class Padding {
                private final Pattern t;

                public JContainer<Expression> getChildren() {
                    return this.t.children;
                }

                public Pattern withChildren(JContainer<Expression> children) {
                    return children == this.t.children ? this.t : new Pattern(this.t.id, this.t.prefix, this.t.markers, this.t.kind, children, this.t.type);
                }

                @Generated
                public Padding(Pattern t) {
                    this.t = t;
                }
            }
        }

        public static class Padding {
            private final MatchCase t;

            public @Nullable JLeftPadded<Expression> getGuard() {
                return this.t.guard;
            }

            public MatchCase withGuard(JLeftPadded<Expression> guard) {
                return guard == this.t.guard ? this.t : new MatchCase(this.t.id, this.t.prefix, this.t.markers, this.t.pattern, guard, null);
            }

            @Generated
            public Padding(MatchCase t) {
                this.t = t;
            }
        }
    }

    public static final class ErrorFrom
    implements Py,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression error;
        private final JLeftPadded<Expression> from;
        private final JavaType type;

        public Expression getFrom() {
            return (Expression)this.from.getElement();
        }

        public ErrorFrom withFrom(Expression from) {
            return this.getPadding().withFrom((JLeftPadded<Expression>)this.from.withElement((Object)from));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitErrorFrom(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorFrom)) {
                return false;
            }
            ErrorFrom other = (ErrorFrom)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$error = this.getError();
            Expression other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            Expression this$from = this.getFrom();
            Expression other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            Expression $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public ErrorFrom(UUID id, Space prefix, Markers markers, Expression error, JLeftPadded<Expression> from, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.error = error;
            this.from = from;
            this.type = type;
        }

        @Generated
        private ErrorFrom(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression error, JLeftPadded<Expression> from, JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.error = error;
            this.from = from;
            this.type = type;
        }

        @Generated
        public ErrorFrom withId(UUID id) {
            return this.id == id ? this : new ErrorFrom(this.padding, id, this.prefix, this.markers, this.error, this.from, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public ErrorFrom withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ErrorFrom(this.padding, this.id, prefix, this.markers, this.error, this.from, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public ErrorFrom withMarkers(Markers markers) {
            return this.markers == markers ? this : new ErrorFrom(this.padding, this.id, this.prefix, markers, this.error, this.from, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public ErrorFrom withError(Expression error) {
            return this.error == error ? this : new ErrorFrom(this.padding, this.id, this.prefix, this.markers, error, this.from, this.type);
        }

        @Generated
        public Expression getError() {
            return this.error;
        }

        @Generated
        public ErrorFrom withType(JavaType type) {
            return this.type == type ? this : new ErrorFrom(this.padding, this.id, this.prefix, this.markers, this.error, this.from, type);
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final ErrorFrom t;

            public JLeftPadded<Expression> getFrom() {
                return this.t.from;
            }

            public ErrorFrom withFrom(JLeftPadded<Expression> from) {
                return from == this.t.from ? this.t : new ErrorFrom(this.t.id, this.t.prefix, this.t.markers, this.t.error, from, this.t.type);
            }

            @Generated
            public Padding(ErrorFrom t) {
                this.t = t;
            }
        }
    }

    public static final class TypeHintedExpression
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final TypeHint typeHint;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTypeHintedExpression(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public TypeHint getTypeHint() {
            return this.typeHint;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeHintedExpression)) {
                return false;
            }
            TypeHintedExpression other = (TypeHintedExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            TypeHint this$typeHint = this.getTypeHint();
            TypeHint other$typeHint = other.getTypeHint();
            if (this$typeHint == null ? other$typeHint != null : !((Object)this$typeHint).equals(other$typeHint)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            TypeHint $typeHint = this.getTypeHint();
            result = result * 59 + ($typeHint == null ? 43 : ((Object)$typeHint).hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public TypeHintedExpression(UUID id, Space prefix, Markers markers, Expression expression, TypeHint typeHint, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.typeHint = typeHint;
            this.type = type;
        }

        @Generated
        public TypeHintedExpression withId(UUID id) {
            return this.id == id ? this : new TypeHintedExpression(id, this.prefix, this.markers, this.expression, this.typeHint, this.type);
        }

        @Generated
        public TypeHintedExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeHintedExpression(this.id, prefix, this.markers, this.expression, this.typeHint, this.type);
        }

        @Generated
        public TypeHintedExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeHintedExpression(this.id, this.prefix, markers, this.expression, this.typeHint, this.type);
        }

        @Generated
        public TypeHintedExpression withExpression(Expression expression) {
            return this.expression == expression ? this : new TypeHintedExpression(this.id, this.prefix, this.markers, expression, this.typeHint, this.type);
        }

        @Generated
        public TypeHintedExpression withTypeHint(TypeHint typeHint) {
            return this.typeHint == typeHint ? this : new TypeHintedExpression(this.id, this.prefix, this.markers, this.expression, typeHint, this.type);
        }

        @Generated
        public TypeHintedExpression withType(@Nullable JavaType type) {
            return this.type == type ? this : new TypeHintedExpression(this.id, this.prefix, this.markers, this.expression, this.typeHint, type);
        }
    }

    public static final class NamedArgument
    implements Py,
    Expression {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.Identifier name;
        private final JLeftPadded<Expression> value;
        private final @Nullable JavaType type;

        public Expression getValue() {
            return (Expression)this.value.getElement();
        }

        public NamedArgument withValue(Expression value) {
            return this.getPadding().withValue((JLeftPadded<Expression>)JLeftPadded.withElement(this.value, (Object)value));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitNamedArgument(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedArgument)) {
                return false;
            }
            NamedArgument other = (NamedArgument)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            J.Identifier this$name = this.getName();
            J.Identifier other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Expression this$value = this.getValue();
            Expression other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            J.Identifier $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Expression $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public NamedArgument(UUID id, Space prefix, Markers markers, J.Identifier name, JLeftPadded<Expression> value, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        @Generated
        private NamedArgument(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.Identifier name, JLeftPadded<Expression> value, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        @Generated
        public NamedArgument withId(UUID id) {
            return this.id == id ? this : new NamedArgument(this.padding, id, this.prefix, this.markers, this.name, this.value, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public NamedArgument withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new NamedArgument(this.padding, this.id, prefix, this.markers, this.name, this.value, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public NamedArgument withMarkers(Markers markers) {
            return this.markers == markers ? this : new NamedArgument(this.padding, this.id, this.prefix, markers, this.name, this.value, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public NamedArgument withName(J.Identifier name) {
            return this.name == name ? this : new NamedArgument(this.padding, this.id, this.prefix, this.markers, name, this.value, this.type);
        }

        @Generated
        public J.Identifier getName() {
            return this.name;
        }

        @Generated
        public NamedArgument withType(@Nullable JavaType type) {
            return this.type == type ? this : new NamedArgument(this.padding, this.id, this.prefix, this.markers, this.name, this.value, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final NamedArgument t;

            public JLeftPadded<Expression> getValue() {
                return this.t.value;
            }

            public NamedArgument withValue(JLeftPadded<Expression> value) {
                return value == this.t.value ? this.t : new NamedArgument(this.t.id, this.t.prefix, this.t.markers, this.t.name, value, this.t.type);
            }

            @Generated
            public Padding(NamedArgument t) {
                this.t = t;
            }
        }
    }

    public static final class Star
    implements Py,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final Expression expression;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitStar(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Star)) {
                return false;
            }
            Star other = (Star)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public Star(UUID id, Space prefix, Markers markers, Kind kind, Expression expression, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        public Star withId(UUID id) {
            return this.id == id ? this : new Star(id, this.prefix, this.markers, this.kind, this.expression, this.type);
        }

        @Generated
        public Star withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Star(this.id, prefix, this.markers, this.kind, this.expression, this.type);
        }

        @Generated
        public Star withMarkers(Markers markers) {
            return this.markers == markers ? this : new Star(this.id, this.prefix, markers, this.kind, this.expression, this.type);
        }

        @Generated
        public Star withKind(Kind kind) {
            return this.kind == kind ? this : new Star(this.id, this.prefix, this.markers, kind, this.expression, this.type);
        }

        @Generated
        public Star withExpression(Expression expression) {
            return this.expression == expression ? this : new Star(this.id, this.prefix, this.markers, this.kind, expression, this.type);
        }

        @Generated
        public Star withType(@Nullable JavaType type) {
            return this.type == type ? this : new Star(this.id, this.prefix, this.markers, this.kind, this.expression, type);
        }

        public static enum Kind {
            LIST,
            DICT;

        }
    }

    public static final class SpecialParameter
    implements Py,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final @Nullable TypeHint typeHint;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitSpecialParameter(this, p);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public @Nullable TypeHint getTypeHint() {
            return this.typeHint;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpecialParameter)) {
                return false;
            }
            SpecialParameter other = (SpecialParameter)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            TypeHint this$typeHint = this.getTypeHint();
            TypeHint other$typeHint = other.getTypeHint();
            if (this$typeHint == null ? other$typeHint != null : !((Object)this$typeHint).equals(other$typeHint)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            TypeHint $typeHint = this.getTypeHint();
            result = result * 59 + ($typeHint == null ? 43 : ((Object)$typeHint).hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public SpecialParameter(UUID id, Space prefix, Markers markers, Kind kind, @Nullable TypeHint typeHint, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.typeHint = typeHint;
            this.type = type;
        }

        @Generated
        public SpecialParameter withId(UUID id) {
            return this.id == id ? this : new SpecialParameter(id, this.prefix, this.markers, this.kind, this.typeHint, this.type);
        }

        @Generated
        public SpecialParameter withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new SpecialParameter(this.id, prefix, this.markers, this.kind, this.typeHint, this.type);
        }

        @Generated
        public SpecialParameter withMarkers(Markers markers) {
            return this.markers == markers ? this : new SpecialParameter(this.id, this.prefix, markers, this.kind, this.typeHint, this.type);
        }

        @Generated
        public SpecialParameter withKind(Kind kind) {
            return this.kind == kind ? this : new SpecialParameter(this.id, this.prefix, this.markers, kind, this.typeHint, this.type);
        }

        @Generated
        public SpecialParameter withTypeHint(@Nullable TypeHint typeHint) {
            return this.typeHint == typeHint ? this : new SpecialParameter(this.id, this.prefix, this.markers, this.kind, typeHint, this.type);
        }

        @Generated
        public SpecialParameter withType(@Nullable JavaType type) {
            return this.type == type ? this : new SpecialParameter(this.id, this.prefix, this.markers, this.kind, this.typeHint, type);
        }

        public static enum Kind {
            KWARGS,
            ARGS;

        }
    }

    public static final class Del
    implements Py,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> targets;

        public List<Expression> getTargets() {
            return JRightPadded.getElements(this.targets);
        }

        public Del withTargets(List<Expression> expressions) {
            return this.getPadding().withTargets(JRightPadded.withElements(this.targets, expressions));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitDel(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Del)) {
                return false;
            }
            Del other = (Del)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Expression> this$targets = this.getTargets();
            List<Expression> other$targets = other.getTargets();
            return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Expression> $targets = this.getTargets();
            result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
            return result;
        }

        @Generated
        public Del(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> targets) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.targets = targets;
        }

        @Generated
        private Del(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> targets) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.targets = targets;
        }

        @Generated
        public Del withId(UUID id) {
            return this.id == id ? this : new Del(this.padding, id, this.prefix, this.markers, this.targets);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Del withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Del(this.padding, this.id, prefix, this.markers, this.targets);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Del withMarkers(Markers markers) {
            return this.markers == markers ? this : new Del(this.padding, this.id, this.prefix, markers, this.targets);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        public static class Padding {
            private final Del t;

            public List<JRightPadded<Expression>> getTargets() {
                return this.t.targets;
            }

            public Del withTargets(List<JRightPadded<Expression>> expressions) {
                return expressions == this.t.targets ? this.t : new Del(this.t.id, this.t.prefix, this.t.markers, expressions);
            }

            @Generated
            public Padding(Del t) {
                this.t = t;
            }
        }
    }

    public static final class VariableScope
    implements Py,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final List<JRightPadded<J.Identifier>> names;

        public List<J.Identifier> getNames() {
            return JRightPadded.getElements(this.names);
        }

        public VariableScope withNames(List<J.Identifier> names) {
            return this.getPadding().withNames(JRightPadded.withElements(this.names, names));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitVariableScope(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VariableScope)) {
                return false;
            }
            VariableScope other = (VariableScope)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            List<J.Identifier> this$names = this.getNames();
            List<J.Identifier> other$names = other.getNames();
            return !(this$names == null ? other$names != null : !((Object)this$names).equals(other$names));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            List<J.Identifier> $names = this.getNames();
            result = result * 59 + ($names == null ? 43 : ((Object)$names).hashCode());
            return result;
        }

        @Generated
        public VariableScope(UUID id, Space prefix, Markers markers, Kind kind, List<JRightPadded<J.Identifier>> names) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.names = names;
        }

        @Generated
        private VariableScope(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Kind kind, List<JRightPadded<J.Identifier>> names) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.names = names;
        }

        @Generated
        public VariableScope withId(UUID id) {
            return this.id == id ? this : new VariableScope(this.padding, id, this.prefix, this.markers, this.kind, this.names);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public VariableScope withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new VariableScope(this.padding, this.id, prefix, this.markers, this.kind, this.names);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public VariableScope withMarkers(Markers markers) {
            return this.markers == markers ? this : new VariableScope(this.padding, this.id, this.prefix, markers, this.kind, this.names);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public VariableScope withKind(Kind kind) {
            return this.kind == kind ? this : new VariableScope(this.padding, this.id, this.prefix, this.markers, kind, this.names);
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        public static enum Kind {
            GLOBAL,
            NONLOCAL;

        }

        public static class Padding {
            private final VariableScope t;

            public List<JRightPadded<J.Identifier>> getNames() {
                return this.t.names;
            }

            public VariableScope withNames(List<JRightPadded<J.Identifier>> names) {
                return names == this.t.names ? this.t : new VariableScope(this.t.id, this.t.prefix, this.t.markers, this.t.kind, names);
            }

            @Generated
            public Padding(VariableScope t) {
                this.t = t;
            }
        }
    }

    public static final class UnionType
    implements Py,
    Expression,
    TypeTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> types;
        private final @Nullable JavaType type;

        public List<Expression> getTypes() {
            return JRightPadded.getElements(this.types);
        }

        public UnionType withTypes(List<Expression> types) {
            return this.getPadding().withTypes(JRightPadded.withElements(this.types, types));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitUnionType(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnionType)) {
                return false;
            }
            UnionType other = (UnionType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public UnionType(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        private UnionType(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> types, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.types = types;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "Py.UnionType(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", types=" + this.getTypes() + ", type=" + this.getType() + ")";
        }

        @Generated
        public UnionType withId(UUID id) {
            return this.id == id ? this : new UnionType(this.padding, id, this.prefix, this.markers, this.types, this.type);
        }

        @Generated
        public UnionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new UnionType(this.padding, this.id, prefix, this.markers, this.types, this.type);
        }

        @Generated
        public UnionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new UnionType(this.padding, this.id, this.prefix, markers, this.types, this.type);
        }

        @Generated
        public UnionType withType(@Nullable JavaType type) {
            return this.type == type ? this : new UnionType(this.padding, this.id, this.prefix, this.markers, this.types, type);
        }

        public static class Padding {
            private final UnionType t;

            public List<JRightPadded<Expression>> getTypes() {
                return this.t.types;
            }

            public UnionType withTypes(List<JRightPadded<Expression>> types) {
                return this.t.types == types ? this.t : new UnionType(this.t.id, this.t.prefix, this.t.markers, types, this.t.type);
            }

            @Generated
            public Padding(UnionType t) {
                this.t = t;
            }
        }
    }

    public static final class YieldFrom
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitYieldFrom(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public YieldFrom(UUID id, Space prefix, Markers markers, Expression expression, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "Py.YieldFrom(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", expression=" + this.getExpression() + ", type=" + this.getType() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof YieldFrom)) {
                return false;
            }
            YieldFrom other = (YieldFrom)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public YieldFrom withId(UUID id) {
            return this.id == id ? this : new YieldFrom(id, this.prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public YieldFrom withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new YieldFrom(this.id, prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public YieldFrom withMarkers(Markers markers) {
            return this.markers == markers ? this : new YieldFrom(this.id, this.prefix, markers, this.expression, this.type);
        }

        @Generated
        public YieldFrom withExpression(Expression expression) {
            return this.expression == expression ? this : new YieldFrom(this.id, this.prefix, this.markers, expression, this.type);
        }

        @Generated
        public YieldFrom withType(JavaType type) {
            return this.type == type ? this : new YieldFrom(this.id, this.prefix, this.markers, this.expression, type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }
    }

    public static final class TypeAlias
    implements Py,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J.Identifier name;
        private final JLeftPadded<J> value;
        private final @Nullable JavaType type;

        public J getValue() {
            return (J)this.value.getElement();
        }

        public TypeAlias withValue(J value) {
            return this.getPadding().withValue((JLeftPadded<J>)this.value.withElement((Object)value));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTypeAlias(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeAlias)) {
                return false;
            }
            TypeAlias other = (TypeAlias)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public TypeAlias(UUID id, Space prefix, Markers markers, J.Identifier name, JLeftPadded<J> value, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        @Generated
        private TypeAlias(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, J.Identifier name, JLeftPadded<J> value, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.name = name;
            this.value = value;
            this.type = type;
        }

        @Generated
        public TypeAlias withId(UUID id) {
            return this.id == id ? this : new TypeAlias(this.padding, id, this.prefix, this.markers, this.name, this.value, this.type);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public TypeAlias withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeAlias(this.padding, this.id, prefix, this.markers, this.name, this.value, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public TypeAlias withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeAlias(this.padding, this.id, this.prefix, markers, this.name, this.value, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public TypeAlias withName(J.Identifier name) {
            return this.name == name ? this : new TypeAlias(this.padding, this.id, this.prefix, this.markers, name, this.value, this.type);
        }

        @Generated
        public J.Identifier getName() {
            return this.name;
        }

        @Generated
        public TypeAlias withType(@Nullable JavaType type) {
            return this.type == type ? this : new TypeAlias(this.padding, this.id, this.prefix, this.markers, this.name, this.value, type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        public static class Padding {
            private final TypeAlias t;

            public JLeftPadded<J> getValue() {
                return this.t.value;
            }

            public TypeAlias withValue(JLeftPadded<J> assignment) {
                return this.t.value == assignment ? this.t : new TypeAlias(this.t.id, this.t.prefix, this.t.markers, this.t.name, assignment, this.t.type);
            }

            @Generated
            public Padding(TypeAlias t) {
                this.t = t;
            }
        }
    }

    public static final class ComprehensionExpression
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final Expression result;
        private final List<Clause> clauses;
        private final Space suffix;
        private final @Nullable JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitComprehensionExpression(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public Expression getResult() {
            return this.result;
        }

        @Generated
        public List<Clause> getClauses() {
            return this.clauses;
        }

        @Generated
        public Space getSuffix() {
            return this.suffix;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComprehensionExpression)) {
                return false;
            }
            ComprehensionExpression other = (ComprehensionExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            Expression this$result = this.getResult();
            Expression other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            List<Clause> this$clauses = this.getClauses();
            List<Clause> other$clauses = other.getClauses();
            if (this$clauses == null ? other$clauses != null : !((Object)this$clauses).equals(other$clauses)) {
                return false;
            }
            Space this$suffix = this.getSuffix();
            Space other$suffix = other.getSuffix();
            if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            Expression $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            List<Clause> $clauses = this.getClauses();
            result = result * 59 + ($clauses == null ? 43 : ((Object)$clauses).hashCode());
            Space $suffix = this.getSuffix();
            result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public ComprehensionExpression(UUID id, Space prefix, Markers markers, Kind kind, Expression result, List<Clause> clauses, Space suffix, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.result = result;
            this.clauses = clauses;
            this.suffix = suffix;
            this.type = type;
        }

        @Generated
        public ComprehensionExpression withId(UUID id) {
            return this.id == id ? this : new ComprehensionExpression(id, this.prefix, this.markers, this.kind, this.result, this.clauses, this.suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ComprehensionExpression(this.id, prefix, this.markers, this.kind, this.result, this.clauses, this.suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withMarkers(Markers markers) {
            return this.markers == markers ? this : new ComprehensionExpression(this.id, this.prefix, markers, this.kind, this.result, this.clauses, this.suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withKind(Kind kind) {
            return this.kind == kind ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, kind, this.result, this.clauses, this.suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withResult(Expression result) {
            return this.result == result ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, result, this.clauses, this.suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withClauses(List<Clause> clauses) {
            return this.clauses == clauses ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, this.result, clauses, this.suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withSuffix(Space suffix) {
            return this.suffix == suffix ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, this.result, this.clauses, suffix, this.type);
        }

        @Generated
        public ComprehensionExpression withType(@Nullable JavaType type) {
            return this.type == type ? this : new ComprehensionExpression(this.id, this.prefix, this.markers, this.kind, this.result, this.clauses, this.suffix, type);
        }

        public static enum Kind {
            LIST,
            SET,
            DICT,
            GENERATOR;

        }

        public static final class Clause
        implements Py {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final @Nullable JRightPadded<Boolean> async;
            private final Expression iteratorVariable;
            private final JLeftPadded<Expression> iteratedList;
            private final @Nullable List<Condition> conditions;

            public boolean isAsync() {
                return this.async != null && (Boolean)this.async.getElement() != false;
            }

            public Clause withAsync(boolean async) {
                return this.getPadding().withAsync((JRightPadded<Boolean>)JRightPadded.withElement(this.async, (Object)async));
            }

            public Expression getIteratedList() {
                return (Expression)this.iteratedList.getElement();
            }

            public Clause withIteratedList(Expression expression) {
                return this.getPadding().withIteratedList((JLeftPadded<Expression>)this.iteratedList.withElement((Object)expression));
            }

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitComprehensionClause(this, p);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Clause)) {
                    return false;
                }
                Clause other = (Clause)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                    return false;
                }
                Space this$prefix = this.getPrefix();
                Space other$prefix = other.getPrefix();
                if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                    return false;
                }
                Markers this$markers = this.getMarkers();
                Markers other$markers = other.getMarkers();
                if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                    return false;
                }
                JRightPadded<Boolean> this$async = this.async;
                JRightPadded<Boolean> other$async = other.async;
                if (this$async == null ? other$async != null : !this$async.equals(other$async)) {
                    return false;
                }
                Expression this$iteratorVariable = this.getIteratorVariable();
                Expression other$iteratorVariable = other.getIteratorVariable();
                if (this$iteratorVariable == null ? other$iteratorVariable != null : !this$iteratorVariable.equals(other$iteratorVariable)) {
                    return false;
                }
                Expression this$iteratedList = this.getIteratedList();
                Expression other$iteratedList = other.getIteratedList();
                if (this$iteratedList == null ? other$iteratedList != null : !this$iteratedList.equals(other$iteratedList)) {
                    return false;
                }
                List<Condition> this$conditions = this.getConditions();
                List<Condition> other$conditions = other.getConditions();
                return !(this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                Space $prefix = this.getPrefix();
                result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
                Markers $markers = this.getMarkers();
                result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
                JRightPadded<Boolean> $async = this.async;
                result = result * 59 + ($async == null ? 43 : $async.hashCode());
                Expression $iteratorVariable = this.getIteratorVariable();
                result = result * 59 + ($iteratorVariable == null ? 43 : $iteratorVariable.hashCode());
                Expression $iteratedList = this.getIteratedList();
                result = result * 59 + ($iteratedList == null ? 43 : $iteratedList.hashCode());
                List<Condition> $conditions = this.getConditions();
                result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
                return result;
            }

            @Generated
            public Clause(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Boolean> async, Expression iteratorVariable, JLeftPadded<Expression> iteratedList, @Nullable List<Condition> conditions) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.async = async;
                this.iteratorVariable = iteratorVariable;
                this.iteratedList = iteratedList;
                this.conditions = conditions;
            }

            @Generated
            private Clause(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<Boolean> async, Expression iteratorVariable, JLeftPadded<Expression> iteratedList, @Nullable List<Condition> conditions) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.async = async;
                this.iteratorVariable = iteratorVariable;
                this.iteratedList = iteratedList;
                this.conditions = conditions;
            }

            @Generated
            public Clause withId(UUID id) {
                return this.id == id ? this : new Clause(this.padding, id, this.prefix, this.markers, this.async, this.iteratorVariable, this.iteratedList, this.conditions);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public Clause withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Clause(this.padding, this.id, prefix, this.markers, this.async, this.iteratorVariable, this.iteratedList, this.conditions);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Clause withMarkers(Markers markers) {
                return this.markers == markers ? this : new Clause(this.padding, this.id, this.prefix, markers, this.async, this.iteratorVariable, this.iteratedList, this.conditions);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public Clause withIteratorVariable(Expression iteratorVariable) {
                return this.iteratorVariable == iteratorVariable ? this : new Clause(this.padding, this.id, this.prefix, this.markers, this.async, iteratorVariable, this.iteratedList, this.conditions);
            }

            @Generated
            public Expression getIteratorVariable() {
                return this.iteratorVariable;
            }

            @Generated
            public Clause withConditions(@Nullable List<Condition> conditions) {
                return this.conditions == conditions ? this : new Clause(this.padding, this.id, this.prefix, this.markers, this.async, this.iteratorVariable, this.iteratedList, conditions);
            }

            @Generated
            public @Nullable List<Condition> getConditions() {
                return this.conditions;
            }

            public static class Padding {
                private final Clause t;

                public JLeftPadded<Expression> getIteratedList() {
                    return this.t.iteratedList;
                }

                public Clause withIteratedList(JLeftPadded<Expression> iteratedList) {
                    return this.t.iteratedList == iteratedList ? this.t : new Clause(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Boolean>)this.t.async, this.t.iteratorVariable, iteratedList, this.t.conditions);
                }

                public @Nullable JRightPadded<Boolean> getAsync() {
                    return this.t.async;
                }

                public Clause withAsync(JRightPadded<Boolean> async) {
                    return this.t.async == async ? this.t : new Clause(this.t.id, this.t.prefix, this.t.markers, async, this.t.iteratorVariable, (JLeftPadded<Expression>)this.t.iteratedList, this.t.conditions);
                }

                @Generated
                public Padding(Clause t) {
                    this.t = t;
                }
            }
        }

        public static final class Condition
        implements Py {
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final Expression expression;

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitComprehensionCondition(this, p);
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public Expression getExpression() {
                return this.expression;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Condition)) {
                    return false;
                }
                Condition other = (Condition)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                    return false;
                }
                Space this$prefix = this.getPrefix();
                Space other$prefix = other.getPrefix();
                if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                    return false;
                }
                Markers this$markers = this.getMarkers();
                Markers other$markers = other.getMarkers();
                if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                    return false;
                }
                Expression this$expression = this.getExpression();
                Expression other$expression = other.getExpression();
                return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                Space $prefix = this.getPrefix();
                result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
                Markers $markers = this.getMarkers();
                result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
                Expression $expression = this.getExpression();
                result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
                return result;
            }

            @Generated
            public Condition(UUID id, Space prefix, Markers markers, Expression expression) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.expression = expression;
            }

            @Generated
            public Condition withId(UUID id) {
                return this.id == id ? this : new Condition(id, this.prefix, this.markers, this.expression);
            }

            @Generated
            public Condition withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Condition(this.id, prefix, this.markers, this.expression);
            }

            @Generated
            public Condition withMarkers(Markers markers) {
                return this.markers == markers ? this : new Condition(this.id, this.prefix, markers, this.expression);
            }

            @Generated
            public Condition withExpression(Expression expression) {
                return this.expression == expression ? this : new Condition(this.id, this.prefix, this.markers, expression);
            }
        }
    }

    public static final class TrailingElseWrapper
    implements Py,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Statement statement;
        private final JLeftPadded<J.Block> elseBlock;

        public J.Block getElseBlock() {
            return (J.Block)this.elseBlock.getElement();
        }

        public TrailingElseWrapper withElseBlock(J.Block elseBlock) {
            return this.getPadding().withElseBlock((JLeftPadded<J.Block>)JLeftPadded.withElement(this.elseBlock, (Object)elseBlock));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTrailingElseWrapper(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public String toString() {
            return "Py.TrailingElseWrapper(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", statement=" + this.getStatement() + ", elseBlock=" + this.getElseBlock() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrailingElseWrapper)) {
                return false;
            }
            TrailingElseWrapper other = (TrailingElseWrapper)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            if (this$statement == null ? other$statement != null : !this$statement.equals(other$statement)) {
                return false;
            }
            J.Block this$elseBlock = this.getElseBlock();
            J.Block other$elseBlock = other.getElseBlock();
            return !(this$elseBlock == null ? other$elseBlock != null : !this$elseBlock.equals(other$elseBlock));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            J.Block $elseBlock = this.getElseBlock();
            result = result * 59 + ($elseBlock == null ? 43 : $elseBlock.hashCode());
            return result;
        }

        @Generated
        public TrailingElseWrapper(UUID id, Space prefix, Markers markers, Statement statement, JLeftPadded<J.Block> elseBlock) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statement = statement;
            this.elseBlock = elseBlock;
        }

        @Generated
        private TrailingElseWrapper(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Statement statement, JLeftPadded<J.Block> elseBlock) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statement = statement;
            this.elseBlock = elseBlock;
        }

        @Generated
        public TrailingElseWrapper withId(UUID id) {
            return this.id == id ? this : new TrailingElseWrapper(this.padding, id, this.prefix, this.markers, this.statement, this.elseBlock);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public TrailingElseWrapper withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TrailingElseWrapper(this.padding, this.id, prefix, this.markers, this.statement, this.elseBlock);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public TrailingElseWrapper withMarkers(Markers markers) {
            return this.markers == markers ? this : new TrailingElseWrapper(this.padding, this.id, this.prefix, markers, this.statement, this.elseBlock);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public TrailingElseWrapper withStatement(Statement statement) {
            return this.statement == statement ? this : new TrailingElseWrapper(this.padding, this.id, this.prefix, this.markers, statement, this.elseBlock);
        }

        @Generated
        public Statement getStatement() {
            return this.statement;
        }

        public static class Padding {
            private final TrailingElseWrapper t;

            public JLeftPadded<J.Block> getElseBlock() {
                return this.t.elseBlock;
            }

            public TrailingElseWrapper withElseBlock(JLeftPadded<J.Block> elseBlock) {
                return this.t.elseBlock == elseBlock ? this.t : new TrailingElseWrapper(this.t.padding, this.t.id, this.t.prefix, this.t.markers, this.t.statement, elseBlock);
            }

            @Generated
            public Padding(TrailingElseWrapper t) {
                this.t = t;
            }
        }
    }

    public static final class Pass
    implements Py,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitPass(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String toString() {
            return "Py.Pass(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pass)) {
                return false;
            }
            Pass other = (Pass)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            return !(this$markers == null ? other$markers != null : !this$markers.equals(other$markers));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            return result;
        }

        @Generated
        public Pass(UUID id, Space prefix, Markers markers) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
        }

        @Generated
        public Pass withId(UUID id) {
            return this.id == id ? this : new Pass(id, this.prefix, this.markers);
        }

        @Generated
        public Pass withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Pass(this.id, prefix, this.markers);
        }

        @Generated
        public Pass withMarkers(Markers markers) {
            return this.markers == markers ? this : new Pass(this.id, this.prefix, markers);
        }
    }

    public static final class FormattedString
    implements Py,
    Expression,
    TypedTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final String delimiter;
        private final List<Expression> parts;

        public JavaType getType() {
            return JavaType.Primitive.String;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this;
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitFormattedString(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getDelimiter() {
            return this.delimiter;
        }

        @Generated
        public List<Expression> getParts() {
            return this.parts;
        }

        @Generated
        public FormattedString withId(UUID id) {
            return this.id == id ? this : new FormattedString(id, this.prefix, this.markers, this.delimiter, this.parts);
        }

        @Generated
        public FormattedString withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new FormattedString(this.id, prefix, this.markers, this.delimiter, this.parts);
        }

        @Generated
        public FormattedString withMarkers(Markers markers) {
            return this.markers == markers ? this : new FormattedString(this.id, this.prefix, markers, this.delimiter, this.parts);
        }

        @Generated
        public FormattedString withDelimiter(String delimiter) {
            return this.delimiter == delimiter ? this : new FormattedString(this.id, this.prefix, this.markers, delimiter, this.parts);
        }

        @Generated
        public FormattedString withParts(List<Expression> parts) {
            return this.parts == parts ? this : new FormattedString(this.id, this.prefix, this.markers, this.delimiter, parts);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FormattedString)) {
                return false;
            }
            FormattedString other = (FormattedString)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            String this$delimiter = this.getDelimiter();
            String other$delimiter = other.getDelimiter();
            if (this$delimiter == null ? other$delimiter != null : !this$delimiter.equals(other$delimiter)) {
                return false;
            }
            List<Expression> this$parts = this.getParts();
            List<Expression> other$parts = other.getParts();
            return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            String $delimiter = this.getDelimiter();
            result = result * 59 + ($delimiter == null ? 43 : $delimiter.hashCode());
            List<Expression> $parts = this.getParts();
            result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
            return result;
        }

        @Generated
        public FormattedString(UUID id, Space prefix, Markers markers, String delimiter, List<Expression> parts) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.delimiter = delimiter;
            this.parts = parts;
        }

        public static final class Value
        implements Py,
        Expression,
        TypedTree {
            private transient @Nullable WeakReference<Padding> padding;
            private final UUID id;
            private final Space prefix;
            private final Markers markers;
            private final JRightPadded<Expression> expression;
            private final @Nullable JRightPadded<Boolean> debug;
            private final @Nullable Conversion conversion;
            private final @Nullable Expression format;

            public Expression getExpression() {
                return (Expression)this.expression.getElement();
            }

            public Value withExpression(Expression expression) {
                return this.getPadding().withExpression((JRightPadded<Expression>)JRightPadded.withElement(this.expression, (Object)expression));
            }

            public boolean isDebug() {
                return this.debug != null && (Boolean)this.debug.getElement() != false;
            }

            public Value withDebug(boolean debug) {
                return this.getPadding().withDebug(debug ? JRightPadded.withElement(this.debug, (Object)true) : null);
            }

            public JavaType getType() {
                return JavaType.Primitive.String;
            }

            public <T extends J> T withType(@Nullable JavaType type) {
                return (T)this;
            }

            @Override
            public <P> J acceptPython(PythonVisitor<P> v, P p) {
                return v.visitFormattedStringValue(this, p);
            }

            @Transient
            public CoordinateBuilder.Expression getCoordinates() {
                return new CoordinateBuilder.Expression((J)this);
            }

            public Padding getPadding() {
                Padding p;
                if (this.padding == null) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                } else {
                    p = (Padding)this.padding.get();
                    if (p == null || p.t != this) {
                        p = new Padding(this);
                        this.padding = new WeakReference<Padding>(p);
                    }
                }
                return p;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                    return false;
                }
                Space this$prefix = this.getPrefix();
                Space other$prefix = other.getPrefix();
                if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                    return false;
                }
                Markers this$markers = this.getMarkers();
                Markers other$markers = other.getMarkers();
                if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                    return false;
                }
                Expression this$expression = this.getExpression();
                Expression other$expression = other.getExpression();
                if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                    return false;
                }
                JRightPadded<Boolean> this$debug = this.debug;
                JRightPadded<Boolean> other$debug = other.debug;
                if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) {
                    return false;
                }
                Conversion this$conversion = this.getConversion();
                Conversion other$conversion = other.getConversion();
                if (this$conversion == null ? other$conversion != null : !((Object)((Object)this$conversion)).equals((Object)other$conversion)) {
                    return false;
                }
                Expression this$format = this.getFormat();
                Expression other$format = other.getFormat();
                return !(this$format == null ? other$format != null : !this$format.equals(other$format));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                Space $prefix = this.getPrefix();
                result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
                Markers $markers = this.getMarkers();
                result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
                Expression $expression = this.getExpression();
                result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
                JRightPadded<Boolean> $debug = this.debug;
                result = result * 59 + ($debug == null ? 43 : $debug.hashCode());
                Conversion $conversion = this.getConversion();
                result = result * 59 + ($conversion == null ? 43 : ((Object)((Object)$conversion)).hashCode());
                Expression $format = this.getFormat();
                result = result * 59 + ($format == null ? 43 : $format.hashCode());
                return result;
            }

            @Generated
            public Value(UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, @Nullable JRightPadded<Boolean> debug, @Nullable Conversion conversion, @Nullable Expression format) {
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.expression = expression;
                this.debug = debug;
                this.conversion = conversion;
                this.format = format;
            }

            @Generated
            private Value(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> expression, @Nullable JRightPadded<Boolean> debug, @Nullable Conversion conversion, @Nullable Expression format) {
                this.padding = padding;
                this.id = id;
                this.prefix = prefix;
                this.markers = markers;
                this.expression = expression;
                this.debug = debug;
                this.conversion = conversion;
                this.format = format;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(this.padding, id, this.prefix, this.markers, this.expression, this.debug, this.conversion, this.format);
            }

            @Override
            @Generated
            public Space getPrefix() {
                return this.prefix;
            }

            @Generated
            public Value withPrefix(Space prefix) {
                return this.prefix == prefix ? this : new Value(this.padding, this.id, prefix, this.markers, this.expression, this.debug, this.conversion, this.format);
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.padding, this.id, this.prefix, markers, this.expression, this.debug, this.conversion, this.format);
            }

            @Generated
            public @Nullable Conversion getConversion() {
                return this.conversion;
            }

            @Generated
            public Value withConversion(@Nullable Conversion conversion) {
                return this.conversion == conversion ? this : new Value(this.padding, this.id, this.prefix, this.markers, this.expression, this.debug, conversion, this.format);
            }

            @Generated
            public @Nullable Expression getFormat() {
                return this.format;
            }

            @Generated
            public Value withFormat(@Nullable Expression format) {
                return this.format == format ? this : new Value(this.padding, this.id, this.prefix, this.markers, this.expression, this.debug, this.conversion, format);
            }

            public static enum Conversion {
                STR,
                REPR,
                ASCII;

            }

            public static class Padding {
                private final Value t;

                public JRightPadded<Expression> getExpression() {
                    return this.t.expression;
                }

                public Value withExpression(JRightPadded<Expression> expression) {
                    return this.t.expression == expression ? this.t : new Value(this.t.id, this.t.prefix, this.t.markers, expression, (JRightPadded<Boolean>)this.t.debug, this.t.conversion, this.t.format);
                }

                public @Nullable JRightPadded<Boolean> getDebug() {
                    return this.t.debug;
                }

                public Value withDebug(@Nullable JRightPadded<Boolean> debug) {
                    return this.t.debug == debug ? this.t : new Value(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<Expression>)this.t.expression, debug, this.t.conversion, this.t.format);
                }

                @Generated
                public Padding(Value t) {
                    this.t = t;
                }
            }
        }
    }

    public static final class CollectionLiteral
    implements Py,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Kind kind;
        private final JContainer<Expression> elements;
        private final @Nullable JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public CollectionLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitCollectionLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CollectionLiteral)) {
                return false;
            }
            CollectionLiteral other = (CollectionLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Kind this$kind = this.getKind();
            Kind other$kind = other.getKind();
            if (this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind)) {
                return false;
            }
            List<Expression> this$elements = this.getElements();
            List<Expression> other$elements = other.getElements();
            if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Kind $kind = this.getKind();
            result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
            List<Expression> $elements = this.getElements();
            result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public CollectionLiteral(UUID id, Space prefix, Markers markers, Kind kind, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private CollectionLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Kind kind, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.kind = kind;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public CollectionLiteral withId(UUID id) {
            return this.id == id ? this : new CollectionLiteral(this.padding, id, this.prefix, this.markers, this.kind, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public CollectionLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CollectionLiteral(this.padding, this.id, prefix, this.markers, this.kind, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public CollectionLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new CollectionLiteral(this.padding, this.id, this.prefix, markers, this.kind, this.elements, this.type);
        }

        @Generated
        public Kind getKind() {
            return this.kind;
        }

        @Generated
        public CollectionLiteral withKind(Kind kind) {
            return this.kind == kind ? this : new CollectionLiteral(this.padding, this.id, this.prefix, this.markers, kind, this.elements, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public CollectionLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new CollectionLiteral(this.padding, this.id, this.prefix, this.markers, this.kind, this.elements, type);
        }

        public static enum Kind {
            LIST,
            SET,
            TUPLE;

        }

        public static class Padding {
            private final CollectionLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public CollectionLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new CollectionLiteral(this.t.id, this.t.prefix, this.t.markers, this.t.kind, elements, this.t.type);
            }

            @Generated
            public Padding(CollectionLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class DictLiteral
    implements Py,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JContainer<Expression> elements;
        private final @Nullable JavaType type;

        public List<Expression> getElements() {
            return this.elements.getElements();
        }

        public DictLiteral withElements(List<Expression> elements) {
            return this.getPadding().withElements((JContainer<Expression>)JContainer.withElements(this.elements, elements));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitDictLiteral(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DictLiteral)) {
                return false;
            }
            DictLiteral other = (DictLiteral)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            List<Expression> this$elements = this.getElements();
            List<Expression> other$elements = other.getElements();
            if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            List<Expression> $elements = this.getElements();
            result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public DictLiteral(UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        private DictLiteral(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JContainer<Expression> elements, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.elements = elements;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public DictLiteral withId(UUID id) {
            return this.id == id ? this : new DictLiteral(this.padding, id, this.prefix, this.markers, this.elements, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public DictLiteral withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new DictLiteral(this.padding, this.id, prefix, this.markers, this.elements, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public DictLiteral withMarkers(Markers markers) {
            return this.markers == markers ? this : new DictLiteral(this.padding, this.id, this.prefix, markers, this.elements, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public DictLiteral withType(@Nullable JavaType type) {
            return this.type == type ? this : new DictLiteral(this.padding, this.id, this.prefix, this.markers, this.elements, type);
        }

        public static class Padding {
            private final DictLiteral t;

            public JContainer<Expression> getElements() {
                return this.t.elements;
            }

            public DictLiteral withElements(JContainer<Expression> elements) {
                return this.t.elements == elements ? this.t : new DictLiteral(this.t.id, this.t.prefix, this.t.markers, elements, this.t.type);
            }

            @Generated
            public Padding(DictLiteral t) {
                this.t = t;
            }
        }
    }

    public static final class KeyValue
    implements Py,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JRightPadded<Expression> key;
        private final Expression value;
        private final @Nullable JavaType type;

        public Expression getKey() {
            return (Expression)this.key.getElement();
        }

        public KeyValue withKey(@Nullable Expression key) {
            return this.getPadding().withKey((JRightPadded<Expression>)JRightPadded.withElement(this.key, (Object)key));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitKeyValue(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$key = this.getKey();
            Expression other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            Expression this$value = this.getValue();
            Expression other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            Expression $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public KeyValue(UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        @Generated
        private KeyValue(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, JRightPadded<Expression> key, Expression value, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.key = key;
            this.value = value;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public KeyValue withId(UUID id) {
            return this.id == id ? this : new KeyValue(this.padding, id, this.prefix, this.markers, this.key, this.value, this.type);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public KeyValue withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new KeyValue(this.padding, this.id, prefix, this.markers, this.key, this.value, this.type);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public KeyValue withMarkers(Markers markers) {
            return this.markers == markers ? this : new KeyValue(this.padding, this.id, this.prefix, markers, this.key, this.value, this.type);
        }

        @Generated
        public Expression getValue() {
            return this.value;
        }

        @Generated
        public KeyValue withValue(Expression value) {
            return this.value == value ? this : new KeyValue(this.padding, this.id, this.prefix, this.markers, this.key, value, this.type);
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public KeyValue withType(@Nullable JavaType type) {
            return this.type == type ? this : new KeyValue(this.padding, this.id, this.prefix, this.markers, this.key, this.value, type);
        }

        public static class Padding {
            private final KeyValue t;

            public @Nullable JRightPadded<Expression> getKey() {
                return this.t.key;
            }

            public KeyValue withKey(@Nullable JRightPadded<Expression> key) {
                return this.t.key == key ? this.t : new KeyValue(this.t.id, this.t.prefix, this.t.markers, key, this.t.value, this.t.type);
            }

            @Generated
            public Padding(KeyValue t) {
                this.t = t;
            }
        }
    }

    public static final class MultiImport
    implements Py,
    Statement {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final @Nullable JRightPadded<NameTree> from;
        private final boolean parenthesized;
        private final JContainer<J.Import> names;

        public @Nullable NameTree getFrom() {
            return this.from == null ? null : (NameTree)this.from.getElement();
        }

        public MultiImport withFrom(NameTree from) {
            return this.getPadding().withFrom((JRightPadded<NameTree>)JRightPadded.withElement(this.from, (Object)from));
        }

        public List<J.Import> getNames() {
            return this.names.getElements();
        }

        public MultiImport withNames(List<J.Import> names) {
            return this.getPadding().withNames((JContainer<J.Import>)JContainer.withElements(this.names, names));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitMultiImport(this, p);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new PythonPrinter());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiImport)) {
                return false;
            }
            MultiImport other = (MultiImport)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public MultiImport(UUID id, Space prefix, Markers markers, @Nullable JRightPadded<NameTree> from, boolean parenthesized, JContainer<J.Import> names) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.parenthesized = parenthesized;
            this.names = names;
        }

        @Generated
        private MultiImport(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, @Nullable JRightPadded<NameTree> from, boolean parenthesized, JContainer<J.Import> names) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.from = from;
            this.parenthesized = parenthesized;
            this.names = names;
        }

        @Generated
        public MultiImport withId(UUID id) {
            return this.id == id ? this : new MultiImport(this.padding, id, this.prefix, this.markers, this.from, this.parenthesized, this.names);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public MultiImport withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new MultiImport(this.padding, this.id, prefix, this.markers, this.from, this.parenthesized, this.names);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public MultiImport withMarkers(Markers markers) {
            return this.markers == markers ? this : new MultiImport(this.padding, this.id, this.prefix, markers, this.from, this.parenthesized, this.names);
        }

        @Generated
        public boolean isParenthesized() {
            return this.parenthesized;
        }

        @Generated
        public MultiImport withParenthesized(boolean parenthesized) {
            return this.parenthesized == parenthesized ? this : new MultiImport(this.padding, this.id, this.prefix, this.markers, this.from, parenthesized, this.names);
        }

        public static class Padding {
            private final MultiImport t;

            public @Nullable JRightPadded<NameTree> getFrom() {
                return this.t.from;
            }

            public MultiImport withFrom(@Nullable JRightPadded<NameTree> from) {
                return this.t.from == from ? this.t : new MultiImport(this.t.id, this.t.prefix, this.t.markers, from, this.t.parenthesized, (JContainer<J.Import>)this.t.names);
            }

            public JContainer<J.Import> getNames() {
                return this.t.names;
            }

            public MultiImport withNames(JContainer<J.Import> names) {
                return this.t.names == names ? this.t : new MultiImport(this.t.id, this.t.prefix, this.t.markers, (JRightPadded<NameTree>)this.t.from, this.t.parenthesized, names);
            }

            @Generated
            public Padding(MultiImport t) {
                this.t = t;
            }
        }
    }

    public static final class StatementExpression
    implements Py,
    Expression,
    Statement {
        private final UUID id;
        private final Statement statement;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitStatementExpression(this, p);
        }

        public <P2 extends J> P2 withPrefix(Space space) {
            return (P2)this.withStatement((Statement)this.statement.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.statement.getPrefix();
        }

        public <P2 extends Tree> P2 withMarkers(Markers markers) {
            return (P2)this.withStatement((Statement)this.statement.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.statement.getMarkers();
        }

        public @Nullable JavaType getType() {
            return null;
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this;
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Statement getStatement() {
            return this.statement;
        }

        @Generated
        public String toString() {
            return "Py.StatementExpression(id=" + this.getId() + ", statement=" + this.getStatement() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StatementExpression)) {
                return false;
            }
            StatementExpression other = (StatementExpression)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        @Generated
        public StatementExpression(UUID id, Statement statement) {
            this.id = id;
            this.statement = statement;
        }

        @Generated
        public StatementExpression withId(UUID id) {
            return this.id == id ? this : new StatementExpression(id, this.statement);
        }

        @Generated
        public StatementExpression withStatement(Statement statement) {
            return this.statement == statement ? this : new StatementExpression(this.id, statement);
        }
    }

    public static final class ExpressionTypeTree
    implements Py,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final J reference;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitExpressionTypeTree(this, p);
        }

        public @Nullable JavaType getType() {
            if (this.reference instanceof Expression) {
                return ((Expression)this.reference).getType();
            }
            if (this.reference instanceof TypedTree) {
                return ((TypedTree)this.reference).getType();
            }
            return null;
        }

        public ExpressionTypeTree withType(@Nullable JavaType type) {
            if (this.reference instanceof Expression) {
                return this.withReference(((Expression)this.reference).withType(type));
            }
            if (this.reference instanceof TypedTree) {
                return this.withReference(((TypedTree)this.reference).withType(type));
            }
            return this;
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public ExpressionTypeTree(UUID id, Space prefix, Markers markers, J reference) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.reference = reference;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public J getReference() {
            return this.reference;
        }

        @Generated
        public String toString() {
            return "Py.ExpressionTypeTree(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", reference=" + this.getReference() + ")";
        }

        @Generated
        public ExpressionTypeTree withId(UUID id) {
            return this.id == id ? this : new ExpressionTypeTree(id, this.prefix, this.markers, this.reference);
        }

        @Generated
        public ExpressionTypeTree withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExpressionTypeTree(this.id, prefix, this.markers, this.reference);
        }

        @Generated
        public ExpressionTypeTree withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExpressionTypeTree(this.id, this.prefix, markers, this.reference);
        }

        @Generated
        public ExpressionTypeTree withReference(J reference) {
            return this.reference == reference ? this : new ExpressionTypeTree(this.id, this.prefix, this.markers, reference);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionTypeTree)) {
                return false;
            }
            ExpressionTypeTree other = (ExpressionTypeTree)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }
    }

    public static final class ExpressionStatement
    implements Py,
    Expression,
    Statement {
        private final UUID id;
        private final Expression expression;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitExpressionStatement(this, p);
        }

        public <P2 extends J> P2 withPrefix(Space space) {
            return (P2)this.withExpression((Expression)this.expression.withPrefix(space));
        }

        @Override
        public Space getPrefix() {
            return this.expression.getPrefix();
        }

        public <P2 extends Tree> P2 withMarkers(Markers markers) {
            return (P2)this.withExpression((Expression)this.expression.withMarkers(markers));
        }

        public Markers getMarkers() {
            return this.expression.getMarkers();
        }

        public @Nullable JavaType getType() {
            return this.expression.getType();
        }

        public <T extends J> T withType(@Nullable JavaType type) {
            return (T)this.withExpression((Expression)this.expression.withType(type));
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public String toString() {
            return "Py.ExpressionStatement(id=" + this.getId() + ", expression=" + this.getExpression() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExpressionStatement)) {
                return false;
            }
            ExpressionStatement other = (ExpressionStatement)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }

        @Generated
        public ExpressionStatement(UUID id, Expression expression) {
            this.id = id;
            this.expression = expression;
        }

        @Generated
        public ExpressionStatement withId(UUID id) {
            return this.id == id ? this : new ExpressionStatement(id, this.expression);
        }

        @Generated
        public ExpressionStatement withExpression(Expression expression) {
            return this.expression == expression ? this : new ExpressionStatement(this.id, expression);
        }
    }

    public static final class CompilationUnit
    implements Py,
    JavaSourceFile,
    SourceFile {
        private transient @Nullable SoftReference<TypesInUse> typesInUse;
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Path sourcePath;
        private final @Nullable FileAttributes fileAttributes;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final List<JRightPadded<J.Import>> imports;
        private final List<JRightPadded<Statement>> statements;
        private final Space eof;

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public SourceFile withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public List<J.Import> getImports() {
            return JRightPadded.getElements(this.imports);
        }

        public CompilationUnit withImports(List<J.Import> imports) {
            return this.getPadding().withImports(JRightPadded.withElements(this.imports, imports));
        }

        public List<Statement> getStatements() {
            return JRightPadded.getElements(this.statements);
        }

        public CompilationUnit withStatements(List<Statement> statements) {
            return this.getPadding().withStatements(JRightPadded.withElements(this.statements, statements));
        }

        @Transient
        public List<J.ClassDeclaration> getClasses() {
            return this.statements.stream().map(JRightPadded::getElement).filter(J.ClassDeclaration.class::isInstance).map(J.ClassDeclaration.class::cast).collect(Collectors.toList());
        }

        public JavaSourceFile withClasses(List<J.ClassDeclaration> classes) {
            return this;
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitCompilationUnit(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new PythonPrinter();
        }

        @Transient
        public TypesInUse getTypesInUse() {
            TypesInUse cache;
            if (this.typesInUse == null) {
                cache = TypesInUse.build((JavaSourceFile)this);
                this.typesInUse = new SoftReference<TypesInUse>(cache);
            } else {
                cache = this.typesInUse.get();
                if (cache == null || cache.getCu() != this) {
                    cache = TypesInUse.build((JavaSourceFile)this);
                    this.typesInUse = new SoftReference<TypesInUse>(cache);
                }
            }
            return cache;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable J.Package getPackageDeclaration() {
            return null;
        }

        public JavaSourceFile withPackageDeclaration(J.Package pkg) {
            throw new IllegalStateException("Python does not support package declarations");
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public String toString() {
            return "Py.CompilationUnit(typesInUse=" + this.getTypesInUse() + ", padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", sourcePath=" + this.getSourcePath() + ", fileAttributes=" + this.getFileAttributes() + ", charsetName=" + this.charsetName + ", charsetBomMarked=" + this.isCharsetBomMarked() + ", checksum=" + this.getChecksum() + ", imports=" + this.getImports() + ", statements=" + this.getStatements() + ", eof=" + this.getEof() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompilationUnit)) {
                return false;
            }
            CompilationUnit other = (CompilationUnit)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            FileAttributes this$fileAttributes = this.getFileAttributes();
            FileAttributes other$fileAttributes = other.getFileAttributes();
            if (this$fileAttributes == null ? other$fileAttributes != null : !this$fileAttributes.equals(other$fileAttributes)) {
                return false;
            }
            String this$charsetName = this.charsetName;
            String other$charsetName = other.charsetName;
            if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
                return false;
            }
            Checksum this$checksum = this.getChecksum();
            Checksum other$checksum = other.getChecksum();
            if (this$checksum == null ? other$checksum != null : !this$checksum.equals(other$checksum)) {
                return false;
            }
            List<J.Import> this$imports = this.getImports();
            List<J.Import> other$imports = other.getImports();
            if (this$imports == null ? other$imports != null : !((Object)this$imports).equals(other$imports)) {
                return false;
            }
            List<Statement> this$statements = this.getStatements();
            List<Statement> other$statements = other.getStatements();
            if (this$statements == null ? other$statements != null : !((Object)this$statements).equals(other$statements)) {
                return false;
            }
            Space this$eof = this.getEof();
            Space other$eof = other.getEof();
            return !(this$eof == null ? other$eof != null : !this$eof.equals(other$eof));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            FileAttributes $fileAttributes = this.getFileAttributes();
            result = result * 59 + ($fileAttributes == null ? 43 : $fileAttributes.hashCode());
            String $charsetName = this.charsetName;
            result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
            Checksum $checksum = this.getChecksum();
            result = result * 59 + ($checksum == null ? 43 : $checksum.hashCode());
            List<J.Import> $imports = this.getImports();
            result = result * 59 + ($imports == null ? 43 : ((Object)$imports).hashCode());
            List<Statement> $statements = this.getStatements();
            result = result * 59 + ($statements == null ? 43 : ((Object)$statements).hashCode());
            Space $eof = this.getEof();
            result = result * 59 + ($eof == null ? 43 : $eof.hashCode());
            return result;
        }

        @Generated
        public CompilationUnit(UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @Generated
        private CompilationUnit(@Nullable SoftReference<TypesInUse> typesInUse, @Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Path sourcePath, @Nullable FileAttributes fileAttributes, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, List<JRightPadded<J.Import>> imports, List<JRightPadded<Statement>> statements, Space eof) {
            this.typesInUse = typesInUse;
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.sourcePath = sourcePath;
            this.fileAttributes = fileAttributes;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.imports = imports;
            this.statements = statements;
            this.eof = eof;
        }

        @Generated
        public CompilationUnit withId(UUID id) {
            return this.id == id ? this : new CompilationUnit(this.typesInUse, this.padding, id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public CompilationUnit withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public CompilationUnit withMarkers(Markers markers) {
            return this.markers == markers ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public CompilationUnit withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public CompilationUnit withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Generated
        private CompilationUnit withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public CompilationUnit withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, charsetBomMarked, this.checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Generated
        public CompilationUnit withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, checksum, this.imports, this.statements, this.eof);
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @Generated
        public CompilationUnit withEof(Space eof) {
            return this.eof == eof ? this : new CompilationUnit(this.typesInUse, this.padding, this.id, this.prefix, this.markers, this.sourcePath, this.fileAttributes, this.charsetName, this.charsetBomMarked, this.checksum, this.imports, this.statements, eof);
        }

        @Generated
        public Space getEof() {
            return this.eof;
        }

        public static class Padding
        implements JavaSourceFile.Padding {
            private final CompilationUnit t;

            public List<JRightPadded<J.Import>> getImports() {
                return this.t.imports;
            }

            public CompilationUnit withImports(List<JRightPadded<J.Import>> imports) {
                return this.t.imports == imports ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, null, imports, this.t.statements, this.t.eof);
            }

            public List<JRightPadded<Statement>> getStatements() {
                return this.t.statements;
            }

            public CompilationUnit withStatements(List<JRightPadded<Statement>> statements) {
                return this.t.statements == statements ? this.t : new CompilationUnit(this.t.id, this.t.prefix, this.t.markers, this.t.sourcePath, this.t.fileAttributes, this.t.charsetName, this.t.charsetBomMarked, this.t.checksum, this.t.imports, statements, this.t.eof);
            }

            @Generated
            public Padding(CompilationUnit t) {
                this.t = t;
            }
        }
    }

    public static final class TypeHint
    implements Py,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression typeTree;
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitTypeHint(this, p);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getTypeTree() {
            return this.typeTree;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public TypeHint withId(UUID id) {
            return this.id == id ? this : new TypeHint(id, this.prefix, this.markers, this.typeTree, this.type);
        }

        @Generated
        public TypeHint withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new TypeHint(this.id, prefix, this.markers, this.typeTree, this.type);
        }

        @Generated
        public TypeHint withMarkers(Markers markers) {
            return this.markers == markers ? this : new TypeHint(this.id, this.prefix, markers, this.typeTree, this.type);
        }

        @Generated
        public TypeHint withTypeTree(Expression typeTree) {
            return this.typeTree == typeTree ? this : new TypeHint(this.id, this.prefix, this.markers, typeTree, this.type);
        }

        @Generated
        public TypeHint withType(JavaType type) {
            return this.type == type ? this : new TypeHint(this.id, this.prefix, this.markers, this.typeTree, type);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TypeHint)) {
                return false;
            }
            TypeHint other = (TypeHint)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$typeTree = this.getTypeTree();
            Expression other$typeTree = other.getTypeTree();
            if (this$typeTree == null ? other$typeTree != null : !this$typeTree.equals(other$typeTree)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $typeTree = this.getTypeTree();
            result = result * 59 + ($typeTree == null ? 43 : $typeTree.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public TypeHint(UUID id, Space prefix, Markers markers, Expression typeTree, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.typeTree = typeTree;
            this.type = type;
        }
    }

    public static final class LiteralType
    implements Py,
    Expression,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression literal;
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitLiteralType(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LiteralType)) {
                return false;
            }
            LiteralType other = (LiteralType)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$literal = this.getLiteral();
            Expression other$literal = other.getLiteral();
            if (this$literal == null ? other$literal != null : !this$literal.equals(other$literal)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $literal = this.getLiteral();
            result = result * 59 + ($literal == null ? 43 : $literal.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public LiteralType(UUID id, Space prefix, Markers markers, Expression literal, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.literal = literal;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLiteral() {
            return this.literal;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public String toString() {
            return "Py.LiteralType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", literal=" + this.getLiteral() + ", type=" + this.getType() + ")";
        }

        @Generated
        public LiteralType withId(UUID id) {
            return this.id == id ? this : new LiteralType(id, this.prefix, this.markers, this.literal, this.type);
        }

        @Generated
        public LiteralType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new LiteralType(this.id, prefix, this.markers, this.literal, this.type);
        }

        @Generated
        public LiteralType withMarkers(Markers markers) {
            return this.markers == markers ? this : new LiteralType(this.id, this.prefix, markers, this.literal, this.type);
        }

        @Generated
        public LiteralType withLiteral(Expression literal) {
            return this.literal == literal ? this : new LiteralType(this.id, this.prefix, this.markers, literal, this.type);
        }

        @Generated
        public LiteralType withType(JavaType type) {
            return this.type == type ? this : new LiteralType(this.id, this.prefix, this.markers, this.literal, type);
        }
    }

    public static final class ForLoop
    implements Py,
    Loop {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression target;
        private final JLeftPadded<Expression> iterable;
        private final JRightPadded<Statement> body;

        public Expression getIterable() {
            return (Expression)this.iterable.getElement();
        }

        public ForLoop withIterable(Expression iterable) {
            return this.getPadding().withIterable((JLeftPadded<Expression>)JLeftPadded.withElement(this.iterable, (Object)iterable));
        }

        public Statement getBody() {
            return (Statement)this.body.getElement();
        }

        public ForLoop withBody(Statement body) {
            return this.getPadding().withBody((JRightPadded<Statement>)this.body.withElement((Object)body));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitForLoop(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new PythonPrinter());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForLoop)) {
                return false;
            }
            ForLoop other = (ForLoop)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ForLoop(UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Expression> iterable, JRightPadded<Statement> body) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.iterable = iterable;
            this.body = body;
        }

        @Generated
        private ForLoop(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression target, JLeftPadded<Expression> iterable, JRightPadded<Statement> body) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.target = target;
            this.iterable = iterable;
            this.body = body;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getTarget() {
            return this.target;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public ForLoop withId(UUID id) {
            return this.id == id ? this : new ForLoop(this.padding, id, this.prefix, this.markers, this.target, this.iterable, this.body);
        }

        @Generated
        public ForLoop withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ForLoop(this.padding, this.id, prefix, this.markers, this.target, this.iterable, this.body);
        }

        @Generated
        public ForLoop withMarkers(Markers markers) {
            return this.markers == markers ? this : new ForLoop(this.padding, this.id, this.prefix, markers, this.target, this.iterable, this.body);
        }

        @Generated
        public ForLoop withTarget(Expression target) {
            return this.target == target ? this : new ForLoop(this.padding, this.id, this.prefix, this.markers, target, this.iterable, this.body);
        }

        public static class Padding {
            private final ForLoop t;

            public JLeftPadded<Expression> getIterable() {
                return this.t.iterable;
            }

            public ForLoop withIterable(JLeftPadded<Expression> iterable) {
                return this.t.iterable == iterable ? this.t : new ForLoop(this.t.id, this.t.prefix, this.t.markers, this.t.target, iterable, (JRightPadded<Statement>)this.t.body);
            }

            public JRightPadded<Statement> getBody() {
                return this.t.body;
            }

            public ForLoop withBody(JRightPadded<Statement> body) {
                return this.t.body == body ? this.t : new ForLoop(this.t.id, this.t.prefix, this.t.markers, this.t.target, (JLeftPadded<Expression>)this.t.iterable, body);
            }

            @Generated
            public Padding(ForLoop t) {
                this.t = t;
            }
        }
    }

    public static final class ExceptionType
    implements Py,
    TypeTree {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final JavaType type;
        private final boolean isExceptionGroup;
        private final Expression expression;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitExceptionType(this, p);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionType)) {
                return false;
            }
            ExceptionType other = (ExceptionType)o;
            if (this.isExceptionGroup() != other.isExceptionGroup()) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            return !(this$expression == null ? other$expression != null : !this$expression.equals(other$expression));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExceptionGroup() ? 79 : 97);
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            return result;
        }

        @Generated
        public ExceptionType(UUID id, Space prefix, Markers markers, JavaType type, boolean isExceptionGroup, Expression expression) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.type = type;
            this.isExceptionGroup = isExceptionGroup;
            this.expression = expression;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean isExceptionGroup() {
            return this.isExceptionGroup;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public String toString() {
            return "Py.ExceptionType(id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", type=" + this.getType() + ", isExceptionGroup=" + this.isExceptionGroup() + ", expression=" + this.getExpression() + ")";
        }

        @Generated
        public ExceptionType withId(UUID id) {
            return this.id == id ? this : new ExceptionType(id, this.prefix, this.markers, this.type, this.isExceptionGroup, this.expression);
        }

        @Generated
        public ExceptionType withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ExceptionType(this.id, prefix, this.markers, this.type, this.isExceptionGroup, this.expression);
        }

        @Generated
        public ExceptionType withMarkers(Markers markers) {
            return this.markers == markers ? this : new ExceptionType(this.id, this.prefix, markers, this.type, this.isExceptionGroup, this.expression);
        }

        @Generated
        public ExceptionType withType(JavaType type) {
            return this.type == type ? this : new ExceptionType(this.id, this.prefix, this.markers, type, this.isExceptionGroup, this.expression);
        }

        @Generated
        public ExceptionType withExceptionGroup(boolean isExceptionGroup) {
            return this.isExceptionGroup == isExceptionGroup ? this : new ExceptionType(this.id, this.prefix, this.markers, this.type, isExceptionGroup, this.expression);
        }

        @Generated
        public ExceptionType withExpression(Expression expression) {
            return this.expression == expression ? this : new ExceptionType(this.id, this.prefix, this.markers, this.type, this.isExceptionGroup, expression);
        }
    }

    public static final class ChainedAssignment
    implements Py,
    Statement,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final List<JRightPadded<Expression>> variables;
        private final Expression assignment;
        private final @Nullable JavaType type;

        public List<Expression> getVariables() {
            return JRightPadded.getElements(this.variables);
        }

        public ChainedAssignment withVariables(List<Expression> variables) {
            return this.getPadding().withVariables(JRightPadded.withElements(this.variables, variables));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitChainedAssignment(this, p);
        }

        @Transient
        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChainedAssignment)) {
                return false;
            }
            ChainedAssignment other = (ChainedAssignment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public ChainedAssignment(UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> variables, Expression assignment, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variables = variables;
            this.assignment = assignment;
            this.type = type;
        }

        @Generated
        private ChainedAssignment(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, List<JRightPadded<Expression>> variables, Expression assignment, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.variables = variables;
            this.assignment = assignment;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getAssignment() {
            return this.assignment;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public String toString() {
            return "Py.ChainedAssignment(padding=" + this.getPadding() + ", id=" + this.getId() + ", prefix=" + this.getPrefix() + ", markers=" + this.getMarkers() + ", variables=" + this.getVariables() + ", assignment=" + this.getAssignment() + ", type=" + this.getType() + ")";
        }

        @Generated
        public ChainedAssignment withId(UUID id) {
            return this.id == id ? this : new ChainedAssignment(this.padding, id, this.prefix, this.markers, this.variables, this.assignment, this.type);
        }

        @Generated
        public ChainedAssignment withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new ChainedAssignment(this.padding, this.id, prefix, this.markers, this.variables, this.assignment, this.type);
        }

        @Generated
        public ChainedAssignment withMarkers(Markers markers) {
            return this.markers == markers ? this : new ChainedAssignment(this.padding, this.id, this.prefix, markers, this.variables, this.assignment, this.type);
        }

        @Generated
        public ChainedAssignment withAssignment(Expression assignment) {
            return this.assignment == assignment ? this : new ChainedAssignment(this.padding, this.id, this.prefix, this.markers, this.variables, assignment, this.type);
        }

        @Generated
        public ChainedAssignment withType(@Nullable JavaType type) {
            return this.type == type ? this : new ChainedAssignment(this.padding, this.id, this.prefix, this.markers, this.variables, this.assignment, type);
        }

        public static class Padding {
            private final ChainedAssignment t;

            public List<JRightPadded<Expression>> getVariables() {
                return this.t.variables;
            }

            public ChainedAssignment withVariables(List<JRightPadded<Expression>> variables) {
                return this.t.variables == variables ? this.t : new ChainedAssignment(this.t.id, this.t.prefix, this.t.markers, variables, this.t.assignment, this.t.type);
            }

            @Generated
            public Padding(ChainedAssignment t) {
                this.t = t;
            }
        }
    }

    public static final class Binary
    implements Py,
    Expression,
    TypedTree {
        private transient @Nullable WeakReference<Padding> padding;
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression left;
        private final JLeftPadded<Type> operator;
        private final @Nullable Space negation;
        private final Expression right;
        private final @Nullable JavaType type;

        public Type getOperator() {
            return (Type)((Object)this.operator.getElement());
        }

        public Binary withOperator(Type operator) {
            return this.getPadding().withOperator((JLeftPadded<Type>)this.operator.withElement((Object)operator));
        }

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitBinary(this, p);
        }

        @Transient
        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        public Padding getPadding() {
            Padding p;
            if (this.padding == null) {
                p = new Padding(this);
                this.padding = new WeakReference<Padding>(p);
            } else {
                p = (Padding)this.padding.get();
                if (p == null || p.t != this) {
                    p = new Padding(this);
                    this.padding = new WeakReference<Padding>(p);
                }
            }
            return p;
        }

        public String toString() {
            return this.withPrefix(Space.EMPTY).printTrimmed((TreeVisitor)new JavaPrinter());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Binary)) {
                return false;
            }
            Binary other = (Binary)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Binary(UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, @Nullable Space negation, Expression right, @Nullable JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.negation = negation;
            this.right = right;
            this.type = type;
        }

        @Generated
        private Binary(@Nullable WeakReference<Padding> padding, UUID id, Space prefix, Markers markers, Expression left, JLeftPadded<Type> operator, @Nullable Space negation, Expression right, @Nullable JavaType type) {
            this.padding = padding;
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.left = left;
            this.operator = operator;
            this.negation = negation;
            this.right = right;
            this.type = type;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getLeft() {
            return this.left;
        }

        @Generated
        public @Nullable Space getNegation() {
            return this.negation;
        }

        @Generated
        public Expression getRight() {
            return this.right;
        }

        @Generated
        public @Nullable JavaType getType() {
            return this.type;
        }

        @Generated
        public void setPadding(@Nullable WeakReference<Padding> padding) {
            this.padding = padding;
        }

        @Generated
        public Binary withId(UUID id) {
            return this.id == id ? this : new Binary(this.padding, id, this.prefix, this.markers, this.left, this.operator, this.negation, this.right, this.type);
        }

        @Generated
        public Binary withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Binary(this.padding, this.id, prefix, this.markers, this.left, this.operator, this.negation, this.right, this.type);
        }

        @Generated
        public Binary withMarkers(Markers markers) {
            return this.markers == markers ? this : new Binary(this.padding, this.id, this.prefix, markers, this.left, this.operator, this.negation, this.right, this.type);
        }

        @Generated
        public Binary withLeft(Expression left) {
            return this.left == left ? this : new Binary(this.padding, this.id, this.prefix, this.markers, left, this.operator, this.negation, this.right, this.type);
        }

        @Generated
        public Binary withNegation(@Nullable Space negation) {
            return this.negation == negation ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, negation, this.right, this.type);
        }

        @Generated
        public Binary withRight(Expression right) {
            return this.right == right ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.negation, right, this.type);
        }

        @Generated
        public Binary withType(@Nullable JavaType type) {
            return this.type == type ? this : new Binary(this.padding, this.id, this.prefix, this.markers, this.left, this.operator, this.negation, this.right, type);
        }

        public static enum Type {
            In,
            Is,
            IsNot,
            NotIn,
            FloorDivision,
            MatrixMultiplication,
            Power,
            StringConcatenation;

        }

        public static class Padding {
            private final Binary t;

            public JLeftPadded<Type> getOperator() {
                return this.t.operator;
            }

            public Binary withOperator(JLeftPadded<Type> operator) {
                return this.t.operator == operator ? this.t : new Binary(this.t.id, this.t.prefix, this.t.markers, this.t.left, operator, this.t.negation, this.t.right, this.t.type);
            }

            @Generated
            public Padding(Binary t) {
                this.t = t;
            }
        }
    }

    public static final class Await
    implements Py,
    Expression {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Expression expression;
        private final JavaType type;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitAwait(this, p);
        }

        public CoordinateBuilder.Expression getCoordinates() {
            return new CoordinateBuilder.Expression((J)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Expression getExpression() {
            return this.expression;
        }

        @Generated
        public JavaType getType() {
            return this.type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Await)) {
                return false;
            }
            Await other = (Await)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Expression this$expression = this.getExpression();
            Expression other$expression = other.getExpression();
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Expression $expression = this.getExpression();
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public Await(UUID id, Space prefix, Markers markers, Expression expression, JavaType type) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.expression = expression;
            this.type = type;
        }

        @Generated
        public Await withId(UUID id) {
            return this.id == id ? this : new Await(id, this.prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public Await withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Await(this.id, prefix, this.markers, this.expression, this.type);
        }

        @Generated
        public Await withMarkers(Markers markers) {
            return this.markers == markers ? this : new Await(this.id, this.prefix, markers, this.expression, this.type);
        }

        @Generated
        public Await withExpression(Expression expression) {
            return this.expression == expression ? this : new Await(this.id, this.prefix, this.markers, expression, this.type);
        }

        @Generated
        public Await withType(JavaType type) {
            return this.type == type ? this : new Await(this.id, this.prefix, this.markers, this.expression, type);
        }
    }

    public static final class Async
    implements Py,
    Statement {
        private final UUID id;
        private final Space prefix;
        private final Markers markers;
        private final Statement statement;

        @Override
        public <P> J acceptPython(PythonVisitor<P> v, P p) {
            return v.visitAsync(this, p);
        }

        public CoordinateBuilder.Statement getCoordinates() {
            return new CoordinateBuilder.Statement((Statement)this);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Override
        @Generated
        public Space getPrefix() {
            return this.prefix;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Statement getStatement() {
            return this.statement;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Async)) {
                return false;
            }
            Async other = (Async)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Space this$prefix = this.getPrefix();
            Space other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Markers this$markers = this.getMarkers();
            Markers other$markers = other.getMarkers();
            if (this$markers == null ? other$markers != null : !this$markers.equals(other$markers)) {
                return false;
            }
            Statement this$statement = this.getStatement();
            Statement other$statement = other.getStatement();
            return !(this$statement == null ? other$statement != null : !this$statement.equals(other$statement));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Space $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Markers $markers = this.getMarkers();
            result = result * 59 + ($markers == null ? 43 : $markers.hashCode());
            Statement $statement = this.getStatement();
            result = result * 59 + ($statement == null ? 43 : $statement.hashCode());
            return result;
        }

        @Generated
        public Async(UUID id, Space prefix, Markers markers, Statement statement) {
            this.id = id;
            this.prefix = prefix;
            this.markers = markers;
            this.statement = statement;
        }

        @Generated
        public Async withId(UUID id) {
            return this.id == id ? this : new Async(id, this.prefix, this.markers, this.statement);
        }

        @Generated
        public Async withPrefix(Space prefix) {
            return this.prefix == prefix ? this : new Async(this.id, prefix, this.markers, this.statement);
        }

        @Generated
        public Async withMarkers(Markers markers) {
            return this.markers == markers ? this : new Async(this.id, this.prefix, markers, this.statement);
        }

        @Generated
        public Async withStatement(Statement statement) {
            return this.statement == statement ? this : new Async(this.id, this.prefix, this.markers, statement);
        }
    }
}

