/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.CanonicalHashingStrategy;
import com.intellij.util.containers.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.containers.CharSequenceHashingStrategy;
import com.intellij.util.containers.IdentityHashingStrategy;
import org.jetbrains.annotations.NotNull;

public interface HashingStrategy<T> {
    public int hashCode(T var1);

    public boolean equals(T var1, T var2);

    @NotNull
    public static <T> HashingStrategy<T> canonical() {
        HashingStrategy<?> hashingStrategy = CanonicalHashingStrategy.INSTANCE;
        if (hashingStrategy == null) {
            HashingStrategy.$$$reportNull$$$0(0);
        }
        return hashingStrategy;
    }

    @NotNull
    public static <T> HashingStrategy<T> identity() {
        HashingStrategy<?> hashingStrategy = IdentityHashingStrategy.INSTANCE;
        if (hashingStrategy == null) {
            HashingStrategy.$$$reportNull$$$0(1);
        }
        return hashingStrategy;
    }

    @NotNull
    public static HashingStrategy<String> caseInsensitive() {
        HashingStrategy hashingStrategy = CaseInsensitiveStringHashingStrategy.INSTANCE;
        if (hashingStrategy == null) {
            HashingStrategy.$$$reportNull$$$0(2);
        }
        return hashingStrategy;
    }

    @NotNull
    public static HashingStrategy<CharSequence> caseInsensitiveCharSequence() {
        CharSequenceHashingStrategy charSequenceHashingStrategy = CharSequenceHashingStrategy.CASE_INSENSITIVE_INSTANCE;
        if (charSequenceHashingStrategy == null) {
            HashingStrategy.$$$reportNull$$$0(3);
        }
        return charSequenceHashingStrategy;
    }

    @NotNull
    public static HashingStrategy<CharSequence> caseSensitiveCharSequence() {
        CharSequenceHashingStrategy charSequenceHashingStrategy = CharSequenceHashingStrategy.CASE_SENSITIVE_INSTANCE;
        if (charSequenceHashingStrategy == null) {
            HashingStrategy.$$$reportNull$$$0(4);
        }
        return charSequenceHashingStrategy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/HashingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "canonical";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "identity";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "caseInsensitive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "caseInsensitiveCharSequence";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "caseSensitiveCharSequence";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

