/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.marker;

import java.util.Collections;
import java.util.UUID;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Marker;

public final class PythonExtraPadding
implements Marker {
    private final UUID id;
    private final Location loc;
    private final Space space;

    @Nullable
    public static Space get(Tree tree, Location loc) {
        for (PythonExtraPadding marker : tree.getMarkers().findAll(PythonExtraPadding.class)) {
            if (marker.loc != loc) continue;
            return marker.space;
        }
        return null;
    }

    public static Space getOrDefault(Tree tree, Location loc) {
        @Nullable Space space = PythonExtraPadding.get(tree, loc);
        if (space == null) {
            return loc.defaultSpace;
        }
        return space;
    }

    public static <T extends Tree> T set(T tree, Location loc, Space space) {
        if (space.equals((Object)loc.defaultSpace)) {
            return tree;
        }
        PythonExtraPadding marker = new PythonExtraPadding(UUID.randomUUID(), loc, space);
        return (T)tree.withMarkers(tree.getMarkers().compute((Marker)marker, (oldMarker, newMarker) -> oldMarker == null ? newMarker : oldMarker.withSpace(space)));
    }

    public PythonExtraPadding(UUID id, Location loc, Space space) {
        this.id = id;
        this.loc = loc;
        this.space = space;
    }

    public UUID getId() {
        return this.id;
    }

    public Location getLoc() {
        return this.loc;
    }

    public Space getSpace() {
        return this.space;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PythonExtraPadding)) {
            return false;
        }
        PythonExtraPadding other = (PythonExtraPadding)o;
        Location this$loc = this.getLoc();
        Location other$loc = other.getLoc();
        return !(this$loc == null ? other$loc != null : !((Object)((Object)this$loc)).equals((Object)other$loc));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Location $loc = this.getLoc();
        result2 = result2 * 59 + ($loc == null ? 43 : ((Object)((Object)$loc)).hashCode());
        return result2;
    }

    public String toString() {
        return "PythonExtraPadding(id=" + this.getId() + ", loc=" + (Object)((Object)this.getLoc()) + ", space=" + this.getSpace() + ")";
    }

    public PythonExtraPadding withId(UUID id) {
        return this.id == id ? this : new PythonExtraPadding(id, this.loc, this.space);
    }

    public PythonExtraPadding withLoc(Location loc) {
        return this.loc == loc ? this : new PythonExtraPadding(this.id, loc, this.space);
    }

    public PythonExtraPadding withSpace(Space space) {
        return this.space == space ? this : new PythonExtraPadding(this.id, this.loc, space);
    }

    public static enum Location {
        AFTER_DECORATOR(Space.build((String)"\n", Collections.emptyList())),
        BEFORE_COMPOUND_BLOCK_COLON(Space.EMPTY),
        IMPORT_PARENS_PREFIX(Space.build((String)" ", Collections.emptyList())),
        IMPORT_PARENS_SUFFIX(Space.build((String)"\n", Collections.emptyList())),
        WITHIN_OPERATOR_NAME(Space.build((String)" ", Collections.emptyList())),
        EMPTY_INITIALIZER(Space.EMPTY);

        final Space defaultSpace;

        private Location(Space defaultSpace) {
            this.defaultSpace = defaultSpace;
        }
    }
}

