/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.net.Socket;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.openrewrite.internal.Throwing;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingMessenger;

public abstract class AbstractRemotingClient {
    private static final boolean debug = false;
    protected final Supplier<Socket> socketSupplier;
    protected final RemotingContext context;
    protected final RemotingMessenger messenger;
    protected final CBORFactory factory = new CBORFactory();
    @Nullable
    protected Socket socket;

    protected <T> T withActiveSocket(Function<Socket, T> command) {
        Socket currentSocket = this.currentSocket();
        if (currentSocket != null) {
            return command.apply(currentSocket);
        }
        try {
            Socket newSocket = this.newSocket();
            return command.apply(newSocket);
        }
        catch (IOException e) {
            Throwing.sneakyThrow((Throwable)e);
            throw new IllegalStateException("unreachable");
        }
    }

    @Nullable
    protected Socket currentSocket() {
        return this.socket != null && !this.socket.isClosed() ? this.socket : null;
    }

    protected Socket newSocket() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
        this.socket = this.socketSupplier.get();
        return this.socket;
    }

    @Generated
    protected AbstractRemotingClient(Supplier<Socket> socketSupplier, RemotingContext context, RemotingMessenger messenger) {
        this.socketSupplier = socketSupplier;
        this.context = context;
        this.messenger = messenger;
    }

    @Generated
    public RemotingContext getContext() {
        return this.context;
    }
}

