/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.remote.DiffEvent;
import org.openrewrite.remote.EventType;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.TreeSender;

public class JsonSender
implements TreeSender {
    private final AtomicInteger sendCounter = new AtomicInteger(0);
    private final JsonGenerator generator;
    private final DefaultSerializerProvider serializerProvider;
    private final ClassValue<JsonSerializer<Object>> serializerCache = new ClassValue<JsonSerializer<Object>>(){

        @Override
        protected JsonSerializer<Object> computeValue(Class<?> type) {
            if (type == JavaType.Primitive.class) {
                return new StdSerializer<JavaType.Primitive>(JavaType.Primitive.class){

                    public void serialize(JavaType.Primitive value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                        gen.writeNull();
                    }
                };
            }
            return JsonSender.this.serializerProvider.findTypedValueSerializer(type, false, null);
        }
    };
    private final RemotingContext context;
    private final boolean debug;

    public JsonSender(OutputStream out, RemotingContext context) {
        ObjectMapper mapper = context.objectMapper();
        try {
            this.generator = mapper.createGenerator(out);
            this.serializerProvider = (DefaultSerializerProvider)mapper.getSerializerProviderInstance();
            this.context = context;
            this.debug = context.debug();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JsonSender(JsonGenerator generator, RemotingContext context) {
        ObjectMapper mapper = context.objectMapper();
        this.generator = generator;
        this.serializerProvider = (DefaultSerializerProvider)mapper.getSerializerProviderInstance();
        this.context = context;
        this.debug = context.debug();
    }

    public RemotingContext context() {
        return this.context;
    }

    @Override
    public void sendNode(DiffEvent event, Consumer<TreeSender> visitor) {
        try {
            switch (event.getEventType()) {
                case Add: 
                case Update: {
                    if (event.getConcreteType() != null) {
                        this.generator.writeStartArray(2);
                        this.generator.writeNumber(event.getEventType().ordinal());
                        this.generator.writeString(event.getConcreteType().getName());
                        this.generator.writeEndArray();
                        break;
                    }
                }
                case Delete: 
                case NoChange: {
                    this.generator.writeArray(new int[]{event.getEventType().ordinal()}, 0, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected event type: " + (Object)((Object)event.getEventType()));
                }
            }
            if (this.debug) {
                System.out.println("SEND " + this.sendCounter.getAndIncrement() + ": " + event);
            }
            if (event.getEventType() != EventType.NoChange && event.getEventType() != EventType.Delete) {
                visitor.accept(null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void sendValue(DiffEvent event) {
        try {
            switch (event.getEventType()) {
                case Add: 
                case Update: {
                    this.generator.writeStartArray(event.getConcreteType() != null ? 3 : 2);
                    this.generator.writeNumber(event.getEventType().ordinal());
                    if (event.getConcreteType() != null) {
                        this.generator.writeString(event.getConcreteType().getName());
                    }
                    if (event.getMsg() != null) {
                        JsonSerializer<Object> valueSerializer = this.serializerCache.get(event.getMsg().getClass());
                        valueSerializer.serialize(event.getMsg(), this.generator, (SerializerProvider)this.serializerProvider);
                    } else {
                        this.generator.writeNull();
                    }
                    this.generator.writeEndArray();
                    break;
                }
                case Delete: 
                case NoChange: 
                case StartList: 
                case EndList: {
                    this.generator.writeArray(new int[]{event.getEventType().ordinal()}, 0, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected event type: " + (Object)((Object)event.getEventType()));
                }
            }
            if (this.debug) {
                System.out.println("SEND " + this.sendCounter.getAndIncrement() + ": " + event);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.generator.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

