/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.remote.ReceiverContext;
import org.openrewrite.remote.RemotingContext;
import org.openrewrite.remote.RemotingExecutionContextView;
import org.openrewrite.remote.RemotingMessenger;
import org.openrewrite.remote.RemotingServerEngine;

public final class RemotingRecipe
extends Recipe {
    static final Field DESCRIPTOR_FIELD;
    private final RecipeDescriptor recipeDescriptor;
    private final RemotingServerEngine remotingServerEngine;

    public RemotingRecipe(RecipeDescriptor recipeDescriptor, RemotingServerEngine remotingServerEngine) {
        this.recipeDescriptor = recipeDescriptor;
        this.remotingServerEngine = remotingServerEngine;
        try {
            DESCRIPTOR_FIELD.set((Object)this, recipeDescriptor);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.recipeDescriptor.getName();
    }

    public String getDisplayName() {
        return this.recipeDescriptor.getDisplayName();
    }

    public String getDescription() {
        return this.recipeDescriptor.getDescription();
    }

    public Validated<Object> validate(ExecutionContext ctx) {
        try {
            this.remotingServerEngine.ensureStarted();
        }
        catch (Exception e) {
            return Validated.invalid((String)"remoting-server-engine", null, (String)e.getMessage(), (Throwable)e);
        }
        return super.validate(ctx);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Nullable
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    SourceFile sourceFile = (SourceFile)tree;
                    return RemotingRecipe.this.runRecipe(RemotingRecipe.this.recipeDescriptor, sourceFile, ctx);
                }
                return tree;
            }
        };
    }

    private <T extends SourceFile> T runRecipe(RecipeDescriptor recipe, T sourceFile, ExecutionContext ctx) {
        SourceFile remoteState;
        RemotingMessenger messenger;
        Socket activeSocket;
        RemotingExecutionContextView view = RemotingExecutionContextView.view(ctx);
        RemotingContext remotingContext = view.getRemotingContext();
        if (remotingContext == null) {
            remotingContext = new RemotingContext(((Object)((Object)this)).getClass().getClassLoader(), false);
            view.setRemotingContext(remotingContext);
        }
        if ((activeSocket = (Socket)view.getMessage(this.remotingServerEngine.getClass().getName() + Socket.class.getName())) == null) {
            try {
                activeSocket = this.remotingServerEngine.getNewSocketConnection();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            view.putMessage(this.remotingServerEngine.getClass().getName() + Socket.class.getName(), activeSocket);
        }
        if ((messenger = (RemotingMessenger)view.getMessage(RemotingMessenger.class.getName())) == null) {
            messenger = new RemotingMessenger((CBORFactory)remotingContext.objectMapper().getFactory(), Collections.emptyMap(), m -> new InMemoryExecutionContext());
            ctx.putMessage(RemotingMessenger.class.getName(), (Object)messenger);
        }
        if ((remoteState = (SourceFile)view.getMessage("remote-state")) != null && !remoteState.equals(sourceFile)) {
            remoteState = null;
            view.putMessage("remote-state", null);
        }
        remoteState = this.runRecipe0(recipe, sourceFile, remoteState, activeSocket, messenger, view);
        view.putMessage("remote-state", remoteState);
        return (T)remoteState;
    }

    private <T extends SourceFile> T runRecipe0(RecipeDescriptor recipe, T sourceFile, @Nullable T remoteState, Socket socket, RemotingMessenger messenger, RemotingExecutionContextView view) {
        RemotingContext context = Objects.requireNonNull(view.getRemotingContext());
        return (T)Objects.requireNonNull(messenger.sendRequest(generator -> {
            generator.writeString("run-recipe-load-and-visitor");
            generator.writeString(recipe.getName());
            generator.writeString(recipe.getSource().toString());
            generator.writeStartObject();
            List options = recipe.getOptions();
            for (OptionDescriptor option : options) {
                generator.writeFieldName(option.getName());
                generator.writeObject(option.getValue());
            }
            generator.writeEndObject();
            context.newSenderContext((JsonGenerator)generator).sendTree(sourceFile, remoteState);
        }, parser -> new ReceiverContext(context.newReceiver((JsonParser)parser), context).receiveTree(sourceFile), socket));
    }

    @Generated
    public RecipeDescriptor getRecipeDescriptor() {
        return this.recipeDescriptor;
    }

    @Generated
    public RemotingServerEngine getRemotingServerEngine() {
        return this.remotingServerEngine;
    }

    @Generated
    public String toString() {
        return "RemotingRecipe(recipeDescriptor=" + this.getRecipeDescriptor() + ", remotingServerEngine=" + this.getRemotingServerEngine() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemotingRecipe)) {
            return false;
        }
        RemotingRecipe other = (RemotingRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RecipeDescriptor this$recipeDescriptor = this.getRecipeDescriptor();
        RecipeDescriptor other$recipeDescriptor = other.getRecipeDescriptor();
        if (this$recipeDescriptor == null ? other$recipeDescriptor != null : !this$recipeDescriptor.equals(other$recipeDescriptor)) {
            return false;
        }
        RemotingServerEngine this$remotingServerEngine = this.getRemotingServerEngine();
        RemotingServerEngine other$remotingServerEngine = other.getRemotingServerEngine();
        return !(this$remotingServerEngine == null ? other$remotingServerEngine != null : !this$remotingServerEngine.equals(other$remotingServerEngine));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemotingRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RecipeDescriptor $recipeDescriptor = this.getRecipeDescriptor();
        result = result * 59 + ($recipeDescriptor == null ? 43 : $recipeDescriptor.hashCode());
        RemotingServerEngine $remotingServerEngine = this.getRemotingServerEngine();
        result = result * 59 + ($remotingServerEngine == null ? 43 : $remotingServerEngine.hashCode());
        return result;
    }

    static {
        try {
            DESCRIPTOR_FIELD = Recipe.class.getDeclaredField("descriptor");
            DESCRIPTOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

