/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.remote.csharp;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.csharp.CSharpVisitor;
import org.openrewrite.csharp.tree.Cs;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;
import org.openrewrite.remote.csharp.Extensions;

public final class CSharpSender
implements Sender<Cs> {
    @Override
    public void send(Cs after, @Nullable Cs before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor<?, SenderContext>)visitor, (Tree)before));
        ctx.flush();
    }

    private static <T extends J> void sendContainer(JContainer<T> container, SenderContext ctx) {
        Extensions.sendContainer(container, ctx);
    }

    private static <T> void sendLeftPadded(JLeftPadded<T> leftPadded, SenderContext ctx) {
        Extensions.sendLeftPadded(leftPadded, ctx);
    }

    private static <T> void sendRightPadded(JRightPadded<T> rightPadded, SenderContext ctx) {
        Extensions.sendRightPadded(rightPadded, ctx);
    }

    private static void sendSpace(Space space, SenderContext ctx) {
        Extensions.sendSpace(space, ctx);
    }

    private static void sendComment(Comment comment, SenderContext ctx) {
        Extensions.sendComment(comment, ctx);
    }

    @Generated
    public CSharpSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof CSharpSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "CSharpSender()";
    }

    private static class Visitor
    extends CSharpVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable J visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode(tree, Function.identity(), ctx::sendTree);
            this.setCursor(this.getCursor().getParent());
            return (J)tree;
        }

        public Cs.CompilationUnit visitCompilationUnit(Cs.CompilationUnit compilationUnit, SenderContext ctx) {
            ctx.sendValue(compilationUnit, Cs.CompilationUnit::getId);
            ctx.sendNode(compilationUnit, Cs.CompilationUnit::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(compilationUnit, Cs.CompilationUnit::getMarkers, ctx::sendMarkers);
            ctx.sendValue(compilationUnit, Cs.CompilationUnit::getSourcePath);
            ctx.sendTypedValue(compilationUnit, Cs.CompilationUnit::getFileAttributes);
            ctx.sendValue(compilationUnit, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue(compilationUnit, Cs.CompilationUnit::isCharsetBomMarked);
            ctx.sendTypedValue(compilationUnit, Cs.CompilationUnit::getChecksum);
            ctx.sendNodes(compilationUnit, e -> e.getPadding().getExterns(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.ExternAlias)e.getElement()).getId());
            ctx.sendNodes(compilationUnit, e -> e.getPadding().getUsings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.UsingDirective)e.getElement()).getId());
            ctx.sendNodes(compilationUnit, Cs.CompilationUnit::getAttributeLists, ctx::sendTree, Tree::getId);
            ctx.sendNodes(compilationUnit, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode(compilationUnit, Cs.CompilationUnit::getEof, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return compilationUnit;
        }

        public Cs.AnnotatedStatement visitAnnotatedStatement(Cs.AnnotatedStatement annotatedStatement, SenderContext ctx) {
            ctx.sendValue(annotatedStatement, Cs.AnnotatedStatement::getId);
            ctx.sendNode(annotatedStatement, Cs.AnnotatedStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(annotatedStatement, Cs.AnnotatedStatement::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(annotatedStatement, Cs.AnnotatedStatement::getAttributeLists, ctx::sendTree, Tree::getId);
            ctx.sendNode(annotatedStatement, Cs.AnnotatedStatement::getStatement, ctx::sendTree);
            return annotatedStatement;
        }

        public Cs.ArrayRankSpecifier visitArrayRankSpecifier(Cs.ArrayRankSpecifier arrayRankSpecifier, SenderContext ctx) {
            ctx.sendValue(arrayRankSpecifier, Cs.ArrayRankSpecifier::getId);
            ctx.sendNode(arrayRankSpecifier, Cs.ArrayRankSpecifier::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(arrayRankSpecifier, Cs.ArrayRankSpecifier::getMarkers, ctx::sendMarkers);
            ctx.sendNode(arrayRankSpecifier, e -> e.getPadding().getSizes(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return arrayRankSpecifier;
        }

        public Cs.AssignmentOperation visitAssignmentOperation(Cs.AssignmentOperation assignmentOperation, SenderContext ctx) {
            ctx.sendValue(assignmentOperation, Cs.AssignmentOperation::getId);
            ctx.sendNode(assignmentOperation, Cs.AssignmentOperation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(assignmentOperation, Cs.AssignmentOperation::getMarkers, ctx::sendMarkers);
            ctx.sendNode(assignmentOperation, Cs.AssignmentOperation::getVariable, ctx::sendTree);
            ctx.sendNode(assignmentOperation, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(assignmentOperation, Cs.AssignmentOperation::getAssignment, ctx::sendTree);
            ctx.sendTypedValue(assignmentOperation, Cs.AssignmentOperation::getType);
            return assignmentOperation;
        }

        public Cs.AttributeList visitAttributeList(Cs.AttributeList attributeList, SenderContext ctx) {
            ctx.sendValue(attributeList, Cs.AttributeList::getId);
            ctx.sendNode(attributeList, Cs.AttributeList::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(attributeList, Cs.AttributeList::getMarkers, ctx::sendMarkers);
            ctx.sendNode(attributeList, e -> e.getPadding().getTarget(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes(attributeList, e -> e.getPadding().getAttributes(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.Annotation)e.getElement()).getId());
            return attributeList;
        }

        public Cs.AwaitExpression visitAwaitExpression(Cs.AwaitExpression awaitExpression, SenderContext ctx) {
            ctx.sendValue(awaitExpression, Cs.AwaitExpression::getId);
            ctx.sendNode(awaitExpression, Cs.AwaitExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(awaitExpression, Cs.AwaitExpression::getMarkers, ctx::sendMarkers);
            ctx.sendNode(awaitExpression, Cs.AwaitExpression::getExpression, ctx::sendTree);
            ctx.sendTypedValue(awaitExpression, Cs.AwaitExpression::getType);
            return awaitExpression;
        }

        public Cs.Binary visitBinary(Cs.Binary binary, SenderContext ctx) {
            ctx.sendValue(binary, Cs.Binary::getId);
            ctx.sendNode(binary, Cs.Binary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(binary, Cs.Binary::getMarkers, ctx::sendMarkers);
            ctx.sendNode(binary, Cs.Binary::getLeft, ctx::sendTree);
            ctx.sendNode(binary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(binary, Cs.Binary::getRight, ctx::sendTree);
            ctx.sendTypedValue(binary, Cs.Binary::getType);
            return binary;
        }

        public Cs.BlockScopeNamespaceDeclaration visitBlockScopeNamespaceDeclaration(Cs.BlockScopeNamespaceDeclaration blockScopeNamespaceDeclaration, SenderContext ctx) {
            ctx.sendValue(blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getId);
            ctx.sendNode(blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getMarkers, ctx::sendMarkers);
            ctx.sendNode(blockScopeNamespaceDeclaration, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes(blockScopeNamespaceDeclaration, e -> e.getPadding().getExterns(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.ExternAlias)e.getElement()).getId());
            ctx.sendNodes(blockScopeNamespaceDeclaration, e -> e.getPadding().getUsings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.UsingDirective)e.getElement()).getId());
            ctx.sendNodes(blockScopeNamespaceDeclaration, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode(blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getEnd, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return blockScopeNamespaceDeclaration;
        }

        public Cs.CollectionExpression visitCollectionExpression(Cs.CollectionExpression collectionExpression, SenderContext ctx) {
            ctx.sendValue(collectionExpression, Cs.CollectionExpression::getId);
            ctx.sendNode(collectionExpression, Cs.CollectionExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(collectionExpression, Cs.CollectionExpression::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(collectionExpression, e -> e.getPadding().getElements(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            ctx.sendTypedValue(collectionExpression, Cs.CollectionExpression::getType);
            return collectionExpression;
        }

        public Cs.ExpressionStatement visitExpressionStatement(Cs.ExpressionStatement expressionStatement, SenderContext ctx) {
            ctx.sendValue(expressionStatement, Cs.ExpressionStatement::getId);
            ctx.sendNode(expressionStatement, Cs.ExpressionStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(expressionStatement, Cs.ExpressionStatement::getMarkers, ctx::sendMarkers);
            ctx.sendNode(expressionStatement, Cs.ExpressionStatement::getExpression, ctx::sendTree);
            return expressionStatement;
        }

        public Cs.ExternAlias visitExternAlias(Cs.ExternAlias externAlias, SenderContext ctx) {
            ctx.sendValue(externAlias, Cs.ExternAlias::getId);
            ctx.sendNode(externAlias, Cs.ExternAlias::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(externAlias, Cs.ExternAlias::getMarkers, ctx::sendMarkers);
            ctx.sendNode(externAlias, e -> e.getPadding().getIdentifier(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return externAlias;
        }

        public Cs.FileScopeNamespaceDeclaration visitFileScopeNamespaceDeclaration(Cs.FileScopeNamespaceDeclaration fileScopeNamespaceDeclaration, SenderContext ctx) {
            ctx.sendValue(fileScopeNamespaceDeclaration, Cs.FileScopeNamespaceDeclaration::getId);
            ctx.sendNode(fileScopeNamespaceDeclaration, Cs.FileScopeNamespaceDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(fileScopeNamespaceDeclaration, Cs.FileScopeNamespaceDeclaration::getMarkers, ctx::sendMarkers);
            ctx.sendNode(fileScopeNamespaceDeclaration, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes(fileScopeNamespaceDeclaration, e -> e.getPadding().getExterns(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.ExternAlias)e.getElement()).getId());
            ctx.sendNodes(fileScopeNamespaceDeclaration, e -> e.getPadding().getUsings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.UsingDirective)e.getElement()).getId());
            ctx.sendNodes(fileScopeNamespaceDeclaration, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            return fileScopeNamespaceDeclaration;
        }

        public Cs.InterpolatedString visitInterpolatedString(Cs.InterpolatedString interpolatedString, SenderContext ctx) {
            ctx.sendValue(interpolatedString, Cs.InterpolatedString::getId);
            ctx.sendNode(interpolatedString, Cs.InterpolatedString::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(interpolatedString, Cs.InterpolatedString::getMarkers, ctx::sendMarkers);
            ctx.sendValue(interpolatedString, Cs.InterpolatedString::getStart);
            ctx.sendNodes(interpolatedString, e -> e.getPadding().getParts(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            ctx.sendValue(interpolatedString, Cs.InterpolatedString::getEnd);
            return interpolatedString;
        }

        public Cs.Interpolation visitInterpolation(Cs.Interpolation interpolation, SenderContext ctx) {
            ctx.sendValue(interpolation, Cs.Interpolation::getId);
            ctx.sendNode(interpolation, Cs.Interpolation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(interpolation, Cs.Interpolation::getMarkers, ctx::sendMarkers);
            ctx.sendNode(interpolation, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(interpolation, e -> e.getPadding().getAlignment(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(interpolation, e -> e.getPadding().getFormat(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return interpolation;
        }

        public Cs.NullSafeExpression visitNullSafeExpression(Cs.NullSafeExpression nullSafeExpression, SenderContext ctx) {
            ctx.sendValue(nullSafeExpression, Cs.NullSafeExpression::getId);
            ctx.sendNode(nullSafeExpression, Cs.NullSafeExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(nullSafeExpression, Cs.NullSafeExpression::getMarkers, ctx::sendMarkers);
            ctx.sendNode(nullSafeExpression, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return nullSafeExpression;
        }

        public Cs.StatementExpression visitStatementExpression(Cs.StatementExpression statementExpression, SenderContext ctx) {
            ctx.sendValue(statementExpression, Cs.StatementExpression::getId);
            ctx.sendNode(statementExpression, Cs.StatementExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(statementExpression, Cs.StatementExpression::getMarkers, ctx::sendMarkers);
            ctx.sendNode(statementExpression, Cs.StatementExpression::getStatement, ctx::sendTree);
            return statementExpression;
        }

        public Cs.UsingDirective visitUsingDirective(Cs.UsingDirective usingDirective, SenderContext ctx) {
            ctx.sendValue(usingDirective, Cs.UsingDirective::getId);
            ctx.sendNode(usingDirective, Cs.UsingDirective::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(usingDirective, Cs.UsingDirective::getMarkers, ctx::sendMarkers);
            ctx.sendNode(usingDirective, e -> e.getPadding().getGlobal(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(usingDirective, e -> e.getPadding().getStatic(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(usingDirective, e -> e.getPadding().getUnsafe(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(usingDirective, e -> e.getPadding().getAlias(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(usingDirective, Cs.UsingDirective::getNamespaceOrType, ctx::sendTree);
            return usingDirective;
        }

        public Cs.PropertyDeclaration visitPropertyDeclaration(Cs.PropertyDeclaration propertyDeclaration, SenderContext ctx) {
            ctx.sendValue(propertyDeclaration, Cs.PropertyDeclaration::getId);
            ctx.sendNode(propertyDeclaration, Cs.PropertyDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(propertyDeclaration, Cs.PropertyDeclaration::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(propertyDeclaration, Cs.PropertyDeclaration::getAttributeLists, ctx::sendTree, Tree::getId);
            ctx.sendNodes(propertyDeclaration, Cs.PropertyDeclaration::getModifiers, this::sendModifier, Tree::getId);
            ctx.sendNode(propertyDeclaration, Cs.PropertyDeclaration::getTypeExpression, ctx::sendTree);
            ctx.sendNode(propertyDeclaration, e -> e.getPadding().getInterfaceSpecifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(propertyDeclaration, Cs.PropertyDeclaration::getName, ctx::sendTree);
            ctx.sendNode(propertyDeclaration, Cs.PropertyDeclaration::getAccessors, ctx::sendTree);
            ctx.sendNode(propertyDeclaration, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return propertyDeclaration;
        }

        public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, SenderContext ctx) {
            ctx.sendValue(annotatedType, J.AnnotatedType::getId);
            ctx.sendNode(annotatedType, J.AnnotatedType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(annotatedType, J.AnnotatedType::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(annotatedType, J.AnnotatedType::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNode(annotatedType, J.AnnotatedType::getTypeExpression, ctx::sendTree);
            return annotatedType;
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, SenderContext ctx) {
            ctx.sendValue(annotation, J.Annotation::getId);
            ctx.sendNode(annotation, J.Annotation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(annotation, J.Annotation::getMarkers, ctx::sendMarkers);
            ctx.sendNode(annotation, J.Annotation::getAnnotationType, ctx::sendTree);
            ctx.sendNode(annotation, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return annotation;
        }

        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, SenderContext ctx) {
            ctx.sendValue(arrayAccess, J.ArrayAccess::getId);
            ctx.sendNode(arrayAccess, J.ArrayAccess::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(arrayAccess, J.ArrayAccess::getMarkers, ctx::sendMarkers);
            ctx.sendNode(arrayAccess, J.ArrayAccess::getIndexed, ctx::sendTree);
            ctx.sendNode(arrayAccess, J.ArrayAccess::getDimension, ctx::sendTree);
            ctx.sendTypedValue(arrayAccess, J.ArrayAccess::getType);
            return arrayAccess;
        }

        public J.ArrayType visitArrayType(J.ArrayType arrayType, SenderContext ctx) {
            ctx.sendValue(arrayType, J.ArrayType::getId);
            ctx.sendNode(arrayType, J.ArrayType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(arrayType, J.ArrayType::getMarkers, ctx::sendMarkers);
            ctx.sendNode(arrayType, J.ArrayType::getElementType, ctx::sendTree);
            ctx.sendNodes(arrayType, J.ArrayType::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNode(arrayType, J.ArrayType::getDimension, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(arrayType, J.ArrayType::getType);
            return arrayType;
        }

        public J.Assert visitAssert(J.Assert assert_, SenderContext ctx) {
            ctx.sendValue(assert_, J.Assert::getId);
            ctx.sendNode(assert_, J.Assert::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(assert_, J.Assert::getMarkers, ctx::sendMarkers);
            ctx.sendNode(assert_, J.Assert::getCondition, ctx::sendTree);
            ctx.sendNode(assert_, J.Assert::getDetail, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return assert_;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, SenderContext ctx) {
            ctx.sendValue(assignment, J.Assignment::getId);
            ctx.sendNode(assignment, J.Assignment::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(assignment, J.Assignment::getMarkers, ctx::sendMarkers);
            ctx.sendNode(assignment, J.Assignment::getVariable, ctx::sendTree);
            ctx.sendNode(assignment, e -> e.getPadding().getAssignment(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(assignment, J.Assignment::getType);
            return assignment;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignmentOperation, SenderContext ctx) {
            ctx.sendValue(assignmentOperation, J.AssignmentOperation::getId);
            ctx.sendNode(assignmentOperation, J.AssignmentOperation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(assignmentOperation, J.AssignmentOperation::getMarkers, ctx::sendMarkers);
            ctx.sendNode(assignmentOperation, J.AssignmentOperation::getVariable, ctx::sendTree);
            ctx.sendNode(assignmentOperation, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(assignmentOperation, J.AssignmentOperation::getAssignment, ctx::sendTree);
            ctx.sendTypedValue(assignmentOperation, J.AssignmentOperation::getType);
            return assignmentOperation;
        }

        public J.Binary visitBinary(J.Binary binary, SenderContext ctx) {
            ctx.sendValue(binary, J.Binary::getId);
            ctx.sendNode(binary, J.Binary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(binary, J.Binary::getMarkers, ctx::sendMarkers);
            ctx.sendNode(binary, J.Binary::getLeft, ctx::sendTree);
            ctx.sendNode(binary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(binary, J.Binary::getRight, ctx::sendTree);
            ctx.sendTypedValue(binary, J.Binary::getType);
            return binary;
        }

        public J.Block visitBlock(J.Block block, SenderContext ctx) {
            ctx.sendValue(block, J.Block::getId);
            ctx.sendNode(block, J.Block::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(block, J.Block::getMarkers, ctx::sendMarkers);
            ctx.sendNode(block, e -> e.getPadding().getStatic(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes(block, e -> e.getPadding().getStatements(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode(block, J.Block::getEnd, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return block;
        }

        public J.Break visitBreak(J.Break break_, SenderContext ctx) {
            ctx.sendValue(break_, J.Break::getId);
            ctx.sendNode(break_, J.Break::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(break_, J.Break::getMarkers, ctx::sendMarkers);
            ctx.sendNode(break_, J.Break::getLabel, ctx::sendTree);
            return break_;
        }

        public J.Case visitCase(J.Case case_, SenderContext ctx) {
            ctx.sendValue(case_, J.Case::getId);
            ctx.sendNode(case_, J.Case::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(case_, J.Case::getMarkers, ctx::sendMarkers);
            ctx.sendValue(case_, J.Case::getType);
            ctx.sendNode(case_, e -> e.getPadding().getExpressions(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(case_, e -> e.getPadding().getStatements(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(case_, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return case_;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, SenderContext ctx) {
            ctx.sendValue(classDeclaration, J.ClassDeclaration::getId);
            ctx.sendNode(classDeclaration, J.ClassDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(classDeclaration, J.ClassDeclaration::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(classDeclaration, J.ClassDeclaration::getLeadingAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNodes(classDeclaration, J.ClassDeclaration::getModifiers, this::sendModifier, Tree::getId);
            ctx.sendNode(classDeclaration, e -> e.getPadding().getKind(), this::sendClassDeclarationKind);
            ctx.sendNode(classDeclaration, J.ClassDeclaration::getName, ctx::sendTree);
            ctx.sendNode(classDeclaration, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(classDeclaration, e -> e.getPadding().getPrimaryConstructor(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(classDeclaration, e -> e.getPadding().getExtends(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(classDeclaration, e -> e.getPadding().getImplements(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(classDeclaration, e -> e.getPadding().getPermits(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(classDeclaration, J.ClassDeclaration::getBody, ctx::sendTree);
            ctx.sendTypedValue(classDeclaration, J.ClassDeclaration::getType);
            return classDeclaration;
        }

        private void sendClassDeclarationKind(J.ClassDeclaration.Kind kind, SenderContext ctx) {
            ctx.sendValue(kind, J.ClassDeclaration.Kind::getId);
            ctx.sendNode(kind, J.ClassDeclaration.Kind::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(kind, J.ClassDeclaration.Kind::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(kind, J.ClassDeclaration.Kind::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendValue(kind, J.ClassDeclaration.Kind::getType);
        }

        public J.Continue visitContinue(J.Continue continue_, SenderContext ctx) {
            ctx.sendValue(continue_, J.Continue::getId);
            ctx.sendNode(continue_, J.Continue::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(continue_, J.Continue::getMarkers, ctx::sendMarkers);
            ctx.sendNode(continue_, J.Continue::getLabel, ctx::sendTree);
            return continue_;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SenderContext ctx) {
            ctx.sendValue(doWhileLoop, J.DoWhileLoop::getId);
            ctx.sendNode(doWhileLoop, J.DoWhileLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(doWhileLoop, J.DoWhileLoop::getMarkers, ctx::sendMarkers);
            ctx.sendNode(doWhileLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(doWhileLoop, e -> e.getPadding().getWhileCondition(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return doWhileLoop;
        }

        public J.Empty visitEmpty(J.Empty empty, SenderContext ctx) {
            ctx.sendValue(empty, J.Empty::getId);
            ctx.sendNode(empty, J.Empty::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(empty, J.Empty::getMarkers, ctx::sendMarkers);
            return empty;
        }

        public J.EnumValue visitEnumValue(J.EnumValue enumValue, SenderContext ctx) {
            ctx.sendValue(enumValue, J.EnumValue::getId);
            ctx.sendNode(enumValue, J.EnumValue::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(enumValue, J.EnumValue::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(enumValue, J.EnumValue::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNode(enumValue, J.EnumValue::getName, ctx::sendTree);
            ctx.sendNode(enumValue, J.EnumValue::getInitializer, ctx::sendTree);
            return enumValue;
        }

        public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enumValueSet, SenderContext ctx) {
            ctx.sendValue(enumValueSet, J.EnumValueSet::getId);
            ctx.sendNode(enumValueSet, J.EnumValueSet::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(enumValueSet, J.EnumValueSet::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(enumValueSet, e -> e.getPadding().getEnums(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.EnumValue)e.getElement()).getId());
            ctx.sendValue(enumValueSet, J.EnumValueSet::isTerminatedWithSemicolon);
            return enumValueSet;
        }

        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, SenderContext ctx) {
            ctx.sendValue(fieldAccess, J.FieldAccess::getId);
            ctx.sendNode(fieldAccess, J.FieldAccess::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(fieldAccess, J.FieldAccess::getMarkers, ctx::sendMarkers);
            ctx.sendNode(fieldAccess, J.FieldAccess::getTarget, ctx::sendTree);
            ctx.sendNode(fieldAccess, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(fieldAccess, J.FieldAccess::getType);
            return fieldAccess;
        }

        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, SenderContext ctx) {
            ctx.sendValue(forEachLoop, J.ForEachLoop::getId);
            ctx.sendNode(forEachLoop, J.ForEachLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(forEachLoop, J.ForEachLoop::getMarkers, ctx::sendMarkers);
            ctx.sendNode(forEachLoop, J.ForEachLoop::getControl, ctx::sendTree);
            ctx.sendNode(forEachLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return forEachLoop;
        }

        public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, SenderContext ctx) {
            ctx.sendValue(control, J.ForEachLoop.Control::getId);
            ctx.sendNode(control, J.ForEachLoop.Control::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(control, J.ForEachLoop.Control::getMarkers, ctx::sendMarkers);
            ctx.sendNode(control, e -> e.getPadding().getVariable(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(control, e -> e.getPadding().getIterable(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return control;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, SenderContext ctx) {
            ctx.sendValue(forLoop, J.ForLoop::getId);
            ctx.sendNode(forLoop, J.ForLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(forLoop, J.ForLoop::getMarkers, ctx::sendMarkers);
            ctx.sendNode(forLoop, J.ForLoop::getControl, ctx::sendTree);
            ctx.sendNode(forLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return forLoop;
        }

        public J.ForLoop.Control visitForControl(J.ForLoop.Control control, SenderContext ctx) {
            ctx.sendValue(control, J.ForLoop.Control::getId);
            ctx.sendNode(control, J.ForLoop.Control::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(control, J.ForLoop.Control::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(control, e -> e.getPadding().getInit(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode(control, e -> e.getPadding().getCondition(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes(control, e -> e.getPadding().getUpdate(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            return control;
        }

        public J.ParenthesizedTypeTree visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedTypeTree, SenderContext ctx) {
            ctx.sendValue(parenthesizedTypeTree, J.ParenthesizedTypeTree::getId);
            ctx.sendNode(parenthesizedTypeTree, J.ParenthesizedTypeTree::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(parenthesizedTypeTree, J.ParenthesizedTypeTree::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(parenthesizedTypeTree, J.ParenthesizedTypeTree::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNode(parenthesizedTypeTree, J.ParenthesizedTypeTree::getParenthesizedType, ctx::sendTree);
            return parenthesizedTypeTree;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, SenderContext ctx) {
            ctx.sendValue(identifier, J.Identifier::getId);
            ctx.sendNode(identifier, J.Identifier::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(identifier, J.Identifier::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(identifier, J.Identifier::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendValue(identifier, J.Identifier::getSimpleName);
            ctx.sendTypedValue(identifier, J.Identifier::getType);
            ctx.sendTypedValue(identifier, J.Identifier::getFieldType);
            return identifier;
        }

        public J.If visitIf(J.If if_, SenderContext ctx) {
            ctx.sendValue(if_, J.If::getId);
            ctx.sendNode(if_, J.If::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(if_, J.If::getMarkers, ctx::sendMarkers);
            ctx.sendNode(if_, J.If::getIfCondition, ctx::sendTree);
            ctx.sendNode(if_, e -> e.getPadding().getThenPart(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(if_, J.If::getElsePart, ctx::sendTree);
            return if_;
        }

        public J.If.Else visitElse(J.If.Else else_, SenderContext ctx) {
            ctx.sendValue(else_, J.If.Else::getId);
            ctx.sendNode(else_, J.If.Else::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(else_, J.If.Else::getMarkers, ctx::sendMarkers);
            ctx.sendNode(else_, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return else_;
        }

        public J.Import visitImport(J.Import import_, SenderContext ctx) {
            ctx.sendValue(import_, J.Import::getId);
            ctx.sendNode(import_, J.Import::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(import_, J.Import::getMarkers, ctx::sendMarkers);
            ctx.sendNode(import_, e -> e.getPadding().getStatic(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(import_, J.Import::getQualid, ctx::sendTree);
            ctx.sendNode(import_, e -> e.getPadding().getAlias(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return import_;
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, SenderContext ctx) {
            ctx.sendValue(instanceOf, J.InstanceOf::getId);
            ctx.sendNode(instanceOf, J.InstanceOf::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(instanceOf, J.InstanceOf::getMarkers, ctx::sendMarkers);
            ctx.sendNode(instanceOf, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(instanceOf, J.InstanceOf::getClazz, ctx::sendTree);
            ctx.sendNode(instanceOf, J.InstanceOf::getPattern, ctx::sendTree);
            ctx.sendTypedValue(instanceOf, J.InstanceOf::getType);
            return instanceOf;
        }

        public J.IntersectionType visitIntersectionType(J.IntersectionType intersectionType, SenderContext ctx) {
            ctx.sendValue(intersectionType, J.IntersectionType::getId);
            ctx.sendNode(intersectionType, J.IntersectionType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(intersectionType, J.IntersectionType::getMarkers, ctx::sendMarkers);
            ctx.sendNode(intersectionType, e -> e.getPadding().getBounds(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return intersectionType;
        }

        public J.Label visitLabel(J.Label label, SenderContext ctx) {
            ctx.sendValue(label, J.Label::getId);
            ctx.sendNode(label, J.Label::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(label, J.Label::getMarkers, ctx::sendMarkers);
            ctx.sendNode(label, e -> e.getPadding().getLabel(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(label, J.Label::getStatement, ctx::sendTree);
            return label;
        }

        public J.Lambda visitLambda(J.Lambda lambda, SenderContext ctx) {
            ctx.sendValue(lambda, J.Lambda::getId);
            ctx.sendNode(lambda, J.Lambda::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(lambda, J.Lambda::getMarkers, ctx::sendMarkers);
            ctx.sendNode(lambda, J.Lambda::getParameters, this::sendLambdaParameters);
            ctx.sendNode(lambda, J.Lambda::getArrow, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(lambda, J.Lambda::getBody, ctx::sendTree);
            ctx.sendTypedValue(lambda, J.Lambda::getType);
            return lambda;
        }

        private void sendLambdaParameters(J.Lambda.Parameters parameters, SenderContext ctx) {
            ctx.sendValue(parameters, J.Lambda.Parameters::getId);
            ctx.sendNode(parameters, J.Lambda.Parameters::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(parameters, J.Lambda.Parameters::getMarkers, ctx::sendMarkers);
            ctx.sendValue(parameters, J.Lambda.Parameters::isParenthesized);
            ctx.sendNodes(parameters, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J)e.getElement()).getId());
        }

        public J.Literal visitLiteral(J.Literal literal, SenderContext ctx) {
            ctx.sendValue(literal, J.Literal::getId);
            ctx.sendNode(literal, J.Literal::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(literal, J.Literal::getMarkers, ctx::sendMarkers);
            ctx.sendTypedValue(literal, J.Literal::getValue);
            ctx.sendValue(literal, J.Literal::getValueSource);
            ctx.sendValues(literal, J.Literal::getUnicodeEscapes, Function.identity());
            ctx.sendValue(literal, J.Literal::getType);
            return literal;
        }

        public J.MemberReference visitMemberReference(J.MemberReference memberReference, SenderContext ctx) {
            ctx.sendValue(memberReference, J.MemberReference::getId);
            ctx.sendNode(memberReference, J.MemberReference::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(memberReference, J.MemberReference::getMarkers, ctx::sendMarkers);
            ctx.sendNode(memberReference, e -> e.getPadding().getContaining(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(memberReference, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(memberReference, e -> e.getPadding().getReference(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(memberReference, J.MemberReference::getType);
            ctx.sendTypedValue(memberReference, J.MemberReference::getMethodType);
            ctx.sendTypedValue(memberReference, J.MemberReference::getVariableType);
            return memberReference;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, SenderContext ctx) {
            ctx.sendValue(methodDeclaration, J.MethodDeclaration::getId);
            ctx.sendNode(methodDeclaration, J.MethodDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(methodDeclaration, J.MethodDeclaration::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(methodDeclaration, J.MethodDeclaration::getLeadingAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNodes(methodDeclaration, J.MethodDeclaration::getModifiers, this::sendModifier, Tree::getId);
            ctx.sendNode(methodDeclaration, e -> e.getAnnotations().getTypeParameters(), this::sendMethodTypeParameters);
            ctx.sendNode(methodDeclaration, J.MethodDeclaration::getReturnTypeExpression, ctx::sendTree);
            ctx.sendNode(methodDeclaration, e -> e.getAnnotations().getName(), this::sendMethodIdentifierWithAnnotations);
            ctx.sendNode(methodDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(methodDeclaration, e -> e.getPadding().getThrows(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(methodDeclaration, J.MethodDeclaration::getBody, ctx::sendTree);
            ctx.sendNode(methodDeclaration, e -> e.getPadding().getDefaultValue(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(methodDeclaration, J.MethodDeclaration::getMethodType);
            return methodDeclaration;
        }

        private void sendMethodIdentifierWithAnnotations(J.MethodDeclaration.IdentifierWithAnnotations identifierWithAnnotations, SenderContext ctx) {
            ctx.sendNode(identifierWithAnnotations, J.MethodDeclaration.IdentifierWithAnnotations::getIdentifier, ctx::sendTree);
            ctx.sendNodes(identifierWithAnnotations, J.MethodDeclaration.IdentifierWithAnnotations::getAnnotations, ctx::sendTree, Tree::getId);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, SenderContext ctx) {
            ctx.sendValue(methodInvocation, J.MethodInvocation::getId);
            ctx.sendNode(methodInvocation, J.MethodInvocation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(methodInvocation, J.MethodInvocation::getMarkers, ctx::sendMarkers);
            ctx.sendNode(methodInvocation, e -> e.getPadding().getSelect(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(methodInvocation, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(methodInvocation, J.MethodInvocation::getName, ctx::sendTree);
            ctx.sendNode(methodInvocation, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue(methodInvocation, J.MethodInvocation::getMethodType);
            return methodInvocation;
        }

        private void sendModifier(J.Modifier modifier, SenderContext ctx) {
            ctx.sendValue(modifier, J.Modifier::getId);
            ctx.sendNode(modifier, J.Modifier::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(modifier, J.Modifier::getMarkers, ctx::sendMarkers);
            ctx.sendValue(modifier, J.Modifier::getKeyword);
            ctx.sendValue(modifier, J.Modifier::getType);
            ctx.sendNodes(modifier, J.Modifier::getAnnotations, ctx::sendTree, Tree::getId);
        }

        public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, SenderContext ctx) {
            ctx.sendValue(multiCatch, J.MultiCatch::getId);
            ctx.sendNode(multiCatch, J.MultiCatch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(multiCatch, J.MultiCatch::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(multiCatch, e -> e.getPadding().getAlternatives(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((NameTree)e.getElement()).getId());
            return multiCatch;
        }

        public J.NewArray visitNewArray(J.NewArray newArray, SenderContext ctx) {
            ctx.sendValue(newArray, J.NewArray::getId);
            ctx.sendNode(newArray, J.NewArray::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(newArray, J.NewArray::getMarkers, ctx::sendMarkers);
            ctx.sendNode(newArray, J.NewArray::getTypeExpression, ctx::sendTree);
            ctx.sendNodes(newArray, J.NewArray::getDimensions, ctx::sendTree, Tree::getId);
            ctx.sendNode(newArray, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue(newArray, J.NewArray::getType);
            return newArray;
        }

        public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, SenderContext ctx) {
            ctx.sendValue(arrayDimension, J.ArrayDimension::getId);
            ctx.sendNode(arrayDimension, J.ArrayDimension::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(arrayDimension, J.ArrayDimension::getMarkers, ctx::sendMarkers);
            ctx.sendNode(arrayDimension, e -> e.getPadding().getIndex(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return arrayDimension;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, SenderContext ctx) {
            ctx.sendValue(newClass, J.NewClass::getId);
            ctx.sendNode(newClass, J.NewClass::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(newClass, J.NewClass::getMarkers, ctx::sendMarkers);
            ctx.sendNode(newClass, e -> e.getPadding().getEnclosing(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode(newClass, J.NewClass::getNew, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(newClass, J.NewClass::getClazz, ctx::sendTree);
            ctx.sendNode(newClass, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(newClass, J.NewClass::getBody, ctx::sendTree);
            ctx.sendTypedValue(newClass, J.NewClass::getConstructorType);
            return newClass;
        }

        public J.NullableType visitNullableType(J.NullableType nullableType, SenderContext ctx) {
            ctx.sendValue(nullableType, J.NullableType::getId);
            ctx.sendNode(nullableType, J.NullableType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(nullableType, J.NullableType::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(nullableType, J.NullableType::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNode(nullableType, e -> e.getPadding().getTypeTree(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return nullableType;
        }

        public J.Package visitPackage(J.Package package_, SenderContext ctx) {
            ctx.sendValue(package_, J.Package::getId);
            ctx.sendNode(package_, J.Package::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(package_, J.Package::getMarkers, ctx::sendMarkers);
            ctx.sendNode(package_, J.Package::getExpression, ctx::sendTree);
            ctx.sendNodes(package_, J.Package::getAnnotations, ctx::sendTree, Tree::getId);
            return package_;
        }

        public J.ParameterizedType visitParameterizedType(J.ParameterizedType parameterizedType, SenderContext ctx) {
            ctx.sendValue(parameterizedType, J.ParameterizedType::getId);
            ctx.sendNode(parameterizedType, J.ParameterizedType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(parameterizedType, J.ParameterizedType::getMarkers, ctx::sendMarkers);
            ctx.sendNode(parameterizedType, J.ParameterizedType::getClazz, ctx::sendTree);
            ctx.sendNode(parameterizedType, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue(parameterizedType, J.ParameterizedType::getType);
            return parameterizedType;
        }

        public <J2 extends J> J.Parentheses<J2> visitParentheses(J.Parentheses<J2> parentheses, SenderContext ctx) {
            ctx.sendValue(parentheses, J.Parentheses::getId);
            ctx.sendNode(parentheses, J.Parentheses::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(parentheses, J.Parentheses::getMarkers, ctx::sendMarkers);
            ctx.sendNode(parentheses, e -> e.getPadding().getTree(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return parentheses;
        }

        public <J2 extends J> J.ControlParentheses<J2> visitControlParentheses(J.ControlParentheses<J2> controlParentheses, SenderContext ctx) {
            ctx.sendValue(controlParentheses, J.ControlParentheses::getId);
            ctx.sendNode(controlParentheses, J.ControlParentheses::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(controlParentheses, J.ControlParentheses::getMarkers, ctx::sendMarkers);
            ctx.sendNode(controlParentheses, e -> e.getPadding().getTree(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return controlParentheses;
        }

        public J.Primitive visitPrimitive(J.Primitive primitive, SenderContext ctx) {
            ctx.sendValue(primitive, J.Primitive::getId);
            ctx.sendNode(primitive, J.Primitive::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(primitive, J.Primitive::getMarkers, ctx::sendMarkers);
            ctx.sendValue(primitive, J.Primitive::getType);
            return primitive;
        }

        public J.Return visitReturn(J.Return return_, SenderContext ctx) {
            ctx.sendValue(return_, J.Return::getId);
            ctx.sendNode(return_, J.Return::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(return_, J.Return::getMarkers, ctx::sendMarkers);
            ctx.sendNode(return_, J.Return::getExpression, ctx::sendTree);
            return return_;
        }

        public J.Switch visitSwitch(J.Switch switch_, SenderContext ctx) {
            ctx.sendValue(switch_, J.Switch::getId);
            ctx.sendNode(switch_, J.Switch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(switch_, J.Switch::getMarkers, ctx::sendMarkers);
            ctx.sendNode(switch_, J.Switch::getSelector, ctx::sendTree);
            ctx.sendNode(switch_, J.Switch::getCases, ctx::sendTree);
            return switch_;
        }

        public J.SwitchExpression visitSwitchExpression(J.SwitchExpression switchExpression, SenderContext ctx) {
            ctx.sendValue(switchExpression, J.SwitchExpression::getId);
            ctx.sendNode(switchExpression, J.SwitchExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(switchExpression, J.SwitchExpression::getMarkers, ctx::sendMarkers);
            ctx.sendNode(switchExpression, J.SwitchExpression::getSelector, ctx::sendTree);
            ctx.sendNode(switchExpression, J.SwitchExpression::getCases, ctx::sendTree);
            return switchExpression;
        }

        public J.Synchronized visitSynchronized(J.Synchronized synchronized_, SenderContext ctx) {
            ctx.sendValue(synchronized_, J.Synchronized::getId);
            ctx.sendNode(synchronized_, J.Synchronized::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(synchronized_, J.Synchronized::getMarkers, ctx::sendMarkers);
            ctx.sendNode(synchronized_, J.Synchronized::getLock, ctx::sendTree);
            ctx.sendNode(synchronized_, J.Synchronized::getBody, ctx::sendTree);
            return synchronized_;
        }

        public J.Ternary visitTernary(J.Ternary ternary, SenderContext ctx) {
            ctx.sendValue(ternary, J.Ternary::getId);
            ctx.sendNode(ternary, J.Ternary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(ternary, J.Ternary::getMarkers, ctx::sendMarkers);
            ctx.sendNode(ternary, J.Ternary::getCondition, ctx::sendTree);
            ctx.sendNode(ternary, e -> e.getPadding().getTruePart(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(ternary, e -> e.getPadding().getFalsePart(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(ternary, J.Ternary::getType);
            return ternary;
        }

        public J.Throw visitThrow(J.Throw throw_, SenderContext ctx) {
            ctx.sendValue(throw_, J.Throw::getId);
            ctx.sendNode(throw_, J.Throw::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(throw_, J.Throw::getMarkers, ctx::sendMarkers);
            ctx.sendNode(throw_, J.Throw::getException, ctx::sendTree);
            return throw_;
        }

        public J.Try visitTry(J.Try try_, SenderContext ctx) {
            ctx.sendValue(try_, J.Try::getId);
            ctx.sendNode(try_, J.Try::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(try_, J.Try::getMarkers, ctx::sendMarkers);
            ctx.sendNode(try_, e -> e.getPadding().getResources(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode(try_, J.Try::getBody, ctx::sendTree);
            ctx.sendNodes(try_, J.Try::getCatches, ctx::sendTree, Tree::getId);
            ctx.sendNode(try_, e -> e.getPadding().getFinally(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return try_;
        }

        public J.Try.Resource visitTryResource(J.Try.Resource resource, SenderContext ctx) {
            ctx.sendValue(resource, J.Try.Resource::getId);
            ctx.sendNode(resource, J.Try.Resource::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(resource, J.Try.Resource::getMarkers, ctx::sendMarkers);
            ctx.sendNode(resource, J.Try.Resource::getVariableDeclarations, ctx::sendTree);
            ctx.sendValue(resource, J.Try.Resource::isTerminatedWithSemicolon);
            return resource;
        }

        public J.Try.Catch visitCatch(J.Try.Catch catch_, SenderContext ctx) {
            ctx.sendValue(catch_, J.Try.Catch::getId);
            ctx.sendNode(catch_, J.Try.Catch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(catch_, J.Try.Catch::getMarkers, ctx::sendMarkers);
            ctx.sendNode(catch_, J.Try.Catch::getParameter, ctx::sendTree);
            ctx.sendNode(catch_, J.Try.Catch::getBody, ctx::sendTree);
            return catch_;
        }

        public J.TypeCast visitTypeCast(J.TypeCast typeCast, SenderContext ctx) {
            ctx.sendValue(typeCast, J.TypeCast::getId);
            ctx.sendNode(typeCast, J.TypeCast::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(typeCast, J.TypeCast::getMarkers, ctx::sendMarkers);
            ctx.sendNode(typeCast, J.TypeCast::getClazz, ctx::sendTree);
            ctx.sendNode(typeCast, J.TypeCast::getExpression, ctx::sendTree);
            return typeCast;
        }

        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParameter, SenderContext ctx) {
            ctx.sendValue(typeParameter, J.TypeParameter::getId);
            ctx.sendNode(typeParameter, J.TypeParameter::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(typeParameter, J.TypeParameter::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(typeParameter, J.TypeParameter::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNodes(typeParameter, J.TypeParameter::getModifiers, this::sendModifier, Tree::getId);
            ctx.sendNode(typeParameter, J.TypeParameter::getName, ctx::sendTree);
            ctx.sendNode(typeParameter, e -> e.getPadding().getBounds(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return typeParameter;
        }

        private void sendMethodTypeParameters(J.TypeParameters typeParameters, SenderContext ctx) {
            ctx.sendValue(typeParameters, J.TypeParameters::getId);
            ctx.sendNode(typeParameters, J.TypeParameters::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(typeParameters, J.TypeParameters::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(typeParameters, J.TypeParameters::getAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNodes(typeParameters, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.TypeParameter)e.getElement()).getId());
        }

        public J.Unary visitUnary(J.Unary unary, SenderContext ctx) {
            ctx.sendValue(unary, J.Unary::getId);
            ctx.sendNode(unary, J.Unary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(unary, J.Unary::getMarkers, ctx::sendMarkers);
            ctx.sendNode(unary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(unary, J.Unary::getExpression, ctx::sendTree);
            ctx.sendTypedValue(unary, J.Unary::getType);
            return unary;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, SenderContext ctx) {
            ctx.sendValue(variableDeclarations, J.VariableDeclarations::getId);
            ctx.sendNode(variableDeclarations, J.VariableDeclarations::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(variableDeclarations, J.VariableDeclarations::getMarkers, ctx::sendMarkers);
            ctx.sendNodes(variableDeclarations, J.VariableDeclarations::getLeadingAnnotations, ctx::sendTree, Tree::getId);
            ctx.sendNodes(variableDeclarations, J.VariableDeclarations::getModifiers, this::sendModifier, Tree::getId);
            ctx.sendNode(variableDeclarations, J.VariableDeclarations::getTypeExpression, ctx::sendTree);
            ctx.sendNode(variableDeclarations, J.VariableDeclarations::getVarargs, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNodes(variableDeclarations, J.VariableDeclarations::getDimensionsBeforeName, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1), Function.identity());
            ctx.sendNodes(variableDeclarations, e -> e.getPadding().getVariables(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.VariableDeclarations.NamedVariable)e.getElement()).getId());
            return variableDeclarations;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable namedVariable, SenderContext ctx) {
            ctx.sendValue(namedVariable, J.VariableDeclarations.NamedVariable::getId);
            ctx.sendNode(namedVariable, J.VariableDeclarations.NamedVariable::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(namedVariable, J.VariableDeclarations.NamedVariable::getMarkers, ctx::sendMarkers);
            ctx.sendNode(namedVariable, J.VariableDeclarations.NamedVariable::getName, ctx::sendTree);
            ctx.sendNodes(namedVariable, J.VariableDeclarations.NamedVariable::getDimensionsAfterName, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1), Function.identity());
            ctx.sendNode(namedVariable, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue(namedVariable, J.VariableDeclarations.NamedVariable::getVariableType);
            return namedVariable;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SenderContext ctx) {
            ctx.sendValue(whileLoop, J.WhileLoop::getId);
            ctx.sendNode(whileLoop, J.WhileLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(whileLoop, J.WhileLoop::getMarkers, ctx::sendMarkers);
            ctx.sendNode(whileLoop, J.WhileLoop::getCondition, ctx::sendTree);
            ctx.sendNode(whileLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return whileLoop;
        }

        public J.Wildcard visitWildcard(J.Wildcard wildcard, SenderContext ctx) {
            ctx.sendValue(wildcard, J.Wildcard::getId);
            ctx.sendNode(wildcard, J.Wildcard::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(wildcard, J.Wildcard::getMarkers, ctx::sendMarkers);
            ctx.sendNode(wildcard, e -> e.getPadding().getBound(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode(wildcard, J.Wildcard::getBoundedType, ctx::sendTree);
            return wildcard;
        }

        public J.Yield visitYield(J.Yield yield, SenderContext ctx) {
            ctx.sendValue(yield, J.Yield::getId);
            ctx.sendNode(yield, J.Yield::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(yield, J.Yield::getMarkers, ctx::sendMarkers);
            ctx.sendValue(yield, J.Yield::isImplicit);
            ctx.sendNode(yield, J.Yield::getValue, ctx::sendTree);
            return yield;
        }

        public J.Unknown visitUnknown(J.Unknown unknown, SenderContext ctx) {
            ctx.sendValue(unknown, J.Unknown::getId);
            ctx.sendNode(unknown, J.Unknown::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(unknown, J.Unknown::getMarkers, ctx::sendMarkers);
            ctx.sendNode(unknown, J.Unknown::getSource, ctx::sendTree);
            return unknown;
        }

        public J.Unknown.Source visitUnknownSource(J.Unknown.Source source, SenderContext ctx) {
            ctx.sendValue(source, J.Unknown.Source::getId);
            ctx.sendNode(source, J.Unknown.Source::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(source, J.Unknown.Source::getMarkers, ctx::sendMarkers);
            ctx.sendValue(source, J.Unknown.Source::getText);
            return source;
        }
    }
}

